<?php
//
// ZoneMinder web Swedish language file, $Date: 2009-05-24 11:00:20 +0100 (Sun, 24 May 2009) $, $Revision: 2889 $
// Copyright (C) 2001-2008 Philip Coombes
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

// ZoneMinder Swedish Translation by Mikael Carlsson
// Updated 2008-12 by Mikael Carlsson

// Notes for Translators
// 0. Get some credit, put your name in the line above (optional)
// 1. When composing the language tokens in your language you should try and keep to roughly the
//   same length text if possible. Abbreviate where necessary as spacing is quite close in a number of places.
// 2. There are four types of string replacement
//   a) Simple replacements are words or short phrases that are static and used directly. This type of
//     replacement can be used 'as is'.
//   b) Complex replacements involve some dynamic element being included and so may require substitution
//     or changing into a different order. The token listed in this file will be passed through sprintf as
//     a formatting string. If the dynamic element is a number you will usually need to use a variable
//     replacement also as described below.
//   c) Variable replacements are used in conjunction with complex replacements and involve the generation
//     of a singular or plural noun depending on the number passed into the zmVlang function. See the 
//     the zmVlang section below for a further description of this.
//   d) Optional strings which can be used to replace the prompts and/or help text for the Options section
//     of the web interface. These are not listed below as they are quite large and held in the database
//     so that they can also be used by the zmconfig.pl script. However you can build up your own list
//     quite easily from the Config table in the database if necessary.
// 3. The tokens listed below are not used to build up phrases or sentences from single words. Therefore
//   you can safely assume that a single word token will only be used in that context.
// 4. In new language files, or if you are changing only a few words or phrases it makes sense from a 
//   maintenance point of view to include the original language file and override the old definitions rather
//   than copy all the language tokens across. To do this change the line below to whatever your base language
//   is and uncomment it.
// require_once( 'zm_lang_en_gb.php' );

// You may need to change the character set here, if your web server does not already
// do this by default, uncomment this if required.
//
// Example
// header( "Content-Type: text/html; charset=iso-8859-1" );

// You may need to change your locale here if your default one is incorrect for the
// language described in this file, or if you have multiple languages supported.
// If you do need to change your locale, be aware that the format of this function
// is subtlely different in versions of PHP before and after 4.3.0, see
// http://uk2.php.net/manual/en/function.setlocale.php for details.
// Also be aware that changing the whole locale may affect some floating point or decimal 
// arithmetic in the database, if this is the case change only the individual locale areas
// that don't affect this rather than all at once. See the examples below.
// Finally, depending on your setup, PHP may not enjoy have multiple locales in a shared 
// threaded environment, if you get funny errors it may be this.
//
// Examples
// setlocale( 'LC_ALL', 'en_GB' ); All locale settings pre-4.3.0
// setlocale( LC_ALL, 'en_GB' ); All locale settings 4.3.0 and after
// setlocale( LC_CTYPE, 'en_GB' ); Character class settings 4.3.0 and after
// setlocale( LC_TIME, 'en_GB' ); Date and time formatting 4.3.0 and after

// Simple String Replacements
$SLANG = array(
    '24BitColour'          => '24 bitars frg',
    '8BitGrey'             => '8 bit grskala',
    'Action'               => 'Action',
    'Actual'               => 'Verklig',
    'AddNewControl'        => 'Ny kontroll',
    'AddNewMonitor'        => 'Ny bevakare',
    'AddNewUser'           => 'Ny anvndare',
    'AddNewZone'           => 'Ny zon',
    'Alarm'                => 'Larm',
    'AlarmBrFrames'        => 'Larm<br/>ramar',
    'AlarmFrame'           => 'Larmram',
    'AlarmFrameCount'      => 'Larmramsrknare',
    'AlarmLimits'          => 'Larmgrnser',
    'AlarmMaximumFPS'      => 'Max. ramar/s fr larm',
    'AlarmPx'              => 'Larmpunkter',
    'AlarmRGBUnset'        => 'Du mste stta en frg fr RGB-larm',
    'Alert'                => 'Varning',
    'All'                  => 'Alla',
    'Apply'                => 'Lgg till',
    'ApplyingStateChange'  => 'Aktivera statusndring',
    'ArchArchived'         => 'Arkivera endast',
    'ArchUnarchived'       => 'Endast ej arkiverade',
    'Archive'              => 'Arkiv',
    'Archived'             => 'Arkiverad',
    'Area'                 => 'Omrde',
    'AreaUnits'            => 'Omrde (px/%)',
    'AttrAlarmFrames'      => 'Larmramar',
    'AttrArchiveStatus'    => 'Arkivstatus',
    'AttrAvgScore'         => 'Ung. vrde',
    'AttrCause'            => 'Orsak',
    'AttrDate'             => 'Datum',
    'AttrDateTime'         => 'Datum/Tid',
    'AttrDiskBlocks'       => 'Diskblock',
    'AttrDiskPercent'      => 'Diskprocent',
    'AttrDuration'         => 'Lngd',
    'AttrFrames'           => 'Ramar',
    'AttrId'               => 'Id',
    'AttrMaxScore'         => 'Max. vrde',
    'AttrMonitorId'        => 'Bevakningsid',
    'AttrMonitorName'      => 'Bevakningsnamn',
    'AttrName'             => 'Namn',
    'AttrNotes'            => 'Notering',
    'AttrSystemLoad'       => 'Systemlast',
    'AttrTime'             => 'Tid',
    'AttrTotalScore'       => 'Totalvrde',
    'AttrWeekday'          => 'Veckodag',
    'Auto'                 => 'Automatik',
    'AutoStopTimeout'      => 'Tidsutlsning fr automatstop',
    'Available'            => 'Available',              // Added - 2009-03-31
    'AvgBrScore'           => 'Ung.<br/>trff',
    'Background'           => 'Bakgrund',
    'BackgroundFilter'     => 'Kr filter i bakgrunden',
    'BadAlarmFrameCount'   => 'Ramantalet fr larm mste vara ett heltal, minsta vrdet r 1',
    'BadAlarmMaxFPS'       => 'Larm fr bilder/s mste vara ett positivt heltal eller ett flyttal',
    'BadChannel'           => 'Kanalen mste vara ett heltal, noll eller hgre',
    'BadDevice'            => 'Enheten mste sttas till ett giltigt vrde',
    'BadFPSReportInterval' => 'Buffern fr ramintervallrapporten mste vara ett heltal p minst 100 eller hgre',
    'BadFormat'            => 'Formatet mste vara ett heltal, noll eller hgre',
    'BadFrameSkip'         => 'Vrdet fr ramverhopp mste vara ett heltal p 0 eller hgre',
    'BadHeight'            => 'Hjden mste sttas till ett giltigt vrde',
    'BadHost'              => 'Detta flt ska innehlla en giltig ip-adress eller vrdnamn, inkludera inte http://',
    'BadImageBufferCount'  => 'Bufferstorleken fr avbilden mste vara ett heltal p minst 10 eller hgre',
    'BadLabelX'            => 'Etiketten fr X koordinaten mste sttas till ett heltal, 0 eller hgre',
    'BadLabelY'            => 'Etiketten fr Y koordinaten mste sttas till ett heltal, 0 eller hgre',
    'BadMaxFPS'            => 'Max. ramar/s mste vara ett positivt heltal eller ett flyttal',
    'BadNameChars'         => 'Namn kan endast innehlla alfanumeriska tecken, bindestreck och understreck',
    'BadPalette'           => 'Palette must be set to a valid value', // Added - 2009-03-31
    'BadPath'              => 'Skvgen mste innehlla ett giltigt vrde',
    'BadPort'              => 'Porten mste innehlla ett giltigt nummer',
    'BadPostEventCount'    => 'Rknaren fr efterhndelsen mste vara ett heltal p 0 eller hgre',
    'BadPreEventCount'     => 'Rknaren fr fr-hndelsen mste vara ett heltal p 0 eller hgre, och mindre n bufferstorleken p avbilden',
    'BadRefBlendPerc'      => 'Mixprocenten fr referensen mste hara ett positivt heltal',
    'BadSectionLength'     => 'Sektionslngden mste vara ett heltal p minst 30 eller hgre',
    'BadSignalCheckColour' => 'Kontrollfrgen p signalen mste vara en giltig RGB frgstrng',
    'BadStreamReplayBuffer'=> 'Buffern fr strmmande uppspelning mste vara ett heltal p 0 eller hgre',
    'BadWarmupCount'       => 'Uppvrmingsramen mste vara ett heltal p 0 eller hgre',
    'BadWebColour'         => 'Webbfrgen mste vara en giltig strng fr webbfrg',
    'BadWidth'             => 'Bredden mste sttas til ett giltigt vrde',
    'Bandwidth'            => 'Bandbredd',
    'BlobPx'               => 'Blob Px',
    'BlobSizes'            => 'Blobstorlek',
    'Blobs'                => 'Blobbar',
    'Brightness'           => 'Ljusstyrka',
    'Buffers'              => 'Buffrar',
    'CanAutoFocus'         => 'Har autofokus',
    'CanAutoGain'          => 'Har autoniv',
    'CanAutoIris'          => 'Har autoiris',
    'CanAutoWhite'         => 'Har autovitbalans.',
    'CanAutoZoom'          => 'Har autozoom',
    'CanFocus'             => 'Har fokus',
    'CanFocusAbs'          => 'Har absolut fokus',
    'CanFocusCon'          => 'Har kontinuerlig fokus',
    'CanFocusRel'          => 'Har relativ fokus',
    'CanGain'              => 'Har niv',
    'CanGainAbs'           => 'Har absolut niv',
    'CanGainCon'           => 'Har kontinuerlig niv',
    'CanGainRel'           => 'Har relativ niv',
    'CanIris'              => 'Har iris',
    'CanIrisAbs'           => 'Har absolut iris',
    'CanIrisCon'           => 'Har kontinuerlig iris',
    'CanIrisRel'           => 'Har relativ iris',
    'CanMove'              => 'Har frflyttning',
    'CanMoveAbs'           => 'Har absolut frflyttning',
    'CanMoveCon'           => 'Har kontinuerlig frflyttning',
    'CanMoveDiag'          => 'Har diagonal frflyttning',
    'CanMoveMap'           => 'Har mappad frflyttning',
    'CanMoveRel'           => 'Har relativ frflyttning',
    'CanPan'               => 'Har panorering',
    'CanReset'             => 'Har terstllning',
    'CanSetPresets'        => 'Har frinstllningar',
    'CanSleep'             => 'Kan vila',
    'CanTilt'              => 'Kan tilta',
    'CanWake'              => 'Kan vakna',
    'CanWhite'             => 'Kan vitbalansera',
    'CanWhiteAbs'          => 'Har absolut vitbalans',
    'CanWhiteBal'          => 'Kan vitbalans',
    'CanWhiteCon'          => 'Kan kontinuerligt vitbalansera',
    'CanWhiteRel'          => 'Kan relativt vitbalansera',
    'CanZoom'              => 'Kan zooma',
    'CanZoomAbs'           => 'Kan zooma absolut',
    'CanZoomCon'           => 'Kan zooma kontinuerligt',
    'CanZoomRel'           => 'Kan zooma realativt',
    'Cancel'               => 'ngra',
    'CancelForcedAlarm'    => 'ngra tvingande larm',
    'CaptureHeight'        => 'Fngsthjd',
    'CaptureMethod'        => 'Capture Method',         // Added - 2009-02-08
    'CapturePalette'       => 'Fngstpalett',
    'CaptureWidth'         => 'Fngstbredd',
    'Cause'                => 'Orsak',
    'CheckMethod'          => 'Larmkontrollmetod',
    'ChooseDetectedCamera' => 'Choose Detected Camera', // Added - 2009-03-31
    'ChooseFilter'         => 'Vlj filter',
    'ChoosePreset'         => 'Vlj standard',
    'Close'                => 'Stng',
    'Colour'               => 'Frg',
    'Command'              => 'Kommando',
    'Config'               => 'Konfigurera',
    'ConfiguredFor'        => 'Konfigurerad fr',
    'ConfirmDeleteEvents'  => 'r du sker p att du vill ta bort dom valda hndelserna?',
    'ConfirmPassword'      => 'Bekrfta lsenord',
    'ConjAnd'              => 'och',
    'ConjOr'               => 'eller',
    'Console'              => 'Konsoll',
    'ContactAdmin'         => 'Kontakta din administratr fr detaljer.',
    'Continue'             => 'Fortstt',
    'Contrast'             => 'Kontrast',
    'Control'              => 'Kontroll',
    'ControlAddress'       => 'Kontrolladress',
    'ControlCap'           => 'Kontrollfrmga',
    'ControlCaps'          => 'Kontrollfrmgor',
    'ControlDevice'        => 'Kontrollenhet',
    'ControlType'          => 'Kontrolltyp',
    'Controllable'         => 'Kontrollerbar',
    'Cycle'                => 'Period',
    'CycleWatch'           => 'Cycle Watch',
    'Day'                  => 'Dag',
    'Debug'                => 'Avlusa',
    'DefaultRate'          => 'Standardhastighet',
    'DefaultScale'         => 'Standardskala',
    'DefaultView'          => 'Standardvy',
    'Delete'               => 'Radera',
    'DeleteAndNext'        => 'Radera &amp; Nsta',
    'DeleteAndPrev'        => 'Radera &amp; Freg.',
    'DeleteSavedFilter'    => 'Radera sparade filter',
    'Description'          => 'Beskrivning',
    'DetectedCameras'      => 'Detected Cameras',       // Added - 2009-03-31
    'Device'               => 'Device',                 // Added - 2009-02-08
    'DeviceChannel'        => 'Enhetskanal',
    'DeviceFormat'         => 'Enhetsformat',
    'DeviceNumber'         => 'Enhetsnummer',
    'DevicePath'           => 'Enhetsskvg',
    'Devices'              => 'Enheter',
    'Dimensions'           => 'Dimensioner',
    'DisableAlarms'        => 'Avaktivera larm',
    'Disk'                 => 'Disk',
    'Donate'               => 'Var vnlig och donera',
    'DonateAlready'        => 'Nej, Jag har redan donerat',
    'DonateEnticement'     => 'Du har krt ZoneMinder ett tag nu och frhoppningsvis har du sett att det fungerar bra hemma eller p ditt fretag. ven om ZoneMinder r, och kommer att vara, fri programvara och ppen kallkod, s kostar det pengar att utveckla och underhlla. Om du vill hjlpa till med framtida utveckling och nya funktioner s var vanlig och bidrag med en slant. Bidragen r naturligtvis en option men mycket uppskattade och du kan bidra med precis hur mycket du vill.<br><br>Om du vill ge ett bidrag vljer du nedan eller surfar till http://www.zoneminder.com/donate.html.<br><br>Tack fr att du anvnder ZoneMinder, glm inte att beska forumen p ZoneMinder.com fr support och frslag om hur du fr din ZoneMinder att fungera lite bttre.',
    'DonateRemindDay'      => 'Inte n, pminn om 1 dag',
    'DonateRemindHour'     => 'Inte n, pminn om en 1 timme',
    'DonateRemindMonth'    => 'Inte n, pminn om 1 mnad',
    'DonateRemindNever'    => 'Nej, Jag vill inte donera, pminn mig inte mer',
    'DonateRemindWeek'     => 'Inte n, pminn om 1 vecka',
    'DonateYes'            => 'Ja, jag vill grna donera nu',
    'Download'             => 'Ladda ner',
    'DuplicateMonitorName' => 'Duplicate Monitor Name', // Added - 2009-03-31
    'Duration'             => 'Lngd',
    'Edit'                 => 'Redigera',
    'Email'                => 'E-post',
    'EnableAlarms'         => 'Aktivera larm',
    'Enabled'              => 'Aktiverad',
    'EnterNewFilterName'   => 'Mata in nytt filternamn',
    'Error'                => 'Fel',
    'ErrorBrackets'        => 'Fel, kontrollera att du har samma antal vnster som hger-hakar',
    'ErrorValidValue'      => 'Fel, kontrollera att alla parametrar har giltligt vrde',
    'Etc'                  => 'etc',
    'Event'                => 'Hndelse',
    'EventFilter'          => 'Hndelsefilter',
    'EventId'              => 'Hndelse nr',
    'EventName'            => 'Hndelsenamn',
    'EventPrefix'          => 'Hndelseprefix',
    'Events'               => 'Hndelser',
    'Exclude'              => 'Exkludera',
    'Execute'              => 'Utfr',
    'Export'               => 'Exportera',
    'ExportDetails'        => 'Exportera hndelsedetaljer',
    'ExportFailed'         => 'Exporten misslyckades',
    'ExportFormat'         => 'Filformat fr exporter',
    'ExportFormatTar'      => 'Tar',
    'ExportFormatZip'      => 'Zip',
    'ExportFrames'         => 'Exportera ramdetaljer',
    'ExportImageFiles'     => 'Exportera bildfiler',
    'ExportMiscFiles'      => 'Exportera andra filer (om dom finns)',
    'ExportOptions'        => 'Konfiguera export',
    'ExportSucceeded'      => 'Export Succeeded',       // Added - 2009-02-08
    'ExportVideoFiles'     => 'Exportera videofiler (om dom finns)',
    'Exporting'            => 'Exporterar',
    'FPS'                  => 'fps',
    'FPSReportInterval'    => 'FPS rapportintervall',
    'FTP'                  => 'FTP',
    'Far'                  => 'Far',
    'FastForward'          => 'Fast Forward',
    'Feed'                 => 'Matning',
    'Ffmpeg'               => 'Ffmpeg',                 // Added - 2009-02-08
    'File'                 => 'Fil',
    'FilterArchiveEvents'  => 'Arkivera alla trffar',
    'FilterDeleteEvents'   => 'Radera alla trffar',
    'FilterEmailEvents'    => 'Skicka e-post med detaljer om alla trffar',
    'FilterExecuteEvents'  => 'Utfr kommando p alla trffar',
    'FilterMessageEvents'  => 'Meddela detaljer om alla trffar',
    'FilterPx'             => 'Filter Px',
    'FilterUnset'          => 'Du mste specificera filtrets bredd och hjd',
    'FilterUploadEvents'   => 'Ladda upp alla trffar',
    'FilterVideoEvents'    => 'Skapa video fr alla trffar',
    'Filters'              => 'Filter',
    'First'                => 'Frst',
    'FlippedHori'          => 'Vnd horisontellt',
    'FlippedVert'          => 'Vnd vertikalt',
    'Focus'                => 'Fokus',
    'ForceAlarm'           => 'Tvinga larm',
    'Format'               => 'Format',
    'Frame'                => 'Ram',
    'FrameId'              => 'Ram id',
    'FrameRate'            => 'Ram hastighet',
    'FrameSkip'            => 'Hoppa ver ram',
    'Frames'               => 'Ramar',
    'Func'                 => 'Funk',
    'Function'             => 'Funktion',
    'Gain'                 => 'Niv',
    'General'              => 'Generell',
    'GenerateVideo'        => 'Skapa video',
    'GeneratingVideo'      => 'Skapar video',
    'GoToZoneMinder'       => 'G till ZoneMinder.com',
    'Grey'                 => 'Gr',
    'Group'                => 'Grupp',
    'Groups'               => 'Grupper',
    'HasFocusSpeed'        => 'Har focushastighet',
    'HasGainSpeed'         => 'Har nivhastighet',
    'HasHomePreset'        => 'Har normalinstllning',
    'HasIrisSpeed'         => 'Har irishastighet',
    'HasPanSpeed'          => 'Har panoramahastighet',
    'HasPresets'           => 'Har frinstllningar',
    'HasTiltSpeed'         => 'Har tilthastighet',
    'HasTurboPan'          => 'Har turbopanorering',
    'HasTurboTilt'         => 'Har turbotilt',
    'HasWhiteSpeed'        => 'Har vitbalanshastighet',
    'HasZoomSpeed'         => 'Har Zoomhastighet',
    'High'                 => 'Hg',
    'HighBW'               => 'Hg bandbredd',
    'Home'                 => 'Hem',
    'Hour'                 => 'Timme',
    'Hue'                  => 'Hue',
    'Id'                   => 'nr',
    'Idle'                 => 'Vila',
    'Ignore'               => 'Ignorera',
    'Image'                => 'Bild',
    'ImageBufferSize'      => 'Bildbufferstorlek (ramar)',
    'Images'               => 'Images',
    'In'                   => 'I',
    'Include'              => 'Inkludera',
    'Inverted'             => 'Inverterad',
    'Iris'                 => 'Iris',
    'KeyString'            => 'Nyckelstrng',
    'Label'                => 'Etikett',
    'Language'             => 'Sprk',
    'Last'                 => 'Sist',
    'Layout'               => 'Layout',                 // Added - 2009-02-08
    'LimitResultsPost'     => 'resultaten;', // This is used at the end of the phrase 'Limit to first N results only'
    'LimitResultsPre'      => 'Begrnsa till frsta', // This is used at the beginning of the phrase 'Limit to first N results only'
    'LinkedMonitors'       => 'Lnkade vervakare',
    'List'                 => 'Lista',
    'Load'                 => 'Belastning',
    'Local'                => 'Lokal',
    'LoggedInAs'           => 'Inloggad som',
    'LoggingIn'            => 'Loggar in',
    'Login'                => 'Logga in',
    'Logout'               => 'Logga ut',
    'Low'                  => 'Lg',
    'LowBW'                => 'Lg bandbredd',
    'Main'                 => 'Huvudmeny',
    'Man'                  => 'Man',
    'Manual'               => 'Manuell',
    'Mark'                 => 'Markera',
    'Max'                  => 'Max',
    'MaxBandwidth'         => 'Max bandbredd',
    'MaxBrScore'           => 'Max.<br/>Score',
    'MaxFocusRange'        => 'Max fokusomrde',
    'MaxFocusSpeed'        => 'Max fokushastighet',
    'MaxFocusStep'         => 'Max fokussteg',
    'MaxGainRange'         => 'Max nivomrde',
    'MaxGainSpeed'         => 'Max nivhastighet',
    'MaxGainStep'          => 'Max nivsteg',
    'MaxIrisRange'         => 'Max irsiomrde',
    'MaxIrisSpeed'         => 'Max irishastighet',
    'MaxIrisStep'          => 'Max irissteg',
    'MaxPanRange'          => 'Max panoramaomrde',
    'MaxPanSpeed'          => 'Max panoramahastighet',
    'MaxPanStep'           => 'Max panoramasteg',
    'MaxTiltRange'         => 'Max tiltomrde',
    'MaxTiltSpeed'         => 'Max tilthastighet',
    'MaxTiltStep'          => 'Max tiltsteg',
    'MaxWhiteRange'        => 'Max vitbalansomrde',
    'MaxWhiteSpeed'        => 'Max vitbalanshastighet',
    'MaxWhiteStep'         => 'Max vitbalanssteg',
    'MaxZoomRange'         => 'Max zoomomrde',
    'MaxZoomSpeed'         => 'Max zoomhastighet',
    'MaxZoomStep'          => 'Max zoomsteg',
    'MaximumFPS'           => 'Max ramar/s',
    'Medium'               => 'Mellan',
    'MediumBW'             => 'Mellan bandbredd',
    'MinAlarmAreaLtMax'    => 'Minsta larmarean skall vara mindre n strsta',
    'MinAlarmAreaUnset'    => 'Du mste ange minsta antal larmbildpunkter',
    'MinBlobAreaLtMax'     => 'Minsta blobarean skall vara mindre n hgsta',
    'MinBlobAreaUnset'     => 'Du mste ange minsta antalet blobpixlar',
    'MinBlobLtMinFilter'   => 'Minsta blobarean skall vara mindre n eller lika med minsta filterarean',
    'MinBlobsLtMax'        => 'Minsta antalet blobbar skall vara mindre n strsta',
    'MinBlobsUnset'        => 'Du mste ange minsta antalet blobbar',
    'MinFilterAreaLtMax'   => 'Minsta filterarean skall vara mindre n hgsta',
    'MinFilterAreaUnset'   => 'Du mste ange minsta antal filterbildpunkter',
    'MinFilterLtMinAlarm'  => 'Minsta filterarean skall vara mindre n eller lika med minsta larmarean',
    'MinFocusRange'        => 'Min fokusomrde',
    'MinFocusSpeed'        => 'Min fokushastighet',
    'MinFocusStep'         => 'Min fokussteg',
    'MinGainRange'         => 'Min nivomrde',
    'MinGainSpeed'         => 'Min nivhastighet',
    'MinGainStep'          => 'Min nivsteg',
    'MinIrisRange'         => 'Min irisomrde',
    'MinIrisSpeed'         => 'Min irishastighet',
    'MinIrisStep'          => 'Min irissteg',
    'MinPanRange'          => 'Min panoramaomrde',
    'MinPanSpeed'          => 'Min panoramahastighet',
    'MinPanStep'           => 'Min panoramasteg',
    'MinPixelThresLtMax'   => 'Minsta trskelvrde fr bildpunkter ska vara mindre n hgsta',
    'MinPixelThresUnset'   => 'Du mste ange minsta trskelvrde fr bildpunkter',
    'MinTiltRange'         => 'Min tiltomrde',
    'MinTiltSpeed'         => 'Min tilthastighet',
    'MinTiltStep'          => 'Min tiltsteg',
    'MinWhiteRange'        => 'Min vitbalansomrde',
    'MinWhiteSpeed'        => 'Min vitbalanshastighet',
    'MinWhiteStep'         => 'Min vitbalanssteg',
    'MinZoomRange'         => 'Min zoomomrde',
    'MinZoomSpeed'         => 'Min zoomhastighet',
    'MinZoomStep'          => 'Min zoomsteg',
    'Misc'                 => 'vrigt',
    'Monitor'              => 'Bevakning',
    'MonitorIds'           => 'Bevakningsnr',
    'MonitorPreset'        => 'Frinstlld bevakning',
    'MonitorPresetIntro'   => 'Vlj en frinstllning frn listan.<br><br>Var medveten om att detta kan skriva ver instllningar du redan gjort fr denna bevakare.<br><br>',
    'MonitorProbe'         => 'Monitor Probe',          // Added - 2009-03-31
    'MonitorProbeIntro'    => 'The list below shows detected analog and network cameras and whether they are already being used or available for selection.<br/><br/>Select the desired entry from the list below.<br/><br/>Please note that not all cameras may be detected and that choosing a camera here may overwrite any values you already have configured for the current monitor.<br/><br/>', // Added - 2009-03-31
    'Monitors'             => 'Bevakare',
    'Montage'              => 'Montera',
    'Month'                => 'Mnad',
    'Move'                 => 'Flytta',
    'MustBeGe'             => 'mste vara strre n eller lika med',
    'MustBeLe'             => 'mste vara mindre n eller lika med',
    'MustConfirmPassword'  => 'Du mste bekrfta lsenordet',
    'MustSupplyPassword'   => 'Du mste ange ett lsenord',
    'MustSupplyUsername'   => 'Du mste ange ett anvndarnamn',
    'Name'                 => 'Namn',
    'Near'                 => 'Nra',
    'Network'              => 'Ntverk',
    'New'                  => 'Ny',
    'NewGroup'             => 'Ny grupp',
    'NewLabel'             => 'Ny etikett',
    'NewPassword'          => 'Nytt lsenord',
    'NewState'             => 'Nytt lge',
    'NewUser'              => 'Ny anvndare',
    'Next'                 => 'Nsta',
    'No'                   => 'Nej',
    'NoDetectedCameras'    => 'No Detected Cameras',    // Added - 2009-03-31
    'NoFramesRecorded'     => 'Det finns inga ramar inspelade fr denna hndelse',
    'NoGroup'              => 'Ingen grupp',
    'NoSavedFilters'       => 'Inga sparade filter',
    'NoStatisticsRecorded' => 'Det finns ingen statistik inspelad fr denna hndelse/ram',
    'None'                 => 'Ingen',
    'NoneAvailable'        => 'Ingen tillgnglig',
    'Normal'               => 'Normal',
    'Notes'                => 'Not.',
    'NumPresets'           => 'Antal frinstllningar',
    'Off'                  => 'Av',
    'On'                   => 'P',
    'OpEq'                 => 'lika med',
    'OpGt'                 => 'strre n',
    'OpGtEq'               => 'strre n eller lika med',
    'OpIn'                 => 'in set',
    'OpLt'                 => 'mindre n',
    'OpLtEq'               => 'mindre n eller lika med',
    'OpMatches'            => 'matchar',
    'OpNe'                 => 'inte lika med',
    'OpNotIn'              => 'inte i set',
    'OpNotMatches'         => 'matchar inte',
    'Open'                 => 'ppna',
    'OptionHelp'           => 'Optionhjlp',
    'OptionRestartWarning' => 'Dessa ndringar kommer inte att vara implementerade\nnr systemet krs. Nr du r klar starta om\n ZoneMinder.',
    'Options'              => 'Alternativ',
    'OrEnterNewName'       => 'eller skriv in nytt namn',
    'Order'                => 'Sortera',
    'Orientation'          => 'Orientation',
    'Out'                  => 'Ut',
    'OverwriteExisting'    => 'Skriv ver',
    'Paged'                => 'Paged',
    'Pan'                  => 'Panorera',
    'PanLeft'              => 'Panorera vnster',
    'PanRight'             => 'Panorera hger',
    'PanTilt'              => 'Pan/Tilt',
    'Parameter'            => 'Parameter',
    'Password'             => 'Lsenord',
    'PasswordsDifferent'   => 'Lsenorden skiljer sig t',
    'Paths'                => 'Skvgar',
    'Pause'                => 'Paus',
    'Phone'                => 'Mobil',
    'PhoneBW'              => 'Mobil bandbredd',
    'PixelDiff'            => 'Skillnad i bildpunkter',
    'Pixels'               => 'bildpunkter',
    'Play'                 => 'Spela',
    'PlayAll'              => 'Visa alla',
    'PleaseWait'           => 'Vnta...',
    'Point'                => 'Punkt',
    'PostEventImageBuffer' => 'Post Event Image Count',
    'PreEventImageBuffer'  => 'Pre Event Image Count',
    'PreserveAspect'       => 'Bevara lgesfrhllande',
    'Preset'               => 'Frinstllning',
    'Presets'              => 'Frinstllningar',
    'Prev'                 => 'Freg.',
    'Probe'                => 'Probe',                  // Added - 2009-03-31
    'Protocol'             => 'Protokol',
    'Rate'                 => 'Hastighet',
    'Real'                 => 'Verklig',
    'Record'               => 'Spela in',
    'RefImageBlendPct'     => 'Reference Image Blend %ge',
    'Refresh'              => 'Uppdatera',
    'Remote'               => 'Fjrr',
    'RemoteHostName'       => 'Fjrrnamn',
    'RemoteHostPath'       => 'Fjrrskvg',
    'RemoteHostPort'       => 'Fjrrport',
    'RemoteHostSubPath'    => 'Remote Host SubPath',    // Added - 2009-02-08
    'RemoteImageColours'   => 'Fjrrbildfrger',
    'RemoteMethod'         => 'Remote Method',          // Added - 2009-02-08
    'RemoteProtocol'       => 'Remote Protocol',        // Added - 2009-02-08
    'Rename'               => 'Byt namn',
    'Replay'               => 'Repris',
    'ReplayAll'            => 'Alla hndelser',
    'ReplayGapless'        => 'Gapless Events',
    'ReplaySingle'         => 'Ensam hndelse',
    'Reset'                => 'terstll',
    'ResetEventCounts'     => 'terstll hndelserknare',
    'Restart'              => 'terstart',
    'Restarting'           => 'terstartar',
    'RestrictedCameraIds'  => 'Begrnsade kameranr.',
    'RestrictedMonitors'   => 'Begrnsade bevakare',
    'ReturnDelay'          => 'Frdrjd retur',
    'ReturnLocation'       => 'tervnd till position',
    'Rewind'               => 'Backa',
    'RotateLeft'           => 'Rotera vnster',
    'RotateRight'          => 'Rotera hger',
    'RunMode'              => 'Krlge',
    'RunState'             => 'Krlge',
    'Running'              => 'Krs',
    'Save'                 => 'Spara',
    'SaveAs'               => 'Spara som',
    'SaveFilter'           => 'Spara filter',
    'Scale'                => 'Skala',
    'Score'                => 'Resultat',
    'Secs'                 => 'Sek',
    'Sectionlength'        => 'Sektionslngd',
    'Select'               => 'Vlj',
    'SelectMonitors'       => 'Vlj bevakare',
    'SelfIntersecting'     => 'Polygonndarna fr inte verlappa',
    'Set'                  => 'Stll in',
    'SetNewBandwidth'      => 'Stll in ny bandbredd',
    'SetPreset'            => 'Stll in frinstllning',
    'Settings'             => 'Instllningar',
    'ShowFilterWindow'     => 'Visa fnsterfilter',
    'ShowTimeline'         => 'Visa tidslinje',
    'SignalCheckColour'    => 'Signal Check Colour',
    'Size'                 => 'Storlek',
    'Sleep'                => 'Vila',
    'SortAsc'              => 'Stigande',
    'SortBy'               => 'Sortera',
    'SortDesc'             => 'Fallande',
    'Source'               => 'Klla',
    'SourceColours'        => 'Source Colours',         // Added - 2009-02-08
    'SourcePath'           => 'Source Path',            // Added - 2009-02-08
    'SourceType'           => 'Klltyp',
    'Speed'                => 'Hastighet',
    'SpeedHigh'            => 'Hghastighet',
    'SpeedLow'             => 'Lghastighet',
    'SpeedMedium'          => 'Normalhastighet',
    'SpeedTurbo'           => 'Turbohastighet',
    'Start'                => 'Start',
    'State'                => 'Lge',
    'Stats'                => 'Statistik',
    'Status'               => 'Status',
    'Step'                 => 'Steg',
    'StepBack'             => 'Stepga bakt',
    'StepForward'          => 'Stega framt',
    'StepLarge'            => 'Stora steg',
    'StepMedium'           => 'Normalsteg',
    'StepNone'             => 'Inga steg',
    'StepSmall'            => 'Sm steg',
    'Stills'               => 'Stillbilder',
    'Stop'                 => 'Stopp',
    'Stopped'              => 'Stoppad',
    'Stream'               => 'Strmmande',
    'StreamReplayBuffer'   => 'Buffert fr strmmande uppspelning',
    'Submit'               => 'Skicka',
    'System'               => 'System',
    'Tele'                 => 'Tele',
    'Thumbnail'            => 'Miniatyrer',
    'Tilt'                 => 'Tilt',
    'Time'                 => 'Tid',
    'TimeDelta'            => 'tidsdelta',
    'TimeStamp'            => 'Tidsstmpel',
    'Timeline'             => 'Tidslinje',
    'Timestamp'            => 'Tidsstmpel',
    'TimestampLabelFormat' => 'Format p tidsstmpel',
    'TimestampLabelX'      => 'Vrde p tidsstmpel X',
    'TimestampLabelY'      => 'Vrde p tidsstmpel Y',
    'Today'                => 'Idag',
    'Tools'                => 'Verktyg',
    'TotalBrScore'         => 'Total<br/>Score',
    'TrackDelay'           => 'Sprfrdrjning',
    'TrackMotion'          => 'Spra rrelse',
    'Triggers'             => 'Triggers',
    'TurboPanSpeed'        => 'Turbo panoramahastighet',
    'TurboTiltSpeed'       => 'Turbo tilthastighet',
    'Type'                 => 'Typ',
    'Unarchive'            => 'Packa upp',
    'Undefined'            => 'Undefined',              // Added - 2009-02-08
    'Units'                => 'Enheter',
    'Unknown'              => 'Oknd',
    'Update'               => 'Uppdatera',
    'UpdateAvailable'      => 'En uppdatering till ZoneMinder finns tillgnglig.',
    'UpdateNotNecessary'   => 'Ingen uppdatering behvs.',
    'UseFilter'            => 'Anvnd filter',
    'UseFilterExprsPost'   => '&nbsp;filter&nbsp;expressions', // This is used at the end of the phrase 'use N filter expressions'
    'UseFilterExprsPre'    => 'Anvnd&nbsp;', // This is used at the beginning of the phrase 'use N filter expressions'
    'User'                 => 'Anvndare',
    'Username'             => 'Anvndarnamn',
    'Users'                => 'Anvndare',
    'Value'                => 'Vrde',
    'Version'              => 'Version',
    'VersionIgnore'        => 'Ignorera denna version',
    'VersionRemindDay'     => 'Pminn om 1 dag',
    'VersionRemindHour'    => 'Pminn om 1 timme',
    'VersionRemindNever'   => 'Pminn inte om nya versioner',
    'VersionRemindWeek'    => 'Pminn om en 1 vecka',
    'Video'                => 'Video',
    'VideoFormat'          => 'Videoformat',
    'VideoGenFailed'       => 'Videogenereringen misslyckades!',
    'VideoGenFiles'        => 'Befintliga videofiler',
    'VideoGenNoFiles'      => 'Inga videofiler',
    'VideoGenParms'        => 'Instllningar fr videogenerering',
    'VideoGenSucceeded'    => 'Videogenereringen lyckades!',
    'VideoSize'            => 'Videostorlek',
    'View'                 => 'Visa',
    'ViewAll'              => 'Visa alla',
    'ViewEvent'            => 'Visa hndelse',
    'ViewPaged'            => 'Visa Paged',
    'Wake'                 => 'Vakna',
    'WarmupFrames'         => 'Vrm upp ramar',
    'Watch'                => 'Se',
    'Web'                  => 'Webb',
    'WebColour'            => 'Webbfrg',
    'Week'                 => 'Vecka',
    'White'                => 'Vit',
    'WhiteBalance'         => 'Vitbalans',
    'Wide'                 => 'Vid',
    'X'                    => 'X',
    'X10'                  => 'X10',
    'X10ActivationString'  => 'X10 aktiveringsstrng',
    'X10InputAlarmString'  => 'X10 larmingngsstrng',
    'X10OutputAlarmString' => 'X10 larmutgngsstrng',
    'Y'                    => 'J',
    'Yes'                  => 'Ja',
    'YouNoPerms'           => 'Du har inte tillstnd till denna resurs.',
    'Zone'                 => 'Zon',
    'ZoneAlarmColour'      => 'Larmfrg (Rd/Grn/Bl)',
    'ZoneArea'             => 'Zonarea',
    'ZoneFilterSize'       => 'Filterbredd/hjd (pixlar)',
    'ZoneMinMaxAlarmArea'  => 'Min/Max larmarea',
    'ZoneMinMaxBlobArea'   => 'Min/Max blobbarea',
    'ZoneMinMaxBlobs'      => 'Min/Max blobbar',
    'ZoneMinMaxFiltArea'   => 'Min/Max filterarea',
    'ZoneMinMaxPixelThres' => 'Min/Max pixel Threshold (0-255)',
    'ZoneOverloadFrames'   => 'Overload Frame Ignore Count',
    'Zones'                => 'Zoner',
    'Zoom'                 => 'Zoom',
    'ZoomIn'               => 'Zooma in',
    'ZoomOut'              => 'Zooma ut',
);

// Complex replacements with formatting and/or placements, must be passed through sprintf
$CLANG = array(
    'CurrentLogin'         => 'Aktuell inloggning r \'%1$s\'',
    'EventCount'           => '%1$s %2$s', // For example '37 Events' (from Vlang below)
    'LastEvents'           => 'Senaste %1$s %2$s', // For example 'Last 37 Events' (from Vlang below)
    'LatestRelease'        => 'Aktuell version r v%1$s, du har v%2$s.',
    'MonitorCount'         => '%1$s %2$s', // For example '4 Monitors' (from Vlang below)
    'MonitorFunction'      => 'Bevakare %1$s funktion',
    'RunningRecentVer'     => 'Du anvnder den senaste versionen av ZoneMinder, v%s.',
);

// The next section allows you to describe a series of word ending and counts used to 
// generate the correctly conjugated forms of words depending on a count that is associated
// with that word.
// This intended to allow phrases such a '0 potatoes', '1 potato', '2 potatoes' etc to
// conjugate correctly with the associated count.
// In some languages such as English this is fairly simple and can be expressed by assigning
// a count with a singular or plural form of a word and then finding the nearest (lower) value.
// So '0' of something generally ends in 's', 1 of something is singular and has no extra
// ending and 2 or more is a plural and ends in 's' also. So to find the ending for '187' of
// something you would find the nearest lower count (2) and use that ending.
//
// So examples of this would be
// $zmVlangPotato = array( 0=>'Potatoes', 1=>'Potato', 2=>'Potatoes' );
// $zmVlangSheep = array( 0=>'Sheep' );
//
// where you can have as few or as many entries in the array as necessary
// If your language is similar in form to this then use the same format and choose the
// appropriate zmVlang function below.
// If however you have a language with a different format of plural endings then another
// approach is required . For instance in Russian the word endings change continuously
// depending on the last digit (or digits) of the numerator. In this case then zmVlang
// arrays could be written so that the array index just represents an arbitrary 'type'
// and the zmVlang function does the calculation about which version is appropriate.
//
// So an example in Russian might be (using English words, and made up endings as I
// don't know any Russian!!)
// $zmVlangPotato = array( 1=>'Potati', 2=>'Potaton', 3=>'Potaten' );
//
// and the zmVlang function decides that the first form is used for counts ending in
// 0, 5-9 or 11-19 and the second form when ending in 1 etc.
//

// Variable arrays expressing plurality, see the zmVlang description above
$VLANG = array(
    'Event'                => array( 0=>'Hndelser', 1=>'Hndelsen', 2=>'Hndelserna' ),
    'Monitor'              => array( 0=>'Bevakare', 1=>'Bevakare', 2=>'Bevakare' ),
);

// You will need to choose or write a function that can correlate the plurality string arrays
// with variable counts. This is used to conjugate the Vlang arrays above with a number passed
// in to generate the correct noun form.
//
// In languages such as English this is fairly simple 
// Note this still has to be used with printf etc to get the right formating
function zmVlang( $langVarArray, $count )
{
    krsort( $langVarArray );
    foreach ( $langVarArray as $key=>$value )
    {
        if ( abs($count) >= $key )
        {
            return( $value );
        }
    }
    die( 'Fel, kan inte relatera variabel sprkstrng' );
}

// This is an version that could be used in the Russian example above
// The rules are that the first word form is used if the count ends in
// 0, 5-9 or 11-19. The second form is used then the count ends in 1
// (not including 11 as above) and the third form is used when the 
// count ends in 2-4, again excluding any values ending in 12-14.
// 
// function zmVlang( $langVarArray, $count )
// {
//  $secondlastdigit = substr( $count, -2, 1 );
//  $lastdigit = substr( $count, -1, 1 );
//  // or
//  // $secondlastdigit = ($count/10)%10;
//  // $lastdigit = $count%10;
// 
//  // Get rid of the special cases first, the teens
//  if ( $secondlastdigit == 1 && $lastdigit != 0 )
//  {
//      return( $langVarArray[1] );
//  }
//  switch ( $lastdigit )
//  {
//      case 0 :
//      case 5 :
//      case 6 :
//      case 7 :
//      case 8 :
//      case 9 :
//      {
//          return( $langVarArray[1] );
//          break;
//      }
//      case 1 :
//      {
//          return( $langVarArray[2] );
//          break;
//      }
//      case 2 :
//      case 3 :
//      case 4 :
//      {
//          return( $langVarArray[3] );
//          break;
//      }
//  }
//  die( 'Error, unable to correlate variable language string' );
// }

// This is an example of how the function is used in the code which you can uncomment and 
// use to test your custom function.
//$monitors = array();
//$monitors[] = 1; // Choose any number
//echo sprintf( $zmClangMonitorCount, count($monitors), zmVlang( $zmVlangMonitor, count($monitors) ) );

// In this section you can override the default prompt and help texts for the options area
// These overrides are in the form show below where the array key represents the option name minus the initial ZM_
$OLANG = array(
    'LANG_DEFAULT' => array(
        'Prompt' => "Vlj sprk fr ZoneMinder",
        'Help' => "ZoneMinder kan anvnda annat sprk n engelska i menyer och texter. Vlj hr det sprk du vill anvnda till ZoneMinder."
    ),
);

?>
