package Zim::Events;

use strict;

our $VERSION = '0.24';

=head1 NAME

Zim::Events - Simple event dispatching

=head1 DESCRIPTION

Add a few routines to mimic Gtk style event dispatcing.

=head1 METHODS

=over 4

=item C<signal_connect(NAME, CODE, DATA)>

=cut

sub signal_connect {
	my ($self, $signal, $code, @data) = @_;
	$self->{_signals}{$signal} ||= [];
	push @{$self->{_signals}{$signal}}, [$code, @data];
}

=item C<signal_emit(NAME, ARGS)>

=cut

sub signal_emit {
	my ($self, $signal, @args) = @_;
	warn "## emit $signal: @args (".ref($self).")\n";
	return unless exists $self->{_signals}{$signal};
	for my $handler (grep defined($_), @{$self->{_signals}{$signal}}) {
		my ($code, @data) = @$handler;
		eval { $code->($self, @args, @data) };
		warn if $@;
	}
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

L<Zim>

=cut

