from distutils.core import setup
from distutils.extension import Extension
from Cython.Distutils import build_ext
from distutils.command.build import build as _build
from distutils.command.clean import clean as _clean
import os

class my_build(_build):
    def run(self):
        _build.run(self)

        # compile theme files
        import subprocess
        result = subprocess.call( "cd ./data/themes/toby; edje_cc -v -fd ../fonts zhone.edc; mv zhone.edj ../", shell=True )
        if result != 0:
            raise Exception( "Can't build theme files. Built edje_cc?" )

class my_clean(_clean):
    def run(self):
        _clean.run(self)

        if os.path.exists('./data/themes/zhone.edj'):
            os.remove('./data/themes/zhone.edj')

setup(
    name = "zhone",
    version = "milestone4.1+git",
    author = "See AUTHORS",
    author_email = "mlauer@vanille-media.de",
    url = "http://www.freesmartphone.org",
    ext_modules = [
        Extension( "illume", ["src/illume.pyx"], libraries = ["ecore", "ecore_x"] )
        ],
    cmdclass = { 'build_ext': build_ext ,
                 'build'    : my_build  ,
                 'clean'    : my_clean  },
    scripts = [ "src/zhone" ],
    data_files = [
        ( "zhone", ["data/themes/zhone.edj"] ),
        ( "zhone/locale/ru/LC_MESSAGES", ["data/locale/ru/LC_MESSAGES/zhone.mo"] ),
        ( "zhone/locale/pl/LC_MESSAGES", ["data/locale/pl/LC_MESSAGES/zhone.mo"] ),
        ( "pixmaps", ["data/launcher/zhone.png"] ),
        ( "applications", ["data/launcher/zhone.desktop"] ),
        ]
)
