/* notify.c generated by valac 0.14.0, the Vala compiler
 * generated from notify.vala, do not modify */

/* notify.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define ZEITGEIST_TYPE_MONITOR_MANAGER (zeitgeist_monitor_manager_get_type ())
#define ZEITGEIST_MONITOR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManager))
#define ZEITGEIST_MONITOR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManagerClass))
#define ZEITGEIST_IS_MONITOR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_MONITOR_MANAGER))
#define ZEITGEIST_IS_MONITOR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_MONITOR_MANAGER))
#define ZEITGEIST_MONITOR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManagerClass))

typedef struct _ZeitgeistMonitorManager ZeitgeistMonitorManager;
typedef struct _ZeitgeistMonitorManagerClass ZeitgeistMonitorManagerClass;
typedef struct _ZeitgeistMonitorManagerPrivate ZeitgeistMonitorManagerPrivate;

#define ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR (zeitgeist_monitor_manager_monitor_get_type ())
#define ZEITGEIST_MONITOR_MANAGER_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitor))
#define ZEITGEIST_MONITOR_MANAGER_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitorClass))
#define ZEITGEIST_MONITOR_MANAGER_IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR))
#define ZEITGEIST_MONITOR_MANAGER_IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR))
#define ZEITGEIST_MONITOR_MANAGER_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitorClass))

typedef struct _ZeitgeistMonitorManagerMonitor ZeitgeistMonitorManagerMonitor;
typedef struct _ZeitgeistMonitorManagerMonitorClass ZeitgeistMonitorManagerMonitorClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;
#define _zeitgeist_monitor_manager_monitor_unref0(var) ((var == NULL) ? NULL : (var = (zeitgeist_monitor_manager_monitor_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZeitgeistMonitorManagerMonitorPrivate ZeitgeistMonitorManagerMonitorPrivate;

#define ZEITGEIST_TYPE_REMOTE_MONITOR (zeitgeist_remote_monitor_get_type ())
#define ZEITGEIST_REMOTE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR, ZeitgeistRemoteMonitor))
#define ZEITGEIST_IS_REMOTE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR))
#define ZEITGEIST_REMOTE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR, ZeitgeistRemoteMonitorIface))

typedef struct _ZeitgeistRemoteMonitor ZeitgeistRemoteMonitor;
typedef struct _ZeitgeistRemoteMonitorIface ZeitgeistRemoteMonitorIface;

#define ZEITGEIST_TYPE_REMOTE_MONITOR_PROXY (zeitgeist_remote_monitor_proxy_get_type ())
typedef struct _ZeitgeistMonitorManagerParamSpecMonitor ZeitgeistMonitorManagerParamSpecMonitor;

struct _ZeitgeistMonitorManager {
	GObject parent_instance;
	ZeitgeistMonitorManagerPrivate * priv;
};

struct _ZeitgeistMonitorManagerClass {
	GObjectClass parent_class;
};

struct _ZeitgeistMonitorManagerPrivate {
	GHashTable* monitors;
	GHashTable* connections;
};

struct _ZeitgeistMonitorManagerMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ZeitgeistMonitorManagerMonitorPrivate * priv;
};

struct _ZeitgeistMonitorManagerMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (ZeitgeistMonitorManagerMonitor *self);
};

struct _ZeitgeistRemoteMonitorIface {
	GTypeInterface parent_iface;
	void (*notify_insert) (ZeitgeistRemoteMonitor* self, GVariant* time_range, GVariant* events, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*notify_insert_finish) (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
	void (*notify_delete) (ZeitgeistRemoteMonitor* self, GVariant* time_range, guint32* event_ids, int event_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*notify_delete_finish) (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
};

struct _ZeitgeistMonitorManagerMonitorPrivate {
	GPtrArray* event_templates;
	ZeitgeistTimeRange* time_range;
	ZeitgeistRemoteMonitor* proxy_object;
};

struct _ZeitgeistMonitorManagerParamSpecMonitor {
	GParamSpec parent_instance;
};


static gpointer zeitgeist_monitor_manager_parent_class = NULL;
static gpointer zeitgeist_monitor_manager_monitor_parent_class = NULL;

GType zeitgeist_monitor_manager_get_type (void) G_GNUC_CONST;
static gpointer zeitgeist_monitor_manager_monitor_ref (gpointer instance);
static void zeitgeist_monitor_manager_monitor_unref (gpointer instance);
static GParamSpec* zeitgeist_monitor_manager_param_spec_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void zeitgeist_monitor_manager_value_set_monitor (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void zeitgeist_monitor_manager_value_take_monitor (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer zeitgeist_monitor_manager_value_get_monitor (const GValue* value) G_GNUC_UNUSED;
static GType zeitgeist_monitor_manager_monitor_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define ZEITGEIST_MONITOR_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManagerPrivate))
enum  {
	ZEITGEIST_MONITOR_MANAGER_DUMMY_PROPERTY
};
GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
void zeitgeist_monitor_manager_install_monitor (ZeitgeistMonitorManager* self, const char* peer, const gchar* object_path, ZeitgeistTimeRange* time_range, GPtrArray* templates);
static ZeitgeistMonitorManagerMonitor* zeitgeist_monitor_manager_monitor_new (const char* peer, const gchar* object_path, ZeitgeistTimeRange* tr, GPtrArray* templates);
static ZeitgeistMonitorManagerMonitor* zeitgeist_monitor_manager_monitor_construct (GType object_type, const char* peer, const gchar* object_path, ZeitgeistTimeRange* tr, GPtrArray* templates);
static void _g_free0_ (gpointer var);
void zeitgeist_monitor_manager_remove_monitor (ZeitgeistMonitorManager* self, const char* peer, const gchar* object_path);
void zeitgeist_monitor_manager_notify_insert (ZeitgeistMonitorManager* self, ZeitgeistTimeRange* time_range, GPtrArray* events);
static void zeitgeist_monitor_manager_monitor_notify_insert (ZeitgeistMonitorManagerMonitor* self, ZeitgeistTimeRange* time_range, GPtrArray* events);
void zeitgeist_monitor_manager_notify_delete (ZeitgeistMonitorManager* self, ZeitgeistTimeRange* time_range, guint32* event_ids, int event_ids_length1);
static void zeitgeist_monitor_manager_monitor_notify_delete (ZeitgeistMonitorManagerMonitor* self, ZeitgeistTimeRange* time_range, guint32* event_ids, int event_ids_length1);
ZeitgeistMonitorManager* zeitgeist_monitor_manager_new (void);
ZeitgeistMonitorManager* zeitgeist_monitor_manager_construct (GType object_type);
static GObject * zeitgeist_monitor_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _zeitgeist_monitor_manager_monitor_unref0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
static void _zeitgeist_monitor_manager____lambda9_ (ZeitgeistMonitorManager* self, GDBusConnection* conn, const gchar* sender, const gchar* path, const gchar* ifc_name, const gchar* sig_name, GVariant* parameters);
static void __zeitgeist_monitor_manager____lambda9__gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self);
GType zeitgeist_remote_monitor_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_monitor_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_monitor_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_MONITOR_MANAGER_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, ZeitgeistMonitorManagerMonitorPrivate))
enum  {
	ZEITGEIST_MONITOR_MANAGER_MONITOR_DUMMY_PROPERTY
};
static void __lambda8_ (ZeitgeistMonitorManagerMonitor* self, GObject* obj, GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean zeitgeist_monitor_manager_monitor_matches (ZeitgeistMonitorManagerMonitor* self, ZeitgeistEvent* event);
gboolean zeitgeist_event_matches_template (ZeitgeistEvent* self, ZeitgeistEvent* template_event);
ZeitgeistTimeRange* zeitgeist_time_range_intersect (ZeitgeistTimeRange* self, ZeitgeistTimeRange* time_range);
static void _g_object_unref0_ (gpointer var);
gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self);
gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self);
gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self);
void zeitgeist_remote_monitor_notify_insert (ZeitgeistRemoteMonitor* self, GVariant* time_range, GVariant* events, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_monitor_notify_insert_finish (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
GVariant* zeitgeist_time_range_to_variant (ZeitgeistTimeRange* self);
GVariant* zeitgeist_events_to_variant (GPtrArray* events);
void zeitgeist_remote_monitor_notify_delete (ZeitgeistRemoteMonitor* self, GVariant* time_range, guint32* event_ids, int event_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_monitor_notify_delete_finish (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
static void zeitgeist_monitor_manager_monitor_finalize (ZeitgeistMonitorManagerMonitor* obj);
static void zeitgeist_monitor_manager_finalize (GObject* obj);


static gpointer _zeitgeist_monitor_manager_monitor_ref0 (gpointer self) {
	return self ? zeitgeist_monitor_manager_monitor_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


void zeitgeist_monitor_manager_install_monitor (ZeitgeistMonitorManager* self, const char* peer, const gchar* object_path, ZeitgeistTimeRange* time_range, GPtrArray* templates) {
	const char* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* hash;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (peer != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (templates != NULL);
	_tmp0_ = peer;
	_tmp1_ = object_path;
	_tmp2_ = g_strdup_printf ("%s#%s", (const gchar*) _tmp0_, _tmp1_);
	hash = _tmp2_;
	_tmp3_ = self->priv->monitors;
	_tmp4_ = hash;
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
	if (((ZeitgeistMonitorManagerMonitor*) _tmp5_) == NULL) {
		const char* _tmp6_;
		const gchar* _tmp7_;
		ZeitgeistTimeRange* _tmp8_;
		GPtrArray* _tmp9_;
		ZeitgeistMonitorManagerMonitor* _tmp10_;
		ZeitgeistMonitorManagerMonitor* monitor;
		GHashTable* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		ZeitgeistMonitorManagerMonitor* _tmp14_;
		ZeitgeistMonitorManagerMonitor* _tmp15_;
		GHashTable* _tmp16_;
		const char* _tmp17_;
		gconstpointer _tmp18_ = NULL;
		GHashTable* _tmp23_;
		const char* _tmp24_;
		gconstpointer _tmp25_ = NULL;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		const char* _tmp28_;
		_tmp6_ = peer;
		_tmp7_ = object_path;
		_tmp8_ = time_range;
		_tmp9_ = templates;
		_tmp10_ = zeitgeist_monitor_manager_monitor_new (_tmp6_, _tmp7_, _tmp8_, _tmp9_);
		monitor = _tmp10_;
		_tmp11_ = self->priv->monitors;
		_tmp12_ = hash;
		_tmp13_ = g_strdup (_tmp12_);
		_tmp14_ = monitor;
		_tmp15_ = _zeitgeist_monitor_manager_monitor_ref0 (_tmp14_);
		g_hash_table_insert (_tmp11_, _tmp13_, _tmp15_);
		_tmp16_ = self->priv->connections;
		_tmp17_ = peer;
		_tmp18_ = g_hash_table_lookup (_tmp16_, (const gchar*) _tmp17_);
		if (((GPtrArray*) _tmp18_) == NULL) {
			GHashTable* _tmp19_;
			const char* _tmp20_;
			gchar* _tmp21_;
			GPtrArray* _tmp22_;
			_tmp19_ = self->priv->connections;
			_tmp20_ = peer;
			_tmp21_ = g_strdup ((gchar*) _tmp20_);
			_tmp22_ = g_ptr_array_new_with_free_func (_g_free0_);
			g_hash_table_insert (_tmp19_, _tmp21_, _tmp22_);
		}
		_tmp23_ = self->priv->connections;
		_tmp24_ = peer;
		_tmp25_ = g_hash_table_lookup (_tmp23_, (const gchar*) _tmp24_);
		_tmp26_ = object_path;
		_tmp27_ = g_strdup (_tmp26_);
		g_ptr_array_add ((GPtrArray*) _tmp25_, _tmp27_);
		_tmp28_ = peer;
		g_debug ("notify.vala:170: Installed new monitor for %s", (const gchar*) _tmp28_);
		_zeitgeist_monitor_manager_monitor_unref0 (monitor);
	} else {
		const gchar* _tmp29_;
		_tmp29_ = hash;
		g_warning ("notify.vala:174: There's already a monitor installed for %s", _tmp29_);
	}
	_g_free0 (hash);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


void zeitgeist_monitor_manager_remove_monitor (ZeitgeistMonitorManager* self, const char* peer, const gchar* object_path) {
	const char* _tmp0_;
	const gchar* _tmp1_;
	const char* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* hash;
	GHashTable* _tmp5_;
	const gchar* _tmp6_;
	gconstpointer _tmp7_ = NULL;
	GHashTable* _tmp11_;
	const char* _tmp12_;
	gconstpointer _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (peer != NULL);
	g_return_if_fail (object_path != NULL);
	_tmp0_ = peer;
	_tmp1_ = object_path;
	g_debug ("notify.vala:180: Removing monitor %s%s", (const gchar*) _tmp0_, _tmp1_);
	_tmp2_ = peer;
	_tmp3_ = object_path;
	_tmp4_ = g_strdup_printf ("%s#%s", (const gchar*) _tmp2_, _tmp3_);
	hash = _tmp4_;
	_tmp5_ = self->priv->monitors;
	_tmp6_ = hash;
	_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
	if (((ZeitgeistMonitorManagerMonitor*) _tmp7_) != NULL) {
		GHashTable* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->monitors;
		_tmp9_ = hash;
		g_hash_table_remove (_tmp8_, _tmp9_);
	} else {
		const gchar* _tmp10_;
		_tmp10_ = hash;
		g_warning ("notify.vala:186: There's no monitor installed for %s", _tmp10_);
	}
	_tmp11_ = self->priv->connections;
	_tmp12_ = peer;
	_tmp13_ = g_hash_table_lookup (_tmp11_, (const gchar*) _tmp12_);
	if (((GPtrArray*) _tmp13_) != NULL) {
		GHashTable* _tmp14_;
		const char* _tmp15_;
		gconstpointer _tmp16_ = NULL;
		GPtrArray* _tmp17_;
		GPtrArray* paths;
		_tmp14_ = self->priv->connections;
		_tmp15_ = peer;
		_tmp16_ = g_hash_table_lookup (_tmp14_, (const gchar*) _tmp15_);
		_tmp17_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp16_);
		paths = _tmp17_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp18_;
				_tmp18_ = TRUE;
				while (TRUE) {
					gboolean _tmp19_;
					gint _tmp21_;
					GPtrArray* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					GPtrArray* _tmp25_;
					gint _tmp26_;
					gconstpointer _tmp27_ = NULL;
					const gchar* _tmp28_;
					_tmp19_ = _tmp18_;
					if (!_tmp19_) {
						gint _tmp20_;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp21_ = i;
					_tmp22_ = paths;
					_tmp23_ = g_ptr_array_get_length (_tmp22_);
					_tmp24_ = _tmp23_;
					if (!(_tmp21_ < _tmp24_)) {
						break;
					}
					_tmp25_ = paths;
					_tmp26_ = i;
					_tmp27_ = g_ptr_array_index (_tmp25_, (guint) _tmp26_);
					_tmp28_ = object_path;
					if (g_strcmp0 ((const gchar*) _tmp27_, _tmp28_) == 0) {
						GPtrArray* _tmp29_;
						gint _tmp30_;
						_tmp29_ = paths;
						_tmp30_ = i;
						g_ptr_array_remove_index_fast (_tmp29_, (guint) _tmp30_);
						break;
					}
				}
			}
		}
		_g_ptr_array_unref0 (paths);
	}
	_g_free0 (hash);
}


void zeitgeist_monitor_manager_notify_insert (ZeitgeistMonitorManager* self, ZeitgeistTimeRange* time_range, GPtrArray* events) {
	GHashTable* _tmp0_;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = self->priv->monitors;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* mon_collection = NULL;
		GList* mon_it = NULL;
		mon_collection = _tmp1_;
		for (mon_it = mon_collection; mon_it != NULL; mon_it = mon_it->next) {
			ZeitgeistMonitorManagerMonitor* mon = NULL;
			mon = (ZeitgeistMonitorManagerMonitor*) mon_it->data;
			{
				ZeitgeistMonitorManagerMonitor* _tmp2_;
				ZeitgeistTimeRange* _tmp3_;
				GPtrArray* _tmp4_;
				_tmp2_ = mon;
				_tmp3_ = time_range;
				_tmp4_ = events;
				zeitgeist_monitor_manager_monitor_notify_insert (_tmp2_, _tmp3_, _tmp4_);
			}
		}
		_g_list_free0 (mon_collection);
	}
}


void zeitgeist_monitor_manager_notify_delete (ZeitgeistMonitorManager* self, ZeitgeistTimeRange* time_range, guint32* event_ids, int event_ids_length1) {
	GHashTable* _tmp0_;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	_tmp0_ = self->priv->monitors;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* mon_collection = NULL;
		GList* mon_it = NULL;
		mon_collection = _tmp1_;
		for (mon_it = mon_collection; mon_it != NULL; mon_it = mon_it->next) {
			ZeitgeistMonitorManagerMonitor* mon = NULL;
			mon = (ZeitgeistMonitorManagerMonitor*) mon_it->data;
			{
				ZeitgeistMonitorManagerMonitor* _tmp2_;
				ZeitgeistTimeRange* _tmp3_;
				guint32* _tmp4_;
				gint _tmp4__length1;
				_tmp2_ = mon;
				_tmp3_ = time_range;
				_tmp4_ = event_ids;
				_tmp4__length1 = event_ids_length1;
				zeitgeist_monitor_manager_monitor_notify_delete (_tmp2_, _tmp3_, _tmp4_, _tmp4__length1);
			}
		}
		_g_list_free0 (mon_collection);
	}
}


ZeitgeistMonitorManager* zeitgeist_monitor_manager_construct (GType object_type) {
	ZeitgeistMonitorManager * self = NULL;
	self = (ZeitgeistMonitorManager*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistMonitorManager* zeitgeist_monitor_manager_new (void) {
	return zeitgeist_monitor_manager_construct (ZEITGEIST_TYPE_MONITOR_MANAGER);
}


static void _zeitgeist_monitor_manager_monitor_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (zeitgeist_monitor_manager_monitor_unref (var), NULL));
}


static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static void _zeitgeist_monitor_manager____lambda9_ (ZeitgeistMonitorManager* self, GDBusConnection* conn, const gchar* sender, const gchar* path, const gchar* ifc_name, const gchar* sig_name, GVariant* parameters) {
	GVariant* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* arg0;
	GVariant* _tmp5_;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* arg1;
	GVariant* _tmp10_;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* arg2;
	const gchar* _tmp15_;
	GHashTable* _tmp16_;
	GList* _tmp17_ = NULL;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (ifc_name != NULL);
	g_return_if_fail (sig_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = parameters;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_dup_string (_tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	arg0 = _tmp4_;
	_tmp5_ = parameters;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_dup_string (_tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	arg1 = _tmp9_;
	_tmp10_ = parameters;
	_tmp11_ = g_variant_get_child_value (_tmp10_, (gsize) 2);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_dup_string (_tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_g_variant_unref0 (_tmp12_);
	arg2 = _tmp14_;
	_tmp15_ = arg2;
	if (g_strcmp0 (_tmp15_, "") != 0) {
		_g_free0 (arg2);
		_g_free0 (arg1);
		_g_free0 (arg0);
		return;
	}
	_tmp16_ = self->priv->connections;
	_tmp17_ = g_hash_table_get_keys (_tmp16_);
	{
		GList* owner_collection = NULL;
		GList* owner_it = NULL;
		owner_collection = _tmp17_;
		for (owner_it = owner_collection; owner_it != NULL; owner_it = owner_it->next) {
			const gchar* owner = NULL;
			owner = (const gchar*) owner_it->data;
			{
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = arg0;
				_tmp19_ = owner;
				if (g_strcmp0 (_tmp18_, _tmp19_) == 0) {
					GHashTable* _tmp20_;
					const gchar* _tmp21_;
					gconstpointer _tmp22_ = NULL;
					GPtrArray* _tmp23_;
					GPtrArray* paths;
					const gchar* _tmp24_;
					GHashTable* _tmp36_;
					const gchar* _tmp37_;
					_tmp20_ = self->priv->connections;
					_tmp21_ = arg0;
					_tmp22_ = g_hash_table_lookup (_tmp20_, _tmp21_);
					_tmp23_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp22_);
					paths = _tmp23_;
					_tmp24_ = owner;
					g_debug ("notify.vala:59: Client disconnected %s", _tmp24_);
					{
						gint i;
						i = 0;
						{
							gboolean _tmp25_;
							_tmp25_ = TRUE;
							while (TRUE) {
								gboolean _tmp26_;
								gint _tmp28_;
								GPtrArray* _tmp29_;
								gint _tmp30_;
								gint _tmp31_;
								const gchar* _tmp32_;
								GPtrArray* _tmp33_;
								gint _tmp34_;
								gconstpointer _tmp35_ = NULL;
								_tmp26_ = _tmp25_;
								if (!_tmp26_) {
									gint _tmp27_;
									_tmp27_ = i;
									i = _tmp27_ + 1;
								}
								_tmp25_ = FALSE;
								_tmp28_ = i;
								_tmp29_ = paths;
								_tmp30_ = g_ptr_array_get_length (_tmp29_);
								_tmp31_ = _tmp30_;
								if (!(_tmp28_ < _tmp31_)) {
									break;
								}
								_tmp32_ = arg0;
								_tmp33_ = paths;
								_tmp34_ = i;
								_tmp35_ = g_ptr_array_index (_tmp33_, (guint) _tmp34_);
								zeitgeist_monitor_manager_remove_monitor (self, (const char*) _tmp32_, (const gchar*) _tmp35_);
							}
						}
					}
					_tmp36_ = self->priv->connections;
					_tmp37_ = arg0;
					g_hash_table_remove (_tmp36_, _tmp37_);
					_g_ptr_array_unref0 (paths);
				}
			}
		}
		_g_list_free0 (owner_collection);
	}
	_g_free0 (arg2);
	_g_free0 (arg1);
	_g_free0 (arg0);
}


static void __zeitgeist_monitor_manager____lambda9__gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self) {
	_zeitgeist_monitor_manager____lambda9_ (self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}


static GObject * zeitgeist_monitor_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistMonitorManager * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_monitor_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ZEITGEIST_MONITOR_MANAGER (obj);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _zeitgeist_monitor_manager_monitor_unref0_);
	_g_hash_table_unref0 (self->priv->monitors);
	self->priv->monitors = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->connections);
	self->priv->connections = _tmp5_;
	{
		GDBusConnection* _tmp6_ = NULL;
		GDBusConnection* connection;
		GDBusConnection* _tmp7_;
		_tmp6_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch9_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp7_ = connection;
		g_dbus_connection_signal_subscribe (_tmp7_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, 0, __zeitgeist_monitor_manager____lambda9__gd_bus_signal_callback, g_object_ref (self), g_object_unref);
		_g_object_unref0 (connection);
	}
	goto __finally9;
	__catch9_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		g_warning ("notify.vala:69: Cannot subscribe to NameOwnerChanged signal! %s", _tmp9_);
		_g_error_free0 (err);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void __lambda8_ (ZeitgeistMonitorManagerMonitor* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GAsyncResult* _tmp0_;
		ZeitgeistRemoteMonitor* _tmp1_ = NULL;
		ZeitgeistRemoteMonitor* _tmp2_ = NULL;
		ZeitgeistRemoteMonitor* _tmp3_;
		_tmp0_ = res;
		_tmp1_ = g_async_result_get_source_object (_tmp0_);
		_tmp2_ = g_async_initable_new_finish (_tmp1_, _tmp0_, &_inner_error_);
		g_object_unref (_tmp1_);
		_tmp3_ = (ZeitgeistRemoteMonitor*) _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch10_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (self->priv->proxy_object);
		self->priv->proxy_object = _tmp3_;
	}
	goto __finally10;
	__catch10_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("notify.vala:95: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda8_ (self, source_object, res);
	zeitgeist_monitor_manager_monitor_unref (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static ZeitgeistMonitorManagerMonitor* zeitgeist_monitor_manager_monitor_construct (GType object_type, const char* peer, const gchar* object_path, ZeitgeistTimeRange* tr, GPtrArray* templates) {
	ZeitgeistMonitorManagerMonitor* self = NULL;
	const char* _tmp0_;
	const gchar* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	ZeitgeistTimeRange* _tmp3_;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (peer != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (tr != NULL, NULL);
	g_return_val_if_fail (templates != NULL, NULL);
	self = (ZeitgeistMonitorManagerMonitor*) g_type_create_instance (object_type);
	_tmp0_ = peer;
	_tmp1_ = object_path;
	g_async_initable_new_async (ZEITGEIST_TYPE_REMOTE_MONITOR_PROXY, 0, NULL, ___lambda8__gasync_ready_callback, zeitgeist_monitor_manager_monitor_ref (self), "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", (const gchar*) _tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp1_, "g-interface-name", "org.gnome.zeitgeist.Monitor", NULL);
	_tmp2_ = tr;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->time_range);
	self->priv->time_range = _tmp3_;
	_tmp4_ = templates;
	_tmp5_ = _g_ptr_array_ref0 (_tmp4_);
	_g_ptr_array_unref0 (self->priv->event_templates);
	self->priv->event_templates = _tmp5_;
	return self;
}


static ZeitgeistMonitorManagerMonitor* zeitgeist_monitor_manager_monitor_new (const char* peer, const gchar* object_path, ZeitgeistTimeRange* tr, GPtrArray* templates) {
	return zeitgeist_monitor_manager_monitor_construct (ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR, peer, object_path, tr, templates);
}


static gboolean zeitgeist_monitor_manager_monitor_matches (ZeitgeistMonitorManagerMonitor* self, ZeitgeistEvent* event) {
	gboolean result = FALSE;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->event_templates;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = TRUE;
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				ZeitgeistEvent* _tmp10_;
				GPtrArray* _tmp11_;
				gint _tmp12_;
				gconstpointer _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->priv->event_templates;
				_tmp8_ = g_ptr_array_get_length (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ < _tmp9_)) {
					break;
				}
				_tmp10_ = event;
				_tmp11_ = self->priv->event_templates;
				_tmp12_ = i;
				_tmp13_ = g_ptr_array_index (_tmp11_, (guint) _tmp12_);
				_tmp14_ = zeitgeist_event_matches_template (_tmp10_, (ZeitgeistEvent*) _tmp13_);
				if (_tmp14_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void zeitgeist_monitor_manager_monitor_notify_insert (ZeitgeistMonitorManagerMonitor* self, ZeitgeistTimeRange* time_range, GPtrArray* events) {
	ZeitgeistRemoteMonitor* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	ZeitgeistTimeRange* _tmp3_ = NULL;
	ZeitgeistTimeRange* intersect_tr;
	ZeitgeistTimeRange* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = self->priv->proxy_object;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = time_range;
	_tmp2_ = self->priv->time_range;
	_tmp3_ = zeitgeist_time_range_intersect (_tmp1_, _tmp2_);
	intersect_tr = _tmp3_;
	_tmp4_ = intersect_tr;
	if (_tmp4_ != NULL) {
		GPtrArray* _tmp5_;
		GPtrArray* matching_events;
		GPtrArray* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		_tmp5_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
		matching_events = _tmp5_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					gboolean _tmp7_;
					gint _tmp9_;
					GPtrArray* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
					gboolean _tmp15_ = FALSE;
					GPtrArray* _tmp16_;
					gint _tmp17_;
					gconstpointer _tmp18_ = NULL;
					gboolean _tmp23_;
					gboolean _tmp32_;
					gboolean _tmp41_;
					_tmp7_ = _tmp6_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp9_ = i;
					_tmp10_ = events;
					_tmp11_ = g_ptr_array_get_length (_tmp10_);
					_tmp12_ = _tmp11_;
					if (!(_tmp9_ < _tmp12_)) {
						break;
					}
					_tmp16_ = events;
					_tmp17_ = i;
					_tmp18_ = g_ptr_array_index (_tmp16_, (guint) _tmp17_);
					if (((ZeitgeistEvent*) _tmp18_) != NULL) {
						GPtrArray* _tmp19_;
						gint _tmp20_;
						gconstpointer _tmp21_ = NULL;
						gboolean _tmp22_ = FALSE;
						_tmp19_ = events;
						_tmp20_ = i;
						_tmp21_ = g_ptr_array_index (_tmp19_, (guint) _tmp20_);
						_tmp22_ = zeitgeist_monitor_manager_monitor_matches (self, (ZeitgeistEvent*) _tmp21_);
						_tmp15_ = _tmp22_;
					} else {
						_tmp15_ = FALSE;
					}
					_tmp23_ = _tmp15_;
					if (_tmp23_) {
						GPtrArray* _tmp24_;
						gint _tmp25_;
						gconstpointer _tmp26_ = NULL;
						gint64 _tmp27_;
						gint64 _tmp28_;
						ZeitgeistTimeRange* _tmp29_;
						gint64 _tmp30_;
						gint64 _tmp31_;
						_tmp24_ = events;
						_tmp25_ = i;
						_tmp26_ = g_ptr_array_index (_tmp24_, (guint) _tmp25_);
						_tmp27_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = intersect_tr;
						_tmp30_ = zeitgeist_time_range_get_start (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp14_ = _tmp28_ >= _tmp31_;
					} else {
						_tmp14_ = FALSE;
					}
					_tmp32_ = _tmp14_;
					if (_tmp32_) {
						GPtrArray* _tmp33_;
						gint _tmp34_;
						gconstpointer _tmp35_ = NULL;
						gint64 _tmp36_;
						gint64 _tmp37_;
						ZeitgeistTimeRange* _tmp38_;
						gint64 _tmp39_;
						gint64 _tmp40_;
						_tmp33_ = events;
						_tmp34_ = i;
						_tmp35_ = g_ptr_array_index (_tmp33_, (guint) _tmp34_);
						_tmp36_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = intersect_tr;
						_tmp39_ = zeitgeist_time_range_get_end (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp13_ = _tmp37_ <= _tmp40_;
					} else {
						_tmp13_ = FALSE;
					}
					_tmp41_ = _tmp13_;
					if (_tmp41_) {
						GPtrArray* _tmp42_;
						GPtrArray* _tmp43_;
						gint _tmp44_;
						gconstpointer _tmp45_ = NULL;
						ZeitgeistEvent* _tmp46_;
						_tmp42_ = matching_events;
						_tmp43_ = events;
						_tmp44_ = i;
						_tmp45_ = g_ptr_array_index (_tmp43_, (guint) _tmp44_);
						_tmp46_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp45_);
						g_ptr_array_add (_tmp42_, _tmp46_);
					}
				}
			}
		}
		_tmp47_ = matching_events;
		_tmp48_ = g_ptr_array_get_length (_tmp47_);
		_tmp49_ = _tmp48_;
		if (_tmp49_ > 0) {
			ZeitgeistRemoteMonitor* _tmp50_;
			GDBusProxy* _tmp51_;
			GDBusProxy* p;
			GDBusProxy* _tmp52_;
			const gchar* _tmp53_ = NULL;
			GPtrArray* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			ZeitgeistRemoteMonitor* _tmp57_;
			ZeitgeistTimeRange* _tmp58_;
			GVariant* _tmp59_ = NULL;
			GVariant* _tmp60_;
			GPtrArray* _tmp61_;
			GVariant* _tmp62_ = NULL;
			GVariant* _tmp63_;
			_tmp50_ = self->priv->proxy_object;
			_tmp51_ = _g_object_ref0 (G_DBUS_PROXY (_tmp50_));
			p = _tmp51_;
			_tmp52_ = p;
			_tmp53_ = g_dbus_proxy_get_name (_tmp52_);
			_tmp54_ = matching_events;
			_tmp55_ = g_ptr_array_get_length (_tmp54_);
			_tmp56_ = _tmp55_;
			g_debug ("notify.vala:136: Notifying %s about %d insertions", _tmp53_, _tmp56_);
			_tmp57_ = self->priv->proxy_object;
			_tmp58_ = intersect_tr;
			_tmp59_ = zeitgeist_time_range_to_variant (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = matching_events;
			_tmp62_ = zeitgeist_events_to_variant (_tmp61_);
			_tmp63_ = _tmp62_;
			zeitgeist_remote_monitor_notify_insert (_tmp57_, _tmp60_, _tmp63_, NULL, NULL);
			_g_variant_unref0 (_tmp63_);
			_g_variant_unref0 (_tmp60_);
			_g_object_unref0 (p);
		}
		_g_ptr_array_unref0 (matching_events);
	}
	_g_object_unref0 (intersect_tr);
}


static void zeitgeist_monitor_manager_monitor_notify_delete (ZeitgeistMonitorManagerMonitor* self, ZeitgeistTimeRange* time_range, guint32* event_ids, int event_ids_length1) {
	ZeitgeistRemoteMonitor* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	ZeitgeistTimeRange* _tmp3_ = NULL;
	ZeitgeistTimeRange* intersect_tr;
	ZeitgeistTimeRange* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	_tmp0_ = self->priv->proxy_object;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = time_range;
	_tmp2_ = self->priv->time_range;
	_tmp3_ = zeitgeist_time_range_intersect (_tmp1_, _tmp2_);
	intersect_tr = _tmp3_;
	_tmp4_ = intersect_tr;
	if (_tmp4_ != NULL) {
		ZeitgeistRemoteMonitor* _tmp5_;
		ZeitgeistTimeRange* _tmp6_;
		GVariant* _tmp7_ = NULL;
		GVariant* _tmp8_;
		guint32* _tmp9_;
		gint _tmp9__length1;
		_tmp5_ = self->priv->proxy_object;
		_tmp6_ = intersect_tr;
		_tmp7_ = zeitgeist_time_range_to_variant (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = event_ids;
		_tmp9__length1 = event_ids_length1;
		zeitgeist_remote_monitor_notify_delete (_tmp5_, _tmp8_, _tmp9_, _tmp9__length1, NULL, NULL);
		_g_variant_unref0 (_tmp8_);
	}
	_g_object_unref0 (intersect_tr);
}


static void zeitgeist_monitor_manager_value_monitor_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void zeitgeist_monitor_manager_value_monitor_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		zeitgeist_monitor_manager_monitor_unref (value->data[0].v_pointer);
	}
}


static void zeitgeist_monitor_manager_value_monitor_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = zeitgeist_monitor_manager_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer zeitgeist_monitor_manager_value_monitor_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* zeitgeist_monitor_manager_value_monitor_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ZeitgeistMonitorManagerMonitor* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = zeitgeist_monitor_manager_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* zeitgeist_monitor_manager_value_monitor_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ZeitgeistMonitorManagerMonitor** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = zeitgeist_monitor_manager_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* zeitgeist_monitor_manager_param_spec_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ZeitgeistMonitorManagerParamSpecMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer zeitgeist_monitor_manager_value_get_monitor (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR), NULL);
	return value->data[0].v_pointer;
}


static void zeitgeist_monitor_manager_value_set_monitor (GValue* value, gpointer v_object) {
	ZeitgeistMonitorManagerMonitor* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		zeitgeist_monitor_manager_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_monitor_manager_monitor_unref (old);
	}
}


static void zeitgeist_monitor_manager_value_take_monitor (GValue* value, gpointer v_object) {
	ZeitgeistMonitorManagerMonitor* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_MONITOR_MANAGER_TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_monitor_manager_monitor_unref (old);
	}
}


static void zeitgeist_monitor_manager_monitor_class_init (ZeitgeistMonitorManagerMonitorClass * klass) {
	zeitgeist_monitor_manager_monitor_parent_class = g_type_class_peek_parent (klass);
	ZEITGEIST_MONITOR_MANAGER_MONITOR_CLASS (klass)->finalize = zeitgeist_monitor_manager_monitor_finalize;
	g_type_class_add_private (klass, sizeof (ZeitgeistMonitorManagerMonitorPrivate));
}


static void zeitgeist_monitor_manager_monitor_instance_init (ZeitgeistMonitorManagerMonitor * self) {
	self->priv = ZEITGEIST_MONITOR_MANAGER_MONITOR_GET_PRIVATE (self);
	self->priv->proxy_object = NULL;
	self->ref_count = 1;
}


static void zeitgeist_monitor_manager_monitor_finalize (ZeitgeistMonitorManagerMonitor* obj) {
	ZeitgeistMonitorManagerMonitor * self;
	self = ZEITGEIST_MONITOR_MANAGER_MONITOR (obj);
	_g_ptr_array_unref0 (self->priv->event_templates);
	_g_object_unref0 (self->priv->time_range);
	_g_object_unref0 (self->priv->proxy_object);
}


static GType zeitgeist_monitor_manager_monitor_get_type (void) {
	static volatile gsize zeitgeist_monitor_manager_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_monitor_manager_monitor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { zeitgeist_monitor_manager_value_monitor_init, zeitgeist_monitor_manager_value_monitor_free_value, zeitgeist_monitor_manager_value_monitor_copy_value, zeitgeist_monitor_manager_value_monitor_peek_pointer, "p", zeitgeist_monitor_manager_value_monitor_collect_value, "p", zeitgeist_monitor_manager_value_monitor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistMonitorManagerMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_monitor_manager_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistMonitorManagerMonitor), 0, (GInstanceInitFunc) zeitgeist_monitor_manager_monitor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType zeitgeist_monitor_manager_monitor_type_id;
		zeitgeist_monitor_manager_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ZeitgeistMonitorManagerMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&zeitgeist_monitor_manager_monitor_type_id__volatile, zeitgeist_monitor_manager_monitor_type_id);
	}
	return zeitgeist_monitor_manager_monitor_type_id__volatile;
}


static gpointer zeitgeist_monitor_manager_monitor_ref (gpointer instance) {
	ZeitgeistMonitorManagerMonitor* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void zeitgeist_monitor_manager_monitor_unref (gpointer instance) {
	ZeitgeistMonitorManagerMonitor* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ZEITGEIST_MONITOR_MANAGER_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void zeitgeist_monitor_manager_class_init (ZeitgeistMonitorManagerClass * klass) {
	zeitgeist_monitor_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistMonitorManagerPrivate));
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_monitor_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_monitor_manager_finalize;
}


static void zeitgeist_monitor_manager_instance_init (ZeitgeistMonitorManager * self) {
	self->priv = ZEITGEIST_MONITOR_MANAGER_GET_PRIVATE (self);
}


static void zeitgeist_monitor_manager_finalize (GObject* obj) {
	ZeitgeistMonitorManager * self;
	self = ZEITGEIST_MONITOR_MANAGER (obj);
	_g_hash_table_unref0 (self->priv->monitors);
	_g_hash_table_unref0 (self->priv->connections);
	G_OBJECT_CLASS (zeitgeist_monitor_manager_parent_class)->finalize (obj);
}


GType zeitgeist_monitor_manager_get_type (void) {
	static volatile gsize zeitgeist_monitor_manager_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_monitor_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistMonitorManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_monitor_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistMonitorManager), 0, (GInstanceInitFunc) zeitgeist_monitor_manager_instance_init, NULL };
		GType zeitgeist_monitor_manager_type_id;
		zeitgeist_monitor_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistMonitorManager", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_monitor_manager_type_id__volatile, zeitgeist_monitor_manager_type_id);
	}
	return zeitgeist_monitor_manager_type_id__volatile;
}



