/* fts.c generated by valac 0.14.0, the Vala compiler
 * generated from fts.vala, do not modify */

/* fts.vala
 *
 * Copyright © 2011 Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Canonical Ltd.
 *             By Michal Hruby <michal.hruby@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <zeitgeist-engine.h>


#define ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE (zeitgeist_remote_search_engine_get_type ())
#define ZEITGEIST_REMOTE_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, ZeitgeistRemoteSearchEngine))
#define ZEITGEIST_IS_REMOTE_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE))
#define ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, ZeitgeistRemoteSearchEngineIface))

typedef struct _ZeitgeistRemoteSearchEngine ZeitgeistRemoteSearchEngine;
typedef struct _ZeitgeistRemoteSearchEngineIface ZeitgeistRemoteSearchEngineIface;

#define ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE_PROXY (zeitgeist_remote_search_engine_proxy_get_type ())
typedef GDBusProxy ZeitgeistRemoteSearchEngineProxy;
typedef GDBusProxyClass ZeitgeistRemoteSearchEngineProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define ZEITGEIST_TYPE_SEARCH_ENGINE (zeitgeist_search_engine_get_type ())
#define ZEITGEIST_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngine))
#define ZEITGEIST_SEARCH_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngineClass))
#define ZEITGEIST_IS_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SEARCH_ENGINE))
#define ZEITGEIST_IS_SEARCH_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SEARCH_ENGINE))
#define ZEITGEIST_SEARCH_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngineClass))

typedef struct _ZeitgeistSearchEngine ZeitgeistSearchEngine;
typedef struct _ZeitgeistSearchEngineClass ZeitgeistSearchEngineClass;
typedef struct _ZeitgeistSearchEnginePrivate ZeitgeistSearchEnginePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _ZeitgeistSearchEngineSearchData ZeitgeistSearchEngineSearchData;

struct _ZeitgeistRemoteSearchEngineIface {
	GTypeInterface parent_iface;
	void (*search) (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GVariant* (*search_finish) (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, GError** error);
};

struct _ZeitgeistSearchEngine {
	ZeitgeistExtension parent_instance;
	ZeitgeistSearchEnginePrivate * priv;
};

struct _ZeitgeistSearchEngineClass {
	ZeitgeistExtensionClass parent_class;
};

struct _ZeitgeistSearchEnginePrivate {
	ZeitgeistRemoteSimpleIndexer* siin;
	guint registration_id;
};

struct _ZeitgeistSearchEngineSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistSearchEngine* self;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint offset;
	guint count;
	guint result_type;
	GVariant* events;
	GVariant* result;
	gboolean _tmp0_;
	ZeitgeistRemoteSimpleIndexer* _tmp1_;
	ZeitgeistRemoteSimpleIndexer* _tmp2_;
	gboolean _tmp3_;
	GError* _tmp4_;
	GTimer* _tmp5_;
	GTimer* timer;
	ZeitgeistRemoteSimpleIndexer* _tmp6_;
	GDBusProxy* _tmp7_;
	GDBusProxy* proxy;
	GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GVariantBuilder* _tmp10_;
	GVariantBuilder* _tmp11_;
	GVariantBuilder* b;
	const gchar* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _result_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	gsize _tmp24_;
	gdouble _tmp25_;
	GVariant* _tmp26_;
	GError * _inner_error_;
};


static GType zeitgeist_remote_search_engine_type_id = 0;
static gpointer zeitgeist_search_engine_parent_class = NULL;
static ZeitgeistRemoteSearchEngineIface* zeitgeist_search_engine_zeitgeist_remote_search_engine_parent_iface = NULL;
static GType zeitgeist_search_engine_type_id = 0;

GType zeitgeist_remote_search_engine_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_search_engine_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_search_engine_get_type (void) G_GNUC_CONST;
GType zeitgeist_remote_search_engine_register_type (GTypeModule * module);
void zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* zeitgeist_remote_search_engine_search_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, GError** error);
static void zeitgeist_remote_search_engine_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_remote_search_engine_proxy_search_async (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GVariant* zeitgeist_remote_search_engine_proxy_search_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, GError** error);
static void zeitgeist_remote_search_engine_proxy_zeitgeist_remote_search_engine_interface_init (ZeitgeistRemoteSearchEngineIface* iface);
static void _dbus_zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_zeitgeist_remote_search_engine_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void zeitgeist_remote_search_engine_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* zeitgeist_remote_search_engine_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean zeitgeist_remote_search_engine_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _zeitgeist_remote_search_engine_unregister_object (gpointer user_data);
GType zeitgeist_search_engine_get_type (void) G_GNUC_CONST;
GType zeitgeist_search_engine_register_type (GTypeModule * module);
#define ZEITGEIST_SEARCH_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEnginePrivate))
enum  {
	ZEITGEIST_SEARCH_ENGINE_DUMMY_PROPERTY
};
static ZeitgeistSearchEngine* zeitgeist_search_engine_new (void);
static ZeitgeistSearchEngine* zeitgeist_search_engine_construct (GType object_type);
static void zeitgeist_search_engine_proxy_acquired (ZeitgeistSearchEngine* self, GObject* obj, GAsyncResult* res);
static void zeitgeist_search_engine_real_search_data_free (gpointer _data);
static void zeitgeist_search_engine_real_search (ZeitgeistRemoteSearchEngine* base, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_search_engine_real_search_co (ZeitgeistSearchEngineSearchData* _data_);
static void zeitgeist_search_engine_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GObject * zeitgeist_search_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _zeitgeist_search_engine____lambda0_ (ZeitgeistSearchEngine* self, GDBusConnection* conn);
static void _zeitgeist_search_engine_proxy_acquired_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __zeitgeist_search_engine____lambda0__gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void _zeitgeist_search_engine____lambda1_ (ZeitgeistSearchEngine* self);
static void __zeitgeist_search_engine____lambda1__gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void zeitgeist_search_engine_finalize (GObject* obj);
GType zeitgeist_extension_register (GTypeModule* module);

static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_query_string = {-1, "query_string", "s"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_time_range = {-1, "time_range", "(xx)"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_filter_templates = {-1, "filter_templates", "a(asaasay)"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_offset = {-1, "offset", "u"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_count = {-1, "count", "u"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_result_type = {-1, "result_type", "u"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_events = {-1, "events", "a(asaasay)"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_result = {-1, "result", "a(asaasay)u"};
static const GDBusArgInfo * const _zeitgeist_remote_search_engine_dbus_arg_info_search_in[] = {&_zeitgeist_remote_search_engine_dbus_arg_info_search_query_string, &_zeitgeist_remote_search_engine_dbus_arg_info_search_time_range, &_zeitgeist_remote_search_engine_dbus_arg_info_search_filter_templates, &_zeitgeist_remote_search_engine_dbus_arg_info_search_offset, &_zeitgeist_remote_search_engine_dbus_arg_info_search_count, &_zeitgeist_remote_search_engine_dbus_arg_info_search_result_type, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_search_engine_dbus_arg_info_search_out[] = {&_zeitgeist_remote_search_engine_dbus_arg_info_search_events, &_zeitgeist_remote_search_engine_dbus_arg_info_search_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_search_engine_dbus_method_info_search = {-1, "Search", (GDBusArgInfo **) (&_zeitgeist_remote_search_engine_dbus_arg_info_search_in), (GDBusArgInfo **) (&_zeitgeist_remote_search_engine_dbus_arg_info_search_out)};
static const GDBusMethodInfo * const _zeitgeist_remote_search_engine_dbus_method_info[] = {&_zeitgeist_remote_search_engine_dbus_method_info_search, NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_search_engine_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_search_engine_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_search_engine_dbus_interface_info = {-1, "org.gnome.zeitgeist.Index", (GDBusMethodInfo **) (&_zeitgeist_remote_search_engine_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_search_engine_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_search_engine_dbus_property_info)};
static const GDBusInterfaceVTable _zeitgeist_remote_search_engine_dbus_interface_vtable = {zeitgeist_remote_search_engine_dbus_interface_method_call, zeitgeist_remote_search_engine_dbus_interface_get_property, zeitgeist_remote_search_engine_dbus_interface_set_property};

void zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE (self)->search (self, query_string, time_range, filter_templates, offset, count, result_type, _callback_, _user_data_);
}


GVariant* zeitgeist_remote_search_engine_search_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, GError** error) {
	return ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE (self)->search_finish (self, _res_, events, error);
}


static void zeitgeist_remote_search_engine_base_init (ZeitgeistRemoteSearchEngineIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType zeitgeist_remote_search_engine_get_type (void) {
	return zeitgeist_remote_search_engine_type_id;
}


GType zeitgeist_remote_search_engine_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteSearchEngineIface), (GBaseInitFunc) zeitgeist_remote_search_engine_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	zeitgeist_remote_search_engine_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ZeitgeistRemoteSearchEngine", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_remote_search_engine_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_search_engine_proxy_get_type);
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.Index");
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_search_engine_register_object);
	return zeitgeist_remote_search_engine_type_id;
}


G_DEFINE_TYPE_EXTENDED (ZeitgeistRemoteSearchEngineProxy, zeitgeist_remote_search_engine_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, zeitgeist_remote_search_engine_proxy_zeitgeist_remote_search_engine_interface_init) )
static void zeitgeist_remote_search_engine_proxy_class_init (ZeitgeistRemoteSearchEngineProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_search_engine_proxy_g_signal;
}


static void zeitgeist_remote_search_engine_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void zeitgeist_remote_search_engine_proxy_init (ZeitgeistRemoteSearchEngineProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void zeitgeist_remote_search_engine_proxy_search_async (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Index", "Search");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query_string));
	g_variant_builder_add_value (&_arguments_builder, time_range);
	g_variant_builder_add_value (&_arguments_builder, filter_templates);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (offset));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (count));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (result_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static GVariant* zeitgeist_remote_search_engine_proxy_search_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _vala_events;
	GVariant* _result;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_events = g_variant_iter_next_value (&_reply_iter);
	*events = _vala_events;
	_result = g_variant_iter_next_value (&_reply_iter);
	g_object_unref (_reply_message);
	return _result;
}


static void zeitgeist_remote_search_engine_proxy_zeitgeist_remote_search_engine_interface_init (ZeitgeistRemoteSearchEngineIface* iface) {
	iface->search = zeitgeist_remote_search_engine_proxy_search_async;
	iface->search_finish = zeitgeist_remote_search_engine_proxy_search_finish;
}


static void _dbus_zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* query_string = NULL;
	GVariant* _tmp0_;
	GVariant* time_range = NULL;
	GVariant* filter_templates = NULL;
	guint offset = 0U;
	GVariant* _tmp1_;
	guint count = 0U;
	GVariant* _tmp2_;
	guint result_type = 0U;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	query_string = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	time_range = g_variant_iter_next_value (&_arguments_iter);
	filter_templates = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	offset = g_variant_get_uint32 (_tmp1_);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	count = g_variant_get_uint32 (_tmp2_);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	result_type = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	zeitgeist_remote_search_engine_search (self, query_string, time_range, filter_templates, offset, count, result_type, (GAsyncReadyCallback) _dbus_zeitgeist_remote_search_engine_search_ready, invocation);
	_g_free0 (query_string);
	_g_variant_unref0 (time_range);
	_g_variant_unref0 (filter_templates);
}


static void _dbus_zeitgeist_remote_search_engine_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* events = NULL;
	GVariant* result;
	invocation = _user_data_;
	result = zeitgeist_remote_search_engine_search_finish ((ZeitgeistRemoteSearchEngine*) source_object, _res_, &events, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, events);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_variant_unref0 (events);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void zeitgeist_remote_search_engine_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Search") == 0) {
		_dbus_zeitgeist_remote_search_engine_search (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* zeitgeist_remote_search_engine_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean zeitgeist_remote_search_engine_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint zeitgeist_remote_search_engine_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_search_engine_dbus_interface_info), &_zeitgeist_remote_search_engine_dbus_interface_vtable, data, _zeitgeist_remote_search_engine_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _zeitgeist_remote_search_engine_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static ZeitgeistSearchEngine* zeitgeist_search_engine_construct (GType object_type) {
	ZeitgeistSearchEngine * self = NULL;
	self = (ZeitgeistSearchEngine*) g_object_new (object_type, NULL);
	return self;
}


static ZeitgeistSearchEngine* zeitgeist_search_engine_new (void) {
	return zeitgeist_search_engine_construct (ZEITGEIST_TYPE_SEARCH_ENGINE);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void zeitgeist_search_engine_proxy_acquired (ZeitgeistSearchEngine* self, GObject* obj, GAsyncResult* res) {
	GObject* _tmp0_;
	GDBusConnection* _tmp1_;
	GDBusConnection* conn;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (G_IS_DBUS_CONNECTION (_tmp0_) ? ((GDBusConnection*) _tmp0_) : NULL);
	conn = _tmp1_;
	{
		GAsyncResult* _tmp2_;
		ZeitgeistRemoteSimpleIndexer* _tmp3_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp4_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp5_;
		_tmp2_ = res;
		_tmp3_ = g_async_result_get_source_object (_tmp2_);
		_tmp4_ = g_async_initable_new_finish (_tmp3_, _tmp2_, &_inner_error_);
		g_object_unref (_tmp3_);
		_tmp5_ = (ZeitgeistRemoteSimpleIndexer*) _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (self->priv->siin);
		self->priv->siin = _tmp5_;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("fts.vala:102: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (conn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (conn);
}


static void zeitgeist_search_engine_real_search_data_free (gpointer _data) {
	ZeitgeistSearchEngineSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->filter_templates);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistSearchEngineSearchData, _data_);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void zeitgeist_search_engine_real_search (ZeitgeistRemoteSearchEngine* base, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistSearchEngine * self;
	ZeitgeistSearchEngineSearchData* _data_;
	ZeitgeistSearchEngine* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	self = (ZeitgeistSearchEngine*) base;
	_data_ = g_slice_new0 (ZeitgeistSearchEngineSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_search_engine_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_search_engine_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->query_string = _tmp2_;
	_tmp3_ = time_range;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_data_->time_range = _tmp4_;
	_tmp5_ = filter_templates;
	_tmp6_ = _g_variant_ref0 (_tmp5_);
	_data_->filter_templates = _tmp6_;
	_tmp7_ = offset;
	_data_->offset = _tmp7_;
	_tmp8_ = count;
	_data_->count = _tmp8_;
	_tmp9_ = result_type;
	_data_->result_type = _tmp9_;
	zeitgeist_search_engine_real_search_co (_data_);
}


static GVariant* zeitgeist_search_engine_real_search_finish (ZeitgeistRemoteSearchEngine* base, GAsyncResult* _res_, GVariant** events, GError** error) {
	GVariant* result;
	ZeitgeistSearchEngineSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (events) {
		*events = _data_->events;
	} else {
		_g_variant_unref0 (_data_->events);
	}
	_data_->events = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void zeitgeist_search_engine_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistSearchEngineSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_search_engine_real_search_co (_data_);
}


static gboolean zeitgeist_search_engine_real_search_co (ZeitgeistSearchEngineSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->siin;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->siin;
		_data_->_tmp0_ = !G_IS_DBUS_PROXY (_data_->_tmp2_);
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	if (_data_->_tmp3_) {
		_data_->_tmp4_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, "Not connected to SimpleIndexer");
		_data_->_inner_error_ = _data_->_tmp4_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = g_timer_new ();
	_data_->timer = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->self->priv->siin;
	_data_->_tmp7_ = _g_object_ref0 (G_DBUS_PROXY (_data_->_tmp6_));
	_data_->proxy = _data_->_tmp7_;
	_data_->_tmp8_ = g_variant_type_new ("(s(xx)a(asaasay)uuu)");
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = g_variant_builder_new (_data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_g_variant_type_free0 (_data_->_tmp9_);
	_data_->b = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->query_string;
	g_variant_builder_add (_data_->b, "s", _data_->_tmp12_, NULL);
	_data_->_tmp13_ = _data_->time_range;
	g_variant_builder_add_value (_data_->b, _data_->_tmp13_);
	_data_->_tmp14_ = _data_->filter_templates;
	g_variant_builder_add_value (_data_->b, _data_->_tmp14_);
	_data_->_tmp15_ = _data_->offset;
	g_variant_builder_add (_data_->b, "u", _data_->_tmp15_, NULL);
	_data_->_tmp16_ = _data_->count;
	g_variant_builder_add (_data_->b, "u", _data_->_tmp16_, NULL);
	_data_->_tmp17_ = _data_->result_type;
	g_variant_builder_add (_data_->b, "u", _data_->_tmp17_, NULL);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = g_variant_builder_end (_data_->b);
	_data_->_tmp19_ = g_variant_ref_sink (_data_->_tmp18_);
	_data_->_state_ = 1;
	g_dbus_proxy_call (_data_->proxy, "Search", _data_->_tmp19_, 0, -1, NULL, zeitgeist_search_engine_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = g_dbus_proxy_call_finish (_data_->proxy, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp21_ = _data_->_tmp20_;
	_g_variant_unref0 (_data_->_tmp19_);
	_data_->_result_ = _data_->_tmp21_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_variant_builder_unref0 (_data_->b);
		_g_object_unref0 (_data_->proxy);
		_g_timer_destroy0 (_data_->timer);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = g_variant_get_child_value (_data_->_result_, (gsize) 0);
	_g_variant_unref0 (_data_->events);
	_data_->events = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->events;
	_data_->_tmp24_ = 0UL;
	_data_->_tmp24_ = g_variant_n_children (_data_->_tmp23_);
	_data_->_tmp25_ = 0.0;
	_data_->_tmp25_ = g_timer_elapsed (_data_->timer, NULL);
	g_debug ("fts.vala:136: Got %u results from indexer (in %f seconds)", (guint) _data_->_tmp24_, _data_->_tmp25_);
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = g_variant_get_child_value (_data_->_result_, (gsize) 1);
	_data_->result = _data_->_tmp26_;
	_g_variant_unref0 (_data_->_result_);
	_g_variant_builder_unref0 (_data_->b);
	_g_object_unref0 (_data_->proxy);
	_g_timer_destroy0 (_data_->timer);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_variant_unref0 (_data_->_result_);
	_g_variant_builder_unref0 (_data_->b);
	_g_object_unref0 (_data_->proxy);
	_g_timer_destroy0 (_data_->timer);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _zeitgeist_search_engine_proxy_acquired_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	zeitgeist_search_engine_proxy_acquired (self, source_object, res);
	g_object_unref (self);
}


static void _zeitgeist_search_engine____lambda0_ (ZeitgeistSearchEngine* self, GDBusConnection* conn) {
	ZeitgeistRemoteSimpleIndexer* _tmp0_;
	GDBusConnection* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (conn != NULL);
	_tmp0_ = self->priv->siin;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = conn;
	g_async_initable_new_async (ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER_PROXY, 0, NULL, _zeitgeist_search_engine_proxy_acquired_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", "org.gnome.zeitgeist.SimpleIndexer", "g-connection", _tmp1_, "g-object-path", "/org/gnome/zeitgeist/index/activity", "g-interface-name", "org.gnome.zeitgeist.Index", NULL);
}


static void __zeitgeist_search_engine____lambda0__gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	_zeitgeist_search_engine____lambda0_ (self, connection);
}


static void _zeitgeist_search_engine____lambda1_ (ZeitgeistSearchEngine* self) {
}


static void __zeitgeist_search_engine____lambda1__gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	_zeitgeist_search_engine____lambda1_ (self);
}


static GObject * zeitgeist_search_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistSearchEngine * self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_search_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ZEITGEIST_SEARCH_ENGINE (obj);
	_tmp0_ = zeitgeist_utils_using_in_memory_database ();
	if (_tmp0_) {
		return obj;
	}
	{
		GDBusConnection* _tmp1_ = NULL;
		GDBusConnection* connection;
		GDBusConnection* _tmp2_;
		guint _tmp3_ = 0U;
		guint _tmp4_;
		GDBusConnection* _tmp5_;
		_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp2_ = connection;
		_tmp3_ = zeitgeist_remote_search_engine_register_object ((ZeitgeistRemoteSearchEngine*) self, _tmp2_, "/org/gnome/zeitgeist/index/activity", &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (connection);
			goto __catch1_g_error;
		}
		self->priv->registration_id = _tmp4_;
		_tmp5_ = connection;
		g_bus_watch_name_on_connection_with_closures (_tmp5_, "org.gnome.zeitgeist.SimpleIndexer", G_BUS_NAME_WATCHER_FLAGS_AUTO_START, (GClosure*) ((__zeitgeist_search_engine____lambda0__gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __zeitgeist_search_engine____lambda0__gbus_name_appeared_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((__zeitgeist_search_engine____lambda1__gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __zeitgeist_search_engine____lambda1__gbus_name_vanished_callback, g_object_ref (self), g_object_unref)));
		_g_object_unref0 (connection);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("fts.vala:89: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void zeitgeist_search_engine_class_init (ZeitgeistSearchEngineClass * klass) {
	zeitgeist_search_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistSearchEnginePrivate));
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_search_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_search_engine_finalize;
}


static void zeitgeist_search_engine_zeitgeist_remote_search_engine_interface_init (ZeitgeistRemoteSearchEngineIface * iface) {
	zeitgeist_search_engine_zeitgeist_remote_search_engine_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (GVariant* (*)(ZeitgeistRemoteSearchEngine*, const gchar*, GVariant*, GVariant*, guint, guint, guint, GVariant**, GError**)) zeitgeist_search_engine_real_search;
	iface->search_finish = zeitgeist_search_engine_real_search_finish;
}


static void zeitgeist_search_engine_instance_init (ZeitgeistSearchEngine * self) {
	self->priv = ZEITGEIST_SEARCH_ENGINE_GET_PRIVATE (self);
}


static void zeitgeist_search_engine_finalize (GObject* obj) {
	ZeitgeistSearchEngine * self;
	self = ZEITGEIST_SEARCH_ENGINE (obj);
	_g_object_unref0 (self->priv->siin);
	G_OBJECT_CLASS (zeitgeist_search_engine_parent_class)->finalize (obj);
}


GType zeitgeist_search_engine_get_type (void) {
	return zeitgeist_search_engine_type_id;
}


GType zeitgeist_search_engine_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSearchEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_search_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSearchEngine), 0, (GInstanceInitFunc) zeitgeist_search_engine_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_search_engine_info = { (GInterfaceInitFunc) zeitgeist_search_engine_zeitgeist_remote_search_engine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_search_engine_type_id = g_type_module_register_type (module, ZEITGEIST_TYPE_EXTENSION, "ZeitgeistSearchEngine", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_search_engine_type_id, ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, &zeitgeist_remote_search_engine_info);
	return zeitgeist_search_engine_type_id;
}


GType zeitgeist_extension_register (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	zeitgeist_remote_search_engine_register_type (module);
	zeitgeist_search_engine_register_type (module);
	result = ZEITGEIST_TYPE_SEARCH_ENGINE;
	return result;
}



