/* storage-monitor.c generated by valac 0.14.0, the Vala compiler
 * generated from storage-monitor.vala, do not modify */

/* ds-registry.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * Based upon a Python implementation:
 *  Copyright © 2009 Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Copyright © 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <zeitgeist-engine.h>
#include <sqlite3.h>


#define ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR (zeitgeist_remote_storage_monitor_get_type ())
#define ZEITGEIST_REMOTE_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, ZeitgeistRemoteStorageMonitor))
#define ZEITGEIST_IS_REMOTE_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR))
#define ZEITGEIST_REMOTE_STORAGE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, ZeitgeistRemoteStorageMonitorIface))

typedef struct _ZeitgeistRemoteStorageMonitor ZeitgeistRemoteStorageMonitor;
typedef struct _ZeitgeistRemoteStorageMonitorIface ZeitgeistRemoteStorageMonitorIface;

#define ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR_PROXY (zeitgeist_remote_storage_monitor_proxy_get_type ())
typedef GDBusProxy ZeitgeistRemoteStorageMonitorProxy;
typedef GDBusProxyClass ZeitgeistRemoteStorageMonitorProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define ZEITGEIST_TYPE_STORAGE_MONITOR (zeitgeist_storage_monitor_get_type ())
#define ZEITGEIST_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitor))
#define ZEITGEIST_STORAGE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitorClass))
#define ZEITGEIST_IS_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_STORAGE_MONITOR))
#define ZEITGEIST_IS_STORAGE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_STORAGE_MONITOR))
#define ZEITGEIST_STORAGE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitorClass))

typedef struct _ZeitgeistStorageMonitor ZeitgeistStorageMonitor;
typedef struct _ZeitgeistStorageMonitorClass ZeitgeistStorageMonitorClass;
typedef struct _ZeitgeistStorageMonitorPrivate ZeitgeistStorageMonitorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _ZeitgeistRemoteStorageMonitorIface {
	GTypeInterface parent_iface;
	GVariant* (*get_storages) (ZeitgeistRemoteStorageMonitor* self, GError** error);
};

struct _ZeitgeistStorageMonitor {
	ZeitgeistExtension parent_instance;
	ZeitgeistStorageMonitorPrivate * priv;
};

struct _ZeitgeistStorageMonitorClass {
	ZeitgeistExtensionClass parent_class;
};

struct _ZeitgeistStorageMonitorPrivate {
	ZeitgeistSQLiteZeitgeistDatabase* database;
	sqlite3* db;
	guint registration_id;
	sqlite3_stmt* get_storages_stmt;
	sqlite3_stmt* store_storage_medium_stmt;
	sqlite3_stmt* insert_unavailable_medium_stmt;
	sqlite3_stmt* update_medium_state_stmt;
};


static GType zeitgeist_remote_storage_monitor_type_id = 0;
static gpointer zeitgeist_storage_monitor_parent_class = NULL;
static ZeitgeistRemoteStorageMonitorIface* zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_parent_iface = NULL;
static GType zeitgeist_storage_monitor_type_id = 0;

GType zeitgeist_remote_storage_monitor_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_storage_monitor_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_storage_monitor_get_type (void) G_GNUC_CONST;
GType zeitgeist_remote_storage_monitor_register_type (GTypeModule * module);
GVariant* zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void zeitgeist_remote_storage_monitor_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_zeitgeist_remote_storage_monitor_storage_available (ZeitgeistRemoteStorageMonitor* self, GVariant* parameters);
static void _dbus_handle_zeitgeist_remote_storage_monitor_storage_unavailable (ZeitgeistRemoteStorageMonitor* self, GVariant* parameters);
static GVariant* zeitgeist_remote_storage_monitor_proxy_get_storages (ZeitgeistRemoteStorageMonitor* self, GError** error);
static void zeitgeist_remote_storage_monitor_proxy_zeitgeist_remote_storage_monitor_interface_init (ZeitgeistRemoteStorageMonitorIface* iface);
static void _dbus_zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void zeitgeist_remote_storage_monitor_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* zeitgeist_remote_storage_monitor_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean zeitgeist_remote_storage_monitor_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_zeitgeist_remote_storage_monitor_storage_available (GObject* _sender, const gchar* storage_id, GVariant* storage_description, gpointer* _data);
static void _dbus_zeitgeist_remote_storage_monitor_storage_unavailable (GObject* _sender, const gchar* storage_id, gpointer* _data);
static void _zeitgeist_remote_storage_monitor_unregister_object (gpointer user_data);
GVariant* zeitgeist_storage_media_to_variant (const gchar* medium_name, gboolean available, const gchar* icon, const gchar* display_name);
GType zeitgeist_storage_monitor_get_type (void) G_GNUC_CONST;
GType zeitgeist_storage_monitor_register_type (GTypeModule * module);
#define ZEITGEIST_STORAGE_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitorPrivate))
enum  {
	ZEITGEIST_STORAGE_MONITOR_DUMMY_PROPERTY
};
static ZeitgeistStorageMonitor* zeitgeist_storage_monitor_new (void);
static ZeitgeistStorageMonitor* zeitgeist_storage_monitor_construct (GType object_type);
static void zeitgeist_storage_monitor_real_unload (ZeitgeistExtension* base);
static void zeitgeist_storage_monitor_prepare_queries (ZeitgeistStorageMonitor* self, GError** error);
static void zeitgeist_storage_monitor_real_pre_insert_events (ZeitgeistExtension* base, GPtrArray* events, const char* sender);
static gchar* zeitgeist_storage_monitor_find_storage_for_uri (ZeitgeistStorageMonitor* self, const gchar* uri);
static void zeitgeist_storage_monitor_on_volume_added (ZeitgeistStorageMonitor* self, GVolumeMonitor* monitor, GVolume* volume);
void zeitgeist_storage_monitor_add_storage_medium (ZeitgeistStorageMonitor* self, const gchar* medium_name, const gchar* icon, const gchar* display_name);
static gchar* zeitgeist_storage_monitor_get_volume_id (ZeitgeistStorageMonitor* self, GVolume* volume);
static void zeitgeist_storage_monitor_on_volume_removed (ZeitgeistStorageMonitor* self, GVolumeMonitor* monitor, GVolume* volume);
void zeitgeist_storage_monitor_remove_storage_medium (ZeitgeistStorageMonitor* self, const gchar* medium_name);
static GVariant* zeitgeist_storage_monitor_real_get_storages (ZeitgeistRemoteStorageMonitor* base, GError** error);
static GObject * zeitgeist_storage_monitor_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _zeitgeist_storage_monitor_on_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _zeitgeist_storage_monitor_on_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void zeitgeist_storage_monitor_finalize (GObject* obj);
GType zeitgeist_extension_register (GTypeModule* module);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_result = {-1, "result", "a(sa{sv})"};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_in[] = {NULL};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_out[] = {&_zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_storage_monitor_dbus_method_info_get_storages = {-1, "GetStorages", (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_in), (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_out)};
static const GDBusMethodInfo * const _zeitgeist_remote_storage_monitor_dbus_method_info[] = {&_zeitgeist_remote_storage_monitor_dbus_method_info_get_storages, NULL};
static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_id = {-1, "storage_id", "s"};
static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_description = {-1, "storage_description", "a{sv}"};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available[] = {&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_id, &_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_description, NULL};
static const GDBusSignalInfo _zeitgeist_remote_storage_monitor_dbus_signal_info_storage_available = {-1, "StorageAvailable", (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available)};
static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable_storage_id = {-1, "storage_id", "s"};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable[] = {&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable_storage_id, NULL};
static const GDBusSignalInfo _zeitgeist_remote_storage_monitor_dbus_signal_info_storage_unavailable = {-1, "StorageUnavailable", (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable)};
static const GDBusSignalInfo * const _zeitgeist_remote_storage_monitor_dbus_signal_info[] = {&_zeitgeist_remote_storage_monitor_dbus_signal_info_storage_available, &_zeitgeist_remote_storage_monitor_dbus_signal_info_storage_unavailable, NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_storage_monitor_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_storage_monitor_dbus_interface_info = {-1, "org.gnome.zeitgeist.StorageMonitor", (GDBusMethodInfo **) (&_zeitgeist_remote_storage_monitor_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_storage_monitor_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_storage_monitor_dbus_property_info)};
static const GDBusInterfaceVTable _zeitgeist_remote_storage_monitor_dbus_interface_vtable = {zeitgeist_remote_storage_monitor_dbus_interface_method_call, zeitgeist_remote_storage_monitor_dbus_interface_get_property, zeitgeist_remote_storage_monitor_dbus_interface_set_property};

GVariant* zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return ZEITGEIST_REMOTE_STORAGE_MONITOR_GET_INTERFACE (self)->get_storages (self, error);
}


static void g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), data2);
}


static void zeitgeist_remote_storage_monitor_base_init (ZeitgeistRemoteStorageMonitorIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("storage_available", ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VARIANT);
		g_signal_new ("storage_unavailable", ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


GType zeitgeist_remote_storage_monitor_get_type (void) {
	return zeitgeist_remote_storage_monitor_type_id;
}


GType zeitgeist_remote_storage_monitor_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteStorageMonitorIface), (GBaseInitFunc) zeitgeist_remote_storage_monitor_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	zeitgeist_remote_storage_monitor_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ZeitgeistRemoteStorageMonitor", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_remote_storage_monitor_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_storage_monitor_proxy_get_type);
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.StorageMonitor");
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_storage_monitor_register_object);
	return zeitgeist_remote_storage_monitor_type_id;
}


G_DEFINE_TYPE_EXTENDED (ZeitgeistRemoteStorageMonitorProxy, zeitgeist_remote_storage_monitor_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, zeitgeist_remote_storage_monitor_proxy_zeitgeist_remote_storage_monitor_interface_init) )
static void zeitgeist_remote_storage_monitor_proxy_class_init (ZeitgeistRemoteStorageMonitorProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_storage_monitor_proxy_g_signal;
}


static void _dbus_handle_zeitgeist_remote_storage_monitor_storage_available (ZeitgeistRemoteStorageMonitor* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* storage_id = NULL;
	GVariant* _tmp0_;
	GVariant* storage_description = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	storage_id = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	storage_description = g_variant_iter_next_value (&_arguments_iter);
	g_signal_emit_by_name (self, "storage-available", storage_id, storage_description);
	_g_free0 (storage_id);
	_g_variant_unref0 (storage_description);
}


static void _dbus_handle_zeitgeist_remote_storage_monitor_storage_unavailable (ZeitgeistRemoteStorageMonitor* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* storage_id = NULL;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	storage_id = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "storage-unavailable", storage_id);
	_g_free0 (storage_id);
}


static void zeitgeist_remote_storage_monitor_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "StorageAvailable") == 0) {
		_dbus_handle_zeitgeist_remote_storage_monitor_storage_available ((ZeitgeistRemoteStorageMonitor*) proxy, parameters);
	} else if (strcmp (signal_name, "StorageUnavailable") == 0) {
		_dbus_handle_zeitgeist_remote_storage_monitor_storage_unavailable ((ZeitgeistRemoteStorageMonitor*) proxy, parameters);
	}
}


static void zeitgeist_remote_storage_monitor_proxy_init (ZeitgeistRemoteStorageMonitorProxy* self) {
}


static GVariant* zeitgeist_remote_storage_monitor_proxy_get_storages (ZeitgeistRemoteStorageMonitor* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _result;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.StorageMonitor", "GetStorages");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result = g_variant_iter_next_value (&_reply_iter);
	g_object_unref (_reply_message);
	return _result;
}


static void zeitgeist_remote_storage_monitor_proxy_zeitgeist_remote_storage_monitor_interface_init (ZeitgeistRemoteStorageMonitorIface* iface) {
	iface->get_storages = zeitgeist_remote_storage_monitor_proxy_get_storages;
}


static void _dbus_zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = zeitgeist_remote_storage_monitor_get_storages (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void zeitgeist_remote_storage_monitor_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetStorages") == 0) {
		_dbus_zeitgeist_remote_storage_monitor_get_storages (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* zeitgeist_remote_storage_monitor_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean zeitgeist_remote_storage_monitor_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_zeitgeist_remote_storage_monitor_storage_available (GObject* _sender, const gchar* storage_id, GVariant* storage_description, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (storage_id));
	g_variant_builder_add_value (&_arguments_builder, storage_description);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.zeitgeist.StorageMonitor", "StorageAvailable", _arguments, NULL);
}


static void _dbus_zeitgeist_remote_storage_monitor_storage_unavailable (GObject* _sender, const gchar* storage_id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (storage_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.zeitgeist.StorageMonitor", "StorageUnavailable", _arguments, NULL);
}


guint zeitgeist_remote_storage_monitor_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_storage_monitor_dbus_interface_info), &_zeitgeist_remote_storage_monitor_dbus_interface_vtable, data, _zeitgeist_remote_storage_monitor_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "storage-available", (GCallback) _dbus_zeitgeist_remote_storage_monitor_storage_available, data);
	g_signal_connect (object, "storage-unavailable", (GCallback) _dbus_zeitgeist_remote_storage_monitor_storage_unavailable, data);
	return result;
}


static void _zeitgeist_remote_storage_monitor_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_zeitgeist_remote_storage_monitor_storage_available, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_zeitgeist_remote_storage_monitor_storage_unavailable, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


GVariant* zeitgeist_storage_media_to_variant (const gchar* medium_name, gboolean available, const gchar* icon, const gchar* display_name) {
	GVariant* result = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* vb;
	const gchar* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	GVariant* _tmp22_ = NULL;
	GVariant* _tmp23_;
	g_return_val_if_fail (medium_name != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = g_variant_type_new ("(sa{sv})");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = medium_name;
	g_variant_builder_add (vb, "s", _tmp4_, NULL);
	_tmp5_ = g_variant_type_new ("a{sv}");
	_tmp6_ = _tmp5_;
	g_variant_builder_open (vb, _tmp6_);
	_g_variant_type_free0 (_tmp6_);
	{
		GVariantType* _tmp7_;
		GVariantType* _tmp8_;
		gboolean _tmp9_;
		GVariant* _tmp10_;
		GVariant* _tmp11_;
		GVariantType* _tmp12_;
		GVariantType* _tmp13_;
		const gchar* _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		GVariantType* _tmp17_;
		GVariantType* _tmp18_;
		const gchar* _tmp19_;
		GVariant* _tmp20_;
		GVariant* _tmp21_;
		_tmp7_ = g_variant_type_new ("{sv}");
		_tmp8_ = _tmp7_;
		g_variant_builder_open (vb, _tmp8_);
		_g_variant_type_free0 (_tmp8_);
		g_variant_builder_add (vb, "s", "available", NULL);
		_tmp9_ = available;
		_tmp10_ = g_variant_new ("b", _tmp9_, NULL);
		_tmp11_ = g_variant_ref_sink (_tmp10_);
		g_variant_builder_add (vb, "v", _tmp11_, NULL);
		_g_variant_unref0 (_tmp11_);
		g_variant_builder_close (vb);
		_tmp12_ = g_variant_type_new ("{sv}");
		_tmp13_ = _tmp12_;
		g_variant_builder_open (vb, _tmp13_);
		_g_variant_type_free0 (_tmp13_);
		g_variant_builder_add (vb, "s", "icon", NULL);
		_tmp14_ = icon;
		_tmp15_ = g_variant_new ("s", _tmp14_, NULL);
		_tmp16_ = g_variant_ref_sink (_tmp15_);
		g_variant_builder_add (vb, "v", _tmp16_, NULL);
		_g_variant_unref0 (_tmp16_);
		g_variant_builder_close (vb);
		_tmp17_ = g_variant_type_new ("{sv}");
		_tmp18_ = _tmp17_;
		g_variant_builder_open (vb, _tmp18_);
		_g_variant_type_free0 (_tmp18_);
		g_variant_builder_add (vb, "s", "display-name", NULL);
		_tmp19_ = display_name;
		_tmp20_ = g_variant_new ("s", _tmp19_, NULL);
		_tmp21_ = g_variant_ref_sink (_tmp20_);
		g_variant_builder_add (vb, "v", _tmp21_, NULL);
		_g_variant_unref0 (_tmp21_);
		g_variant_builder_close (vb);
	}
	g_variant_builder_close (vb);
	_tmp22_ = g_variant_builder_end (vb);
	_tmp23_ = g_variant_ref_sink (_tmp22_);
	result = _tmp23_;
	_g_variant_builder_unref0 (vb);
	return result;
}


static ZeitgeistStorageMonitor* zeitgeist_storage_monitor_construct (GType object_type) {
	ZeitgeistStorageMonitor * self = NULL;
	self = (ZeitgeistStorageMonitor*) g_object_new (object_type, NULL);
	return self;
}


static ZeitgeistStorageMonitor* zeitgeist_storage_monitor_new (void) {
	return zeitgeist_storage_monitor_construct (ZEITGEIST_TYPE_STORAGE_MONITOR);
}


static void zeitgeist_storage_monitor_real_unload (ZeitgeistExtension* base) {
	ZeitgeistStorageMonitor * self;
	guint _tmp5_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistStorageMonitor*) base;
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* connection;
		guint _tmp1_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->registration_id;
		if (_tmp1_ != ((guint) 0)) {
			guint _tmp2_;
			_tmp2_ = self->priv->registration_id;
			g_dbus_connection_unregister_object (connection, _tmp2_);
			self->priv->registration_id = (guint) 0;
		}
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("storage-monitor.vala:157: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = ((GObject*) self)->ref_count;
	g_debug ("storage-monitor.vala:160: %s, this.ref_count = %u", "Zeitgeist.StorageMonitor.unload", _tmp5_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void zeitgeist_storage_monitor_prepare_queries (ZeitgeistStorageMonitor* self, GError** error) {
	ZeitgeistEngine* _tmp0_;
	ZeitgeistEngine* _tmp1_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp2_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp3_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp4_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp5_;
	sqlite3* _tmp6_;
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp7_;
	sqlite3* _tmp8_;
	const gchar* _tmp9_;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	sqlite3* _tmp15_;
	const gchar* _tmp16_;
	sqlite3_stmt* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_;
	sqlite3* _tmp22_;
	const gchar* _tmp23_;
	sqlite3_stmt* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp26_;
	gint _tmp27_;
	gchar* _tmp28_;
	sqlite3* _tmp29_;
	const gchar* _tmp30_;
	sqlite3_stmt* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp33_;
	gint _tmp34_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = zeitgeist_extension_get_engine ((ZeitgeistExtension*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = zeitgeist_engine_get_database (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp4_;
	_tmp5_ = self->priv->database;
	_tmp6_ = _tmp5_->database;
	self->priv->db = _tmp6_;
	_tmp7_ = g_strdup ("\n" \
"                SELECT value, state, icon, display_name\n" \
"                FROM storage\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp7_;
	_tmp8_ = self->priv->db;
	_tmp9_ = sql;
	_tmp11_ = sqlite3_prepare_v2 (_tmp8_, _tmp9_, -1, &_tmp10_, NULL);
	_sqlite3_finalize0 (self->priv->get_storages_stmt);
	self->priv->get_storages_stmt = _tmp10_;
	rc = _tmp11_;
	_tmp12_ = self->priv->database;
	_tmp13_ = rc;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp12_, _tmp13_, "Storage retrieval query error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = g_strdup ("\n" \
"                INSERT OR REPLACE INTO storage (\n" \
"                    value, state, icon, display_name\n" \
"                ) VALUES (\n" \
"                    ?, ?, ?, ?\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp14_;
	_tmp15_ = self->priv->db;
	_tmp16_ = sql;
	_tmp18_ = sqlite3_prepare_v2 (_tmp15_, _tmp16_, -1, &_tmp17_, NULL);
	_sqlite3_finalize0 (self->priv->store_storage_medium_stmt);
	self->priv->store_storage_medium_stmt = _tmp17_;
	rc = _tmp18_;
	_tmp19_ = self->priv->database;
	_tmp20_ = rc;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp19_, _tmp20_, "Storage insertion query error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp21_ = g_strdup ("\n" \
"                INSERT INTO storage (\n" \
"                    state, value\n" \
"                ) VALUES (\n" \
"                    ?, ?\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp21_;
	_tmp22_ = self->priv->db;
	_tmp23_ = sql;
	_tmp25_ = sqlite3_prepare_v2 (_tmp22_, _tmp23_, -1, &_tmp24_, NULL);
	_sqlite3_finalize0 (self->priv->insert_unavailable_medium_stmt);
	self->priv->insert_unavailable_medium_stmt = _tmp24_;
	rc = _tmp25_;
	_tmp26_ = self->priv->database;
	_tmp27_ = rc;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp26_, _tmp27_, "insert_unavailable_medium_stmt error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp28_ = g_strdup ("\n" \
"                UPDATE storage\n" \
"                SET state=?\n" \
"                WHERE value=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp28_;
	_tmp29_ = self->priv->db;
	_tmp30_ = sql;
	_tmp32_ = sqlite3_prepare_v2 (_tmp29_, _tmp30_, -1, &_tmp31_, NULL);
	_sqlite3_finalize0 (self->priv->update_medium_state_stmt);
	self->priv->update_medium_state_stmt = _tmp31_;
	rc = _tmp32_;
	_tmp33_ = self->priv->database;
	_tmp34_ = rc;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp33_, _tmp34_, "update_medium_state_stmt error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (sql);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void zeitgeist_storage_monitor_real_pre_insert_events (ZeitgeistExtension* base, GPtrArray* events, const char* sender) {
	ZeitgeistStorageMonitor * self;
	self = (ZeitgeistStorageMonitor*) base;
	g_return_if_fail (events != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = events;
				_tmp5_ = g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				{
					gint j;
					j = 0;
					{
						gboolean _tmp7_;
						_tmp7_ = TRUE;
						while (TRUE) {
							gboolean _tmp8_;
							gint _tmp10_;
							GPtrArray* _tmp11_;
							gint _tmp12_;
							gconstpointer _tmp13_ = NULL;
							GPtrArray* _tmp14_;
							GPtrArray* _tmp15_;
							gint _tmp16_;
							gint _tmp17_;
							GPtrArray* _tmp18_;
							gint _tmp19_;
							gconstpointer _tmp20_ = NULL;
							GPtrArray* _tmp21_;
							GPtrArray* _tmp22_;
							gint _tmp23_;
							gconstpointer _tmp24_ = NULL;
							ZeitgeistSubject* _tmp25_;
							ZeitgeistSubject* subject;
							ZeitgeistSubject* _tmp26_;
							const gchar* _tmp27_;
							const gchar* _tmp28_;
							_tmp8_ = _tmp7_;
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp10_ = j;
							_tmp11_ = events;
							_tmp12_ = i;
							_tmp13_ = g_ptr_array_index (_tmp11_, (guint) _tmp12_);
							_tmp14_ = zeitgeist_event_get_subjects ((ZeitgeistEvent*) _tmp13_);
							_tmp15_ = _tmp14_;
							_tmp16_ = g_ptr_array_get_length (_tmp15_);
							_tmp17_ = _tmp16_;
							if (!(_tmp10_ < _tmp17_)) {
								break;
							}
							_tmp18_ = events;
							_tmp19_ = i;
							_tmp20_ = g_ptr_array_index (_tmp18_, (guint) _tmp19_);
							_tmp21_ = zeitgeist_event_get_subjects ((ZeitgeistEvent*) _tmp20_);
							_tmp22_ = _tmp21_;
							_tmp23_ = j;
							_tmp24_ = g_ptr_array_index (_tmp22_, (guint) _tmp23_);
							_tmp25_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp24_);
							subject = _tmp25_;
							_tmp26_ = subject;
							_tmp27_ = zeitgeist_subject_get_storage (_tmp26_);
							_tmp28_ = _tmp27_;
							if (g_strcmp0 (_tmp28_, "") == 0) {
								ZeitgeistSubject* _tmp29_;
								ZeitgeistSubject* _tmp30_;
								const gchar* _tmp31_;
								const gchar* _tmp32_;
								gchar* _tmp33_ = NULL;
								gchar* _tmp34_;
								_tmp29_ = subject;
								_tmp30_ = subject;
								_tmp31_ = zeitgeist_subject_get_uri (_tmp30_);
								_tmp32_ = _tmp31_;
								_tmp33_ = zeitgeist_storage_monitor_find_storage_for_uri (self, _tmp32_);
								_tmp34_ = _tmp33_;
								zeitgeist_subject_set_storage (_tmp29_, _tmp34_);
								_g_free0 (_tmp34_);
							}
							_g_object_unref0 (subject);
						}
					}
				}
			}
		}
	}
}


static gchar* zeitgeist_storage_monitor_find_storage_for_uri (ZeitgeistStorageMonitor* self, const gchar* uri) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_strdup ("unknown");
	result = _tmp0_;
	return result;
}


static void zeitgeist_storage_monitor_on_volume_added (ZeitgeistStorageMonitor* self, GVolumeMonitor* monitor, GVolume* volume) {
	GVolume* _tmp0_;
	GIcon* _tmp1_ = NULL;
	GIcon* _tmp2_;
	GIcon* icon;
	gchar* _tmp3_;
	gchar* icon_name;
	gboolean _tmp4_ = FALSE;
	GIcon* _tmp5_;
	gboolean _tmp9_;
	GVolume* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GVolume* _tmp19_;
	const gchar* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (volume != NULL);
	g_debug ("storage-monitor.vala:233: volume added");
	_tmp0_ = volume;
	_tmp1_ = g_volume_get_icon (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	icon = _tmp2_;
	_tmp3_ = g_strdup ("");
	icon_name = _tmp3_;
	_tmp5_ = icon;
	if (G_IS_THEMED_ICON (_tmp5_)) {
		GIcon* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_ = NULL;
		_tmp6_ = icon;
		_tmp8_ = _tmp7_ = g_themed_icon_get_names (G_THEMED_ICON (_tmp6_));
		_tmp4_ = _vala_array_length (_tmp7_) > 0;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		GIcon* _tmp10_;
		gchar** _tmp11_;
		gchar** _tmp12_ = NULL;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp10_ = icon;
		_tmp12_ = _tmp11_ = g_themed_icon_get_names (G_THEMED_ICON (_tmp10_));
		_tmp13_ = _tmp12_[0];
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (icon_name);
		icon_name = _tmp14_;
	}
	_tmp15_ = volume;
	_tmp16_ = zeitgeist_storage_monitor_get_volume_id (self, _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = icon_name;
	_tmp19_ = volume;
	_tmp20_ = g_volume_get_name (_tmp19_);
	zeitgeist_storage_monitor_add_storage_medium (self, _tmp17_, _tmp18_, _tmp20_);
	_g_free0 (_tmp17_);
	_g_free0 (icon_name);
	_g_object_unref0 (icon);
}


static void zeitgeist_storage_monitor_on_volume_removed (ZeitgeistStorageMonitor* self, GVolumeMonitor* monitor, GVolume* volume) {
	GVolume* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (volume != NULL);
	g_debug ("storage-monitor.vala:245: Volume removed");
	_tmp0_ = volume;
	_tmp1_ = zeitgeist_storage_monitor_get_volume_id (self, _tmp0_);
	_tmp2_ = _tmp1_;
	zeitgeist_storage_monitor_remove_storage_medium (self, _tmp2_);
	_g_free0 (_tmp2_);
}


static gchar* zeitgeist_storage_monitor_get_volume_id (ZeitgeistStorageMonitor* self, GVolume* volume) {
	gchar* result = NULL;
	gchar* volume_id = NULL;
	GVolume* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GVolume* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GVolume* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (volume != NULL, NULL);
	_tmp0_ = volume;
	_tmp1_ = g_volume_get_uuid (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (volume_id);
	volume_id = _tmp2_;
	_tmp3_ = volume_id;
	if (_tmp3_ != NULL) {
		result = volume_id;
		return result;
	}
	_tmp4_ = volume;
	_tmp5_ = g_volume_get_identifier (_tmp4_, "uuid");
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (volume_id);
	volume_id = _tmp6_;
	_tmp7_ = volume_id;
	if (_tmp7_ != NULL) {
		result = volume_id;
		return result;
	}
	_tmp8_ = volume;
	_tmp9_ = g_volume_get_identifier (_tmp8_, "label");
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (volume_id);
	volume_id = _tmp10_;
	_tmp11_ = volume_id;
	if (_tmp11_ != NULL) {
		result = volume_id;
		return result;
	}
	_tmp12_ = g_strdup ("unknown");
	result = _tmp12_;
	_g_free0 (volume_id);
	return result;
}


void zeitgeist_storage_monitor_add_storage_medium (ZeitgeistStorageMonitor* self, const gchar* medium_name, const gchar* icon, const gchar* display_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	sqlite3_stmt* _tmp8_;
	sqlite3_stmt* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GDestroyNotify _tmp12_;
	sqlite3_stmt* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GDestroyNotify _tmp16_;
	sqlite3_stmt* _tmp17_;
	gint _tmp18_ = 0;
	gint rc;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (medium_name != NULL);
	g_return_if_fail (icon != NULL);
	g_return_if_fail (display_name != NULL);
	_tmp0_ = medium_name;
	_tmp1_ = g_strdup_printf ("VOLUME ADDED: %s", _tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("storage-monitor.vala:276: %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->store_storage_medium_stmt;
	sqlite3_reset (_tmp3_);
	_tmp4_ = self->priv->store_storage_medium_stmt;
	_tmp5_ = medium_name;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = g_free;
	sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
	_tmp8_ = self->priv->store_storage_medium_stmt;
	sqlite3_bind_int (_tmp8_, 2, 1);
	_tmp9_ = self->priv->store_storage_medium_stmt;
	_tmp10_ = icon;
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_free;
	sqlite3_bind_text (_tmp9_, 3, _tmp11_, -1, _tmp12_);
	_tmp13_ = self->priv->store_storage_medium_stmt;
	_tmp14_ = display_name;
	_tmp15_ = g_strdup (_tmp14_);
	_tmp16_ = g_free;
	sqlite3_bind_text (_tmp13_, 4, _tmp15_, -1, _tmp16_);
	_tmp17_ = self->priv->store_storage_medium_stmt;
	_tmp18_ = sqlite3_step (_tmp17_);
	rc = _tmp18_;
	_tmp19_ = self->priv->database;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp19_, rc, "add_storage_medium", SQLITE_DONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp20_ = medium_name;
	_tmp21_ = medium_name;
	_tmp22_ = icon;
	_tmp23_ = display_name;
	_tmp24_ = zeitgeist_storage_media_to_variant (_tmp21_, TRUE, _tmp22_, _tmp23_);
	_tmp25_ = _tmp24_;
	g_signal_emit_by_name ((ZeitgeistRemoteStorageMonitor*) self, "storage-available", _tmp20_, _tmp25_);
	_g_variant_unref0 (_tmp25_);
}


void zeitgeist_storage_monitor_remove_storage_medium (ZeitgeistStorageMonitor* self, const gchar* medium_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	sqlite3_stmt* _tmp9_;
	gint _tmp10_ = 0;
	const gchar* _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (medium_name != NULL);
	_tmp0_ = medium_name;
	_tmp1_ = g_strdup_printf ("VOLUME REMOVED: %s", _tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("storage-monitor.vala:293: %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->insert_unavailable_medium_stmt;
	sqlite3_reset (_tmp3_);
	_tmp4_ = self->priv->insert_unavailable_medium_stmt;
	sqlite3_bind_int (_tmp4_, 1, 0);
	_tmp5_ = self->priv->insert_unavailable_medium_stmt;
	_tmp6_ = medium_name;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_free;
	sqlite3_bind_text (_tmp5_, 2, _tmp7_, -1, _tmp8_);
	_tmp9_ = self->priv->insert_unavailable_medium_stmt;
	_tmp10_ = sqlite3_step (_tmp9_);
	if (_tmp10_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp11_;
		sqlite3_stmt* _tmp12_;
		sqlite3_stmt* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		GDestroyNotify _tmp16_;
		sqlite3_stmt* _tmp17_;
		gint _tmp18_ = 0;
		gint rc;
		ZeitgeistSQLiteZeitgeistDatabase* _tmp19_;
		gint _tmp20_;
		_tmp11_ = self->priv->update_medium_state_stmt;
		sqlite3_reset (_tmp11_);
		_tmp12_ = self->priv->update_medium_state_stmt;
		sqlite3_bind_int (_tmp12_, 1, 0);
		_tmp13_ = self->priv->update_medium_state_stmt;
		_tmp14_ = medium_name;
		_tmp15_ = g_strdup (_tmp14_);
		_tmp16_ = g_free;
		sqlite3_bind_text (_tmp13_, 2, _tmp15_, -1, _tmp16_);
		_tmp17_ = self->priv->update_medium_state_stmt;
		_tmp18_ = sqlite3_step (_tmp17_);
		rc = _tmp18_;
		_tmp19_ = self->priv->database;
		_tmp20_ = rc;
		zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp19_, _tmp20_, "remove_storage_medium", SQLITE_DONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp21_ = medium_name;
	g_signal_emit_by_name ((ZeitgeistRemoteStorageMonitor*) self, "storage-unavailable", _tmp21_);
}


static GVariant* zeitgeist_storage_monitor_real_get_storages (ZeitgeistRemoteStorageMonitor* base, GError** error) {
	ZeitgeistStorageMonitor * self;
	GVariant* result = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* vb;
	gint rc = 0;
	sqlite3_stmt* _tmp4_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp29_;
	gint _tmp30_;
	GVariantBuilder* _tmp31_;
	GVariant* _tmp32_ = NULL;
	GVariant* _tmp33_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistStorageMonitor*) base;
	_tmp0_ = g_variant_type_new ("a(sa{sv})");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = self->priv->get_storages_stmt;
	sqlite3_reset (_tmp4_);
	while (TRUE) {
		sqlite3_stmt* _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_;
		sqlite3_stmt* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		sqlite3_stmt* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		sqlite3_stmt* _tmp20_;
		const gchar* _tmp21_ = NULL;
		sqlite3_stmt* _tmp22_;
		gint _tmp23_ = 0;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GVariant* _tmp26_ = NULL;
		GVariant* medium;
		GVariantBuilder* _tmp27_;
		GVariant* _tmp28_;
		_tmp5_ = self->priv->get_storages_stmt;
		_tmp6_ = sqlite3_step (_tmp5_);
		rc = _tmp6_;
		_tmp7_ = rc;
		if (!(_tmp7_ == SQLITE_ROW)) {
			break;
		}
		_tmp8_ = self->priv->get_storages_stmt;
		_tmp9_ = sqlite3_column_text (_tmp8_, 2);
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		if (_tmp12_ == NULL) {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("");
			_g_free0 (_tmp11_);
			_tmp11_ = _tmp13_;
		}
		_tmp14_ = self->priv->get_storages_stmt;
		_tmp15_ = sqlite3_column_text (_tmp14_, 3);
		_tmp16_ = g_strdup (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		if (_tmp18_ == NULL) {
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("");
			_g_free0 (_tmp17_);
			_tmp17_ = _tmp19_;
		}
		_tmp20_ = self->priv->get_storages_stmt;
		_tmp21_ = sqlite3_column_text (_tmp20_, 0);
		_tmp22_ = self->priv->get_storages_stmt;
		_tmp23_ = sqlite3_column_int (_tmp22_, 1);
		_tmp24_ = _tmp11_;
		_tmp25_ = _tmp17_;
		_tmp26_ = zeitgeist_storage_media_to_variant (_tmp21_, _tmp23_ == 1, _tmp24_, _tmp25_);
		medium = _tmp26_;
		_tmp27_ = vb;
		_tmp28_ = medium;
		g_variant_builder_add_value (_tmp27_, _tmp28_);
		_g_variant_unref0 (medium);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp11_);
	}
	_tmp29_ = self->priv->database;
	_tmp30_ = rc;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp29_, _tmp30_, "get_storages", SQLITE_DONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_builder_unref0 (vb);
			return NULL;
		} else {
			_g_variant_builder_unref0 (vb);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp31_ = vb;
	_tmp32_ = g_variant_builder_end (_tmp31_);
	_tmp33_ = g_variant_ref_sink (_tmp32_);
	result = _tmp33_;
	_g_variant_builder_unref0 (vb);
	return result;
}


static void _zeitgeist_storage_monitor_on_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	zeitgeist_storage_monitor_on_volume_added (self, _sender, volume);
}


static void _zeitgeist_storage_monitor_on_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	zeitgeist_storage_monitor_on_volume_removed (self, _sender, volume);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GObject * zeitgeist_storage_monitor_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistStorageMonitor * self;
	GVolumeMonitor* _tmp6_ = NULL;
	GVolumeMonitor* monitor;
	GVolumeMonitor* _tmp7_;
	GVolumeMonitor* _tmp8_;
	GVolumeMonitor* _tmp9_;
	GList* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_storage_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ZEITGEIST_STORAGE_MONITOR (obj);
	{
		zeitgeist_storage_monitor_prepare_queries (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch1_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	goto __finally1;
	__catch1_zeitgeist_engine_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("storage-monitor.vala:114: Storage Monitor couldn't communicate with DB" \
" - bye");
		_g_error_free0 (e);
		return obj;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* connection;
		GDBusConnection* _tmp1_;
		guint _tmp2_ = 0U;
		guint _tmp3_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp1_ = connection;
		_tmp2_ = zeitgeist_remote_storage_monitor_register_object ((ZeitgeistRemoteStorageMonitor*) self, _tmp1_, "/org/gnome/zeitgeist/storagemonitor", &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (connection);
			goto __catch2_g_error;
		}
		self->priv->registration_id = _tmp3_;
		_g_object_unref0 (connection);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("storage-monitor.vala:127: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp6_ = g_volume_monitor_get ();
	monitor = _tmp6_;
	_tmp7_ = monitor;
	g_signal_connect_object (_tmp7_, "volume-added", (GCallback) _zeitgeist_storage_monitor_on_volume_added_g_volume_monitor_volume_added, self, 0);
	_tmp8_ = monitor;
	g_signal_connect_object (_tmp8_, "volume-removed", (GCallback) _zeitgeist_storage_monitor_on_volume_removed_g_volume_monitor_volume_removed, self, 0);
	_tmp9_ = monitor;
	_tmp10_ = g_volume_monitor_get_volumes (_tmp9_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp10_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp11_;
			GVolume* volume = NULL;
			_tmp11_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp11_;
			{
				GVolume* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				GVolume* _tmp15_;
				GIcon* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				GVolume* _tmp19_;
				const gchar* _tmp20_ = NULL;
				_tmp12_ = volume;
				_tmp13_ = zeitgeist_storage_monitor_get_volume_id (self, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = volume;
				_tmp16_ = g_volume_get_icon (_tmp15_);
				_tmp17_ = g_icon_to_string (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = volume;
				_tmp20_ = g_volume_get_name (_tmp19_);
				zeitgeist_storage_monitor_add_storage_medium (self, _tmp14_, _tmp18_, _tmp20_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp14_);
				_g_object_unref0 (volume);
			}
		}
		__g_list_free__g_object_unref0_0 (volume_collection);
	}
	_g_object_unref0 (monitor);
	return obj;
}


static void zeitgeist_storage_monitor_class_init (ZeitgeistStorageMonitorClass * klass) {
	zeitgeist_storage_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistStorageMonitorPrivate));
	ZEITGEIST_EXTENSION_CLASS (klass)->unload = zeitgeist_storage_monitor_real_unload;
	ZEITGEIST_EXTENSION_CLASS (klass)->pre_insert_events = zeitgeist_storage_monitor_real_pre_insert_events;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_storage_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_storage_monitor_finalize;
}


static void zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_interface_init (ZeitgeistRemoteStorageMonitorIface * iface) {
	zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_storages = (GVariant* (*)(ZeitgeistRemoteStorageMonitor*, GError**)) zeitgeist_storage_monitor_real_get_storages;
}


static void zeitgeist_storage_monitor_instance_init (ZeitgeistStorageMonitor * self) {
	self->priv = ZEITGEIST_STORAGE_MONITOR_GET_PRIVATE (self);
}


static void zeitgeist_storage_monitor_finalize (GObject* obj) {
	ZeitgeistStorageMonitor * self;
	self = ZEITGEIST_STORAGE_MONITOR (obj);
	_g_object_unref0 (self->priv->database);
	_sqlite3_finalize0 (self->priv->get_storages_stmt);
	_sqlite3_finalize0 (self->priv->store_storage_medium_stmt);
	_sqlite3_finalize0 (self->priv->insert_unavailable_medium_stmt);
	_sqlite3_finalize0 (self->priv->update_medium_state_stmt);
	G_OBJECT_CLASS (zeitgeist_storage_monitor_parent_class)->finalize (obj);
}


GType zeitgeist_storage_monitor_get_type (void) {
	return zeitgeist_storage_monitor_type_id;
}


GType zeitgeist_storage_monitor_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistStorageMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_storage_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistStorageMonitor), 0, (GInstanceInitFunc) zeitgeist_storage_monitor_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_storage_monitor_info = { (GInterfaceInitFunc) zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_storage_monitor_type_id = g_type_module_register_type (module, ZEITGEIST_TYPE_EXTENSION, "ZeitgeistStorageMonitor", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_storage_monitor_type_id, ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, &zeitgeist_remote_storage_monitor_info);
	return zeitgeist_storage_monitor_type_id;
}


GType zeitgeist_extension_register (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	zeitgeist_remote_storage_monitor_register_type (module);
	zeitgeist_storage_monitor_register_type (module);
	result = ZEITGEIST_TYPE_STORAGE_MONITOR;
	return result;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



