/* zeitgeist-datahub.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from zeitgeist-datahub.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <zeitgeist.h>


#define TYPE_DATA_HUB_SERVICE (data_hub_service_get_type ())
#define DATA_HUB_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB_SERVICE, DataHubService))
#define IS_DATA_HUB_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB_SERVICE))
#define DATA_HUB_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATA_HUB_SERVICE, DataHubServiceIface))

typedef struct _DataHubService DataHubService;
typedef struct _DataHubServiceIface DataHubServiceIface;

#define TYPE_DATA_HUB_SERVICE_PROXY (data_hub_service_proxy_get_type ())
typedef GDBusProxy DataHubServiceProxy;
typedef GDBusProxyClass DataHubServiceProxyClass;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;
typedef struct _DataHubPrivate DataHubPrivate;

#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_ptr_array_free0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_RECENT_MANAGER_GTK (recent_manager_gtk_get_type ())
#define RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtk))
#define RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))
#define IS_RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RECENT_MANAGER_GTK))
#define IS_RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RECENT_MANAGER_GTK))
#define RECENT_MANAGER_GTK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))

typedef struct _RecentManagerGtk RecentManagerGtk;
typedef struct _RecentManagerGtkClass RecentManagerGtkClass;

#define TYPE_DESKTOP_LAUNCH_LISTENER (desktop_launch_listener_get_type ())
#define DESKTOP_LAUNCH_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListener))
#define DESKTOP_LAUNCH_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerClass))
#define IS_DESKTOP_LAUNCH_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_LAUNCH_LISTENER))
#define IS_DESKTOP_LAUNCH_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_LAUNCH_LISTENER))
#define DESKTOP_LAUNCH_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerClass))

typedef struct _DesktopLaunchListener DesktopLaunchListener;
typedef struct _DesktopLaunchListenerClass DesktopLaunchListenerClass;
typedef struct _DataHubStartDataProvidersData DataHubStartDataProvidersData;
typedef struct _Block1Data Block1Data;
#define _g_array_free0(var) ((var == NULL) ? NULL : (var = (g_array_free (var, TRUE), NULL)))
typedef struct _DataHubBatchInsertEventsData DataHubBatchInsertEventsData;

struct _DataHubServiceIface {
	GTypeInterface parent_iface;
	gchar** (*get_data_providers) (DataHubService* self, int* result_length1, GError** error);
};

struct _DataHub {
	GObject parent_instance;
	DataHubPrivate * priv;
};

struct _DataHubClass {
	GObjectClass parent_class;
};

struct _DataHubPrivate {
	ZeitgeistLog* zg_log;
	ZeitgeistDataSourceRegistry* registry;
	GMainLoop* main_loop;
	GList* providers;
	GList* sources_info;
	GPtrArray* queued_events;
	guint idle_id;
};

struct _DataHubStartDataProvidersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DataHub* self;
	GPtrArray* _tmp0_;
	GPtrArray* sources;
	guint i;
	gboolean _tmp1_;
	void* _tmp2_;
	void* _tmp3_;
	ZeitgeistDataSource* _tmp4_;
	GError * err;
	RecentManagerGtk* _tmp5_;
	gboolean _tmp6_;
	DesktopLaunchListener* _tmp7_;
	GList* prov_collection;
	GList* prov_it;
	DataProvider* prov;
	gboolean enabled;
	gint64 timestamp;
	GList* src_collection;
	GList* src_it;
	ZeitgeistDataSource* _tmp8_;
	ZeitgeistDataSource* src;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gint64 _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GPtrArray* _tmp16_;
	ZeitgeistDataSource* _tmp17_;
	ZeitgeistDataSource* ds;
	ZeitgeistDataSource* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GError * reg_err;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	DataHub * self;
	GPtrArray* all_events;
	gpointer _async_data_;
};

struct _DataHubBatchInsertEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DataHub* self;
	Block1Data* _data1_;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint _tmp3_;
	guint elements_pushed;
	GPtrArray* _tmp4_;
	GPtrArray* ptr_arr;
	guint i;
	gboolean _tmp5_;
	gconstpointer _tmp6_;
	GPtrArray* _tmp7_;
	GArray* _tmp8_;
	GArray* _tmp9_;
	GError * err;
	GError * _inner_error_;
};


static gpointer data_hub_parent_class = NULL;
static DataHubServiceIface* data_hub_data_hub_service_parent_iface = NULL;

GType data_hub_service_proxy_get_type (void) G_GNUC_CONST;
guint data_hub_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType data_hub_service_get_type (void) G_GNUC_CONST;
gchar** data_hub_service_get_data_providers (DataHubService* self, int* result_length1, GError** error);
static void data_hub_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar** data_hub_service_proxy_get_data_providers (DataHubService* self, int* result_length1, GError** error);
static void data_hub_service_proxy_data_hub_service_interface_init (DataHubServiceIface* iface);
static void _dbus_data_hub_service_get_data_providers (DataHubService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void data_hub_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* data_hub_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean data_hub_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _data_hub_service_unregister_object (gpointer user_data);
GType data_hub_get_type (void) G_GNUC_CONST;
GType data_provider_get_type (void) G_GNUC_CONST;
#define DATA_HUB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DATA_HUB, DataHubPrivate))
enum  {
	DATA_HUB_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define DATA_HUB_UNIQUE_NAME "org.gnome.zeitgeist.datahub"
#define DATA_HUB_OBJECT_PATH "/org/gnome/zeitgeist/datahub"
DataHub* data_hub_new (void);
DataHub* data_hub_construct (GType object_type);
static void data_hub_data_source_registered (DataHub* self, ZeitgeistDataSource* ds);
static void data_hub_start_data_providers_data_free (gpointer _data);
static void data_hub_start_data_providers (DataHub* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void data_hub_start_data_providers_finish (DataHub* self, GAsyncResult* _res_);
static gboolean data_hub_start_data_providers_co (DataHubStartDataProvidersData* data);
static void _data_hub_data_source_registered_zeitgeist_data_source_registry_source_registered (ZeitgeistDataSourceRegistry* _sender, ZeitgeistDataSource* source, gpointer self);
static void data_hub_start_data_providers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RecentManagerGtk* recent_manager_gtk_new (DataHub* datahub);
RecentManagerGtk* recent_manager_gtk_construct (GType object_type, DataHub* datahub);
GType recent_manager_gtk_get_type (void) G_GNUC_CONST;
DesktopLaunchListener* desktop_launch_listener_new (DataHub* datahub);
DesktopLaunchListener* desktop_launch_listener_construct (GType object_type, DataHub* datahub);
GType desktop_launch_listener_get_type (void) G_GNUC_CONST;
const gchar* data_provider_get_unique_id (DataProvider* self);
gboolean data_provider_get_register (DataProvider* self);
const gchar* data_provider_get_name (DataProvider* self);
const gchar* data_provider_get_description (DataProvider* self);
static void data_hub_items_available (DataHub* self, DataProvider* prov, GPtrArray* events);
static void _data_hub_items_available_data_provider_items_available (DataProvider* _sender, GPtrArray* events, gpointer self);
void data_provider_set_last_timestamp (DataProvider* self, gint64 value);
void data_provider_start (DataProvider* self);
gboolean data_provider_get_enabled (DataProvider* self);
static void _lambda1_ (ZeitgeistEvent* e, DataHub* self);
static void __lambda1__gfunc (gconstpointer data, gpointer self);
static gboolean _lambda2_ (DataHub* self);
static void data_hub_insert_events (DataHub* self);
static gboolean __lambda2__gsource_func (gpointer self);
void data_hub_batch_insert_events (DataHub* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void data_hub_batch_insert_events_finish (DataHub* self, GAsyncResult* _res_);
static void data_hub_batch_insert_events_data_free (gpointer _data);
static gboolean data_hub_batch_insert_events_co (DataHubBatchInsertEventsData* data);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda3_ (ZeitgeistEvent* e, Block1Data* _data1_);
static void __lambda3__gfunc (gconstpointer data, gpointer self);
static void _g_object_unref_gdestroy_notify (void* data);
static void data_hub_batch_insert_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void data_hub_run (DataHub* self);
static void _lambda4_ (GDBusConnection* conn, DataHub* self);
static void __lambda4__gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _lambda5_ (DataHub* self);
static void __lambda5__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _lambda6_ (DataHub* self);
void data_hub_quit (DataHub* self);
static void __lambda6__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
gchar** data_hub_get_data_source_actors (DataHub* self, gboolean only_enabled, int* result_length1);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static gchar** data_hub_real_get_data_providers (DataHubService* base, int* result_length1, GError** error);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
void data_hub_main (gchar** args, int args_length1);
static GObject * data_hub_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda7_ (DataHub* self);
static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void data_hub_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _data_hub_service_dbus_arg_info_get_data_providers_result = {-1, "result", "as"};
static const GDBusArgInfo * const _data_hub_service_dbus_arg_info_get_data_providers_in[] = {NULL};
static const GDBusArgInfo * const _data_hub_service_dbus_arg_info_get_data_providers_out[] = {&_data_hub_service_dbus_arg_info_get_data_providers_result, NULL};
static const GDBusMethodInfo _data_hub_service_dbus_method_info_get_data_providers = {-1, "GetDataProviders", (GDBusArgInfo **) (&_data_hub_service_dbus_arg_info_get_data_providers_in), (GDBusArgInfo **) (&_data_hub_service_dbus_arg_info_get_data_providers_out)};
static const GDBusMethodInfo * const _data_hub_service_dbus_method_info[] = {&_data_hub_service_dbus_method_info_get_data_providers, NULL};
static const GDBusSignalInfo * const _data_hub_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _data_hub_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _data_hub_service_dbus_interface_info = {-1, "org.gnome.zeitgeist.datahub", (GDBusMethodInfo **) (&_data_hub_service_dbus_method_info), (GDBusSignalInfo **) (&_data_hub_service_dbus_signal_info), (GDBusPropertyInfo **) (&_data_hub_service_dbus_property_info)};
static const GDBusInterfaceVTable _data_hub_service_dbus_interface_vtable = {data_hub_service_dbus_interface_method_call, data_hub_service_dbus_interface_get_property, data_hub_service_dbus_interface_set_property};

gchar** data_hub_service_get_data_providers (DataHubService* self, int* result_length1, GError** error) {
	return DATA_HUB_SERVICE_GET_INTERFACE (self)->get_data_providers (self, result_length1, error);
}


static void data_hub_service_base_init (DataHubServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType data_hub_service_get_type (void) {
	static volatile gsize data_hub_service_type_id__volatile = 0;
	if (g_once_init_enter (&data_hub_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DataHubServiceIface), (GBaseInitFunc) data_hub_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType data_hub_service_type_id;
		data_hub_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "DataHubService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (data_hub_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (data_hub_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) data_hub_service_proxy_get_type);
		g_type_set_qdata (data_hub_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.datahub");
		g_type_set_qdata (data_hub_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) data_hub_service_register_object);
		g_once_init_leave (&data_hub_service_type_id__volatile, data_hub_service_type_id);
	}
	return data_hub_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DataHubServiceProxy, data_hub_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_DATA_HUB_SERVICE, data_hub_service_proxy_data_hub_service_interface_init) );
static void data_hub_service_proxy_class_init (DataHubServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = data_hub_service_proxy_g_signal;
}


static void data_hub_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void data_hub_service_proxy_init (DataHubServiceProxy* self) {
}


static gchar** data_hub_service_proxy_get_data_providers (DataHubService* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.datahub", "GetDataProviders");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	_result_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_result = _tmp1_;
	g_variant_unref (_tmp0_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void data_hub_service_proxy_data_hub_service_interface_init (DataHubServiceIface* iface) {
	iface->get_data_providers = data_hub_service_proxy_get_data_providers;
}


static void _dbus_data_hub_service_get_data_providers (DataHubService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	int _tmp6_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = data_hub_service_get_data_providers (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	 result = (_vala_array_free ( result,  result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void data_hub_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetDataProviders") == 0) {
		_dbus_data_hub_service_get_data_providers (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* data_hub_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean data_hub_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint data_hub_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_data_hub_service_dbus_interface_info), &_data_hub_service_dbus_interface_vtable, data, _data_hub_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _data_hub_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


DataHub* data_hub_construct (GType object_type) {
	DataHub * self = NULL;
	self = (DataHub*) g_object_new (object_type, NULL);
	return self;
}


DataHub* data_hub_new (void) {
	return data_hub_construct (TYPE_DATA_HUB);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void data_hub_data_source_registered (DataHub* self, ZeitgeistDataSource* ds) {
	GList* iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ds != NULL);
	iter = self->priv->sources_info;
	while (TRUE) {
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		if (!(iter != NULL)) {
			break;
		}
		_tmp0_ = zeitgeist_data_source_get_unique_id ((ZeitgeistDataSource*) iter->data);
		_tmp1_ = zeitgeist_data_source_get_unique_id (ds);
		if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
			break;
		}
		iter = iter->next;
	}
	if (iter != NULL) {
		ZeitgeistDataSource* _tmp2_;
		ZeitgeistDataSource* _tmp3_;
		_tmp2_ = _g_object_ref0 (ds);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (iter->data);
		iter->data = _tmp3_;
	} else {
		ZeitgeistDataSource* _tmp4_;
		_tmp4_ = _g_object_ref0 (ds);
		self->priv->sources_info = g_list_prepend (self->priv->sources_info, _tmp4_);
	}
}


static void data_hub_start_data_providers_data_free (gpointer _data) {
	DataHubStartDataProvidersData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DataHubStartDataProvidersData, data);
}


static void data_hub_start_data_providers (DataHub* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DataHubStartDataProvidersData* _data_;
	_data_ = g_slice_new0 (DataHubStartDataProvidersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, data_hub_start_data_providers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, data_hub_start_data_providers_data_free);
	_data_->self = _g_object_ref0 (self);
	data_hub_start_data_providers_co (_data_);
}


static void data_hub_start_data_providers_finish (DataHub* self, GAsyncResult* _res_) {
	DataHubStartDataProvidersData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _data_hub_data_source_registered_zeitgeist_data_source_registry_source_registered (ZeitgeistDataSourceRegistry* _sender, ZeitgeistDataSource* source, gpointer self) {
	data_hub_data_source_registered (self, source);
}


static void data_hub_start_data_providers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DataHubStartDataProvidersData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	data_hub_start_data_providers_co (data);
}


static void _data_hub_items_available_data_provider_items_available (DataProvider* _sender, GPtrArray* events, gpointer self) {
	data_hub_items_available (self, _sender, events);
}


static gboolean data_hub_start_data_providers_co (DataHubStartDataProvidersData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_signal_connect_object (data->self->priv->registry, "source-registered", (GCallback) _data_hub_data_source_registered_zeitgeist_data_source_registry_source_registered, data->self, 0);
	data->_state_ = 1;
	zeitgeist_data_source_registry_get_data_sources (data->self->priv->registry, NULL, data_hub_start_data_providers_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = zeitgeist_data_source_registry_get_data_sources_finish (data->self->priv->registry, data->_res_, &data->_inner_error_);
	data->sources = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	{
		data->i = (guint) 0;
		{
			data->_tmp1_ = TRUE;
			while (TRUE) {
				if (!data->_tmp1_) {
					data->i++;
				}
				data->_tmp1_ = FALSE;
				if (!(data->i < data->sources->len)) {
					break;
				}
				data->_tmp2_ = NULL;
				data->_tmp2_ = g_ptr_array_index (data->sources, data->i);
				data->_tmp4_ = _g_object_ref0 ((data->_tmp3_ = data->_tmp2_, ZEITGEIST_IS_DATA_SOURCE (data->_tmp3_) ? ((ZeitgeistDataSource*) data->_tmp3_) : NULL));
				data->self->priv->sources_info = g_list_prepend (data->self->priv->sources_info, data->_tmp4_);
			}
		}
	}
	_g_ptr_array_free0 (data->sources);
	goto __finally3;
	__catch3_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("zeitgeist-datahub.vala:101: %s", data->err->message);
		_g_error_free0 (data->err);
	}
	__finally3:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = recent_manager_gtk_new (data->self);
	data->self->priv->providers = g_list_prepend (data->self->priv->providers, (DataProvider*) data->_tmp5_);
	data->_tmp6_ = GLIB_CHECK_VERSION ((guint) 2, (guint) 28, (guint) 0);
	if (data->_tmp6_) {
		data->_tmp7_ = NULL;
		data->_tmp7_ = desktop_launch_listener_new (data->self);
		data->self->priv->providers = g_list_prepend (data->self->priv->providers, (DataProvider*) data->_tmp7_);
	}
	{
		data->prov_collection = data->self->priv->providers;
		for (data->prov_it = data->prov_collection; data->prov_it != NULL; data->prov_it = data->prov_it->next) {
			data->prov = (DataProvider*) data->prov_it->data;
			{
				data->enabled = TRUE;
				data->timestamp = (gint64) 0;
				{
					data->src_collection = data->self->priv->sources_info;
					for (data->src_it = data->src_collection; data->src_it != NULL; data->src_it = data->src_it->next) {
						data->_tmp8_ = _g_object_ref0 ((ZeitgeistDataSource*) data->src_it->data);
						data->src = data->_tmp8_;
						{
							data->_tmp9_ = NULL;
							data->_tmp9_ = zeitgeist_data_source_get_unique_id (data->src);
							data->_tmp10_ = NULL;
							data->_tmp10_ = data_provider_get_unique_id (data->prov);
							if (g_strcmp0 (data->_tmp9_, data->_tmp10_) == 0) {
								data->_tmp11_ = zeitgeist_data_source_get_timestamp (data->src);
								data->timestamp = data->_tmp11_;
								_g_object_unref0 (data->src);
								break;
							}
							_g_object_unref0 (data->src);
						}
					}
				}
				data->_tmp12_ = data_provider_get_register (data->prov);
				if (data->_tmp12_) {
					data->_tmp13_ = NULL;
					data->_tmp13_ = data_provider_get_unique_id (data->prov);
					data->_tmp14_ = NULL;
					data->_tmp14_ = data_provider_get_name (data->prov);
					data->_tmp15_ = NULL;
					data->_tmp15_ = data_provider_get_description (data->prov);
					data->_tmp16_ = NULL;
					data->_tmp16_ = g_ptr_array_new ();
					data->_tmp17_ = NULL;
					data->_tmp17_ = zeitgeist_data_source_new_full (data->_tmp13_, data->_tmp14_, data->_tmp15_, data->_tmp16_);
					data->ds = g_object_ref_sink (data->_tmp17_);
					data->_tmp18_ = _g_object_ref0 (data->ds);
					data->_state_ = 2;
					zeitgeist_data_source_registry_register_data_source (data->self->priv->registry, data->_tmp18_, NULL, data_hub_start_data_providers_ready, data);
					return FALSE;
					_state_2:
					data->_tmp19_ = zeitgeist_data_source_registry_register_data_source_finish (data->self->priv->registry, data->_res_, &data->_inner_error_);
					data->_tmp20_ = data->_tmp19_;
					if (data->_inner_error_ != NULL) {
						goto __catch4_g_error;
					}
					data->enabled = data->_tmp20_;
					goto __finally4;
					__catch4_g_error:
					{
						data->reg_err = data->_inner_error_;
						data->_inner_error_ = NULL;
						g_warning ("zeitgeist-datahub.vala:143: %s", data->reg_err->message);
						_g_error_free0 (data->reg_err);
					}
					__finally4:
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->ds);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
					_g_object_unref0 (data->ds);
				}
				g_signal_connect_object (data->prov, "items-available", (GCallback) _data_hub_items_available_data_provider_items_available, data->self, 0);
				if (data->enabled) {
					data_provider_set_last_timestamp (data->prov, data->timestamp);
					data_provider_start (data->prov);
				}
			}
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _lambda1_ (ZeitgeistEvent* e, DataHub* self) {
	ZeitgeistEvent* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = _g_object_ref0 (e);
	g_ptr_array_add (self->priv->queued_events, _tmp0_);
}


static void __lambda1__gfunc (gconstpointer data, gpointer self) {
	_lambda1_ (data, self);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	g_return_if_fail (self != NULL);
	g_ptr_array_set_size (self, value);
}


static gboolean _lambda2_ (DataHub* self) {
	gboolean result = FALSE;
	data_hub_insert_events (self);
	self->priv->idle_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean __lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


static void data_hub_items_available (DataHub* self, DataProvider* prov, GPtrArray* events) {
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prov != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = data_provider_get_enabled (prov);
	if (!_tmp0_) {
		return;
	}
	g_ptr_array_foreach (events, __lambda1__gfunc, self);
	_tmp2_ = g_ptr_array_get_length (self->priv->queued_events);
	if (_tmp2_ > 0) {
		_tmp1_ = self->priv->idle_id == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		guint _tmp3_;
		_tmp3_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda2__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->idle_id = _tmp3_;
	}
}


static void data_hub_insert_events (DataHub* self) {
	gint _tmp0_;
	GPtrArray* _tmp1_ = NULL;
	GPtrArray* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_get_length (self->priv->queued_events);
	g_debug ("zeitgeist-datahub.vala:174: Inserting %u events", (guint) _tmp0_);
	data_hub_batch_insert_events (self, NULL, NULL);
	_tmp1_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_tmp2_ = _tmp1_;
	_g_ptr_array_unref0 (self->priv->queued_events);
	self->priv->queued_events = _tmp2_;
}


static void data_hub_batch_insert_events_data_free (gpointer _data) {
	DataHubBatchInsertEventsData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DataHubBatchInsertEventsData, data);
}


void data_hub_batch_insert_events (DataHub* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DataHubBatchInsertEventsData* _data_;
	_data_ = g_slice_new0 (DataHubBatchInsertEventsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, data_hub_batch_insert_events);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, data_hub_batch_insert_events_data_free);
	_data_->self = _g_object_ref0 (self);
	data_hub_batch_insert_events_co (_data_);
}


void data_hub_batch_insert_events_finish (DataHub* self, GAsyncResult* _res_) {
	DataHubBatchInsertEventsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_ptr_array_unref0 (_data1_->all_events);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda3_ (ZeitgeistEvent* e, Block1Data* _data1_) {
	DataHub * self;
	ZeitgeistEvent* _tmp0_;
	self = _data1_->self;
	g_return_if_fail (e != NULL);
	_tmp0_ = _g_object_ref0 (e);
	g_ptr_array_add (_data1_->all_events, _tmp0_);
}


static void __lambda3__gfunc (gconstpointer data, gpointer self) {
	_lambda3_ (data, self);
}


static void _g_object_unref_gdestroy_notify (void* data) {
	g_object_unref (data);
}


static void data_hub_batch_insert_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DataHubBatchInsertEventsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	data_hub_batch_insert_events_co (data);
}


static gboolean data_hub_batch_insert_events_co (DataHubBatchInsertEventsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data1_ = g_slice_new0 (Block1Data);
	data->_data1_->_ref_count_ = 1;
	data->_data1_->self = g_object_ref (data->self);
	data->_data1_->_async_data_ = data;
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	data->_data1_->all_events = data->_tmp0_;
	g_ptr_array_foreach (data->self->priv->queued_events, __lambda3__gfunc, data->_data1_);
	while (TRUE) {
		data->_tmp1_ = g_ptr_array_get_length (data->_data1_->all_events);
		if (!(data->_tmp1_ > 0)) {
			break;
		}
		data->_tmp2_ = g_ptr_array_get_length (data->_data1_->all_events);
		data->_tmp3_ = MIN ((guint) data->_tmp2_, (guint) 100);
		data->elements_pushed = data->_tmp3_;
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_ptr_array_new_with_free_func (_g_object_unref_gdestroy_notify);
		data->ptr_arr = data->_tmp4_;
		{
			data->i = (guint) 0;
			{
				data->_tmp5_ = TRUE;
				while (TRUE) {
					if (!data->_tmp5_) {
						data->i++;
					}
					data->_tmp5_ = FALSE;
					if (!(data->i < data->elements_pushed)) {
						break;
					}
					data->_tmp6_ = NULL;
					data->_tmp6_ = g_ptr_array_index (data->_data1_->all_events, data->i);
					g_ptr_array_add (data->ptr_arr, (ZeitgeistEvent*) data->_tmp6_);
				}
			}
		}
		data->_tmp7_ = data->ptr_arr;
		data->ptr_arr = NULL;
		data->_state_ = 1;
		zeitgeist_log_insert_events_from_ptrarray (data->self->priv->zg_log, data->_tmp7_, NULL, data_hub_batch_insert_events_ready, data);
		return FALSE;
		_state_1:
		data->_tmp8_ = NULL;
		data->_tmp8_ = zeitgeist_log_insert_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_);
		data->_tmp9_ = data->_tmp8_;
		_g_array_free0 (data->_tmp9_);
		if (data->_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		goto __finally5;
		__catch5_g_error:
		{
			data->err = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_warning ("zeitgeist-datahub.vala:201: Error during inserting events: %s", data->err->message);
			_g_error_free0 (data->err);
		}
		__finally5:
		if (data->_inner_error_ != NULL) {
			_g_ptr_array_free0 (data->ptr_arr);
			block1_data_unref (data->_data1_);
			data->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		g_ptr_array_remove_range (data->_data1_->all_events, (guint) 0, data->elements_pushed);
		_g_ptr_array_free0 (data->ptr_arr);
	}
	block1_data_unref (data->_data1_);
	data->_data1_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _lambda4_ (GDBusConnection* conn, DataHub* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (conn != NULL);
	data_hub_service_register_object (DATA_HUB_SERVICE (self), conn, DATA_HUB_OBJECT_PATH, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda4__gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	_lambda4_ (connection, self);
}


static void _lambda5_ (DataHub* self) {
	data_hub_start_data_providers (self, NULL, NULL);
}


static void __lambda5__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	_lambda5_ (self);
}


static void _lambda6_ (DataHub* self) {
	g_warning ("zeitgeist-datahub.vala:218: %s", "Unable to get name \"org.gnome.zeitgeist.datahub\"" " on the bus!");
	data_hub_quit (self);
}


static void __lambda6__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	_lambda6_ (self);
}


void data_hub_run (DataHub* self) {
	g_return_if_fail (self != NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, DATA_HUB_UNIQUE_NAME, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((__lambda4__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __lambda4__gbus_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((__lambda5__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __lambda5__gbus_name_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((__lambda6__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __lambda6__gbus_name_lost_callback, g_object_ref (self), g_object_unref)));
	g_main_loop_run (self->priv->main_loop);
}


void data_hub_quit (DataHub* self) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = NULL;
	__g_list_free__g_object_unref0_0 (self->priv->providers);
	self->priv->providers = _tmp0_;
	g_main_loop_quit (self->priv->main_loop);
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** data_hub_get_data_source_actors (DataHub* self, gboolean only_enabled, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** actors;
	gint actors_length1;
	gint _actors_size_;
	gchar** _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	actors = _tmp0_;
	actors_length1 = 0;
	_actors_size_ = 0;
	{
		GList* src_collection;
		GList* src_it;
		src_collection = self->priv->sources_info;
		for (src_it = src_collection; src_it != NULL; src_it = src_it->next) {
			ZeitgeistDataSource* src;
			src = (ZeitgeistDataSource*) src_it->data;
			{
				gboolean _tmp1_ = FALSE;
				GPtrArray* _tmp3_ = NULL;
				GPtrArray* template_arr;
				if (only_enabled) {
					gboolean _tmp2_;
					_tmp2_ = zeitgeist_data_source_is_enabled (src);
					_tmp1_ = !_tmp2_;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					continue;
				}
				_tmp3_ = zeitgeist_data_source_get_event_templates (src);
				template_arr = _tmp3_;
				if (template_arr != NULL) {
					{
						guint i;
						i = (guint) 0;
						{
							gboolean _tmp4_;
							_tmp4_ = TRUE;
							while (TRUE) {
								void* _tmp5_ = NULL;
								void* _tmp6_;
								ZeitgeistEvent* event_template;
								const gchar* _tmp7_ = NULL;
								const gchar* actor;
								gboolean _tmp8_ = FALSE;
								if (!_tmp4_) {
									i++;
								}
								_tmp4_ = FALSE;
								if (!(i < template_arr->len)) {
									break;
								}
								_tmp5_ = g_ptr_array_index (template_arr, i);
								event_template = (_tmp6_ = _tmp5_, ZEITGEIST_IS_EVENT (_tmp6_) ? ((ZeitgeistEvent*) _tmp6_) : NULL);
								_tmp7_ = zeitgeist_event_get_actor (event_template);
								actor = _tmp7_;
								if (actor != NULL) {
									_tmp8_ = g_strcmp0 (actor, "") != 0;
								} else {
									_tmp8_ = FALSE;
								}
								if (_tmp8_) {
									gchar* _tmp9_;
									_tmp9_ = g_strdup (actor);
									_vala_array_add2 (&actors, &actors_length1, &_actors_size_, _tmp9_);
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp10_ = actors;
	*result_length1 = actors_length1;
	result = _tmp10_;
	return result;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** data_hub_real_get_data_providers (DataHubService* base, int* result_length1, GError** error) {
	DataHub * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** arr;
	gint arr_length1;
	gint _arr_size_;
	gchar** _tmp4_;
	self = (DataHub*) base;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	arr = _tmp0_;
	arr_length1 = 0;
	_arr_size_ = 0;
	{
		GList* provider_collection;
		GList* provider_it;
		provider_collection = self->priv->providers;
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
			DataProvider* _tmp1_;
			DataProvider* provider;
			_tmp1_ = _g_object_ref0 ((DataProvider*) provider_it->data);
			provider = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				_tmp2_ = data_provider_get_unique_id (provider);
				_tmp3_ = g_strdup (_tmp2_);
				_vala_array_add3 (&arr, &arr_length1, &_arr_size_, _tmp3_);
				_g_object_unref0 (provider);
			}
		}
	}
	_tmp4_ = arr;
	*result_length1 = arr_length1;
	result = _tmp4_;
	return result;
}


void data_hub_main (gchar** args, int args_length1) {
	DataHub* _tmp0_ = NULL;
	DataHub* hub;
	_tmp0_ = data_hub_new ();
	hub = _tmp0_;
	data_hub_run (hub);
	_g_object_unref0 (hub);
}


int main (int argc, char ** argv) {
	g_type_init ();
	data_hub_main (argv, argc);
	return 0;
}


static void _lambda7_ (DataHub* self) {
	gboolean _tmp0_;
	_tmp0_ = zeitgeist_log_is_connected (self->priv->zg_log);
	if (!_tmp0_) {
		g_debug ("zeitgeist-datahub.vala:58: Zeitgeist-daemon disappeared from the bus, " \
"exitting...");
		data_hub_quit (self);
	}
}


static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda7_ (self);
}


static GObject * data_hub_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DataHub * self;
	GList* _tmp0_;
	GList* _tmp1_;
	GPtrArray* _tmp2_ = NULL;
	GPtrArray* _tmp3_;
	GMainLoop* _tmp4_ = NULL;
	GMainLoop* _tmp5_;
	ZeitgeistLog* _tmp6_ = NULL;
	ZeitgeistLog* _tmp7_;
	ZeitgeistDataSourceRegistry* _tmp8_ = NULL;
	ZeitgeistDataSourceRegistry* _tmp9_;
	parent_class = G_OBJECT_CLASS (data_hub_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DATA_HUB (obj);
	_tmp0_ = NULL;
	__g_list_free__g_object_unref0_0 (self->priv->providers);
	self->priv->providers = _tmp0_;
	_tmp1_ = NULL;
	__g_list_free__g_object_unref0_0 (self->priv->sources_info);
	self->priv->sources_info = _tmp1_;
	_tmp2_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_tmp3_ = _tmp2_;
	_g_ptr_array_unref0 (self->priv->queued_events);
	self->priv->queued_events = _tmp3_;
	_tmp4_ = g_main_loop_new (NULL, FALSE);
	_tmp5_ = _tmp4_;
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp5_;
	_tmp6_ = zeitgeist_log_new ();
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->zg_log);
	self->priv->zg_log = _tmp7_;
	g_signal_connect_object ((GObject*) self->priv->zg_log, "notify::connected", (GCallback) __lambda7__g_object_notify, self, 0);
	_tmp8_ = zeitgeist_data_source_registry_new ();
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->priv->registry);
	self->priv->registry = _tmp9_;
	return obj;
}


static void data_hub_class_init (DataHubClass * klass) {
	data_hub_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DataHubPrivate));
	G_OBJECT_CLASS (klass)->constructor = data_hub_constructor;
	G_OBJECT_CLASS (klass)->finalize = data_hub_finalize;
}


static void data_hub_data_hub_service_interface_init (DataHubServiceIface * iface) {
	data_hub_data_hub_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_data_providers = (gchar** (*)(DataHubService* ,int* ,GError**)) data_hub_real_get_data_providers;
}


static void data_hub_instance_init (DataHub * self) {
	self->priv = DATA_HUB_GET_PRIVATE (self);
	self->priv->idle_id = (guint) 0;
}


static void data_hub_finalize (GObject* obj) {
	DataHub * self;
	self = DATA_HUB (obj);
	_g_object_unref0 (self->priv->zg_log);
	_g_object_unref0 (self->priv->registry);
	_g_main_loop_unref0 (self->priv->main_loop);
	__g_list_free__g_object_unref0_0 (self->priv->providers);
	__g_list_free__g_object_unref0_0 (self->priv->sources_info);
	_g_ptr_array_unref0 (self->priv->queued_events);
	G_OBJECT_CLASS (data_hub_parent_class)->finalize (obj);
}


GType data_hub_get_type (void) {
	static volatile gsize data_hub_type_id__volatile = 0;
	if (g_once_init_enter (&data_hub_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DataHubClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_hub_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataHub), 0, (GInstanceInitFunc) data_hub_instance_init, NULL };
		static const GInterfaceInfo data_hub_service_info = { (GInterfaceInitFunc) data_hub_data_hub_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType data_hub_type_id;
		data_hub_type_id = g_type_register_static (G_TYPE_OBJECT, "DataHub", &g_define_type_info, 0);
		g_type_add_interface_static (data_hub_type_id, TYPE_DATA_HUB_SERVICE, &data_hub_service_info);
		g_once_init_leave (&data_hub_type_id__volatile, data_hub_type_id);
	}
	return data_hub_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



