/*
 * Zaz
 * Copyright (C) Remigiusz Dybka 2009 <remigiusz.dybka@gmail.com>
 *
 Zaz is free software: you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Zaz is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <iostream>
#include "menu.h"

#define RENDERHEIGHT 5

Menu::Menu(float x, float y, float width)
        : x(x), y(y), width(width), posCalculated(false), lastClickedItem(0)
{
};

Menu::Menu()
        : posCalculated(false)
{

};

Menu::~Menu()
{
    std::vector<MenuItem *>::iterator i;

    for (i = items.begin(); i != items.end(); ++i)
        delete (*i);
};

void Menu::Add(const std::string txt)
{
    Add(new GenericMenuItem(txt));
}

void Menu::SetDimensions(float x, float y, float width)
{
    this->x = x;
    this->y = y;
    this->width = width;
    CalculatePositions();
    posCalculated = true;
};

void Menu::Render()
{
    // render items
    std::vector<MenuItem *>::iterator i;

    for (i = items.begin(); i != items.end(); ++i)
    {
        (*i)->Render();
    }
};

void Menu::CalculatePositions()
{
    std::vector<MenuItem *>::iterator i;

    int yy = 0;
    for (i = items.begin(); i != items.end(); ++i)
    {
        (*i)->x = x;
        (*i)->y = y - (itemHeight + 1) * yy;
        (*i)->width = width;
        (*i)->height = itemHeight;

        ++yy;
    }
};

void Menu::Logic(double mx, double my, bool click)
{
    if (!posCalculated)
    {
        CalculatePositions();
        posCalculated = true;
    }

    // fix hovers
    for (uint f = 0; f < items.size(); ++f)
    {
        //std::cout << items[f]->x << ":" << items[f]->y << " - " << items[f]->width << ":" << items[f]->height << " --- " << mx << ":" << my << std::endl;

        if ((items[f]->x < mx)
                && (items[f]->x + width > mx)
                && (items[f]->y > my)
                && (items[f]->y - items[f]->height < my))
        {
            items[f]->hover = true;
        }
        else
        {
            items[f]->hover = false;
        }
    }

    if (click)
    {
        for (uint f = 0; f < items.size(); ++f)
        {
            //std::cout << items[f]->x << ":" << items[f]->y << " - " << items[f]->width << ":" << items[f]->height << " --- " << mx << ":" << my << std::endl;

            if ((items[f]->x < mx)
                    && (items[f]->x + width > mx)
                    && (items[f]->y > my)
                    && (items[f]->y - items[f]->height < my))
                items[f]->Click((int)mx - items[f]->x, (int)my - items[f]->y);

            lastClickedItem = f;
        }
    }
};

void OptionMenuItem::Render()
{
    GenericMenuItem::Render();
    glPushMatrix();
    FTBBox b = font->BBox(values[v].c_str());
    glTranslated(x + (width - (b.Upper().X() / 6.67)) - 2, y - height / 2 - 1, RENDERZHEIGHT + 1);
    glScaled(0.15, 0.15, 0.15);
    font->Render(values[v].c_str());
    glPopMatrix();
}

int OptionMenuItem::GetVNum()
{
    std::string opt = settings->get(option, "");

    for (uint f = 0; f < values.size(); ++f)
    {
        if (values[f] == opt)
            return f;
    }

    return 0;
}

void BooleanMenuItem::Render()
{
    GenericMenuItem::Render();

    // draw tickbox
    glLineWidth(2.0);
    glPushMatrix();
    glTranslatef(x + (width - 5), y - 1, RENDERZHEIGHT + 1);
    glBegin(GL_LINE_STRIP);
    glVertex3d(0, 0, 0);
    glVertex3d(0, -3, 0);
    glVertex3d(3, -3, 0);
    glVertex3d(3, 0, 0);
    glVertex3d(0, 0, 0);
    glEnd();

    if (value)
    {
        glBegin(GL_LINE_STRIP);
        glVertex3d(0.5, -1.5, 0);
        glVertex3d(1.5, -2.5, 0);
        glVertex3d(2.5, 0, 0);
        glEnd();
    }

    glPopMatrix();
};

void ValueMenuItem::Render()
{
    GenericMenuItem::Render();
    glLoadIdentity();
    glLineWidth(2.0);
    glPushMatrix();
    glTranslatef(x + (width / 2), y - 1, RENDERZHEIGHT + 1);
    glBegin(GL_LINE_STRIP);
    glVertex3d(0, 0, 0);
    glVertex3d(0, -3, 0);
    glVertex3d(width / 2 - 2, -3, 0);
    glVertex3d(width / 2 - 2, 0, 0);
    glVertex3d(0, 0, 0);
    glEnd();

    double xx = (double)value / (double)maximum * (width / 2 - 2);

    glBegin(GL_QUADS);
    glVertex3d(0, 0, 0);
    glVertex3d(0, -3, 0);
    glVertex3d(xx, -3, 0);
    glVertex3d(xx, 0, 0);
    glEnd();
    glPopMatrix();
};

void ValueMenuItem::Click(float x, float y)
{
    std::stringstream vs;

    double xx = width / 2 - 3;
    if (x < width / 2)
        return;

    value = (int)iround(((x - width / 2.0f) / xx) * (float)maximum);

    if (value < minimum)
        value = minimum;

    if (value > maximum)
        value = maximum;

    vs << value;

    settings->set(option, vs.str());
};


void GenericMenuItem::Render()
{
    glLoadIdentity();
    if (hover)
    {
        glPushMatrix();
        glTranslatef(x, y, RENDERZHEIGHT);
        glBegin(GL_QUADS);
        glColor3f( 0, 0, 1.0);
        glVertex3d(0, 0, 0);
        glVertex3d(0, -height, 0);
        glColor3d( .1, .1, .7);
        glVertex3d(width, -height, 0);
        glVertex3d(width, 0, 0);
        glEnd();
        glPopMatrix();
    }
    else
    {
        glPushMatrix();
        glTranslatef(x, y, RENDERZHEIGHT);
        glBegin(GL_QUADS);
        glColor3d( 0, 0, 0.5);
        glVertex3d(0, 0, 0);
        glVertex3d(0, -height, 0);
        glColor3d( .1, .1, .7);
        glVertex3d(width, -height, 0);
        glVertex3d(width, 0, 0);
        glEnd();
        glPopMatrix();
    }

    if (hover)
    {
        glColor3d(1.0, 1.0, 1.0);
    }
    else
    {
        glColor3d(0.5, 0.5, 0.5);
    }
    if (!text.empty())
    {
        glPushMatrix();
        glTranslated(x + 1, y - height / 2 - 1, RENDERZHEIGHT + 1);
        glScaled(0.15, 0.15, 0.15);
        font->Render(text.c_str());
        glPopMatrix();
    }
};

