/*
 * Zaz
 * Copyright (C) Remigiusz Dybka 2009 <remigiusz.dybka@gmail.com>
 *
 Zaz is free software: you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Zaz is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "common.h"
#include "editor.h"
#include "gameloop.h"
#include "mainmenu.h"
#include "hiscores.h"
#include <fstream>
#include <vector>
#include <sys/stat.h>
#include <ctime>

Scenes::Settings settings;
HiScores hiScores;

SDL_Surface *screen;
FTFont *font; // the default font for the game/engine/universe
FTFont *font2;
FTFont *font3;

bool wantReinit;
bool audioHardwareInitialized;
SDL_Rect **screenModes;

int main (int argc, char *argv[])
{
    bool editor = false;
    bool testplay = false;
    char *editorPhilename = 0;
    char *testplayPhilename = 0;

#ifdef ENABLE_NLS
    setlocale(LC_CTYPE, "");
    setlocale(LC_MESSAGES, "");
    bindtextdomain(PACKAGE, LOCALEDIR);
    textdomain(PACKAGE);
#endif

    if (argc > 1)
    {
        if (strcmp(argv[1], "-e") == 0)
            editor = true;

        if (editor && argc == 3)
        {
            editorPhilename = argv[2];
        }

        if (strcmp(argv[1], "-p") == 0)
            testplay = true;

        if (testplay && argc == 3)
        {
            testplayPhilename = argv[2];
        }
    }

    // create a game directory
#ifndef WIN32
    string dir = Settings::getDefaultDirectory ();
    mkdir(dir.c_str(), S_IRUSR | S_IWUSR | S_IXUSR);
#else
    _mkdir(Settings::getDefaultDirectory().c_str());
#endif

    // load default settings for things we might not ask too quickly about
    settings.get("mouseSensivity", "5");
    settings.get("musicVolume", "80");
    settings.get("sfxVolume", "80");

    do
    {
        wantReinit = false;
        if (SDL_Init(SDL_INIT_AUDIO | SDL_INIT_VIDEO | SDL_INIT_TIMER) < 0)
        {
            printf("Could not initialize SDL:%s\n", SDL_GetError());
            SDL_Quit();

            return 1;
        }

        Uint32 fullscreen_flag = 0;

        if (settings.getb("fullscreen", false))
            fullscreen_flag = SDL_FULLSCREEN;

        const SDL_VideoInfo *vi = SDL_GetVideoInfo();
        uint bpp = vi->vfmt->BitsPerPixel;

        switch (bpp)
        {
        case 16:
            SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 4 );
            SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 4 );
            SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 4 );
            SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
            SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
            break;

        case 24:
        case 32:
            SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 8 );
            SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 8 );
            SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 8 );
//		        SDL_GL_SetAttribute( SDL_GL_ALPHA_SIZE, 8 );
            SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
            SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
            break;

        default:
            cout << "This program requires at least 16bit display" << endl;
            return 1;
        }

        screenModes=SDL_ListModes(NULL, SDL_OPENGL | SDL_FULLSCREEN|SDL_HWSURFACE);
        string res = settings.get("resolution", "640x480");

        int vmx = atoi(res.c_str());
        int vmy = atoi(res.substr(res.find_first_of("x") + 1).c_str());

        screen = SDL_SetVideoMode(vmx, vmy, bpp, SDL_OPENGL | fullscreen_flag);

        if (screen == NULL)
        {
            printf("%s \n", SDL_GetError());
            return 1;
        }

        SDL_WM_SetCaption("Zaz", NULL);

        glColor3f(1.0, 0, 1.0);
        font = new FTTextureFont(settings.getCFilename ("FreeSans.ttf"));
        if (font->Error())
            return 1;


        font2 = new FTPixmapFont(settings.getCFilename ("FreeMonoBold.ttf"));
        if (font->Error())
            return 1;

        font3 = new FTTextureFont(settings.getCFilename ("font1.ttf"));
        if (font->Error())
            return 1;

        font->FaceSize(24);
        font2->FaceSize(12);
        font3->FaceSize(24);

        try
        {
            if (testplay)
            {
                if (testplayPhilename != 0)
                {
                    Level level(settings.getCFilename(testplayPhilename));
                    Game game(&settings, screen, level, 0, 3, 5);
                    game.Run();
                }
                else
                {
                    cout << "Must give a level to play" << endl;
                }

            };

            if (editor)
            {
                char defPhn[] = "default";

                if (editorPhilename == 0)
                {
                    editorPhilename = defPhn;
                }

                Level level(editorPhilename);
                Editor ed(&settings, screen, level);
                ed.Run();
            }

            if (!editor && !testplay)
            {
                MainMenu m(&settings, screen);
                m.Run();
            }

        }
        catch (Error e)
        {
            cout << e.file << ":" << e.line << ":" << e.msg << endl;
        }

        delete font;
        delete font2;
        delete font3;
        SDL_Quit();
    }
    while (wantReinit);

    settings.Save();

    return(0);
}
