/*
 * Zaz
 * Copyright (C) Remigiusz Dybka 2009 <remigiusz.dybka@gmail.com>
 *
 Zaz is free software: you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Zaz is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __HISCORES_H__
#define __HISCORES_H__

#include <string>
#include <vector>
#include "settings.h"


namespace Scenes
{
    struct HiScoreEntry
    {
        int score;
        std::string name;
        std::string level;

        HiScoreEntry(int score, std::string name, std::string level)
                : score(score), name(name), level(level) {};
    };

    struct HiScores
    {
        std::string filename;
        std::vector<HiScoreEntry> scores;
        HiScores(std::string filename = Settings::getHighscoreFileName ());
        ~HiScores();
        bool GoodEnough(int s);
        void SubmitHiScore(HiScoreEntry hs);
    };
}
#endif //__HISCORES_H__
