/***************************************************************************
 *            stuff.c
 *			Xwota 0.4
 *  Sat Jul 15 10:31:59 2006
 *  Copyright  2006  Emanuele Madeo IZ0ETE
 *  Email <iz0ete@fabaris.it>
 ****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <gtk/gtk.h>
#include <glib.h>
#include <sys/stat.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>
#include "support.h"
#include "xwota_main_callback.h"
#include "global.h"
#include "stuff.h"



int load_preferences()
{
FILE *fp,*sf;
struct stat statdir;
gchar *home_dir,*logs_dir,*preferences_file, *stats_file;
gchar program_version_entry[100],call_entry[100],freq_entry[100],country_entry[100],state_entry[100],grid_entry[100],county_entry[100],latitude_entry[100],longitude_entry[100],comments_entry[100],server_wotadb_entry[100];
gchar port_entry[10],upload_interval_entry[10],check_update_entry[10],participate_entry[10],read_from_rig_entry[10],autoanswer_entry[10],autoanswer_text_entry[100],save_private_messages_entry[10],sound_private_messages_entry[10];
int i;


home_dir = g_get_home_dir();
//home_dir = g_strdup("/tmp");
work_dir = g_strdup_printf("%s/.xwota",home_dir);
logs_dir = g_strdup_printf("%s/logs",work_dir);

if (stat (work_dir, &statdir) == -1)
    {
      if (mkdir (work_dir, S_IRUSR | S_IWUSR | S_IXUSR) == -1){
	  //        printf("Creating ~/.%s directory.",work_dir);
		  }

    }
	
if (stat (logs_dir, &statdir) == -1)
    {
      if (mkdir (logs_dir, S_IRUSR | S_IWUSR | S_IXUSR) == -1){
	  //        printf("Creating ~/.%s directory.",logs_dir);
		  }

    }	
	

preferences_file = g_strdup_printf("%s/xwota.conf",work_dir);
stats_file = g_strdup_printf("%s/stats",work_dir);
	
// Non c'è la configurazione...scrivo quella di default.
	if(stat(preferences_file,&statdir) == -1)
	{
	//printf("Creating %s file.\n",preferences_file);
	
		xwota_settings.program_version = g_strdup("0.4");
		xwota_settings.call = g_strdup("NOCALL");
		xwota_settings.freq = g_strdup("");
		xwota_settings.country = g_strdup("");
		xwota_settings.state = g_strdup("");
		xwota_settings.grid = g_strdup("");
		xwota_settings.county = g_strdup("");
		xwota_settings.latitude = g_strdup("");
		xwota_settings.longitude = g_strdup("");
		xwota_settings.comments = g_strdup("");
		xwota_settings.server_wotadb = g_strdup("server1.wotadb.org");
		xwota_settings.port = g_strdup("1001");
		xwota_settings.upload_interval = g_strdup("5");
		xwota_settings.check_update = g_strdup("-1");
		xwota_settings.participate = g_strdup("1");
		xwota_settings.read_from_rig = g_strdup("0");
		xwota_settings.autoanswer = g_strdup("0");
		xwota_settings.autoanswer_text = g_strdup("Sorry, I'm away from computer.");
		xwota_settings.save_private_messages = g_strdup("0");
		xwota_settings.sound_private_messages = g_strdup("0");
		
				
		if((fp=fopen(preferences_file,"w"))==NULL){
		printf("Error writing preferences file !\nAborting...\n");
		exit(1);
		}
			
	//	printf("Scrivo la conf di default\n");
		fprintf(fp,"%s\n",xwota_settings.program_version);
		fprintf(fp,"%s\n",xwota_settings.call);
		fprintf(fp,"%s\n",xwota_settings.freq);
		fprintf(fp,"%s\n",xwota_settings.country);
		fprintf(fp,"%s\n",xwota_settings.state);
		fprintf(fp,"%s\n",xwota_settings.grid);
		fprintf(fp,"%s\n",xwota_settings.county);
		fprintf(fp,"%s\n",xwota_settings.latitude);
		fprintf(fp,"%s\n",xwota_settings.longitude);
		fprintf(fp,"%s\n",xwota_settings.comments);
		fprintf(fp,"%s\n",xwota_settings.server_wotadb);
		fprintf(fp,"%s\n",xwota_settings.port);
		fprintf(fp,"%s\n",xwota_settings.upload_interval);
		fprintf(fp,"%s\n",xwota_settings.check_update);
		fprintf(fp,"%s\n",xwota_settings.participate);
		fprintf(fp,"%s\n",xwota_settings.read_from_rig);
		fprintf(fp,"%s\n",xwota_settings.autoanswer);
		fprintf(fp,"%s\n",xwota_settings.autoanswer_text);
		fprintf(fp,"%s\n",xwota_settings.save_private_messages);
		fprintf(fp,"%s\n",xwota_settings.sound_private_messages);
		
		
		
				
		fclose(fp);
		return 1;
		}
// Se c'è già la configurazione la leggo.
	//	printf("Leggo la conf.\n");
	if((fp=fopen(preferences_file,"r"))==NULL){
		printf("Error reading preferences file !\nAborting...\n");
		exit(1);
		}
	for(i=0;i<101;i++)program_version_entry[i] = '\0';	
	for(i=0;i<101;i++)call_entry[i] = '\0';
	for(i=0;i<101;i++)freq_entry[i] = '\0';	
	for(i=0;i<101;i++)country_entry[i] = '\0';
	for(i=0;i<101;i++)state_entry[i] = '\0';
	for(i=0;i<101;i++)grid_entry[i] = '\0';
	for(i=0;i<101;i++)county_entry[i] = '\0';
	for(i=0;i<101;i++)latitude_entry[i] = '\0';
	for(i=0;i<101;i++)longitude_entry[i] = '\0';
	for(i=0;i<101;i++)comments_entry[i] = '\0';
	for(i=0;i<101;i++)server_wotadb_entry[i] = '\0';
	for(i=0;i<101;i++)autoanswer_text_entry[i] = '\0';			
						
	fgets(program_version_entry,100,fp);
	fgets(call_entry,100,fp);
	fgets(freq_entry,100,fp);
	fgets(country_entry,100,fp);
	fgets(state_entry,100,fp);
	fgets(grid_entry,100,fp);
	fgets(county_entry,100,fp);
	fgets(latitude_entry,100,fp);
	fgets(longitude_entry,100,fp);
	fgets(comments_entry,100,fp);
	fgets(server_wotadb_entry,100,fp);
	fgets(port_entry,10,fp);
	fgets(upload_interval_entry,10,fp);
	fgets(check_update_entry,10,fp);
	fgets(participate_entry,10,fp);
	fgets(read_from_rig_entry,10,fp);
	fgets(autoanswer_entry,10,fp);
	fgets(autoanswer_text_entry,100,fp);
	fgets(save_private_messages_entry,10,fp);
	fgets(sound_private_messages_entry,10,fp);
	
	
	
	g_strdelimit(program_version_entry,"\n",'\0');
	g_strdelimit(call_entry,"\n",'\0');
	g_strdelimit(freq_entry,"\n",'\0');
	g_strdelimit(country_entry,"\n",'\0');
	g_strdelimit(state_entry,"\n",'\0');
	g_strdelimit(grid_entry,"\n",'\0');
	g_strdelimit(county_entry,"\n",'\0');
	g_strdelimit(latitude_entry,"\n",'\0');
	g_strdelimit(longitude_entry,"\n",'\0');
	g_strdelimit(comments_entry,"\n",'\0');
	g_strdelimit(server_wotadb_entry,"\n",'\0');
	g_strdelimit(port_entry,"\n",'\0');
	g_strdelimit(upload_interval_entry,"\n",'\0');
	g_strdelimit(check_update_entry,"\n",'\0');
	g_strdelimit(participate_entry,"\n",'\0');
	g_strdelimit(read_from_rig_entry,"\n",'\0');
	g_strdelimit(autoanswer_entry,"\n",'\0');
	g_strdelimit(autoanswer_text_entry,"\n",'\0');
	g_strdelimit(save_private_messages_entry,"\n",'\0');
	g_strdelimit(sound_private_messages_entry,"\n",'\0');
	
	
	
	
	
		xwota_settings.program_version = g_strdup(program_version_entry);
		xwota_settings.call = g_strdup(call_entry);
		xwota_settings.freq = g_strdup(freq_entry);
		xwota_settings.country = g_strdup(country_entry);
		xwota_settings.state = g_strdup(state_entry);
		xwota_settings.grid = g_strdup(grid_entry);
		xwota_settings.county = g_strdup(county_entry);
		xwota_settings.latitude = g_strdup(latitude_entry);
		xwota_settings.longitude = g_strdup(longitude_entry);
		xwota_settings.comments = g_strdup(comments_entry);
		xwota_settings.server_wotadb = g_strdup(server_wotadb_entry);
		xwota_settings.port = g_strdup(port_entry);
		xwota_settings.upload_interval = g_strdup(upload_interval_entry);
		xwota_settings.check_update = g_strdup(check_update_entry);
		xwota_settings.participate = g_strdup(participate_entry);
		xwota_settings.read_from_rig = g_strdup(read_from_rig_entry);
		xwota_settings.autoanswer = g_strdup(autoanswer_entry);
		xwota_settings.autoanswer_text = g_strdup(autoanswer_text_entry);
		xwota_settings.save_private_messages = g_strdup(save_private_messages_entry);
		xwota_settings.sound_private_messages = g_strdup(sound_private_messages_entry);
		
		
// Creo il file di stats_file

if(stat(stats_file,&statdir) == -1)
	{
	//printf("Creating %s file.\n",stats_file);
	if((sf=fopen(stats_file,"w"))==NULL){
//		printf("Error opening stats file !\n");
		}
		fclose(sf);
	}
	
		

		return 0;		
		
}


// SAVE PREFERENCES

void save_preferences () {
FILE *fp;	
gchar *home_dir,*work_dir,*preferences_file;

// DA TOGLIERE PRIMA DEL RILASCIO !!
	
home_dir = g_get_home_dir();
//home_dir = g_strdup("/tmp");
work_dir = g_strdup_printf("%s/.xwota",home_dir);
preferences_file = g_strdup_printf("%s/xwota.conf",work_dir);

	
		if((fp=fopen(preferences_file,"w"))==NULL){
		printf("Error opening preferences file !\nAborting...\n");
		exit(1);
		}
			
		
	//	printf("Salvo la configurazione\n");
		fprintf(fp,"%s\n",xwota_settings.program_version);
		fprintf(fp,"%s\n",xwota_settings.call);
		fprintf(fp,"%s\n",xwota_settings.freq);
		fprintf(fp,"%s\n",xwota_settings.country);
		fprintf(fp,"%s\n",xwota_settings.state);
		fprintf(fp,"%s\n",xwota_settings.grid);
		fprintf(fp,"%s\n",xwota_settings.county);
		fprintf(fp,"%s\n",xwota_settings.latitude);
		fprintf(fp,"%s\n",xwota_settings.longitude);
		fprintf(fp,"%s\n",xwota_settings.comments);
		fprintf(fp,"%s\n",xwota_settings.server_wotadb);
		fprintf(fp,"%s\n",xwota_settings.port);
		fprintf(fp,"%s\n",xwota_settings.upload_interval);
		fprintf(fp,"%s\n",xwota_settings.check_update);
		fprintf(fp,"%s\n",xwota_settings.participate);
		fprintf(fp,"%s\n",xwota_settings.read_from_rig);
		fprintf(fp,"%s\n",xwota_settings.autoanswer);	
		fprintf(fp,"%s\n",xwota_settings.autoanswer_text);	
		fprintf(fp,"%s\n",xwota_settings.save_private_messages);	
		fprintf(fp,"%s\n",xwota_settings.sound_private_messages);	
		fclose(fp);	
	
}

// UPPERCASE

gchar *uppercase(gchar *upper) {
	
int upper_len,i;
	upper_len=strlen(upper);
	for(i=0;i<upper_len+1;i++) {
		upper[i] = toupper(upper[i]);
	}
return upper;
	
}

// Main statusbar
void write_main_statusbar(char *message){
gtk_statusbar_push(left_main_statusbar,1,message);
//gtk_statusbar_push(statusbar2,1,message);	
}


void write_message_statusbar(char *message){

gtk_statusbar_push(left_private_messages_statusbar,1,message);
	
}

// AUTOMATIC UPLOAD
guint automatic_upload()
{
	
	if (connection_status == 1) {
//		printf("Upload info.\n");
		if(strcmp(gtk_combo_box_get_active_text(GTK_COMBO_BOX(participate_combo)),"Yes") == 0) {			
		on_update_button_clicked (NULL,NULL);
		return TRUE;
		}
		else {
//			printf("Not participating...\n");
			return TRUE;
		}
	}
 else {
//printf("Removing timeout.\n");
	 return FALSE;
 }
	
}


// DECODE MESSAGE

int decode_msg (char *msg)
  {
	
	  GtkTreeIter iter1;
	  GtkTreeStore *store;
	  GtkTreePath *path;
	  GtkWidget *spot_list;
	
char eor[5];
char *p_eor;	  
gchar *call,*freq,*country,*state,*grid,*county,*lat,*longitude,*status,*comments,*program,*f1,*f2,*d_ate,*t_ime; 
char datetime[50],latlong[50],status_comment[30],display_country[50];
char *country_name;	  
int status_digit,i;	
	 
	 strcpy(eor,"<EOR>"); 
//	printf("Decode: %s\n",msg); 
	//  printf("First char %c\n",msg[0]);
	
	  if(msg[0] == ':' )
	  {
	//  printf("Not implemented yet.\n");
		  if (msg[1] == 'M') {
			 //printf("Message received\n");
			 decode_text_message(msg);
			  
		  		return -1;
			  }
		  if (msg[1] == 'B') {
			  printf("Busy message from server\n");
		  		return -1;
			  }
		  
		  return -1;
	  }
// se non c'è il fine record
	  if ((p_eor = strstr(msg,eor)) == NULL)
	  {
		// printf("Incorrect message type\n");
	  
		  return -1;
	  }
// E' uno spot...lo decodifico.	
	  else {

	call = (gchar *)strsep (&msg, "|");
      freq = (gchar *)strsep (&msg, "|");
      country = (gchar *)strsep (&msg, "|");
      state = (gchar *)strsep (&msg, "|");
      grid = (gchar *)strsep (&msg, "|");
      county = (gchar *)strsep (&msg, "|");
      lat = (gchar *)strsep (&msg, "|");
      longitude = (gchar *)strsep (&msg, "|");
      status = (gchar *)strsep (&msg, "|");
      comments = (gchar *)strsep (&msg, "|");
      program = (gchar *)strsep (&msg, "|");
      f1 = (gchar *)strsep (&msg, "|");
      f2 = (gchar *)strsep (&msg, "|");
      d_ate = (gchar *)strsep (&msg, "|");
      t_ime = (gchar *)strsep (&msg, "|");

// se intercetto la stringa del server...salto...	
	if (strstr(call,"SERVER"))
			{
//		printf("Server WOTA...\n");
				return -1;
			}

			// Elaboro status
			
status_digit= atoi(status);
			
if(status_digit == 1) {
strcpy(status_comment,"Tuning");
	}
else if (status_digit == 2) {
strcpy(status_comment,"Listening");	
	}		

else if (status_digit == 3) {
strcpy(status_comment,"Calling");	
	}

	for(i=0;i<50;i++) display_country[i] = '\0';
	
// Elaboro il country
if(isdigit(country[0]) !=0) {
	country_name = country_lookup(country);
	for (i=0;i<50;i++) {
		if(country_name[i] == '\n')
		{
			country_name[i] = '\0';
	}
}

	//g_strdelimit(country_name,"\n",' ');
	sprintf(display_country,"%s",country_name);	
	
}
else {
	country_name = g_strdup(country);
	sprintf(display_country,"%s",country_name);
}

//printf("%s",country_name);

sprintf(latlong,"%s/%s",lat,longitude);
sprintf(datetime,"%s %s",d_ate,t_ime);

	
	
// Inserisco lo spot nella spot list

spot_list = lookup_widget(GTK_WIDGET(xwota_main),"spot_list");
store = gtk_tree_view_get_model(spot_list);
gtk_tree_store_append (GTK_TREE_STORE(store), &iter1, NULL); 
gtk_tree_store_set(GTK_TREE_STORE(store),&iter1,DATETIME_COLUMN,datetime,CALL_COLUMN,call,FREQ_COLUMN,freq,COUNTRY_COLUMN,display_country,STATE_COLUMN,state,GRID_COLUMN,grid,
COUNTY_COLUMN,county,LATLONG_COLUMN,latlong,STATUS_COLUMN,status_comment,COMMENTS_COLUMN,comments,-1);


 path = gtk_tree_model_get_path (GTK_TREE_MODEL (store), &iter1);
 gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW (spot_list), path,NULL, TRUE, 0.0, 1.0);
 gtk_tree_path_free (path);

	
// alimento le statistiche	
//add_to_stats(call);	
	
return 0;
	}
}


// COUNTRY LOOKUP
gchar *country_lookup (gchar *country_code) {

FILE *cf;
gchar *country_file;
gchar *code, *country;
gchar country_entry[50];
	
//printf("Country code %s conversion.\n",country_code);
country_file = g_strdup_printf("%s/%s/country.txt",PACKAGE_DATA_DIR,PACKAGE);
//	printf("CF : %s\n",country_file);
		if((cf=fopen(country_file,"r"))==NULL){
		printf("Error opening country file !\n");
			return country_code;
		}	
while(!feof(cf)) {
	fgets(country_entry,100,cf);
	code = strtok(country_entry," ");
	country = strtok(NULL,"");

//printf("%s %s\n",code,country);	
	if(strcmp(code,country_code) == 0) {
		return country;
	}

}
country = g_strdup("UNKNOWN");
fclose(cf);	
return country;
	
}

// Check frequency changes and upload when needed.
guint check_freq ()
{
	gchar *get_frequency;
	char frequency_entry[100];	
	
	if (connection_status == 1) {
		// jump check if not participating
		if(strcmp(gtk_combo_box_get_active_text(GTK_COMBO_BOX(participate_combo)),"No") == 0) {			
		return TRUE;
		}
	get_frequency= gtk_entry_get_text(GTK_ENTRY(frequency));
	strcpy(frequency_entry,get_frequency);
	//printf("Freq check: %s - Old Freq: %s\n",get_frequency,old_freq);
	
	if(strcmp(get_frequency,old_freq) == 0) {
		freq_change_count = 0; // reset frequency change count
		return TRUE;
	}
	else {
		
		if(freq_change_count == 2) { // ok, the frequency is stabilzed,upload granted.
		automatic_upload();
		freq_change_count = 0;
		return TRUE;	
		}
	//printf("Frequency not stabilized.\n");	
	freq_change_count++;
	}
	
}
	
else {	
	return FALSE;
}
	return TRUE;
}



int decode_text_message(gchar *msg)
{
	  GtkTreeIter iter;
	  GtkTreeStore *store_message;
	  GtkTreePath *path;
	  GtkWidget *private_messages_list;
	
	gchar *from, *to, *text;	
	char date_msg[30],date_msg_log[12],time_log[6];
	struct tm *utc;
	time_t t;

t=time(NULL);
utc = gmtime(&t);
//printf("Time: %d-%d-%d %d:%d\n",(utc->tm_year)+1900,utc->tm_mon,utc->tm_mday,utc->tm_hour,utc->tm_min);
sprintf(date_msg,"%d-%d-%d %d:%d",(utc->tm_year)+1900,utc->tm_mon,utc->tm_mday,utc->tm_hour,utc->tm_min);
sprintf(date_msg_log,"%d-%d-%d",(utc->tm_year)+1900,utc->tm_mon,utc->tm_mday);
sprintf(time_log,"%d:%d",utc->tm_hour,utc->tm_min);

	//printf("Decoding text message %s\n",msg);	
msg++;
msg++;
//printf("Now msg is %s\n",msg);

	to = (gchar *)strsep (&msg, "|");
      text = (gchar *)strsep (&msg, "|");
      from = (gchar *)strsep (&msg, "|");
	


private_messages_list = lookup_widget(GTK_WIDGET(private_messages_window),"private_messages_list");
store_message = gtk_tree_view_get_model(private_messages_list);
gtk_tree_store_append (GTK_TREE_STORE(store_message), &iter, NULL); 
gtk_tree_store_set(GTK_TREE_STORE(store_message),&iter,DATETIME_MSG_COLUMN,date_msg,MSG_FROM_COLUMN,from,MSG_TO_COLUMN,to,MESSAGE_TEXT_COLUMN,text,-1);

 path = gtk_tree_model_get_path (GTK_TREE_MODEL (store_message), &iter);
 gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW (private_messages_list), path,NULL, TRUE, 0.0, 1.0);
 gtk_tree_path_free (path);
	
gtk_widget_show(private_messages_window);

if(strcmp(xwota_settings.sound_private_messages,"1") == 0) {	
gdk_beep();
}
	
	if(strcmp(xwota_settings.save_private_messages,"1") == 0) {
//printf("Save message\n");
private_messages_log(date_msg_log,time_log,from,to,text);	
}	

// Autoanswer
if(strcmp(to,xwota_settings.call) == 0) {
// mettere controllo qui per non allooppare
  if(strcmp(gtk_combo_box_get_active_text(GTK_COMBO_BOX(autoanswer_combo)),"Yes") == 0) {			
		;
// riempio i campi e clikko send

	GtkWidget* send_to = lookup_widget(GTK_WIDGET(private_messages_window),"send_to");
	GtkWidget* private_message_text = lookup_widget(GTK_WIDGET(private_messages_window),"private_message_text");

	gtk_entry_set_text(GTK_ENTRY(send_to),from);
	gtk_entry_set_text(GTK_ENTRY(private_message_text),xwota_settings.autoanswer_text);	
	on_send_private_message_button_clicked();
	
	}
}	
//----------------------

	return 1;
	}
//-------- DECODE TEXT MESSAGE END -----------

void private_messages_log(gchar *date_msg_log,gchar *time_log,gchar *from,gchar *to,gchar *text)
{
FILE *lf;
struct stat statdir;
char string_to_log[1024],*log_filename;

//sprintf(log_filename,"%s",date_msg_log);
sprintf(string_to_log,"%s %s - %s -> %s : %s",date_msg_log,time_log,from,to,text);

//printf("Log: %s\n",string_to_log);

log_filename = g_strdup_printf("%s/logs/%s",work_dir,date_msg_log);

//printf("Log file: %s\n",log_filename);


if(stat(log_filename,&statdir) == -1)
	{
//	printf("Creating %s file.\n",log_filename);
	if((lf=fopen(log_filename,"w"))==NULL){
		printf("Error opening message log file !\n");
		}
		else {
		fprintf(lf,"%s\n",string_to_log);
		fclose(lf);
		}
	}
else {
		if((lf=fopen(log_filename,"a"))==NULL){
		printf("Error opening message log file !\n");
		}
		else {		
		fprintf(lf,"%s\n",string_to_log);
		fclose(lf);
		}
	}	
}

	
// STATS
int add_to_stats(gchar *call) {
FILE *sf;
gchar *home_dir,*work_dir,*stats_file;	
gchar call_stored[30];

home_dir = g_get_home_dir();
work_dir = g_strdup_printf("%s/.xwota",home_dir);
stats_file = g_strdup_printf("%s/stats",work_dir);

	
		if((sf=fopen(stats_file,"r"))==NULL){
//		printf("Error opening stats file !\n");
		}	
while(!feof(sf)) {
	fscanf(sf,"%s",call_stored);
	//printf("%s",call_stored);	
	if(strcmp(call,call_stored) == 0) {
		return 1;
	}
}
fclose(sf);

		if((sf=fopen(stats_file,"a"))==NULL){
//		printf("Error opening stats file !\n");
		}	
	fprintf(sf,"%s\n",call);
		fclose(sf);
	return 1;	
}


void write_query_statusbar(char *message){

gtk_statusbar_push(query_statusbar,1,message);
	
}

void write_manual (GtkWidget *manual_text) {

FILE *mf;
	 GtkTextBuffer *buffer;
        GtkTextIter iter;
	gchar buf[100];
	gchar *manual_file;
	
	manual_file = g_strdup_printf("%s/README",PACKAGE_DOC_DIR);
	
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(manual_text));
        gtk_text_buffer_get_start_iter (buffer, &iter);

	if((mf=fopen(manual_file,"r"))==NULL){
		printf("Error reading manual file !\n");
		return;
		}
	while(!feof(mf)) {
		 if (fgets (buf, 100, mf) == NULL)
                                break;
                        else
                        {
                          
                                gtk_text_buffer_insert (buffer, &iter, buf, -1);
                   
							}
	}
}
