/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef FADING_H
#define FADING_H

#ifdef SID_WITH_SIDPLAY2
# include <sidplay/sidplay2.h>
#else
# include <sidplay/mytypes.h>
#endif  /* SID_WITH_SIDPLAY2 */
#include "wrapper/TypeWrapper.h"

#include "AudioConfig.h"

class FadingBase
{
 public:
	FadingBase();

	virtual void set(const AudioConfig&, const int msecs) = 0;
	virtual void fade(ubyte_emuwt* buffer, const udword_emuwt bufLen) = 0;

	const int fadeLevel;
	int currentLevel;

	int millisecs;
	
	udword_emuwt step, count;
};

class FadingIn : public FadingBase
{
 public:
	FadingIn();
	
	void set(const AudioConfig&, const int msecs = 0);
	void fade(ubyte_emuwt* buffer, const udword_emuwt bufLen);

 private:
	void fadeIn8(ubyte_emuwt*, const udword_emuwt);
	void fadeIn16(ubyte_emuwt*, const udword_emuwt);
	void dummy(ubyte_emuwt*, const udword_emuwt);
	void (FadingIn::*proc)(ubyte_emuwt*, const udword_emuwt);
};

class FadingOut : public FadingBase
{
 public:
	FadingOut();
	
	void set(const AudioConfig&, const int msecs = 0);
	void fade(ubyte_emuwt* buffer, const udword_emuwt bufLen);
	
 private:
	void fadeOut8(ubyte_emuwt*, const udword_emuwt);
	void fadeOut16(ubyte_emuwt*, const udword_emuwt);
	void dummy(ubyte_emuwt*, const udword_emuwt);
	void (FadingOut::*proc)(ubyte_emuwt*, const udword_emuwt);
};

#endif  /* FADING_H */
