/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef AUDIODRIVERS_H
#define AUDIODRIVERS_H

#include <vector>
#include <qstring.h>

#include "AudioBase.h"

class AudioDrivers
{
 public:
    static void addDriver( AudioBase*, bool isDefault = false );
    static void setDriver( const QString& name );
   
    static AudioBase* getDriver();
    static const QString& getName();

    static void  dispose();  // dispose memory used
    
    struct Entry
    {
        AudioBase* pDriver;
        QString name;
    };
    typedef std::vector<Entry> List;
   
    static List::iterator begin();
    static List::iterator end();

 protected:
    static List driverList;
    static Entry theDriver;
    
 private:
    AudioDrivers();
    ~AudioDrivers();
};

#endif  // AUDIODRIVERS_H
