.TH XScreenSaver 1 "20-Nov-2000" "X Version 11"
.SH NAME
zoom - wander around magnified desktop
.SH SYNOPSIS
.B zoom
[\-display \fIhost:display.screen\fP] [\-foreground \fIcolor\fP]
[\-background \fIcolor\fP] [\-window] [\-root] [\-mono] [\-install]
[\-visual \fIvisual\fP] [\-delay \fIusecs\fP] [\-lenses]
[\-pixwidth \fIpixels\fP] [\-pixheight \fIpixels\fP]
[\-pixspacex \fIpixels\fP] [\-pixspacey \fIpixels\fP]
[\-lensoffsetx \fIpixels\fP] [\-lensoffsety \fIpixels\fP]
.SH DESCRIPTION
The \fIzoom\fP program takes an image, magnifies it, and scrolls around
it, fatbits-style.

The image that it manipulates will be grabbed from the portion of
the screen underlying the window, or from the system's video input,
or from a random file on disk, as indicated by
the \fIgrabDesktopImages\fP, \fIgrabVideoFrames\fP,
and \fIchooseRandomImages\fP options in the \fI~/.xscreensaver\fP
file; see
.BR xscreensaver-demo (1)
for more details.
.SH OPTIONS
.I zoom
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-mono 
If on a color display, pretend we're on a monochrome display.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fImicroseconds\fP
Slow it down.
.TP 8
.B \-lenses
Instead of doing magnification we just copy an offset region from the original
image.  If lensoffsetx < pixwidth (and similarly for Y) then consecutive
regions will overlap, giving the effect of looking through an array of
lenses.
.TP 8
.B \-pixwidth \fIpixels\fP
Width of the magnified pixels.
.TP 8
.B \-pixheight \fIpixels\fP
Height of the magnified pixels.
.TP 8
.B \-pixspacex \fIpixels\fP
Amount of black space between magnified pixels (X direction).
.TP 8
.B \-pixspacey \fIpixels\fP
Amount of black space between magnified pixels (Y direction).
.TP 8
.B \-lensoffsetx \fIpixels\fP
Distance in X direction between consecutive copied regions (only effective
when 
.I -lenses
used).
.TP 8
.B \-lensoffsety \fIpixels\fP
Distance in Y direction between consecutive copied regions (only effective
when 
.I -lenses
used).
.TP 8
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR xscreensaver\-demo (1),
.BR xscreensaver\-getimage (1)
.SH COPYRIGHT
Copyright \(co 2000 by James Macnicol.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
James Macnicol <james.macnicol@mailexcite.com>, 20-Nov-2000.  Much code was
shamelessly stolen from the 
.B spotlight 
hack and a few others.

