 /*
 *  file      : popup.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright :( C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */
 
 
#ifdef HAVE_CONFIG_H
	#include "../config.h"
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define gettext_noop(x)( x) 
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif


#include "global.h"
#include "poche.h"
#include "cd_audio.h"
#include "dvd.h"
#include "split.h"
#include "popup.h"



typedef struct {
	DETAIL      *detail;
	CD_AUDIO    *Audio;
	TYPE_FILE_IS type_file_is;
} VAR_POPUP;

VAR_POPUP VarPopup;

typedef struct {
	gboolean   Show;
	gint       Type;
	gint       Val;
	gint       Call;
} MENU_VAL;

typedef struct {
	GtkWidget *Widget;
	gchar     *Title;
	MENU_VAL   Op;
} POP_MENU;




#define CASE_POP_MENU_FICHERS 0
#define MAX_POP_MENU_FICHERS 9
POP_MENU PopMenuFichiers [ MAX_POP_MENU_FICHERS ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Deselection globale"),			{TRUE,		0,	0,	CASE_POP_MENU_FICHERS}},
{NULL,	gettext_noop("   Deselection verticale"),		{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +1}},
{NULL,	gettext_noop("   Deselection horizontale"),		{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +2}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection verticale"),			{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +3}},
{NULL,	gettext_noop("   Selection Expert verticale"),		{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +4}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection horizontale"),		{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +5}},
{NULL,	gettext_noop("   Selection Expert horizontale  "),	{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +6}}
};


#define CASE_POP_MENU_CD 10
#define MAX_POP_MENU_CD 9
POP_MENU PopMenuCD [ MAX_POP_MENU_CD ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Deselection globale"),			{TRUE,		0,	0,	CASE_POP_MENU_CD}},
{NULL,	gettext_noop("   Deselection verticale"),		{TRUE,		0,	0,	CASE_POP_MENU_CD +1}},
{NULL,	gettext_noop("   Deselection horizontale"),		{TRUE,		0,	0,	CASE_POP_MENU_CD +2}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection verticale"),			{TRUE,		0,	0,	CASE_POP_MENU_CD +3}},
{NULL,	gettext_noop("   Selection Expert verticale"),		{TRUE,		0,	0,	CASE_POP_MENU_CD +4}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection horizontale"),		{TRUE,		0,	0,	CASE_POP_MENU_CD +5}},
{NULL,	gettext_noop("   Selection Expert horizontale  "),	{TRUE,		0,	0,	CASE_POP_MENU_CD +6}}
};


#define CASE_POP_MENU_NORMALISE_CD 200
#define MAX_POP_MENU_NORMALISE_CD 3
POP_MENU PopMenuNormaliseCD [ MAX_POP_MENU_NORMALISE_CD ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Deselection verticale    "),		{TRUE,		0,	0,	CASE_POP_MENU_NORMALISE_CD +0}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection verticale  "),		{TRUE,		0,	0,	CASE_POP_MENU_NORMALISE_CD +1}}
};


#define CASE_POP_MENU_NORMALISE_DVD 300
#define MAX_POP_MENU_NORMALISE_DVD 3
POP_MENU PopMenuNormaliseDVD [ MAX_POP_MENU_NORMALISE_DVD ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Deselection verticale    "),		{TRUE,		0,	0,	CASE_POP_MENU_NORMALISE_DVD +0}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection verticale  "),		{TRUE,		0,	0,	CASE_POP_MENU_NORMALISE_DVD +1}}
};


#define CASE_POP_MENU_REPLAYGAIN 30
#define MAX_POP_MENU_REPLAYGAIN 6
POP_MENU PopMenuReplayGain[ MAX_POP_MENU_REPLAYGAIN ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("---SELECTION VERTICALE-----"),		{FALSE,		-2,	0,	-1}},
{NULL,	gettext_noop("   Deselection verticale   "),		{TRUE,		0,	0,	CASE_POP_MENU_REPLAYGAIN +0}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection PISTE         "),		{TRUE,		0,	0,	CASE_POP_MENU_REPLAYGAIN +1}},
{NULL,	gettext_noop("   Selection ALBUM         "),		{TRUE,		0,	0,	CASE_POP_MENU_REPLAYGAIN +2}},
{NULL,	gettext_noop("   Selection NETTOYER      "),		{TRUE,		0,	0,	CASE_POP_MENU_REPLAYGAIN +3}}
};


#define CASE_POP_MENU_TRASH 40
#define MAX_POP_MENU_TRASH 3
POP_MENU PopMenuTrash[ MAX_POP_MENU_TRASH ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("---MENU TRASH--------------"),		{FALSE,		-2,	0,	-1}},
{NULL,	gettext_noop("   Deselection verticale"),		{TRUE,		0,	0,	CASE_POP_MENU_TRASH}},
{NULL,	gettext_noop("   Selection verticale   "),		{TRUE,		0,	0,	CASE_POP_MENU_TRASH +1}}
};










// 
// 
void popup_callback( GtkMenuItem *menuitem, gpointer user_data )
{
	MENU_VAL *Op =( MENU_VAL *)user_data;
	
	if( -1 == Op->Call) return;
	
	// g_print("Op->Call = %d\n",Op->Call );
	
	switch( Op->Call ) {
	
	// Deselection globale	
	case CASE_POP_MENU_FICHERS :
		file_from_popup( FILE_CONV_DESELECT_ALL, VarPopup.detail, VarPopup.type_file_is );
		break;
	// Deselection verticale	
	case CASE_POP_MENU_FICHERS +1 :
		file_from_popup( FILE_CONV_DESELECT_V, VarPopup.detail, VarPopup.type_file_is );
		break;
	// Deselection horizontale	
	case CASE_POP_MENU_FICHERS +2 :
		file_from_popup( FILE_CONV_DESELECT_H, VarPopup.detail, VarPopup.type_file_is );
		break;
	// Selection verticale	
	case CASE_POP_MENU_FICHERS +3 : 
		file_from_popup( FILE_CONV_SELECT_V, VarPopup.detail, VarPopup.type_file_is );
		break;
	// Selection Expert verticale
	case CASE_POP_MENU_FICHERS +4 :
		file_from_popup( FILE_CONV_SELECT_EXPERT_V, VarPopup.detail, VarPopup.type_file_is );
		break;
	// Selection horizontale
	case CASE_POP_MENU_FICHERS +5 :
		file_from_popup( FILE_CONV_SELECT_H, VarPopup.detail, VarPopup.type_file_is );
		break;
	// Selection Expert horizontale
	case CASE_POP_MENU_FICHERS +6 :
		file_from_popup( FILE_CONV_SELECT_EXPERT_H, VarPopup.detail, VarPopup.type_file_is );
		break;
	

	// Deselection globale
	case CASE_POP_MENU_CD +0 :
		cdaudio_from_popup( CD_CONV_DESELECT_ALL, VarPopup.Audio, VarPopup.type_file_is );
		break;
	// Deselection verticale
	case CASE_POP_MENU_CD +1 :
		cdaudio_from_popup( CD_CONV_DESELECT_V, VarPopup.Audio, VarPopup.type_file_is );
		break;
	// Deselection horizontale
	case CASE_POP_MENU_CD +2 :
		cdaudio_from_popup( CD_CONV_DESELECT_H, VarPopup.Audio, VarPopup.type_file_is );
		break;
	// Selection verticale
	case CASE_POP_MENU_CD +3 :
		cdaudio_from_popup( CD_CONV_SELECT_V, VarPopup.Audio, VarPopup.type_file_is );
		break;
	// Selection Expert verticale
	case CASE_POP_MENU_CD +4 :
		cdaudio_from_popup( CD_CONV_SELECT_EXPERT_V, VarPopup.Audio, VarPopup.type_file_is );
		break;
	// Selection horizontale
	case CASE_POP_MENU_CD +5 :
		cdaudio_from_popup( CD_CONV_SELECT_H, VarPopup.Audio, VarPopup.type_file_is );
		break;
	// Selection Expert horizontale
	case CASE_POP_MENU_CD +6 :
		cdaudio_from_popup( CD_CONV_SELECT_EXPERT_H, VarPopup.Audio, VarPopup.type_file_is );
		break;
	

	// Deselection verticale
	case CASE_POP_MENU_NORMALISE_CD +0:
		cdaudio_from_popup( CD_REPLAYGAIN_SELECT_V, VarPopup.Audio, VarPopup.type_file_is );
		break;
	// Selection verticale
	case CASE_POP_MENU_NORMALISE_CD +1:
		cdaudio_from_popup( CD_REPLAYGAIN_DESELECT_V, VarPopup.Audio, VarPopup.type_file_is );
		break;


	// Deselection verticale
	case CASE_POP_MENU_NORMALISE_DVD +0:
		dvd_from_popup( CD_NORMALISE_SELECT_V , FALSE );
		break;
	// Selection verticale
	case CASE_POP_MENU_NORMALISE_DVD +1:
		dvd_from_popup( CD_NORMALISE_DESELECT_V, TRUE );
		break;
	
	
	// Deselection verticale
	case CASE_POP_MENU_REPLAYGAIN +0 :
		file_from_popup( FILE_REPLAYGAIN_DESELECT_V, VarPopup.detail, VarPopup.type_file_is );
		break;
	// Selection PISTE
	case CASE_POP_MENU_REPLAYGAIN +1 :
		file_from_popup( FILE_REPLAYGAIN_SELECT_PISTE, VarPopup.detail, VarPopup.type_file_is );
		break;
	// Selection ALBUM
	case CASE_POP_MENU_REPLAYGAIN +2 :
		file_from_popup( FILE_REPLAYGAIN_SELECT_ALBUM, VarPopup.detail, VarPopup.type_file_is );
		break;
	// Selection NETTOYER
	case CASE_POP_MENU_REPLAYGAIN +3 :
		file_from_popup( FILE_REPLAYGAIN_SELECT_NETTOYER, VarPopup.detail, VarPopup.type_file_is );
		break;
	

	// Deselection verticale
	case CASE_POP_MENU_TRASH :
		file_from_popup( FILE_TRASH_DESELECT_V, VarPopup.detail, VarPopup.type_file_is );
		break;
	// Selection verticale
	case CASE_POP_MENU_TRASH +1 :
		file_from_popup( FILE_TRASH_SELECT_V, VarPopup.detail, VarPopup.type_file_is );
		break;
	}
}
// 
// 
void popup_make_popup( POP_MENU *p_popup, gint nbr_op)
{
	GtkWidget *menu = NULL;
	GtkWidget *Attach = NULL;
	GtkWidget *SubMenu = NULL;
	gint       cpt = 0;
	gint       val = 0;
	
	
	if( VarPopup.detail != NULL ) {
		if( VarPopup.detail->type_infosong_file_is == FILE_IS_WAV ) {
			INFO_WAV *info =( INFO_WAV *)VarPopup.detail->info;
			val = info->LevelDbfs.level;
		}
		else if( VarPopup.detail->type_infosong_file_is == FILE_IS_OGG ) {
			INFO_OGG *info =( INFO_OGG *)VarPopup.detail->info;
			val = info->LevelDbfs.level;
		}
		else if( VarPopup.detail->type_infosong_file_is == FILE_IS_MP3 ) {
			INFO_MP3 *info =( INFO_MP3 *)VarPopup.detail->info;
			val = info->LevelDbfs.level;
		}
	}
	
	menu = gtk_menu_new(  );	
	gtk_widget_set_extension_events( menu, GDK_EXTENSION_EVENTS_ALL );

	for( cpt = 0; cpt < nbr_op; cpt ++ ) {
		if( p_popup[ cpt ].Op.Type > -1 ) {
			p_popup[ cpt ].Widget = gtk_menu_item_new_with_mnemonic( gettext(p_popup[ cpt ].Title) );
			gtk_widget_show( p_popup[ cpt ].Widget );
			gtk_container_add( GTK_CONTAINER( menu), p_popup[ cpt ].Widget );
		}
		else if( p_popup[ cpt ].Op.Type == -1 ) {
			p_popup[ cpt ].Widget = gtk_separator_menu_item_new(  );
			gtk_widget_show( p_popup[ cpt ].Widget );
			gtk_container_add( GTK_CONTAINER( menu), p_popup[ cpt ].Widget );
		}
		else if( p_popup[ cpt ].Op.Type == -2 ) {
			p_popup[ cpt ].Widget = gtk_menu_item_new_with_mnemonic( gettext(p_popup[ cpt ].Title) );
			gtk_widget_show( p_popup[ cpt ].Widget );
			gtk_container_add( GTK_CONTAINER( menu), p_popup[ cpt ].Widget );
		}
		else if( p_popup[ cpt ].Op.Type == -3 ) {
			Attach = p_popup[ cpt ].Widget = gtk_menu_item_new_with_mnemonic( gettext(p_popup[ cpt ].Title) );
			gtk_widget_show( p_popup[ cpt ].Widget );
			gtk_container_add( GTK_CONTAINER( menu), p_popup[ cpt ].Widget );
			
			SubMenu = gtk_menu_new(  );
			gtk_menu_item_set_submenu( GTK_MENU_ITEM( p_popup[ cpt ].Widget), SubMenu );
		}
		else if( p_popup[ cpt ].Op.Type == -10 ) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic( gettext(p_popup[ cpt ].Title) );
			gtk_widget_show( p_popup[ cpt ].Widget );
			gtk_container_add( GTK_CONTAINER( SubMenu), p_popup[ cpt ].Widget );
		}
		
		gtk_widget_set_sensitive( p_popup[ cpt ].Widget, p_popup[ cpt ].Op.Show );
	}

	for( cpt = 0; cpt < nbr_op; cpt ++ ) {
		g_signal_connect( (gpointer) p_popup[ cpt ].Widget, "activate",
					G_CALLBACK( popup_callback),
					(gpointer)&p_popup[ cpt ].Op );
	}

	GLADE_HOOKUP_OBJECT_NO_REF( menu, menu, "menu" );
	for( cpt = 0; cpt < nbr_op; cpt ++ ) {
		GLADE_HOOKUP_OBJECT( menu, p_popup[ cpt ].Widget, p_popup[ cpt ].Title );
	}

	gtk_menu_popup( GTK_MENU( menu), NULL, NULL, NULL, NULL, 3, 0 );	
}

// 
// 
// POPUP CD 
// 
// 
void popup_cd( CD_AUDIO *Audio, TYPE_FILE_IS TypeFileIs )
{
	VarPopup.detail       = (DETAIL *)NULL;
	VarPopup.type_file_is = TypeFileIs;
	VarPopup.Audio        = (CD_AUDIO *)Audio;
	popup_make_popup( PopMenuCD, MAX_POP_MENU_CD );
}
// 
// 
// POPUP FILE 
// 
// 
void popup_file( DETAIL *detail, TYPE_FILE_IS TypeFileIs )
{
	VarPopup.Audio        = (CD_AUDIO *)NULL;
	VarPopup.detail       = (DETAIL *)detail;
	VarPopup.type_file_is = TypeFileIs;
	popup_make_popup( PopMenuFichiers, MAX_POP_MENU_FICHERS );
}
// 
// 
// POPUP FILE REPLAYGAIN 
// 
// 
void popup_file_ReplayGain( DETAIL *detail )
{
	VarPopup.detail                = (DETAIL *)detail;
	VarPopup.Audio                 = (CD_AUDIO *)NULL;
	PopMenuReplayGain[ 3 ].Op.Show = TRUE;
	if( VarPopup.detail->type_infosong_file_is == FILE_IS_FLAC ) {
		PopMenuReplayGain[ 3 ].Op.Show = FALSE;
	}
	popup_make_popup( PopMenuReplayGain, MAX_POP_MENU_REPLAYGAIN );
}
// 
// 
// POPUP NORMALISE DVD 
// 
// 
void popup_normalise_dvd( void )
{
	VarPopup.detail = (DETAIL *)NULL;
	VarPopup.Audio  = (CD_AUDIO *)NULL;
	popup_make_popup( PopMenuNormaliseDVD, MAX_POP_MENU_NORMALISE_DVD );
}
// 
// 
// POPUP NORMALISE CD 
// 
// 
void popup_normalise_cd( void )
{
	VarPopup.detail = (DETAIL *)NULL;
	VarPopup.Audio  = (CD_AUDIO *)NULL;
	popup_make_popup( PopMenuNormaliseCD, MAX_POP_MENU_NORMALISE_CD );
}
// 
// 
// POPUP TRASH 
// 
// 
void popup_trash( void )
{
	VarPopup.detail = (DETAIL *)NULL;
	VarPopup.Audio  = (CD_AUDIO *)NULL;
	popup_make_popup( PopMenuTrash, MAX_POP_MENU_TRASH );
}

















// 
//
// POPUP FILE WAV PISTE
// 
// 
void on_CellTrack1_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_TRACK_CELL, detail, -2, 1, -2 );
}
void on_CellTrack2_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_TRACK_CELL, detail, -2, 2, -2 );
}
void on_CellTrack4_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_TRACK_CELL, detail, -2, 4, -2 );
}
void on_CellTrack6_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_TRACK_CELL, detail, -2, 6, -2 );
}
void on_CellTrackOriginal_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_TRACK_CELL, detail, -2, -1, -2 );
}
void on_ColTrack1_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_TRACK_COL, detail, -2, 1, -2 );
}
void on_ColTrack2_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_TRACK_COL, detail, -2, 2, -2 );
}
void on_ColTrack4_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_TRACK_COL, detail, -2, 4, -2 );
}
void on_ColTrack6_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_TRACK_COL, detail, -2, 6, -2 );
}
void on_ColTrackOriginal_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_TRACK_COL, detail, -2, -1, -2 );
}
void popup_file_wav_piste( DETAIL *detail)
{
	GtkWidget *Menu;
	GtkWidget *CellTrack;
	GtkWidget *CellSubMenu;
	GtkWidget *CellTrack1;
	GtkWidget *CellTrack2;
	GtkWidget *CellTrack4;
	GtkWidget *CellTrack6;
	GtkWidget *CellSeparate;
	GtkWidget *CellTrackOriginal;

	GtkWidget *ColTrack;
	GtkWidget *ColSubMenu;
	GtkWidget *ColTrack1;
	GtkWidget *ColTrack2;
	GtkWidget *ColTrack4;
	GtkWidget *ColTrack6;
	GtkWidget *ColSeparate;
	GtkWidget *ColTrackOriginal;
	
	Menu = gtk_menu_new(  );
	gtk_widget_set_extension_events( Menu, GDK_EXTENSION_EVENTS_ALL );
	CellTrack = gtk_menu_item_new_with_mnemonic( _("Cellule") );
	gtk_widget_show( CellTrack );
	gtk_container_add( GTK_CONTAINER( Menu), CellTrack ); 
	
	CellSubMenu = gtk_menu_new(  );
	gtk_menu_item_set_submenu( GTK_MENU_ITEM( CellTrack), CellSubMenu );
		
	CellTrack1 = gtk_menu_item_new_with_mnemonic( _("1  piste") );
	gtk_widget_show( CellTrack1 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellTrack1  );
	CellTrack2 = gtk_menu_item_new_with_mnemonic( _("2  pistes") );
	gtk_widget_show( CellTrack2 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellTrack2  );
	CellTrack4 = gtk_menu_item_new_with_mnemonic( _("4  pistes") );
	gtk_widget_show( CellTrack4 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellTrack4  );
	CellTrack6 = gtk_menu_item_new_with_mnemonic( _("6  pistes") );
	gtk_widget_show( CellTrack6 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellTrack6  );
	CellSeparate = gtk_separator_menu_item_new(  );
	gtk_widget_show( CellSeparate );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellSeparate );
	CellTrackOriginal = gtk_menu_item_new_with_mnemonic( _("Valeur d'origine") );
	gtk_widget_show( CellTrackOriginal );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellTrackOriginal  );
	
	ColTrack = gtk_menu_item_new_with_mnemonic( _("Colonne") );
	gtk_widget_show( ColTrack );
	gtk_container_add( GTK_CONTAINER( Menu), ColTrack ); 
	
	ColSubMenu = gtk_menu_new(  );
	gtk_menu_item_set_submenu( GTK_MENU_ITEM( ColTrack), ColSubMenu );
	
	ColTrack1 = gtk_menu_item_new_with_mnemonic( _("1  piste") );
	gtk_widget_show( ColTrack1 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColTrack1  );
	ColTrack2 = gtk_menu_item_new_with_mnemonic( _("2  pistes") );
	gtk_widget_show( ColTrack2 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColTrack2  );
	ColTrack4 = gtk_menu_item_new_with_mnemonic( _("4  pistes") );
	gtk_widget_show( ColTrack4 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColTrack4  );
	ColTrack6 = gtk_menu_item_new_with_mnemonic( _("6  pistes") );
	gtk_widget_show( ColTrack6 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColTrack6  );
	ColSeparate = gtk_separator_menu_item_new(  );
	gtk_widget_show( ColSeparate );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColSeparate );
	ColTrackOriginal = gtk_menu_item_new_with_mnemonic( _("Valeur d'origine") );
	gtk_widget_show( ColTrackOriginal );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColTrackOriginal  );
	
	g_signal_connect(( gpointer) CellTrack1,        "activate", G_CALLBACK( on_CellTrack1_activate),        detail  );
	g_signal_connect(( gpointer) CellTrack2,        "activate", G_CALLBACK( on_CellTrack2_activate),        detail  );
	g_signal_connect(( gpointer) CellTrack4,        "activate", G_CALLBACK( on_CellTrack4_activate),        detail  );
	g_signal_connect(( gpointer) CellTrack6,        "activate", G_CALLBACK( on_CellTrack6_activate),        detail  );
	g_signal_connect(( gpointer) CellTrackOriginal, "activate", G_CALLBACK( on_CellTrackOriginal_activate), detail  );
	g_signal_connect(( gpointer) ColTrack1,         "activate", G_CALLBACK( on_ColTrack1_activate),         detail  );
	g_signal_connect(( gpointer) ColTrack2,         "activate", G_CALLBACK( on_ColTrack2_activate),         detail  );
	g_signal_connect(( gpointer) ColTrack4,         "activate", G_CALLBACK( on_ColTrack4_activate),         detail  );
	g_signal_connect(( gpointer) ColTrack6,         "activate", G_CALLBACK( on_ColTrack6_activate),         detail  );
	g_signal_connect(( gpointer) ColTrackOriginal,  "activate", G_CALLBACK( on_ColTrackOriginal_activate),   detail  );
	
	GLADE_HOOKUP_OBJECT_NO_REF( Menu, Menu,       "Menu" );
	GLADE_HOOKUP_OBJECT( Menu, CellSubMenu,       "CellSubMenu" );
	GLADE_HOOKUP_OBJECT( Menu, CellTrack1,        "CellTrack1" );
	GLADE_HOOKUP_OBJECT( Menu, CellTrack2,        "CellTrack2" );
	GLADE_HOOKUP_OBJECT( Menu, CellTrack4,        "CellTrack4" );
	GLADE_HOOKUP_OBJECT( Menu, CellTrack6,        "CellTrack6" );
	GLADE_HOOKUP_OBJECT( Menu, CellSeparate,      "CellSeparate" );
	GLADE_HOOKUP_OBJECT( Menu, CellTrackOriginal, "CellTrackOriginal" );

	GLADE_HOOKUP_OBJECT( Menu, ColSubMenu,        "ColSubMenu" );
	GLADE_HOOKUP_OBJECT( Menu, ColTrack1,         "ColTrack1" );
	GLADE_HOOKUP_OBJECT( Menu, ColTrack2,         "ColTrack2" );
	GLADE_HOOKUP_OBJECT( Menu, ColTrack4,         "ColTrack4" );
	GLADE_HOOKUP_OBJECT( Menu, ColTrack6,         "ColTrack6" );
	GLADE_HOOKUP_OBJECT( Menu, ColSeparate,       "ColSeparate" );
	GLADE_HOOKUP_OBJECT( Menu, ColTrackOriginal,  "ColTrackOriginal" );
	
	gtk_menu_popup( GTK_MENU( Menu), NULL, NULL, NULL, NULL, 3, 0 );
}
// 
//
// POPUP FILE WAV FREQUENCE
// 
// 
void on_CellHertz8000_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_CELL_HERTZ, detail, 8000, -2, -2 );
}
void on_CellHertz22000_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_CELL_HERTZ, detail, 22000, -2, -2 );
}
void on_CellHertz32000_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_CELL_HERTZ, detail, 32000, -2, -2 );
}
void on_CellHertz44056_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_CELL_HERTZ, detail, 44056, -2, -2 );
}
void on_CellHertz44100_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_CELL_HERTZ, detail, 44100, -2, -2 );
}
void on_CellHertz48000_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_CELL_HERTZ, detail, 48000, -2, -2 );
}
void on_CellHertz88200_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_CELL_HERTZ, detail, 88200, -2, -2 );
}
void on_CellHertz96000_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_CELL_HERTZ, detail, 96000, -2, -2 );
}
void on_CellHertzOriginal_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_CELL_HERTZ, detail, -1, -2, -2 );
}
void on_ColHertz8000_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_COL_HERTZ, detail, 8000, -2, -2 );
}
void on_ColHertz22000_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_COL_HERTZ, detail, 22000, -2, -2 );
}
void on_ColHertz32000_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_COL_HERTZ, detail, 32000, -2, -2 );
}
void on_ColHertz44056_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_COL_HERTZ, detail, 44056, -2, -2 );
}
void on_ColHertz44100_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_COL_HERTZ, detail, 44100, -2, -2 );
}
void on_ColHertz48000_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_COL_HERTZ, detail, 48000, -2, -2 );
}
void on_ColHertz88200_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_COL_HERTZ, detail, 88200, -2, -2 );
}
void on_ColHertz96000_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_COL_HERTZ, detail, 96000, -2, -2 );
}
void on_ColHertzOriginal_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_FREQUENCY_COL_HERTZ, detail, -1, -2, -2 );
}
void popup_file_wav_frequence( DETAIL *detail)
{
	GtkWidget *Menu;
	GtkWidget *CellHertz;
	GtkWidget *CellSubMenu;
	GtkWidget *CellHertz8000;
	GtkWidget *CellHertz22000;
	GtkWidget *CellHertz32000;
	GtkWidget *CellHertz44056;
	GtkWidget *CellHertz44100;
	GtkWidget *CellHertz48000;
	GtkWidget *CellHertz88200;
	GtkWidget *CellHertz96000;
	GtkWidget *CellSeparate;
	GtkWidget *CellHertzOriginal;
	
	GtkWidget *ColHertz;
	GtkWidget *ColSubMenu;
	GtkWidget *ColHertz8000;
	GtkWidget *ColHertz22000;
	GtkWidget *ColHertz32000;
	GtkWidget *ColHertz44056;
	GtkWidget *ColHertz44100;
	GtkWidget *ColHertz48000;
	GtkWidget *ColHertz88200;
	GtkWidget *ColHertz96000;
	GtkWidget *ColSeparate;
	GtkWidget *ColHertzOriginal;
	
	Menu = gtk_menu_new(  );
	gtk_widget_set_extension_events( Menu, GDK_EXTENSION_EVENTS_ALL );
	CellHertz = gtk_menu_item_new_with_mnemonic( _("Cellule") );
	gtk_widget_show( CellHertz );
	gtk_container_add( GTK_CONTAINER( Menu), CellHertz ); 
	
	CellSubMenu = gtk_menu_new(  );
	gtk_menu_item_set_submenu( GTK_MENU_ITEM( CellHertz), CellSubMenu );
		
	CellHertz8000 = gtk_menu_item_new_with_mnemonic( _(" 8000  Hertz") );
	gtk_widget_show( CellHertz8000 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellHertz8000  );
	CellHertz22000 = gtk_menu_item_new_with_mnemonic( _("22000  Hertz") );
	gtk_widget_show( CellHertz22000 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellHertz22000  );
	CellHertz32000 = gtk_menu_item_new_with_mnemonic( _("32000  Hertz") );
	gtk_widget_show( CellHertz32000 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellHertz32000  );
	CellHertz44056 = gtk_menu_item_new_with_mnemonic( _("44056  Hertz") );
	gtk_widget_show( CellHertz44056 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellHertz44056  );
	CellHertz44100 = gtk_menu_item_new_with_mnemonic( _("44100  Hertz") );
	gtk_widget_show( CellHertz44100 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellHertz44100  );
	CellHertz48000 = gtk_menu_item_new_with_mnemonic( _("48000  Hertz") );
	gtk_widget_show( CellHertz48000 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellHertz48000  );
	CellHertz88200 = gtk_menu_item_new_with_mnemonic( _("88200  Hertz") );
	gtk_widget_show( CellHertz88200 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellHertz88200  );
	CellHertz96000 = gtk_menu_item_new_with_mnemonic( _("96000  Hertz") );
	gtk_widget_show( CellHertz96000 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellHertz96000  );
	CellSeparate = gtk_separator_menu_item_new(  );
	gtk_widget_show( CellSeparate );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellSeparate );
	CellHertzOriginal = gtk_menu_item_new_with_mnemonic( _("Valeur d'origine") );
	gtk_widget_show( CellHertzOriginal );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellHertzOriginal  );
	
	ColHertz = gtk_menu_item_new_with_mnemonic( _("Colonne") );
	gtk_widget_show( ColHertz );
	gtk_container_add( GTK_CONTAINER( Menu), ColHertz ); 
	
	ColSubMenu = gtk_menu_new(  );
	gtk_menu_item_set_submenu( GTK_MENU_ITEM( ColHertz), ColSubMenu );
	
	ColHertz8000 = gtk_menu_item_new_with_mnemonic( _(" 8000  Hertz") );
	gtk_widget_show( ColHertz8000 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColHertz8000  );
	ColHertz22000 = gtk_menu_item_new_with_mnemonic( _("22000  Hertz") );
	gtk_widget_show( ColHertz22000 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColHertz22000  );
	ColHertz32000 = gtk_menu_item_new_with_mnemonic( _("32000  Hertz") );
	gtk_widget_show( ColHertz32000 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColHertz32000  );
	ColHertz44056 = gtk_menu_item_new_with_mnemonic( _("44056  Hertz") );
	gtk_widget_show( ColHertz44056 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColHertz44056  );
	ColHertz44100 = gtk_menu_item_new_with_mnemonic( _("44100  Hertz") );
	gtk_widget_show( ColHertz44100 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColHertz44100  );
	ColHertz48000 = gtk_menu_item_new_with_mnemonic( _("48000  Hertz") );
	gtk_widget_show( ColHertz48000 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColHertz48000  );
	ColHertz88200 = gtk_menu_item_new_with_mnemonic( _("88200  Hertz") );
	gtk_widget_show( ColHertz88200 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColHertz88200  );
	ColHertz96000 = gtk_menu_item_new_with_mnemonic( _("96000  Hertz") );
	gtk_widget_show( ColHertz96000 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColHertz96000  );
	ColSeparate = gtk_separator_menu_item_new(  );
	gtk_widget_show( ColSeparate );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColSeparate );
	ColHertzOriginal = gtk_menu_item_new_with_mnemonic( _("Valeur d'origine") );
	gtk_widget_show( ColHertzOriginal );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColHertzOriginal  );
		
	g_signal_connect(( gpointer) CellHertz8000,     "activate", G_CALLBACK( on_CellHertz8000_activate),     detail  );
	g_signal_connect(( gpointer) CellHertz22000,    "activate", G_CALLBACK( on_CellHertz22000_activate),    detail  );
	g_signal_connect(( gpointer) CellHertz32000,    "activate", G_CALLBACK( on_CellHertz32000_activate),    detail  );
	g_signal_connect(( gpointer) CellHertz44056,    "activate", G_CALLBACK( on_CellHertz44056_activate),    detail  );
	g_signal_connect(( gpointer) CellHertz44100,    "activate", G_CALLBACK( on_CellHertz44100_activate),    detail  );
	g_signal_connect(( gpointer) CellHertz48000,    "activate", G_CALLBACK( on_CellHertz48000_activate),    detail  );
	g_signal_connect(( gpointer) CellHertz88200,    "activate", G_CALLBACK( on_CellHertz88200_activate),    detail  );
	g_signal_connect(( gpointer) CellHertz96000,    "activate", G_CALLBACK( on_CellHertz96000_activate),    detail  );
	g_signal_connect(( gpointer) CellHertzOriginal, "activate", G_CALLBACK( on_CellHertzOriginal_activate), detail  );
	
	g_signal_connect(( gpointer) ColHertz8000,      "activate", G_CALLBACK( on_ColHertz8000_activate),      detail  );
	g_signal_connect(( gpointer) ColHertz22000,     "activate", G_CALLBACK( on_ColHertz22000_activate),     detail  );
	g_signal_connect(( gpointer) ColHertz32000,     "activate", G_CALLBACK( on_ColHertz32000_activate),     detail  );
	g_signal_connect(( gpointer) ColHertz44056,     "activate", G_CALLBACK( on_ColHertz44056_activate),     detail  );
	g_signal_connect(( gpointer) ColHertz44100,     "activate", G_CALLBACK( on_ColHertz44100_activate),     detail  );
	g_signal_connect(( gpointer) ColHertz48000,     "activate", G_CALLBACK( on_ColHertz48000_activate),     detail  );
	g_signal_connect(( gpointer) ColHertz88200,     "activate", G_CALLBACK( on_ColHertz88200_activate),     detail  );
	g_signal_connect(( gpointer) ColHertz96000,     "activate", G_CALLBACK( on_ColHertz96000_activate),     detail  );
	g_signal_connect(( gpointer) ColHertzOriginal,  "activate", G_CALLBACK( on_ColHertzOriginal_activate),  detail  );

	GLADE_HOOKUP_OBJECT_NO_REF( Menu, Menu,  "Menu" );
	GLADE_HOOKUP_OBJECT( Menu, CellHertz,         "CellHertz" );
	GLADE_HOOKUP_OBJECT( Menu, CellSubMenu,       "CellSubMenu" );
	GLADE_HOOKUP_OBJECT( Menu, CellHertz8000,     "CellHertz8000" );
	GLADE_HOOKUP_OBJECT( Menu, CellHertz22000,    "CellHertz22000" );
	GLADE_HOOKUP_OBJECT( Menu, CellHertz32000,    "CellHertz32000" );
	GLADE_HOOKUP_OBJECT( Menu, CellHertz44056,    "CellHertz44056" );
	GLADE_HOOKUP_OBJECT( Menu, CellHertz44100,    "CellHertz44100" );
	GLADE_HOOKUP_OBJECT( Menu, CellHertz48000,    "CellHertz48000" );
	GLADE_HOOKUP_OBJECT( Menu, CellHertz88200,    "CellHertz88200" );
	GLADE_HOOKUP_OBJECT( Menu, CellHertz96000,    "CellHertz96000" );
	GLADE_HOOKUP_OBJECT( Menu, CellSeparate,      "CellSeparate" );
	GLADE_HOOKUP_OBJECT( Menu, CellHertzOriginal, "CellHertzOriginal" );
	
	GLADE_HOOKUP_OBJECT( Menu, ColHertz,          "ColHertz" );
	GLADE_HOOKUP_OBJECT( Menu, ColSubMenu,        "ColSubMenu" );
	GLADE_HOOKUP_OBJECT( Menu, ColHertz8000,      "ColHertz8000" );
	GLADE_HOOKUP_OBJECT( Menu, ColHertz22000,     "ColHertz22000" );
	GLADE_HOOKUP_OBJECT( Menu, ColHertz32000,     "ColHertz32000" );
	GLADE_HOOKUP_OBJECT( Menu, ColHertz44056,     "ColHertz44056" );
	GLADE_HOOKUP_OBJECT( Menu, ColHertz44100,     "ColHertz44100" );
	GLADE_HOOKUP_OBJECT( Menu, ColHertz48000,     "ColHertz48000" );
	GLADE_HOOKUP_OBJECT( Menu, ColHertz88200,     "ColHertz88200" );
	GLADE_HOOKUP_OBJECT( Menu, ColHertz96000,     "ColHertz96000" );
	GLADE_HOOKUP_OBJECT( Menu, ColSeparate,       "ColSeparate" );
	GLADE_HOOKUP_OBJECT( Menu, ColHertzOriginal,  "ColHertzOriginal" );

	gtk_menu_popup( GTK_MENU( Menu), NULL, NULL, NULL, NULL, 3, 0 );
}
// 
//
// POPUP FILE WAV QUANTIFICATION
// 
//
void on_CellWav8_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_CELL, detail, -2, -2, 8 );
}
void on_CellWav16_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_CELL, detail, -2, -2, 16 );
}
void on_CellWav24_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_CELL, detail, -2, -2, 24 );
}
void on_CellWav32_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_CELL, detail, -2, -2, 32 );
}
void on_CellWav64_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_CELL, detail, -2, -2, 64 );
}
void on_CellOriginal_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_CELL, detail, -2, -2, -1 );
}
	
void on_ColWav8_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_COL, detail, -2, -2, 8 );
}
void on_ColWav16_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_COL, detail, -2, -2, 16 );
}
void on_ColWav24_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_COL, detail, -2, -2, 24 );
}
void on_ColWav32_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_COL, detail, -2, -2, 32 );
}
void on_ColWav64_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_COL, detail, -2, -2, 64 );
}
void on_ColOriginal_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	DETAIL *detail = ( DETAIL *)user_data;
	FileWav_from_popup( FILEWAV_QUANTIFICATION_COL, detail, -2, -2, -1 );
}
void popup_file_wav_quantification( DETAIL *detail)
{
	GtkWidget *Menu;
	GtkWidget *CellWav;
	GtkWidget *CellSubMenu;
	GtkWidget *CellWav8;
	GtkWidget *CellWav16;
	GtkWidget *CellWav24;
	GtkWidget *CellWav32;
	GtkWidget *CellWav64;
	GtkWidget *CellSeparate;
	GtkWidget *CellOriginal;

	GtkWidget *ColWav;
	GtkWidget *ColSubMenu;
	GtkWidget *ColWav8;
	GtkWidget *ColWav16;
	GtkWidget *ColWav24;
	GtkWidget *ColWav32;
	GtkWidget *ColWav64;
	GtkWidget *ColSeparate;
	GtkWidget *ColOriginal;
	
	Menu = gtk_menu_new(  );
	gtk_widget_set_extension_events( Menu, GDK_EXTENSION_EVENTS_ALL );
	CellWav = gtk_menu_item_new_with_mnemonic( _("Cellule") );
	gtk_widget_show( CellWav );
	gtk_container_add( GTK_CONTAINER( Menu), CellWav ); 
	
	CellSubMenu = gtk_menu_new(  );
	gtk_menu_item_set_submenu( GTK_MENU_ITEM( CellWav), CellSubMenu );
		
	CellWav8 = gtk_menu_item_new_with_mnemonic( _(" 8  bits") );
	gtk_widget_show( CellWav8 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellWav8  );
	CellWav16 = gtk_menu_item_new_with_mnemonic( _("16  bits") );
	gtk_widget_show( CellWav16 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellWav16  );
	CellWav24 = gtk_menu_item_new_with_mnemonic( _("24  bits") );
	gtk_widget_show( CellWav24 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellWav24  );
	CellWav32 = gtk_menu_item_new_with_mnemonic( _("32  bits") );
	gtk_widget_show( CellWav32 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellWav32  );
	CellWav64 = gtk_menu_item_new_with_mnemonic( _("64  bits") );
	gtk_widget_show( CellWav64 );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellWav64  );
	CellSeparate = gtk_separator_menu_item_new(  );
	gtk_widget_show( CellSeparate );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellSeparate );
	CellOriginal = gtk_menu_item_new_with_mnemonic( _("Valeur d'origine") );
	gtk_widget_show( CellOriginal );
	gtk_container_add( GTK_CONTAINER( CellSubMenu), CellOriginal  );
	
	ColWav = gtk_menu_item_new_with_mnemonic( _("Colonne") );
	gtk_widget_show( ColWav );
	gtk_container_add( GTK_CONTAINER( Menu), ColWav ); 
	
	ColSubMenu = gtk_menu_new(  );
	gtk_menu_item_set_submenu( GTK_MENU_ITEM( ColWav), ColSubMenu );
		
	ColWav8 = gtk_menu_item_new_with_mnemonic( _(" 8  bits") );
	gtk_widget_show( ColWav8 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColWav8  );
	
	ColWav16 = gtk_menu_item_new_with_mnemonic( _("16  bits") );
	gtk_widget_show( ColWav16 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColWav16  );
	ColWav24 = gtk_menu_item_new_with_mnemonic( _("24  bits") );
	gtk_widget_show( ColWav24 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColWav24  );
	ColWav32 = gtk_menu_item_new_with_mnemonic( _("32  bits") );
	gtk_widget_show( ColWav32 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColWav32  );
	ColWav64 = gtk_menu_item_new_with_mnemonic( _("64  bits") );
	gtk_widget_show( ColWav64 );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColWav64  );
	ColSeparate = gtk_separator_menu_item_new(  );
	gtk_widget_show( ColSeparate );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColSeparate );
	ColOriginal = gtk_menu_item_new_with_mnemonic( _("Valeur d'origine") );
	gtk_widget_show( ColOriginal );
	gtk_container_add( GTK_CONTAINER( ColSubMenu), ColOriginal  );
	
	g_signal_connect(( gpointer) CellWav8,     "activate", G_CALLBACK( on_CellWav8_activate),     detail  );
	g_signal_connect(( gpointer) CellWav16,    "activate", G_CALLBACK( on_CellWav16_activate),    detail  );
	g_signal_connect(( gpointer) CellWav24,    "activate", G_CALLBACK( on_CellWav24_activate),    detail  );
	g_signal_connect(( gpointer) CellWav32,    "activate", G_CALLBACK( on_CellWav32_activate),    detail  );
	g_signal_connect(( gpointer) CellWav64,    "activate", G_CALLBACK( on_CellWav64_activate),    detail  );
	g_signal_connect(( gpointer) CellOriginal, "activate", G_CALLBACK( on_CellOriginal_activate), detail  );
	
	g_signal_connect(( gpointer) ColWav8,      "activate", G_CALLBACK( on_ColWav8_activate),      detail  );
	g_signal_connect(( gpointer) ColWav16,     "activate", G_CALLBACK( on_ColWav16_activate),     detail  );
	g_signal_connect(( gpointer) ColWav24,     "activate", G_CALLBACK( on_ColWav24_activate),     detail  );
	g_signal_connect(( gpointer) ColWav32,     "activate", G_CALLBACK( on_ColWav32_activate),     detail  );
	g_signal_connect(( gpointer) ColWav64,     "activate", G_CALLBACK( on_ColWav64_activate),     detail  );
	g_signal_connect(( gpointer) ColOriginal,  "activate", G_CALLBACK( on_ColOriginal_activate),  detail  );

	GLADE_HOOKUP_OBJECT_NO_REF( Menu, Menu,  "Menu" );
	GLADE_HOOKUP_OBJECT( Menu, CellWav8,     "CellSubMenu" );
	GLADE_HOOKUP_OBJECT( Menu, CellWav8,     "CellWav8" );
	GLADE_HOOKUP_OBJECT( Menu, CellWav16,    "CellWav16" );
	GLADE_HOOKUP_OBJECT( Menu, CellWav24,    "CellWav24" );
	GLADE_HOOKUP_OBJECT( Menu, CellWav32,    "CellWav32" );
	GLADE_HOOKUP_OBJECT( Menu, CellWav64,    "CellWav64" );
	GLADE_HOOKUP_OBJECT( Menu, CellWav64,    "CellSeparate" );
	GLADE_HOOKUP_OBJECT( Menu, CellOriginal, "CellOriginal" );
	
	GLADE_HOOKUP_OBJECT( Menu, ColWav8,      "ColSubMenu" );
	GLADE_HOOKUP_OBJECT( Menu, ColWav8,      "ColWav8" );
	GLADE_HOOKUP_OBJECT( Menu, ColWav16,     "ColWav16" );
	GLADE_HOOKUP_OBJECT( Menu, ColWav24,     "ColWav24" );
	GLADE_HOOKUP_OBJECT( Menu, ColWav32,     "ColWav32" );
	GLADE_HOOKUP_OBJECT( Menu, ColWav64,     "ColWav64" );
	GLADE_HOOKUP_OBJECT( Menu, ColWav64,     "ColSeparate" );
	GLADE_HOOKUP_OBJECT( Menu, ColOriginal,  "ColOriginal" );
	
	gtk_menu_popup( GTK_MENU( Menu), NULL, NULL, NULL, NULL, 3, 0 );
}
// 
//
// POPUP SPLIT
// 
//
void on_SplitNext_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	split_from_popup( 0 );
}
void on_SplitPrevious_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	split_from_popup( 1 );
}
void on_SplitRemove_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	split_from_popup( 2 );
}
void popup_file_Split( void )
{
	GtkWidget *Menu;
	GtkWidget *SplitNext;
	GtkWidget *SplitPrevious;
	GtkWidget *Separate;
	GtkWidget *SplitRemove;
	
	Menu = gtk_menu_new(  );
	gtk_widget_set_extension_events( Menu, GDK_EXTENSION_EVENTS_ALL );
	SplitNext = gtk_menu_item_new_with_mnemonic( _("Selecteur suivant") );
	gtk_widget_show( SplitNext );
	gtk_container_add( GTK_CONTAINER( Menu), SplitNext );

	SplitPrevious = gtk_menu_item_new_with_mnemonic( _("Selecteur precedant") );
	gtk_widget_show( SplitPrevious );
	gtk_container_add( GTK_CONTAINER( Menu), SplitPrevious );
	
	Separate = gtk_separator_menu_item_new(  );
	gtk_widget_show( Separate );
	gtk_container_add( GTK_CONTAINER( Menu), Separate );
		
	SplitRemove = gtk_menu_item_new_with_mnemonic( _("Supprimer la plage active") );
	gtk_widget_show( SplitRemove );
	gtk_container_add( GTK_CONTAINER( Menu), SplitRemove );	
	
	g_signal_connect(( gpointer) SplitNext,      "activate", G_CALLBACK( on_SplitNext_activate),     NULL  );
	g_signal_connect(( gpointer) SplitPrevious,  "activate", G_CALLBACK( on_SplitPrevious_activate), NULL  );
	g_signal_connect(( gpointer) SplitRemove,    "activate", G_CALLBACK( on_SplitRemove_activate),   NULL  );
	
	GLADE_HOOKUP_OBJECT_NO_REF( Menu, Menu,     "Menu" );
	GLADE_HOOKUP_OBJECT( Menu, SplitNext,       "SplitNext" );
	GLADE_HOOKUP_OBJECT( Menu, SplitPrevious,   "SplitPrevious" );
	GLADE_HOOKUP_OBJECT( Menu, SplitRemove,     "SplitRemove" );
	gtk_menu_popup( GTK_MENU( Menu), NULL, NULL, NULL, NULL, 3, 0 );
}
// 
//
// POPUP FLIP
// 
// 
void on_FlipHorizontal_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	IMAGE *Image = ( IMAGE *)user_data;
	
	Image->BoolFlipHorizontal =(  TRUE == Image->BoolFlipHorizontal ) ? FALSE : TRUE;
	gtk_widget_queue_draw( view.AdrDrawingarea  );
}
void on_FlipVertical_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	IMAGE *Image = ( IMAGE *)user_data;
	
	Image->BoolFlipVertical =(  TRUE == Image->BoolFlipVertical ) ? FALSE : TRUE;
	gtk_widget_queue_draw( view.AdrDrawingarea  );
}
void on_RemoveImage_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	// IMAGE *Image =( IMAGE *)user_data;
	poche_remove_image( );
}
void on_ImageFisrt_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	IMAGE *Image = ( IMAGE *)user_data;
	poche_set_selected_first_image( Image  );
}
void on_ImageUp_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	IMAGE *Image = ( IMAGE *)user_data;
	poche_set_selected_up_image( Image  );
}
void on_ImageDown_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	IMAGE *Image = ( IMAGE *)user_data;
	poche_set_selected_down_image( Image  );
}
void on_ImageLast_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	IMAGE *Image = ( IMAGE *)user_data;
	poche_set_selected_last_image( Image  );
}
void popup_flip( IMAGE *p_Image )
{
	GtkWidget *Menu;
	GtkWidget *FlipHorizontal;
	GtkWidget *FlipVertical;
	GtkWidget *Separate;
	GtkWidget *RemoveImage;
	GtkWidget *ImageFisrt;
	GtkWidget *ImageUp;
	GtkWidget *ImageDown;
	GtkWidget *ImageLast;

	Menu = gtk_menu_new(  );
	gtk_widget_set_extension_events( Menu, GDK_EXTENSION_EVENTS_ALL );
	FlipHorizontal = gtk_menu_item_new_with_mnemonic( _("Retourner horizontalement") );
	gtk_widget_show( FlipHorizontal );
	gtk_container_add( GTK_CONTAINER( Menu), FlipHorizontal );
	
	FlipVertical = gtk_menu_item_new_with_mnemonic( _("Retourner verticalement") );
	gtk_widget_show( FlipVertical );
	gtk_container_add( GTK_CONTAINER( Menu), FlipVertical );
	
	Separate = gtk_separator_menu_item_new(  );
	gtk_widget_show( Separate );
	gtk_container_add( GTK_CONTAINER( Menu), Separate );
		
	ImageFisrt = gtk_menu_item_new_with_mnemonic( _("Image au premier plan") );
	gtk_widget_show( ImageFisrt );
	gtk_container_add( GTK_CONTAINER( Menu), ImageFisrt );	
	
	ImageUp = gtk_menu_item_new_with_mnemonic( _("Image au dessus") );
	gtk_widget_show( ImageUp );
	gtk_container_add( GTK_CONTAINER( Menu), ImageUp );	

	ImageDown = gtk_menu_item_new_with_mnemonic( _("Image en dessous") );
	gtk_widget_show( ImageDown );
	gtk_container_add( GTK_CONTAINER( Menu), ImageDown );	
	
	ImageLast = gtk_menu_item_new_with_mnemonic( _("Image au dernier plan") );
	gtk_widget_show( ImageLast );
	gtk_container_add( GTK_CONTAINER( Menu), ImageLast );	
	
	Separate = gtk_separator_menu_item_new(  );
	gtk_widget_show( Separate );
	gtk_container_add( GTK_CONTAINER( Menu), Separate );
		
	RemoveImage = gtk_menu_item_new_with_mnemonic( _("Effacer l'image") );
	gtk_widget_show( RemoveImage );
	gtk_container_add( GTK_CONTAINER( Menu), RemoveImage );	

	g_signal_connect( (gpointer) FlipHorizontal,   "activate", G_CALLBACK( on_FlipHorizontal_activate),   p_Image );
	g_signal_connect( (gpointer) FlipVertical,     "activate", G_CALLBACK( on_FlipVertical_activate),     p_Image );
	g_signal_connect( (gpointer) ImageFisrt,       "activate", G_CALLBACK( on_ImageFisrt_activate),       p_Image );
	g_signal_connect( (gpointer) ImageUp,          "activate", G_CALLBACK( on_ImageUp_activate),          p_Image );
	g_signal_connect( (gpointer) ImageDown,        "activate", G_CALLBACK( on_ImageDown_activate),        p_Image );
	g_signal_connect( (gpointer) ImageLast,        "activate", G_CALLBACK( on_ImageLast_activate),        p_Image );
	g_signal_connect( (gpointer) RemoveImage,      "activate", G_CALLBACK( on_RemoveImage_activate),      p_Image );
	
	GLADE_HOOKUP_OBJECT_NO_REF( Menu, Menu,    "Menu" );
	GLADE_HOOKUP_OBJECT( Menu, FlipHorizontal, "FlipHorizontal" );
	GLADE_HOOKUP_OBJECT( Menu, FlipVertical,   "FlipVertical" );
	GLADE_HOOKUP_OBJECT( Menu, RemoveImage,    "RemoveImage" );
	gtk_menu_popup( GTK_MENU( Menu), NULL, NULL, NULL, NULL, 3, 0 );
}
// 
//
// POPUP REMOVE IMAGE IN VIEWPORT
// 
// 
void on_viewport_remove_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	GLIST_POCHETTE *gl = ( GLIST_POCHETTE *)user_data;

	gl->BoolStructRemove = TRUE;
	pochedir_destroy_image( gl  );
}
void popup_viewport( GLIST_POCHETTE *gl )
{
	GtkWidget *Menu;
	GtkWidget *RemoveImage;
	
	Menu = gtk_menu_new(  );
	gtk_widget_set_extension_events( Menu, GDK_EXTENSION_EVENTS_ALL );
	RemoveImage = gtk_menu_item_new_with_mnemonic( _("Supprimer l'image de la liste") );
	gtk_widget_show( RemoveImage );
	gtk_container_add( GTK_CONTAINER( Menu), RemoveImage );
	
	g_signal_connect(( gpointer) RemoveImage, "activate", G_CALLBACK( on_viewport_remove_activate), gl  );
	
	GLADE_HOOKUP_OBJECT_NO_REF( Menu, Menu, "Menu" );
	GLADE_HOOKUP_OBJECT( Menu, RemoveImage, "RemoveImage" );
	
	gtk_menu_popup( GTK_MENU( Menu), NULL, NULL, NULL, NULL, 3, 0 );
}
// 
//
// POPUP TAG CD
// 
// 
/*
typedef struct {
	gboolean	BoolFromPopup;
	gint		num;
	gchar		*name;
} CD_POPUP_GENRE;
*/
CD_POPUP_GENRE CdPopupGenre = { FALSE, -1, NULL };

void on_menu_popup_num_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	gint	Choice = GPOINTER_TO_INT(user_data);
	
	CdPopupGenre.num           = Choice;
	CdPopupGenre.BoolFromPopup = TRUE;
	
	PRINT_FUNC_LF();
	if( TRUE == OptionsCommandLine.BoolVerboseMode ) {
		g_print( "\tPtrEntry = %s\n", CdPopupGenre.name );
		g_print( "\tNumEntry = %d\n", Choice);
	}

	gtk_entry_set_text( GTK_ENTRY(GLADE_GET_OBJECT("entry_tag_genre")), CdPopupGenre.name );
	cd_expander_set_genre( CdPopupGenre.num, CdPopupGenre.name );
	
	CdPopupGenre.BoolFromPopup = FALSE;
}
void on_menu_popup_txt_activate( GtkMenuItem *menuitem, gpointer user_data )
{
	gchar	*Ptr = (gchar *)user_data;
	
	if( NULL != CdPopupGenre.name ) {
		g_free( CdPopupGenre.name );
		CdPopupGenre.name = NULL;
	}
	CdPopupGenre.name = g_strdup( Ptr );
}
void popup_menu_cd( void )
{
	GtkWidget	*Menu;
	GtkWidget	*RemoveImage;
	gint		Choice;
	
	Menu = gtk_menu_new(  );
	gtk_widget_set_extension_events( Menu, GDK_EXTENSION_EVENTS_ALL );
	
	for( Choice = 0; -1 != StructTagsFileMp3[ Choice ].num; Choice ++ ) {
		
		// StructTagsFileMp3[ i ].name
		// StructTagsFileMp3[ i ].num
		
		RemoveImage = gtk_menu_item_new_with_mnemonic( StructTagsFileMp3[ Choice ].name );
		
		gtk_widget_show( RemoveImage );
		gtk_container_add( GTK_CONTAINER( Menu), RemoveImage );
		
		g_signal_connect(( gpointer) RemoveImage, "activate", G_CALLBACK(on_menu_popup_txt_activate), (gpointer)StructTagsFileMp3[ Choice ].name );
		g_signal_connect(( gpointer) RemoveImage, "activate", G_CALLBACK(on_menu_popup_num_activate), GINT_TO_POINTER(StructTagsFileMp3[ Choice ].num));
		
		GLADE_HOOKUP_OBJECT( Menu, RemoveImage, "RemoveImage" );
	}
	GLADE_HOOKUP_OBJECT_NO_REF( Menu, Menu, "Menu" );

	gtk_menu_popup( GTK_MENU( Menu), NULL, NULL, NULL, NULL, 3, 0 );
}










