.\" Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
.\" Use subject to license terms.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.TH xkbvleds __appmansuffix__ __xorgversion__
.SH NAME
xkbvleds \- XKB extension user utility
.SH SYNOPSIS
.B xkbvleds
[\-indpy <name>]   
[\-watch <leds>]   
[[\-+]automatic]    
[[\-+]explicit]     
[[\-+]name]         
[[\-+]real]         
[[\-+]virtual]      
[\-intersection]   
[\-union]          
.SH DESCRIPTION
This program is used to display the state of LEDs on an XKB keyboard.
It reports the changes in the fundamental components of the XKB state 
which includes the effective compatibility state. The default set of LEDs 
is \-union +name +automatic +real.
.SH OPTIONS
.PP
.TP 8
.B \-indpy <name>
Mask of LEDs to watch
.TP 8
.B \-watch <leds>
turn on synchronization
.PP
.TP 8
.B \[-+]automatic
(Don't) watch automatic LEDs
.PP
.TP 8
.B \[-+]explicit
(Don't) watch explicit LEDs
.PP
.TP 8
.B \[-+]name
(Don't) watch named LEDs
.PP
.TP 8
.B \[-+]real
(Don't) watch real LEDs
.PP
.TP 8
.B \[-+]virtual 
(Don't) watch virtual LEDs
.PP
.TP 8
.B \-intersection
Watch only LEDs in all desired sets
.PP
.TP 8
.B \-union
Watch LEDs in any desired sets


