
%define qtdir		/usr/lib/qt3
%define kdedir		/usr
%define vers		1.1pre15
%define rel			1mdk

Name:			wordtrans
Group:			Applications/Text
URL:			http://wordtrans.sourceforge.net
Summary:		Multi Language Word Translator for Linux
Summary(es):	Traductor multi lenguaje para Linux
Version:		%{vers}
Release:		%{rel}
Vendor:			Ricardo Villalba <rvm@escomposlinux.org>
Copyright:		GPL
BuildRoot:		%{_tmppath}/%{name}-buildroot
Source:			%{name}-%{version}.tar.bz2
BuildRequires:	kdelibs-devel

%description
Wordtrans is a front-end for several dictionaries. It supports
some dictionaries in plain text such as i2e (English-Spanish) and
de-en (German-English), dict servers and Babylon Translator's
dictionaries (note that Babylon Translator is a windows shareware
application).

%description -l es
Wordtrans es un front-end para varios diccionarios. Puede emplear
algunos diccionarios de texto como i2e (Ingls-Espaol) y de-en
(Alemn-Ingls), servidores dict y los diccionarios de Babylon
Translator (una aplicacin shareware para Windows).

%package kde
Summary:		KDE front-end for wordtrans
Summary(es):	Front-end de KDE para wordtrans
Group:			Graphical desktop/KDE
Requires:		%{name} = %{version}-%{release}
Prefix:			%{kdedir}

%description kde
Wordtrans is a front-end for several dictionaries. It supports
some dictionaries in plain text such as i2e (English-Spanish) and
de-en (German-English), dict servers and Babylon Translator's
dictionaries (note that Babylon Translator is a windows shareware
application).

This package contains a KDE front-end for wordtrans.

%description kde -l es
Wordtrans es un front-end para varios diccionarios. Puede emplear
algunos diccionarios de texto como i2e (Ingls-Espaol) y de-en
(Alemn-Ingls), servidores dict y los diccionarios de Babylon
Translator (una aplicacin shareware para Windows).

Este paquete contiene un front-end de KDE para wordtrans.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q -n %{name}-%{version}

# put the application-data in /usr/share/apps, not in /usr/share:
mv Makefile Makefile.org-appdir
sed -e 's:/usr/share/wordtrans:/usr/share/apps/wordtrans:g' <Makefile.org-appdir >Makefile

%build

export QTDIR=%{qtdir}
export KDEDIR=%{kdedir}

make KDE3=1 QTLINK=-lqt-mt QT_INC="-I$QTDIR/include" QT_LIB="-L$QTDIR/lib" \
	KDE_INC="-I$KDEDIR/include/kde" KDE_LIB="-L$KDEDIR/lib" \
	MOC="$QTDIR/bin/moc" CFLAGS="$RPM_OPT_FLAGS -Wall" USE_FRIBIDI_LIB='' all

make KDE3=1 QTLINK=-lqt-mt QT_INC="-I$QTDIR/include" QT_LIB="-L$QTDIR/lib" \
	KDE_INC="-I$KDEDIR/include/kde" KDE_LIB="-L$KDEDIR/lib" \
	MOC="$QTDIR/bin/moc" CFLAGS="$RPM_OPT_FLAGS -Wall" USE_FRIBIDI_LIB='' all_kde


%install
rm -rf  $RPM_BUILD_ROOT
%makeinstall DESTDIR=$RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install_kde


# Move KDE Documentation to where RH & Mdk install it (and KDE by default)

install -d $RPM_BUILD_ROOT/%_datadir/doc/HTML/en
install -d $RPM_BUILD_ROOT/%_datadir/doc/HTML/es

(	cd $RPM_BUILD_ROOT/%_datadir/doc/HTML/en/
	ln -s ../../wordtrans-doc/html.en kwordtrans
	cd $RPM_BUILD_ROOT/%_datadir/doc/HTML/es/
	ln -s ../../wordtrans-doc/html.es kwordtrans
)

(cd $RPM_BUILD_ROOT
mkdir -p ./usr/lib/menu
cat > ./usr/lib/menu/%{name}-kde <<EOF
?package(%{name}-kde):\
command="%{_bindir}/kwordtrans"\
title="Kwordtrans"\
longtitle="Translate utility"\
needs="x11"\
icon="kwordtrans.xpm"\
section="Office/Accessories"
EOF
)

%post
%update_menus

%postun
%update_menus

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)

%dir %{_sysconfdir}/wordtrans/
%config(noreplace) %{_sysconfdir}/wordtrans/*

%{_bindir}/qwordtrans
%{_bindir}/wordtrans

%dir %_datadir/locale/*/LC_MESSAGES/
%_datadir/locale/*/LC_MESSAGES/wordtrans.mo

%dir %_datadir/apps/wordtrans/
%_datadir/apps/wordtrans/*

%docdir %_datadir/doc/wordtrans-doc/
%doc %_datadir/doc/wordtrans-doc/*
%docdir %_datadir/doc/wordtrans-data/
%doc %_datadir/doc/wordtrans-data/*
%docdir %_datadir/doc/wordtrans-web/
%doc %_datadir/doc/wordtrans-web/*

%doc %{_mandir}/es/man1/qwordtrans.1*
%doc %{_mandir}/es/man1/wordtrans.1*
%doc %{_mandir}/man1/qwordtrans.1*
%doc %{_mandir}/man1/wordtrans.1*

%dir /var/www/wordtrans/
/var/www/wordtrans/*

%files kde
%defattr(-,root,root)

%{_bindir}/kwordtrans

%dir %_datadir/icons/locolor/16x16/apps/
%_datadir/icons/locolor/16x16/apps/*
%dir %_datadir/icons/locolor/32x32/apps/
%_datadir/icons/locolor/32x32/apps/*
%dir %_datadir/icons/hicolor/16x16/apps/
%_datadir/icons/hicolor/16x16/apps/*
%dir %_datadir/icons/hicolor/32x32/apps/
%_datadir/icons/hicolor/32x32/apps/*

%_menudir/*

%dir %_datadir/locale/*/LC_MESSAGES/
%_datadir/locale/*/LC_MESSAGES/kwordtrans.mo

%doc %{_mandir}/es/man1/kwordtrans.1*
%doc %{_mandir}/man1/kwordtrans.1*

%doc %_datadir/doc/HTML/en/kwordtrans
%doc %_datadir/doc/HTML/es/kwordtrans

%_datadir/applnk/*

%changelog
* Sun Jan 18 2004 Johan Evenhuis <johan@evenhuis.nl>
- Updated to 1.1pre14 for Mandrake 9.2
* Fri Jan 17 2003 Johan Evenhuis <johan@evenhuis.nl>
- Updated to 1.1pre12 for Mandrake 9.0
* Mon Oct 01 2001 Juan Minaya <jminaya@iname.com> 1.0.1-1
- Release 1.0.1
- Remove unnecessary patches
- Separate KDE frontend (and make it relocatable)

* Mon Apr 30 2001 Juan Minaya <jminaya@iname.com> 1.0beta1-1
- Added description in Spanish.
- Adapt to 1.0beta1 release.
- Clean up %files.

* Thu Mar 08 2001 Juan Minaya <jminaya@iname.com> 0.9-1
- First spec file.




