/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphics2d.font.FontEncoder;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFHandleManager;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFPathConstructor;
import org.freehep.graphicsio.emf.gdi.AlphaBlend;
import org.freehep.graphicsio.emf.gdi.BeginPath;
import org.freehep.graphicsio.emf.gdi.CreateBrushIndirect;
import org.freehep.graphicsio.emf.gdi.DeleteObject;
import org.freehep.graphicsio.emf.gdi.EOF;
import org.freehep.graphicsio.emf.gdi.EndPath;
import org.freehep.graphicsio.emf.gdi.ExtCreateFontIndirectW;
import org.freehep.graphicsio.emf.gdi.ExtCreatePen;
import org.freehep.graphicsio.emf.gdi.ExtLogFontW;
import org.freehep.graphicsio.emf.gdi.ExtLogPen;
import org.freehep.graphicsio.emf.gdi.ExtTextOutW;
import org.freehep.graphicsio.emf.gdi.FillPath;
import org.freehep.graphicsio.emf.gdi.LogBrush32;
import org.freehep.graphicsio.emf.gdi.ModifyWorldTransform;
import org.freehep.graphicsio.emf.gdi.RestoreDC;
import org.freehep.graphicsio.emf.gdi.SaveDC;
import org.freehep.graphicsio.emf.gdi.SelectClipPath;
import org.freehep.graphicsio.emf.gdi.SelectObject;
import org.freehep.graphicsio.emf.gdi.SetBkMode;
import org.freehep.graphicsio.emf.gdi.SetMapMode;
import org.freehep.graphicsio.emf.gdi.SetMiterLimit;
import org.freehep.graphicsio.emf.gdi.SetPolyFillMode;
import org.freehep.graphicsio.emf.gdi.SetTextAlign;
import org.freehep.graphicsio.emf.gdi.SetTextColor;
import org.freehep.graphicsio.emf.gdi.SetViewportExtEx;
import org.freehep.graphicsio.emf.gdi.SetViewportOrgEx;
import org.freehep.graphicsio.emf.gdi.SetWindowExtEx;
import org.freehep.graphicsio.emf.gdi.SetWindowOrgEx;
import org.freehep.graphicsio.emf.gdi.SetWorldTransform;
import org.freehep.graphicsio.emf.gdi.StrokeAndFillPath;
import org.freehep.graphicsio.emf.gdi.StrokePath;
import org.freehep.graphicsio.emf.gdi.TextW;
import org.freehep.graphicsio.font.FontTable;
import org.freehep.graphicsio.font.FontUtilities;
import org.freehep.util.UserProperties;

public class EMFGraphics2D
extends AbstractVectorGraphicsIO
implements EMFConstants {
    public static final String version = "$Revision: 10140 $";
    private EMFHandleManager handleManager;
    private int penHandle;
    private int brushHandle;
    private Rectangle imageBounds;
    private OutputStream ros;
    private EMFOutputStream os;
    private Color textColor = null;
    private Color penColor = null;
    private Color brushColor = null;
    private Map fontTable;
    private Map unitFontTable;
    private EMFPathConstructor pathConstructor;
    private boolean evenOdd;
    private static final Rectangle dummy = new Rectangle(0, 0, 0, 0);
    private static final String rootKey = EMFGraphics2D.class.getName();
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    private static final UserProperties defaultProperties = new UserProperties();
    Point[] points = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    Color invisible = new Color(0, 0, 0, 0);
    private static final Properties replaceFonts;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties properties) {
        defaultProperties.setProperties(properties);
    }

    public EMFGraphics2D(File file, Dimension dimension) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), dimension);
    }

    public EMFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public EMFGraphics2D(OutputStream outputStream, Dimension dimension) {
        super(dimension, false);
        this.imageBounds = new Rectangle(0, 0, dimension.width, dimension.height);
        this.init(outputStream);
    }

    public EMFGraphics2D(OutputStream outputStream, Component component) {
        super(component, false);
        this.imageBounds = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        this.init(outputStream);
    }

    private void init(OutputStream outputStream) {
        this.fontTable = new HashMap();
        this.unitFontTable = new HashMap();
        this.evenOdd = false;
        this.handleManager = new EMFHandleManager();
        this.ros = outputStream;
        this.initProperties(defaultProperties);
    }

    protected EMFGraphics2D(EMFGraphics2D eMFGraphics2D, boolean bl2) {
        super(eMFGraphics2D, bl2);
        this.os = eMFGraphics2D.os;
        this.imageBounds = eMFGraphics2D.imageBounds;
        this.handleManager = eMFGraphics2D.handleManager;
        this.fontTable = eMFGraphics2D.fontTable;
        this.unitFontTable = eMFGraphics2D.unitFontTable;
        this.pathConstructor = eMFGraphics2D.pathConstructor;
        this.evenOdd = eMFGraphics2D.evenOdd;
        this.textColor = eMFGraphics2D.textColor;
        this.penColor = eMFGraphics2D.penColor;
        this.brushColor = eMFGraphics2D.brushColor;
    }

    public void writeHeader() throws IOException {
        this.ros = new BufferedOutputStream(this.ros);
        Dimension dimension = this.isDeviceIndependent() ? new Dimension(1024, 768) : Toolkit.getDefaultToolkit().getScreenSize();
        String string = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            string = string + " " + version.substring(1, version.length() - 1);
        }
        this.os = new EMFOutputStream(this.ros, this.imageBounds, this.handleManager, this.getCreator(), string, dimension);
        this.pathConstructor = new EMFPathConstructor(this.os, this.imageBounds);
        Point point = new Point(this.imageBounds.x, this.imageBounds.y);
        Dimension dimension2 = new Dimension(this.imageBounds.width, this.imageBounds.height);
        this.os.writeTag(new SetMapMode(8));
        this.os.writeTag(new SetWindowOrgEx(point));
        this.os.writeTag(new SetWindowExtEx(dimension2));
        this.os.writeTag(new SetViewportOrgEx(point));
        this.os.writeTag(new SetViewportExtEx(dimension2));
        this.os.writeTag(new SetTextAlign(24));
        this.os.writeTag(new SetTextColor(this.getColor()));
        this.os.writeTag(new SetPolyFillMode(2));
    }

    public void writeGraphicsState() throws IOException {
        super.writeGraphicsState();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(0.05, 0.05);
        this.os.writeTag(new SetWorldTransform(affineTransform));
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
            this.os.writeTag(new SetBkMode(1));
        } else if (this.isProperty(BACKGROUND)) {
            this.os.writeTag(new SetBkMode(2));
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        } else {
            this.os.writeTag(new SetBkMode(2));
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        int n2;
        while ((n2 = this.handleManager.highestHandleInUse()) >= 0) {
            this.os.writeTag(new DeleteObject(n2));
            this.handleManager.freeHandle(n2);
        }
        this.os.writeTag(new EOF());
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        return new EMFGraphics2D(this, true);
    }

    public Graphics create(double d2, double d3, double d4, double d5) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        EMFGraphics2D eMFGraphics2D = new EMFGraphics2D(this, true);
        ((VectorGraphics)eMFGraphics2D).translate(d2, d3);
        ((VectorGraphics)eMFGraphics2D).clipRect(0.0, 0.0, d4, d5);
        return eMFGraphics2D;
    }

    protected void writeGraphicsSave() throws IOException {
        this.os.writeTag(new SaveDC());
    }

    protected void writeGraphicsRestore() throws IOException {
        if (this.penHandle != 0) {
            this.os.writeTag(new DeleteObject(this.handleManager.freeHandle(this.penHandle)));
        }
        if (this.brushHandle != 0) {
            this.os.writeTag(new DeleteObject(this.handleManager.freeHandle(this.brushHandle)));
        }
        this.os.writeTag(new RestoreDC());
    }

    public void draw(Shape shape) {
        try {
            if (this.getStroke() instanceof BasicStroke) {
                this.writePen((BasicStroke)this.getStroke(), this.getColor());
                this.writePath(shape);
                this.os.writeTag(new StrokePath(this.imageBounds));
            } else {
                this.writeBrush(this.getColor());
                this.writePath(this.getStroke().createStrokedShape(shape));
                this.os.writeTag(new FillPath(this.imageBounds));
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void fill(Shape shape) {
        try {
            this.writeBrush(this.getColor());
            this.writePath(shape);
            this.os.writeTag(new FillPath(this.imageBounds));
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void fillAndDraw(Shape shape, Color color) {
        try {
            this.writePen((BasicStroke)this.getStroke(), this.getColor());
            this.writeBrush(color);
            this.writePath(shape);
            this.os.writeTag(new StrokeAndFillPath(this.imageBounds));
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage renderedImage, AffineTransform affineTransform, Color color) throws IOException {
        this.os.writeTag(new SaveDC());
        AffineTransform affineTransform2 = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)renderedImage.getHeight());
        affineTransform2.preConcatenate(affineTransform);
        this.writeTransform(affineTransform2);
        this.os.writeTag(new AlphaBlend(this.imageBounds, this.toUnit(0.0), this.toUnit(0.0), this.toUnit(renderedImage.getWidth()), this.toUnit(renderedImage.getHeight()), new AffineTransform(), renderedImage, color));
        this.os.writeTag(new RestoreDC());
    }

    public void writeString(String string, double d2, double d3) throws IOException {
        EMFConstants eMFConstants;
        Object object;
        Object object2;
        Color color;
        Paint paint = this.getPaint();
        if (paint instanceof Color) {
            color = (Color)paint;
        } else if (paint instanceof GradientPaint) {
            object2 = (GradientPaint)paint;
            color = PrintColor.mixColor(((GradientPaint)object2).getColor1(), ((GradientPaint)object2).getColor2());
        } else {
            object2 = this.getBackground();
            color = object2 == null ? Color.BLACK : PrintColor.invert((Color)object2);
        }
        if (!color.equals(this.textColor)) {
            this.textColor = color;
            this.os.writeTag(new SetTextColor(this.textColor));
        }
        object2 = this.getFont().getAttributes();
        FontTable.normalize((Map)object2);
        Font font = new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object2);
        Font font2 = (Font)this.unitFontTable.get(font);
        Integer n2 = (Integer)this.fontTable.get(font);
        if (n2 == null) {
            object = font.getName();
            string = FontEncoder.getEncodedString(string, (String)object);
            object = replaceFonts.getProperty((String)object, (String)object);
            String string2 = FontUtilities.getWindowsFontName((String)object);
            font2 = new Font(string2, font.getStyle(), font.getSize());
            font2 = font2.deriveFont(font.getSize2D() * 1.0f * 20.0f);
            this.unitFontTable.put(font, font2);
            eMFConstants = new ExtLogFontW(font2);
            int n3 = this.handleManager.getHandle();
            this.os.writeTag(new ExtCreateFontIndirectW(n3, (ExtLogFontW)eMFConstants));
            n2 = new Integer(n3);
            this.fontTable.put(font, n2);
        }
        this.os.writeTag(new SelectObject(n2));
        object = new int[string.length()];
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            double d4 = font2.getStringBounds(string, i2, i2 + 1, this.getFontRenderContext()).getWidth();
            object[i2] = (int)d4;
        }
        this.translate(d2, d3);
        AffineTransform affineTransform = font.getTransform();
        if (!affineTransform.isIdentity()) {
            this.writeGraphicsSave();
            this.writeTransform(affineTransform);
        }
        eMFConstants = new TextW(new Point(0, 0), string, 0, dummy, (int[])object);
        this.os.writeTag(new ExtTextOutW(this.imageBounds, 2, 1.0f, 1.0f, (TextW)eMFConstants));
        if (!affineTransform.isIdentity()) {
            this.writeGraphicsRestore();
        }
        this.translate(-d2, -d3);
    }

    protected void writeTransform(AffineTransform affineTransform) throws IOException {
        AffineTransform affineTransform2 = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX() * 1.0 * 20.0, affineTransform.getTranslateY() * 1.0 * 20.0);
        this.os.writeTag(new ModifyWorldTransform(affineTransform2, 2));
    }

    protected void writeSetTransform(AffineTransform affineTransform) throws IOException {
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(0.05, 0.05);
        this.os.writeTag(new SetWorldTransform(affineTransform2));
        this.writeTransform(affineTransform);
    }

    protected void writeSetClip(Shape shape) throws IOException {
        if (shape == null || !this.isProperty(CLIP)) {
            return;
        }
        this.writePath(shape);
        this.os.writeTag(new SelectClipPath(5));
    }

    protected void writeClip(Shape shape) throws IOException {
        if (shape == null || !this.isProperty(CLIP)) {
            return;
        }
        this.writePath(shape);
        this.os.writeTag(new SelectClipPath(1));
    }

    public void writeStroke(Stroke stroke) throws IOException {
        if (stroke instanceof BasicStroke) {
            this.writePen((BasicStroke)stroke, this.getColor());
        }
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color color) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color color) throws IOException {
    }

    protected void writePaint(GradientPaint gradientPaint) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(GradientPaint) not implemented.");
        this.setColor(PrintColor.mixColor(gradientPaint.getColor1(), gradientPaint.getColor2()));
    }

    protected void writePaint(TexturePaint texturePaint) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(TexturePaint) not implemented.");
        this.setColor(Color.RED);
    }

    protected void writePaint(Paint paint) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(Paint) not implemented for " + paint.getClass());
        this.setColor(Color.WHITE);
    }

    protected void writeFont(Font font) throws IOException {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl2) {
        this.writeWarning(this.getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String string) throws IOException {
        this.writeWarning(this.getClass() + ": writeComment(String) not implemented.");
    }

    public String toString() {
        return "EMFGraphics2D";
    }

    protected Shape createShape(double[] dArray, double[] dArray2, int n2, boolean bl2) {
        GeneralPath generalPath = new GeneralPath(0);
        if (n2 > 0) {
            generalPath.moveTo((float)dArray[0], (float)dArray2[0]);
            double d2 = dArray[0];
            double d3 = dArray2[0];
            if (bl2 && Math.abs(dArray[n2 - 1] - d2) < 1.0 && Math.abs(dArray2[n2 - 1] - d3) < 1.0) {
                --n2;
            }
            for (int i2 = 1; i2 < n2; ++i2) {
                if (!(Math.abs(dArray[i2] - d2) > 1.0) && !(Math.abs(dArray2[i2] - d3) > 1.0)) continue;
                generalPath.lineTo((float)dArray[i2], (float)dArray2[i2]);
                d2 = dArray[i2];
                d3 = dArray2[i2];
            }
            if (bl2) {
                generalPath.closePath();
            }
        }
        return generalPath;
    }

    private boolean writePath(Shape shape) throws IOException {
        boolean bl2 = EMFPathConstructor.isEvenOdd(shape);
        if (bl2 != this.evenOdd) {
            this.evenOdd = bl2;
            this.os.writeTag(new SetPolyFillMode(this.evenOdd ? 1 : 2));
        }
        this.os.writeTag(new BeginPath());
        this.pathConstructor.addPath(shape);
        this.os.writeTag(new EndPath());
        return this.evenOdd;
    }

    private void writePen(BasicStroke basicStroke, Color color) throws IOException {
        int n2;
        if (color.equals(this.penColor) && basicStroke.equals(this.getStroke())) {
            return;
        }
        this.penColor = color;
        int n3 = 65536;
        switch (basicStroke.getEndCap()) {
            case 0: {
                n3 |= 0x200;
                break;
            }
            case 1: {
                n3 |= 0;
                break;
            }
            case 2: {
                n3 |= 0x100;
            }
        }
        switch (basicStroke.getLineJoin()) {
            case 0: {
                n3 |= 0x2000;
                break;
            }
            case 1: {
                n3 |= 0;
                break;
            }
            case 2: {
                n3 |= 0x1000;
            }
        }
        float[] fArray = basicStroke.getDashArray();
        int[] nArray = new int[fArray != null ? fArray.length : 0];
        n3 |= nArray.length == 0 ? 0 : 7;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = this.toUnit(fArray[n2]);
        }
        n2 = color.getAlpha() == 0 ? 1 : 0;
        ExtLogPen extLogPen = new ExtLogPen(n3, this.toUnit(basicStroke.getLineWidth()), n2, this.getPrintColor(color), 0, nArray);
        if (this.penHandle != 0) {
            this.os.writeTag(new DeleteObject(this.penHandle));
        } else {
            this.penHandle = this.handleManager.getHandle();
        }
        this.os.writeTag(new ExtCreatePen(this.penHandle, extLogPen));
        this.os.writeTag(new SelectObject(this.penHandle));
        if (!(this.getStroke() instanceof BasicStroke) || ((BasicStroke)this.getStroke()).getMiterLimit() != basicStroke.getMiterLimit()) {
            this.os.writeTag(new SetMiterLimit(this.toUnit(basicStroke.getMiterLimit())));
        }
    }

    private void writeBrush(Color color) throws IOException {
        if (color.equals(this.brushColor)) {
            return;
        }
        this.brushColor = color;
        int n2 = color.getAlpha() == 0 ? 1 : 0;
        LogBrush32 logBrush32 = new LogBrush32(n2, this.getPrintColor(color), 0);
        if (this.brushHandle != 0) {
            this.os.writeTag(new DeleteObject(this.brushHandle));
        } else {
            this.brushHandle = this.handleManager.getHandle();
        }
        this.os.writeTag(new CreateBrushIndirect(this.brushHandle, logBrush32));
        this.os.writeTag(new SelectObject(this.brushHandle));
    }

    private int toUnit(double d2) {
        return (int)Math.floor(d2 * 1.0 * 20.0);
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(CLIP, true);
        defaultProperties.setProperty(TEXT_AS_SHAPES, false);
        replaceFonts = new Properties();
        replaceFonts.setProperty("Symbol", "Arial Unicode MS");
        replaceFonts.setProperty("ZapfDingbats", "Arial Unicode MS");
    }
}

