// WideMargin. Simple fast bible software.
// Copyright (C) 2011  Daniel Hughes
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Data;
using System.Data.Linq;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using Mono.Data.Sqlite;
using System.Text;

namespace WideMargin.Database
{
	public static class OSISImporter
	{
		public static void CreateDatabase(string bibleDatabaseFile)
		{
			if(File.Exists(bibleDatabaseFile))
			{
				File.Delete(bibleDatabaseFile);	
			}
			
			SqliteConnection.CreateFile(bibleDatabaseFile);
			
			using(var conn = new SqliteConnection (string.Format("DbLinqProvider=Sqlite;Data Source={0}",bibleDatabaseFile)))
			{
				conn.Open();
				using(IDbCommand command = conn.CreateCommand())
				{
					string sqlFileName = GetSqlFile();
					command.CommandText = File.ReadAllText(sqlFileName);
					command.ExecuteNonQuery();
				}
			}
		}
		
		private static string GetSqlFile()
		{
		
			return WideMarginPaths.GetApplicationDataFile("BibleDatabase.sql");
		}
				                                  
		public static BibleDatabase Import (string versePerLinefile, string bibleDatabaseFile, string readingPlannerFile)
		{
			versePerLinefile = WideMarginPaths.GetApplicationDataFile(versePerLinefile);
			readingPlannerFile = WideMarginPaths.GetApplicationDataFile(readingPlannerFile);
			
			var lookup = NameAbbreviationLookup.Get();
			
			CreateDatabase(bibleDatabaseFile);
			
			//var conn = new SqliteConnection (string.Format("DbLinqProvider=Sqlite;Data Source={0}",bibleDatabaseFile));
			
			BibleDatabase bible = new BibleDatabase(bibleDatabaseFile);
			
			//clean out anyting allready in the verse table

			var verses = 
				from line in File.ReadAllLines(versePerLinefile).Skip(1)
				let spaceIndex = line.IndexOf(' ')
				let content = line.Substring(spaceIndex, line.Length - spaceIndex)
				let colonIndex = line.IndexOf(":")
				let verse = line.Substring(colonIndex + 1, spaceIndex - colonIndex - 1)
				let bookLength = line.Length - line.SkipWhile( val => char.IsNumber(val)).SkipWhile( val => !char.IsNumber(val)).Count()
				let book = lookup.Lookup(line.Substring(0, bookLength))
				let chapter = line.Substring(bookLength, colonIndex - bookLength)
				select new Verse(book, int.Parse(chapter), int.Parse(verse), content);
			bible.AddVerses(verses);
			
			bible.AddReadingPlannerData(readingPlannerFile);
			
			return bible;
		}			
	}
}

