/*
 * TexteditSettingsDialog.cpp
 *
 * Copyright (C) 1999 Stephen F. White/2002 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include "stdafx.h"
#include "TexteditSettingsDialog.h"
#include "DuneApp.h"
#include "resource.h"
#include <swt.h>

TexteditSettingsDialog::TexteditSettingsDialog(SWND parent)
  : Dialog(parent, IDD_TEXTEDIT_SETTINGS)
{
    LoadData();
}

void
TexteditSettingsDialog::OnCommand(int id)
{
    switch(id) {
      case IDC_BROWSE_TEXTEDIT:
	OnBrowseTexteditCommand();
	break;
      default:
	Dialog::OnCommand(id);
	break;
    }
}

static MyString
GetText(SWND item)
{
    char	buf[1024];
    swGetText(item, buf, 1024);
    return buf;
}

void TexteditSettingsDialog::LoadData()
{
    const char *texteditCommand;
    const char *texteditLinenumberOption;
    int texteditUseExtensionTxt;
    int texteditAllowPopup;

    swTexteditGetSettings(TheApp->GetTextedit(), 
                          &texteditCommand, &texteditLinenumberOption,
                          &texteditUseExtensionTxt,&texteditAllowPopup);

    swSetText(swGetDialogItem(_dlg, IDC_TEXTEDIT_COMMAND), texteditCommand);
    swSetText(swGetDialogItem(_dlg, IDC_TEXTEDIT_LINENUMBER_OPTION), 
              texteditLinenumberOption);
    swSetCheck(swGetDialogItem(_dlg, IDC_TEXTEDIT_USE_EXTENSION_TXT), 
               texteditUseExtensionTxt);
    swSetCheck(swGetDialogItem(_dlg, IDC_TEXTEDIT_ALLOW_POPUP), 
               texteditAllowPopup);
}

void
TexteditSettingsDialog::SaveData()
{
    MyString texteditCommand;
    MyString texteditLinenumberOption;
    int texteditUseExtensionTxt;
    int texteditAllowPopup;

    texteditCommand = GetText(swGetDialogItem(_dlg, IDC_TEXTEDIT_COMMAND));
    texteditLinenumberOption = GetText(swGetDialogItem(_dlg, 
                                            IDC_TEXTEDIT_LINENUMBER_OPTION));
    texteditUseExtensionTxt = swGetCheck(swGetDialogItem(_dlg, 
                                          IDC_TEXTEDIT_USE_EXTENSION_TXT));
    texteditAllowPopup = swGetCheck(swGetDialogItem(_dlg, 
                                          IDC_TEXTEDIT_ALLOW_POPUP));

    swTexteditSetSettings(TheApp->GetTextedit(), 
                          texteditCommand, texteditLinenumberOption,
                          texteditUseExtensionTxt, texteditAllowPopup);
}

void TexteditSettingsDialog::OnBrowseTexteditCommand() 
{
    char	buf[1024] = "";

    if (swOpenFileDialog(_dlg, "Select",
#ifdef WIN32
		     "executable (*.exe, *.com, *.bat)\0*.exe;*.com;*.bat\0\0",
#else
		     "executable (*)\0*\0\0",
#endif
		     buf, 1024)) {
	swSetText(swGetDialogItem(_dlg, IDC_TEXTEDIT_COMMAND), buf);
    }
}
