/*
 * FieldValue.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "FieldValue.h"
#include "SFMFTypes.h"
#include "Scene.h"
#include "Element.h"
#include "DuneApp.h"

FieldValue::FieldValue() {
    _refs = 0;
}

//FieldValue::FieldValue(const FieldValue &)
//{
//    _refs = 0;
//}


int FieldValue::write(int f, int indent) const
{
    RET_ONERROR( indentf(f, indent) )
    RET_ONERROR( mywritestr(f, "# UNKNOWN VALUE\n") )
    TheApp->incSelectionLinenumber();
    return(0);
}

FieldValue *
FieldValue::addNode(Node * /* node */) const
{
    assert(0);
    return NULL;
}

FieldValue *
FieldValue::removeNode(Node * /* node */) const
{
    assert(0);
    return NULL;
}

int indentf(int f, int indent)
{
    int		tabs = indent / 8;
    int		spaces = indent % 8;
    char       *buf = new char[tabs + spaces + 1];
    char       *b = buf;
    int ret;

    for(int i = 0; i < tabs; i++)
	*b++ = '\t';

    for(int j = 0; j < spaces; j++)
	*b++ = ' ';

    *b = '\0';
    ret= mywritestr(f , buf);
    delete[] buf;
    return(ret);
}

const char *
FieldValue::getEcmaScriptIndent(int flags)
{
    if (flags == EL_EVENT_IN) {
        static const char* readIndent  = "      ";
        return readIndent;
    } else {
        static const char* writeIndent = "   ";
        return writeIndent;
    }
}

