/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "metadatadialogbase.h"

#include <QLayout>
#include <QLabel>
#include <QDialogButtonBox>
#include <QPushButton>

#include "iconloader.h"

MetadataDialogBase::MetadataDialogBase( QWidget* parent ) :
    QDialog( parent ),
    m_type( DefinitionInfo::Invalid )
{
    m_mainLayout = new QVBoxLayout( this );

    QFrame* separator = new QFrame( this );
    separator->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    m_mainLayout->addWidget( separator );

    QHBoxLayout* statusLayout = new QHBoxLayout();
    m_mainLayout->addLayout( statusLayout );

    m_statusPixmap = new QLabel( this );
    statusLayout->addWidget( m_statusPixmap, 0 );

    m_statusLabel = new QLabel( this );
    statusLayout->addWidget( m_statusLabel, 1 );

    m_statusLabel->setMinimumWidth( 300 );

    QDialogButtonBox* buttonBox = new QDialogButtonBox( QDialogButtonBox::Ok | QDialogButtonBox::Cancel,
        Qt::Horizontal, this );
    m_mainLayout->addWidget( buttonBox );

    buttonBox->button( QDialogButtonBox::Ok )->setText( tr( "&OK" ) );
    buttonBox->button( QDialogButtonBox::Cancel )->setText( tr( "&Cancel" ) );

    connect( buttonBox, SIGNAL( accepted() ), this, SLOT( accept() ) );
    connect( buttonBox, SIGNAL( rejected() ), this, SLOT( reject() ) );

    showInfo( tr( "Enter attribute details" ) );
}

MetadataDialogBase::~MetadataDialogBase()
{
}

void MetadataDialogBase::setDefinitionInfo( const DefinitionInfo& info )
{
    m_type = info.type();

    updateWidgets( info );
}

void MetadataDialogBase::setContentLayout( QLayout* layout, bool fixed )
{
    m_mainLayout->insertLayout( 0, layout );

    if ( fixed )
        setMaximumHeight( sizeHint().height() );
}

void MetadataDialogBase::showInfo( const QString& text )
{
    m_statusPixmap->setPixmap( IconLoader::pixmap( "status-info" ) );
    m_statusLabel->setText( text );
}

void MetadataDialogBase::showWarning( const QString& text )
{
    m_statusPixmap->setPixmap( IconLoader::pixmap( "status-warning" ) );
    m_statusLabel->setText( text );
}

void MetadataDialogBase::accept()
{
    m_info = DefinitionInfo();
    m_info.setType( m_type );

    if ( updateMetadata( m_info ) )
        QDialog::accept();
}
