package org.apache.maven.wagon.repository;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import junit.framework.TestCase;

/**
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @version $Id: RepositoryPermissionsTest.java 162476 2005-04-19 02:49:45Z brett $
 * @todo test defaults
 */
public class RepositoryPermissionsTest
    extends TestCase
{
    public RepositoryPermissionsTest( final String name )
    {
        super( name );
    }

    public void setUp()
        throws Exception
    {
        super.setUp();
    }

    public void tearDown()
        throws Exception
    {
        super.tearDown();
    }

    public void testAuthenticationInfoProperties()
    {
        final RepositoryPermissions repositoryPermissions = new RepositoryPermissions();

        repositoryPermissions.setDirectoryMode( "directoryMode" );

        assertEquals( "directoryMode", repositoryPermissions.getDirectoryMode() );

        repositoryPermissions.setFileMode( "fileMode" );

        assertEquals( "fileMode", repositoryPermissions.getFileMode() );

        repositoryPermissions.setGroup( "group" );

        assertEquals( "group", repositoryPermissions.getGroup() );

    }
}
