package org.apache.maven.wagon;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @version $Id: CommandExecutor.java 477260 2006-11-20 17:11:39Z brett $
 */
public interface CommandExecutor
    extends Wagon
{
    String ROLE = CommandExecutor.class.getName();

    void executeCommand( String command )
        throws CommandExecutionException;

    Streams executeCommand( String command, boolean ignoreFailures )
        throws CommandExecutionException;
}
