// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1994,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        srcanch.h
//
// Purpose:     interface to source anchor (of a geometric 3D object)
//
// Created:      1 Jun 94   Michael Pichler
//
// Changed:     31 Jul 95   Michael Pichler
//
// $Id: srcanch.h,v 1.3 1997/02/25 17:03:58 mpichler Exp $
//
//</file>


#ifndef harmony_scene_srcanch_h
#define harmony_scene_srcanch_h


#include <hyperg/utils/str.h>


class SourceAnchor
{
  public:
    SourceAnchor (                      // constructor
      long id,                          //   anchor id
      const RString& aobject,           //   anchor object
      const char* groupname             //   group name (if NULL, object anchor)
    );
    ~SourceAnchor ();

    const char* groupName () const      // get group name
    { return groupname_; }

    long id () const                    // get anchor id
    { return anchorid_; }

    const RString& object () const      // get anchor object
    { return anchorobj_; }

  private:
    char* groupname_;
    long anchorid_;
    RString anchorobj_;
};  // SourceAnchor



#endif
