/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.inline.ForeignObjectArea;

public class InstreamForeignObject
extends FObj {
    FontState fs;
    int breakBefore;
    int breakAfter;
    int scaling;
    int width;
    int height;
    int contwidth;
    int contheight;
    boolean wauto;
    boolean hauto;
    boolean cwauto;
    boolean chauto;
    int spaceBefore;
    int spaceAfter;
    int startIndent;
    int endIndent;
    ForeignObjectArea areaCurrent;

    public InstreamForeignObject(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:instream-foreign-object";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            object2 = this.properties.get("id").getString();
            object = this.properties.get("font-family").getString();
            String string = this.properties.get("font-style").getString();
            String string2 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            int n2 = this.properties.get("font-variant").getEnum();
            this.fs = new FontState(area.getFontInfo(), (String)object, string, string2, n, n2);
            int n3 = this.properties.get("text-align").getEnum();
            int n4 = this.properties.get("vertical-align").getEnum();
            int n5 = this.properties.get("overflow").getEnum();
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.contwidth = this.properties.get("content-width").getLength().mvalue();
            this.contheight = this.properties.get("content-height").getLength().mvalue();
            this.wauto = this.properties.get("width").getLength().isAuto();
            this.hauto = this.properties.get("height").getLength().isAuto();
            this.cwauto = this.properties.get("content-width").getLength().isAuto();
            this.chauto = this.properties.get("content-height").getLength().isAuto();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.scaling = this.properties.get("scaling").getEnum();
            area.getIDReferences().createID((String)object2);
            if (this.areaCurrent == null) {
                this.areaCurrent = new ForeignObjectArea(this.fs, area.getAllocationWidth());
                this.areaCurrent.start();
                this.areaCurrent.setWidth(this.width);
                this.areaCurrent.setHeight(this.height);
                this.areaCurrent.setContentWidth(this.contwidth);
                this.areaCurrent.setContentHeight(this.contheight);
                this.areaCurrent.setScaling(this.scaling);
                this.areaCurrent.setAlign(n3);
                this.areaCurrent.setVerticalAlign(n4);
                this.areaCurrent.setOverflow(n5);
                this.areaCurrent.setSizeAuto(this.wauto, this.hauto);
                this.areaCurrent.setContentSizeAuto(this.cwauto, this.chauto);
                this.areaCurrent.setPage(area.getPage());
                int n6 = this.children.size();
                if (n6 > 1) {
                    throw new FOPException("Only one child element is allowed in an instream-foreign-object");
                }
                if (this.children.size() > 0) {
                    FONode fONode = (FONode)this.children.elementAt(0);
                    Status status = fONode.layout(this.areaCurrent);
                    if (status.isIncomplete()) {
                        return status;
                    }
                    this.areaCurrent.end();
                }
            }
            this.marker = 0;
            if (this.breakBefore == 3 || this.spaceBefore + this.areaCurrent.getEffectiveHeight() > area.spaceLeft()) {
                return new Status(4);
            }
            if (this.breakBefore == 5) {
                return new Status(6);
            }
            if (this.breakBefore == 4) {
                return new Status(5);
            }
        }
        if (area instanceof BlockArea) {
            object2 = (BlockArea)area;
            object = ((BlockArea)object2).getCurrentLineArea();
            ((LineArea)object).addPending();
            if (this.areaCurrent.getEffectiveWidth() > ((LineArea)object).getRemainingWidth() && (object = ((BlockArea)object2).createNextLineArea()) == null) {
                return new Status(2);
            }
            ((LineArea)object).addInlineArea(this.areaCurrent);
        } else {
            area.addChild(this.areaCurrent);
            area.increaseHeight(this.areaCurrent.getEffectiveHeight());
        }
        if (this.isInLabel) {
            this.startIndent += this.bodyIndent;
        }
        if (this.isInListBody) {
            this.startIndent += this.bodyIndent + this.distanceBetweenStarts;
        }
        if (this.isInTableCell) {
            this.startIndent += this.forcedStartOffset;
        }
        this.areaCurrent.setStartIndent(this.startIndent);
        this.areaCurrent.setPage(area.getPage());
        if (this.breakAfter == 3) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 5) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 4) {
            this.marker = -1001;
            return new Status(5);
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new InstreamForeignObject(fObj, propertyList);
        }
    }
}

