/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.fop.pdf.PDFGoTo;

public class IDNode {
    private String idValue;
    private String internalLinkGoToPageReference;
    private PDFGoTo internalLinkGoTo;
    private int pageNumber = -1;
    private int xPosition = 0;
    private int yPosition = 0;

    protected IDNode(String string) {
        this.idValue = string;
    }

    protected void createInternalLinkGoTo(int n) {
        this.internalLinkGoTo = this.internalLinkGoToPageReference == null ? new PDFGoTo(n, null) : new PDFGoTo(n, this.internalLinkGoToPageReference);
        if (this.xPosition != 0) {
            this.internalLinkGoTo.setXPosition(this.xPosition);
            this.internalLinkGoTo.setYPosition(this.yPosition);
        }
    }

    protected String getIDValue() {
        return this.idValue;
    }

    protected PDFGoTo getInternalLinkGoTo() {
        return this.internalLinkGoTo;
    }

    protected String getInternalLinkGoToReference() {
        return this.internalLinkGoTo.referencePDF();
    }

    public String getPageNumber() {
        return this.pageNumber != -1 ? new Integer(this.pageNumber).toString() : null;
    }

    protected boolean isThereInternalLinkGoTo() {
        return this.internalLinkGoTo != null;
    }

    protected void setInternalLinkGoToPageReference(String string) {
        if (this.internalLinkGoTo != null) {
            this.internalLinkGoTo.setPageReference(string);
        } else {
            this.internalLinkGoToPageReference = string;
        }
    }

    protected void setPageNumber(int n) {
        this.pageNumber = n;
    }

    protected void setPosition(int n, int n2) {
        if (this.internalLinkGoTo != null) {
            this.internalLinkGoTo.setXPosition(n);
            this.internalLinkGoTo.setYPosition(n2);
        } else {
            this.xPosition = n;
            this.yPosition = n2;
        }
    }
}

