/*
 * Fritz!Box plugin for VDR
 *
 * Copyright (C) 2007 Joachim Wilke <vdr@joachim-wilke.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 */

#include "log.h"
#include <vdr/tools.h>

cLog::cLog(Type t)
{
	type = t;
}

cLog::~cLog()
{
}

void cLog::Flush() {
	const char *msg = buffer.c_str();
	switch (type) {
	case CLOG_INFO:
		isyslog(msg);
		break;
	case CLOG_ERROR:
		esyslog(msg);
		break;
	case CLOG_DEBUG:
		dsyslog(msg);
		break;
	}
	buffer.clear();
}

cLog &cLog::operator<<(std::string &s) {
	buffer += s;	
	return *this;
}

cLog &cLog::operator<<(char *s) {
	buffer += s;
	return *this;
}

cLog &cLog::operator<<(char s) {
	if (s == endl) {
		Flush();
	} else {
		buffer += s;
	}
	return *this;
}

void cLog::Init() {
	cLog::infoLog = new cLog(cLog::CLOG_INFO);
	cLog::errorLog = new cLog(cLog::CLOG_ERROR);
	cLog::debugLog = new cLog(cLog::CLOG_DEBUG);
}
