/***************************************************************************
                          dcchat.h  -  description
                             -------------------
    begin                : Don Mr 28 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCHAT_H
#define DCCHAT_H

/**
  *@author Mathias Kster
  */

#include <qwidget.h>
#include <qptrlist.h>
#include <qimage.h>
#include <qtextedit.h>

#include <dcconfig.h>

#include <DCDialogChat.h>

class DCClient;
class DCQTextEdit;
class QStatusBar;
class QLabel;
class QPopupMenu;

class DCChat : public DCDialogChat {
Q_OBJECT

public: 
	/** construtor */
	DCChat( QWidget * parent, const char *name, int wflags, DCClient * client, bool bprivate = TRUE );
	/** destructor */
	virtual ~DCChat();

	/** */
	void InitDocument();
	/** */
	DCClient * GetClient() { return m_pClient; };
	/** */
	void SetNick( CString nick, CString hubname );
	/** */
	CString GetNick() { return m_sNick; };
	/** */
	void AddMessage( CString nick, CString message, bool bremote = TRUE, bool forward = FALSE );
	/** */
	void AddMessage( CMessagePrivateChat * msg, bool bremote = TRUE, bool forward = FALSE );
	/** show statusmessage, if show true the settings are ignored */
	void AddStatus( CString message, bool show = FALSE );
	/** */
	void SetCrypt( eSecureState e );

	/** */
	bool close( bool alsoDelete = FALSE );
	/** */
	void InitView();
	/** Made public for auto responder */
	void SendMessage( CString message = "" );

protected:
	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );

private:
	/** */
	bool CheckForCommand();
	/** */
	bool CheckForData( CString message );
	/** */
	void NickCompletion();

	/** */
	CString GetTimeStamp();
	/** */
	void AddOutput( CString message );
	/** */
	int FindFirstLink( CString msg );
	/** */
	int ConvertLinks( CString msg, CString & s );
	/** */
	int FindFirstEmoticon( CString msg );
	/** */
	int ConvertEmoticons( CString msg, CString & s );

	/** */
	void AddHistory( CString message );

	/** */
	DCQTextEdit * m_pTextEdit_CHATOUTPUT;
	/** */
	CString m_sLanguage;
	/** */
	bool m_bPrivateChat;
	/** */
	bool m_bSendAway;
	/** */
	DCClient * m_pClient;
	/** */
	CString m_sNick;
	/** */
	QStatusBar * m_pStatusBar;
	/** */
	QLabel * m_pStatusCrypt;
	/** */
	eSecureState m_eSecureState;
	/** */
	CList<CString> m_History;
	/** last line */
	CString m_sHistoryTempString;
	/** cursor pos */
	int m_nHistoryTempPara;
	/** cursor pos */
	int m_nHistoryTempIndex;
	/** */
	CString * m_pCurrentHistory;
	/** */
	CString m_sTimeStamp;
	/** */
	int m_nTabStart;
	/** */
	int m_nTabEnd;
	/** */
	int m_nTabPressed;
	/** */
	QString m_sTabSaved;
	/** */
	QString m_sTabNick;
	/** */
	QWidget * m_pParent;
	/** */
	QString m_sLabel;
	/** */
	bool m_bFirstInit;
	
public slots:
	/** */
	void slotRightButtonClickedChatOutput( const QPoint& );

private slots:
	/** */
	void slotClickedChatOutput( int, int );
	/** */
	void slotDoubleClickedChatOutput( int, int );
	/** */
	void slotTextChangedChatInput();
	/** */
	void slotSendMessage();
};

#endif
