/* vtgfilteredlistdialog.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgfilteredlistdialog.vala, do not modify */

/*
 *  vtgfilteredlistdialog.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <float.h>
#include <math.h>


#define VTG_TYPE_FILTERED_LIST_DIALOG_COLUMNS (vtg_filtered_list_dialog_columns_get_type ())

#define VTG_TYPE_FILTERED_LIST_DIALOG (vtg_filtered_list_dialog_get_type ())
#define VTG_FILTERED_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_FILTERED_LIST_DIALOG, VtgFilteredListDialog))
#define VTG_FILTERED_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_FILTERED_LIST_DIALOG, VtgFilteredListDialogClass))
#define VTG_IS_FILTERED_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_FILTERED_LIST_DIALOG))
#define VTG_IS_FILTERED_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_FILTERED_LIST_DIALOG))
#define VTG_FILTERED_LIST_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_FILTERED_LIST_DIALOG, VtgFilteredListDialogClass))

typedef struct _VtgFilteredListDialog VtgFilteredListDialog;
typedef struct _VtgFilteredListDialogClass VtgFilteredListDialogClass;
typedef struct _VtgFilteredListDialogPrivate VtgFilteredListDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VTG_TYPE_COLUMNS (vtg_columns_get_type ())
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

typedef enum  {
	VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME = 0,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_MARKUP,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_OBJECT,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_ICON,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_COLUMNS_COUNT
} VtgFilteredListDialogColumns;

struct _VtgFilteredListDialog {
	GObject parent_instance;
	VtgFilteredListDialogPrivate * priv;
	GtkTreeIter selected_iter;
};

struct _VtgFilteredListDialogClass {
	GObjectClass parent_class;
};

struct _VtgFilteredListDialogPrivate {
	GtkDialog* _dialog;
	GtkTreeView* _treeview;
	GtkEntry* _entry;
	GtkTreeModelFilter* _filtered_model;
	GtkTreeModelSort* _sorted_model;
	GtkTreeModel* _child_model;
	GPatternSpec* _current_pattern;
	gchar* _current_filter;
	GtkButton* _button_ok;
};

typedef enum  {
	VTG_COLUMNS_NAME = 0,
	VTG_COLUMNS_ICON,
	VTG_COLUMNS_DATA,
	VTG_COLUMNS_COLUMNS_COUNT
} VtgColumns;


static gpointer vtg_filtered_list_dialog_parent_class = NULL;
static GType vtg_filtered_list_dialog_type_id = 0;

GType vtg_filtered_list_dialog_columns_get_type (void) G_GNUC_CONST;
GType vtg_filtered_list_dialog_get_type (void) G_GNUC_CONST;
GType vtg_filtered_list_dialog_register_type (GTypeModule * module);
#define VTG_FILTERED_LIST_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_FILTERED_LIST_DIALOG, VtgFilteredListDialogPrivate))
enum  {
	VTG_FILTERED_LIST_DIALOG_DUMMY_PROPERTY
};
GtkTreeStore* vtg_filtered_list_dialog_create_model (void);
VtgFilteredListDialog* vtg_filtered_list_dialog_new (GtkTreeStore* model, GtkTreeIterCompareFunc compare_func, void* compare_func_target);
VtgFilteredListDialog* vtg_filtered_list_dialog_construct (GType object_type, GtkTreeStore* model, GtkTreeIterCompareFunc compare_func, void* compare_func_target);
static void vtg_filtered_list_dialog_initialize_ui (VtgFilteredListDialog* self, GtkTreeIterCompareFunc compare_func, void* compare_func_target);
gchar* vtg_utils_get_ui_path (const gchar* id);
static gboolean vtg_filtered_list_dialog_on_entry_key_press (VtgFilteredListDialog* self, GtkWidget* sender, GdkEventKey* evt);
static gboolean _vtg_filtered_list_dialog_on_entry_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void vtg_filtered_list_dialog_on_entry_text_changed (VtgFilteredListDialog* self, GObject* pspec, GParamSpec* gobject);
static void _vtg_filtered_list_dialog_on_entry_text_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void vtg_filtered_list_dialog_on_row_changed (VtgFilteredListDialog* self, GtkTreeModel* tree_model, GtkTreePath* path, GtkTreeIter* iter);
static void _vtg_filtered_list_dialog_on_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
GType vtg_columns_get_type (void) G_GNUC_CONST;
static gint vtg_filtered_list_dialog_sort_model (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _vtg_filtered_list_dialog_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
static void vtg_filtered_list_dialog_on_tree_selection_changed (VtgFilteredListDialog* self, GtkTreeSelection* sender);
static void _vtg_filtered_list_dialog_on_tree_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
gboolean vtg_filtered_list_dialog_on_treeview_key_press (VtgFilteredListDialog* self, GtkWidget* sender, GdkEventKey* evt);
static gboolean _vtg_filtered_list_dialog_on_treeview_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void vtg_filtered_list_dialog_on_row_activated (VtgFilteredListDialog* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column);
static void _vtg_filtered_list_dialog_on_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static gboolean vtg_filtered_list_dialog_can_select_current_row (VtgFilteredListDialog* self);
void vtg_filtered_list_dialog_set_transient_for (VtgFilteredListDialog* self, GtkWindow* parent);
gboolean vtg_filtered_list_dialog_run (VtgFilteredListDialog* self);
static gboolean vtg_filtered_list_dialog_move_cursor_down (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* curr, GtkTreeIter* target);
static gboolean vtg_filtered_list_dialog_move_cursor_up (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* curr, GtkTreeIter* target);
gboolean vtg_string_utils_is_null_or_empty (const gchar* data);
gchar* vtg_string_utils_replace (const gchar* data, const gchar* search, const gchar* replace);
static void vtg_filtered_list_dialog_filter_and_highlight_rows (VtgFilteredListDialog* self);
static gboolean vtg_filtered_list_dialog_filter_and_highlight_row (VtgFilteredListDialog* self, GtkTreeIter* iter);
static gint vtg_filtered_list_dialog_filter_and_highlight_item (VtgFilteredListDialog* self, GtkTreeIter* iter);
gint vtg_path_utils_compare_vala_filenames (const gchar* filea, const gchar* fileb);
static void vtg_filtered_list_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType vtg_filtered_list_dialog_columns_get_type (void) {
	static volatile gsize vtg_filtered_list_dialog_columns_type_id__volatile = 0;
	if (g_once_init_enter (&vtg_filtered_list_dialog_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME, "VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME", "name"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_MARKUP, "VTG_FILTERED_LIST_DIALOG_COLUMNS_MARKUP", "markup"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY, "VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY", "visibility"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_OBJECT, "VTG_FILTERED_LIST_DIALOG_COLUMNS_OBJECT", "object"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_ICON, "VTG_FILTERED_LIST_DIALOG_COLUMNS_ICON", "icon"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, "VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE", "selectable"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_COLUMNS_COUNT, "VTG_FILTERED_LIST_DIALOG_COLUMNS_COLUMNS_COUNT", "columns-count"}, {0, NULL, NULL}};
		GType vtg_filtered_list_dialog_columns_type_id;
		vtg_filtered_list_dialog_columns_type_id = g_enum_register_static ("VtgFilteredListDialogColumns", values);
		g_once_init_leave (&vtg_filtered_list_dialog_columns_type_id__volatile, vtg_filtered_list_dialog_columns_type_id);
	}
	return vtg_filtered_list_dialog_columns_type_id__volatile;
}


GtkTreeStore* vtg_filtered_list_dialog_create_model (void) {
	GtkTreeStore* result = NULL;
	GtkTreeStore* _tmp0_ = NULL;
	_tmp0_ = gtk_tree_store_new ((gint) VTG_FILTERED_LIST_DIALOG_COLUMNS_COLUMNS_COUNT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_OBJECT, GDK_TYPE_PIXBUF, G_TYPE_BOOLEAN);
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


VtgFilteredListDialog* vtg_filtered_list_dialog_construct (GType object_type, GtkTreeStore* model, GtkTreeIterCompareFunc compare_func, void* compare_func_target) {
	VtgFilteredListDialog * self = NULL;
	GtkTreeModel* _tmp0_;
	g_return_val_if_fail (model != NULL, NULL);
	self = (VtgFilteredListDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 ((GtkTreeModel*) model);
	_g_object_unref0 (self->priv->_child_model);
	self->priv->_child_model = _tmp0_;
	vtg_filtered_list_dialog_initialize_ui (self, compare_func, compare_func_target);
	return self;
}


VtgFilteredListDialog* vtg_filtered_list_dialog_new (GtkTreeStore* model, GtkTreeIterCompareFunc compare_func, void* compare_func_target) {
	return vtg_filtered_list_dialog_construct (VTG_TYPE_FILTERED_LIST_DIALOG, model, compare_func, compare_func_target);
}


static gboolean _vtg_filtered_list_dialog_on_entry_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = vtg_filtered_list_dialog_on_entry_key_press (self, _sender, event);
	return result;
}


static void _vtg_filtered_list_dialog_on_entry_text_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	vtg_filtered_list_dialog_on_entry_text_changed (self, _sender, pspec);
}


static void _vtg_filtered_list_dialog_on_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	vtg_filtered_list_dialog_on_row_changed (self, _sender, path, iter);
}


static gint _vtg_filtered_list_dialog_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = vtg_filtered_list_dialog_sort_model (self, model, a, b);
	return result;
}


static void _vtg_filtered_list_dialog_on_tree_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	vtg_filtered_list_dialog_on_tree_selection_changed (self, _sender);
}


static gboolean _vtg_filtered_list_dialog_on_treeview_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = vtg_filtered_list_dialog_on_treeview_key_press (self, _sender, event);
	return result;
}


static void _vtg_filtered_list_dialog_on_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	vtg_filtered_list_dialog_on_row_activated (self, _sender, path, column);
}


static void vtg_filtered_list_dialog_initialize_ui (VtgFilteredListDialog* self, GtkTreeIterCompareFunc compare_func, void* compare_func_target) {
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* builder;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GObject* _tmp3_ = NULL;
	GtkDialog* _tmp4_;
	GObject* _tmp5_ = NULL;
	GtkButton* _tmp6_;
	GObject* _tmp7_ = NULL;
	GtkTreeView* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkEntry* _tmp10_;
	GtkTreeModelFilter* _tmp11_ = NULL;
	GtkTreeViewColumn* _tmp12_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererPixbuf* _tmp13_ = NULL;
	GtkCellRenderer* renderer;
	GtkCellRendererText* _tmp14_ = NULL;
	GtkTreeModelSort* _tmp15_ = NULL;
	GtkTreeSelection* _tmp17_ = NULL;
	GtkTreeSelection* _tmp18_ = NULL;
	GtkTreeSelection* _tmp19_ = NULL;
	gboolean _tmp20_;
	gboolean _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	_tmp1_ = vtg_utils_get_ui_path ("vtg.ui");
	_tmp2_ = _tmp1_;
	gtk_builder_add_from_file (builder, _tmp2_, &_inner_error_);
	_g_free0 (_tmp2_);
	if (_inner_error_ != NULL) {
		goto __catch40_g_error;
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vtgfilteredlistdialog.vala:77: initialize_ui: %s", err->message);
		_g_error_free0 (err);
	}
	__finally40:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = gtk_builder_get_object (builder, "dialog-db");
	_tmp4_ = _g_object_ref0 (GTK_DIALOG (_tmp3_));
	_g_object_unref0 (self->priv->_dialog);
	self->priv->_dialog = _tmp4_;
	g_assert (self->priv->_dialog != NULL);
	_tmp5_ = gtk_builder_get_object (builder, "button-db-ok");
	_tmp6_ = _g_object_ref0 (GTK_BUTTON (_tmp5_));
	_g_object_unref0 (self->priv->_button_ok);
	self->priv->_button_ok = _tmp6_;
	g_assert (self->priv->_button_ok != NULL);
	_tmp7_ = gtk_builder_get_object (builder, "treeview-db-docs");
	_tmp8_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp7_));
	_g_object_unref0 (self->priv->_treeview);
	self->priv->_treeview = _tmp8_;
	g_assert (self->priv->_treeview != NULL);
	_tmp9_ = gtk_builder_get_object (builder, "entry-db-filter");
	_tmp10_ = _g_object_ref0 (GTK_ENTRY (_tmp9_));
	_g_object_unref0 (self->priv->_entry);
	self->priv->_entry = _tmp10_;
	g_assert (self->priv->_entry != NULL);
	g_signal_connect_object ((GtkWidget*) self->priv->_entry, "key-press-event", (GCallback) _vtg_filtered_list_dialog_on_entry_key_press_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object ((GObject*) self->priv->_entry, "notify::text", (GCallback) _vtg_filtered_list_dialog_on_entry_text_changed_g_object_notify, self, 0);
	_tmp11_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new (self->priv->_child_model, NULL);
	_g_object_unref0 (self->priv->_filtered_model);
	self->priv->_filtered_model = _tmp11_;
	gtk_tree_model_filter_set_visible_column (self->priv->_filtered_model, (gint) VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY);
	g_signal_connect_object (self->priv->_child_model, "row-changed", (GCallback) _vtg_filtered_list_dialog_on_row_changed_gtk_tree_model_row_changed, self, 0);
	_tmp12_ = gtk_tree_view_column_new ();
	column = g_object_ref_sink (_tmp12_);
	_tmp13_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp13_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "pixbuf", (gint) VTG_FILTERED_LIST_DIALOG_COLUMNS_ICON);
	_tmp14_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp14_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "markup", (gint) VTG_FILTERED_LIST_DIALOG_COLUMNS_MARKUP);
	gtk_tree_view_append_column (self->priv->_treeview, column);
	_tmp15_ = (GtkTreeModelSort*) gtk_tree_model_sort_new_with_model ((GtkTreeModel*) self->priv->_filtered_model);
	_g_object_unref0 (self->priv->_sorted_model);
	self->priv->_sorted_model = _tmp15_;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->_sorted_model, (gint) VTG_COLUMNS_NAME, GTK_SORT_ASCENDING);
	if (compare_func == NULL) {
		gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self->priv->_sorted_model, (gint) VTG_COLUMNS_NAME, _vtg_filtered_list_dialog_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	} else {
		GtkTreeIterCompareFunc _tmp16_;
		_tmp16_ = compare_func;
		gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self->priv->_sorted_model, (gint) VTG_COLUMNS_NAME, _tmp16_, compare_func_target, NULL);
	}
	gtk_tree_view_set_model (self->priv->_treeview, (GtkTreeModel*) self->priv->_sorted_model);
	_tmp17_ = gtk_tree_view_get_selection (self->priv->_treeview);
	gtk_tree_selection_set_mode (_tmp17_, GTK_SELECTION_SINGLE);
	_tmp18_ = gtk_tree_view_get_selection (self->priv->_treeview);
	g_signal_connect_object (_tmp18_, "changed", (GCallback) _vtg_filtered_list_dialog_on_tree_selection_changed_gtk_tree_selection_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->_treeview, "key-press-event", (GCallback) _vtg_filtered_list_dialog_on_treeview_key_press_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object (self->priv->_treeview, "row-activated", (GCallback) _vtg_filtered_list_dialog_on_row_activated_gtk_tree_view_row_activated, self, 0);
	gtk_tree_view_expand_all (self->priv->_treeview);
	_tmp19_ = gtk_tree_view_get_selection (self->priv->_treeview);
	_tmp20_ = gtk_tree_selection_get_selected (_tmp19_, NULL, NULL);
	if (!_tmp20_) {
		GtkTreePath* _tmp21_ = NULL;
		GtkTreePath* path;
		GtkTreeSelection* _tmp22_ = NULL;
		_tmp21_ = gtk_tree_path_new_from_indices (0, -1);
		path = _tmp21_;
		_tmp22_ = gtk_tree_view_get_selection (self->priv->_treeview);
		gtk_tree_selection_select_path (_tmp22_, path);
		_gtk_tree_path_free0 (path);
	}
	_tmp23_ = vtg_filtered_list_dialog_can_select_current_row (self);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_button_ok, _tmp23_);
	_g_object_unref0 (renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (builder);
}


void vtg_filtered_list_dialog_set_transient_for (VtgFilteredListDialog* self, GtkWindow* parent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	gtk_window_set_transient_for ((GtkWindow*) self->priv->_dialog, parent);
}


gboolean vtg_filtered_list_dialog_run (VtgFilteredListDialog* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint dialog_result;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_window_set_modal ((GtkWindow*) self->priv->_dialog, TRUE);
	gtk_widget_show_all ((GtkWidget*) self->priv->_dialog);
	_tmp0_ = gtk_dialog_run (self->priv->_dialog);
	dialog_result = _tmp0_;
	if (dialog_result == GTK_RESPONSE_OK) {
		GtkTreeIter iter = {0};
		GtkTreeSelection* _tmp1_ = NULL;
		GtkTreeIter _tmp2_ = {0};
		gboolean _tmp3_;
		_tmp1_ = gtk_tree_view_get_selection (self->priv->_treeview);
		_tmp3_ = gtk_tree_selection_get_selected (_tmp1_, NULL, &_tmp2_);
		iter = _tmp2_;
		if (_tmp3_) {
			GtkTreeIter sort = {0};
			GtkTreeIter _tmp4_ = {0};
			GtkTreeIter _tmp5_ = {0};
			gtk_tree_model_sort_convert_iter_to_child_iter (self->priv->_sorted_model, &_tmp4_, &iter);
			sort = _tmp4_;
			gtk_tree_model_filter_convert_iter_to_child_iter (self->priv->_filtered_model, &_tmp5_, &sort);
			self->selected_iter = _tmp5_;
		} else {
			dialog_result = (gint) GTK_RESPONSE_CANCEL;
		}
	}
	gtk_widget_destroy ((GtkWidget*) self->priv->_dialog);
	result = dialog_result == GTK_RESPONSE_OK;
	return result;
}


static void vtg_filtered_list_dialog_on_row_activated (VtgFilteredListDialog* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = vtg_filtered_list_dialog_can_select_current_row (self);
	if (_tmp0_) {
		gtk_dialog_response (self->priv->_dialog, (gint) GTK_RESPONSE_OK);
	}
}


static void vtg_filtered_list_dialog_on_tree_selection_changed (VtgFilteredListDialog* self, GtkTreeSelection* sender) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = vtg_filtered_list_dialog_can_select_current_row (self);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_button_ok, _tmp0_);
}


static void vtg_filtered_list_dialog_on_row_changed (VtgFilteredListDialog* self, GtkTreeModel* tree_model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreeSelection* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = gtk_tree_view_get_selection (self->priv->_treeview);
	_tmp1_ = gtk_tree_selection_get_selected (_tmp0_, NULL, NULL);
	if (!_tmp1_) {
		GtkTreeIter sel = {0};
		GtkTreeIter _tmp2_ = {0};
		GtkTreeSelection* _tmp3_ = NULL;
		gtk_tree_model_get_iter_first (tree_model, &_tmp2_);
		sel = _tmp2_;
		_tmp3_ = gtk_tree_view_get_selection (self->priv->_treeview);
		gtk_tree_selection_select_iter (_tmp3_, &sel);
	}
	_tmp4_ = vtg_filtered_list_dialog_can_select_current_row (self);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_button_ok, _tmp4_);
}


static gboolean vtg_filtered_list_dialog_move_cursor_down (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* curr, GtkTreeIter* target) {
	GtkTreeIter _target = {0};
	gboolean result = FALSE;
	gboolean _result_;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	_result_ = TRUE;
	_tmp0_ = gtk_tree_model_iter_has_child (model, curr);
	if (_tmp0_) {
		GtkTreeIter _tmp1_ = {0};
		gtk_tree_model_iter_children (model, &_tmp1_, curr);
		_target = _tmp1_;
	} else {
		gboolean _tmp2_;
		_target = *curr;
		_tmp2_ = gtk_tree_model_iter_next (model, &_target);
		if (!_tmp2_) {
			GtkTreeIter tmp;
			gboolean _tmp6_;
			tmp = *curr;
			while (TRUE) {
				GtkTreeIter _tmp3_ = {0};
				gboolean _tmp4_;
				gboolean _tmp5_;
				_tmp4_ = gtk_tree_model_iter_parent (model, &_tmp3_, &tmp);
				_target = _tmp3_;
				if (!_tmp4_) {
					break;
				}
				tmp = _target;
				_tmp5_ = gtk_tree_model_iter_next (model, &_target);
				if (_tmp5_) {
					break;
				}
			}
			_target = tmp;
			_tmp6_ = gtk_tree_model_iter_next (model, &_target);
			if (!_tmp6_) {
				_target = *curr;
				_result_ = FALSE;
			}
		}
	}
	result = _result_;
	if (target) {
		*target = _target;
	}
	return result;
}


static gboolean vtg_filtered_list_dialog_move_cursor_up (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* curr, GtkTreeIter* target) {
	GtkTreeIter _target = {0};
	gboolean result = FALSE;
	gboolean _result_;
	GtkTreeIter tmp = {0};
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	_result_ = TRUE;
	_target = *curr;
	_tmp0_ = gtk_tree_model_iter_previous (model, &_target);
	if (_tmp0_) {
		while (TRUE) {
			GtkTreeIter _tmp1_ = {0};
			gboolean _tmp2_;
			_tmp2_ = gtk_tree_model_iter_children (model, &_tmp1_, &_target);
			tmp = _tmp1_;
			if (!_tmp2_) {
				break;
			}
			_target = tmp;
			while (TRUE) {
				gboolean _tmp3_;
				_tmp3_ = gtk_tree_model_iter_next (model, &tmp);
				if (!_tmp3_) {
					break;
				}
				_target = tmp;
			}
		}
	} else {
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_;
		_tmp5_ = gtk_tree_model_iter_parent (model, &_tmp4_, curr);
		_target = _tmp4_;
		if (!_tmp5_) {
			_target = *curr;
			_result_ = FALSE;
		}
	}
	result = _result_;
	if (target) {
		*target = _target;
	}
	return result;
}


static gboolean vtg_filtered_list_dialog_on_entry_key_press (VtgFilteredListDialog* self, GtkWidget* sender, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	if ((*evt).keyval == GDK_KEY_Down) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*evt).keyval == GDK_KEY_Up;
	}
	if (_tmp0_) {
		GtkTreeIter curr = {0};
		GtkTreeIter target = {0};
		GtkTreeModel* model = NULL;
		GtkTreePath* path = NULL;
		gboolean selectable;
		GtkTreeSelection* _tmp1_ = NULL;
		GtkTreeModel* _tmp2_ = NULL;
		GtkTreeIter _tmp3_ = {0};
		gboolean _tmp4_;
		GtkTreeModel* _tmp5_;
		GtkTreePath* _tmp16_ = NULL;
		GtkTreeSelection* _tmp17_ = NULL;
		selectable = TRUE;
		_tmp1_ = gtk_tree_view_get_selection (self->priv->_treeview);
		_tmp4_ = gtk_tree_selection_get_selected (_tmp1_, &_tmp2_, &_tmp3_);
		_g_object_unref0 (model);
		_tmp5_ = _g_object_ref0 (_tmp2_);
		model = _tmp5_;
		curr = _tmp3_;
		if (_tmp4_) {
			if ((*evt).keyval == GDK_KEY_Down) {
				while (TRUE) {
					GtkTreeIter _tmp6_ = {0};
					gboolean _tmp7_;
					_tmp7_ = vtg_filtered_list_dialog_move_cursor_down (self, model, &curr, &_tmp6_);
					target = _tmp6_;
					if (!_tmp7_) {
						break;
					}
					gtk_tree_model_get (model, &target, VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, &selectable, -1);
					if (selectable) {
						break;
					}
					curr = target;
				}
			} else {
				while (TRUE) {
					GtkTreeIter _tmp8_ = {0};
					gboolean _tmp9_;
					_tmp9_ = vtg_filtered_list_dialog_move_cursor_up (self, model, &curr, &_tmp8_);
					target = _tmp8_;
					if (!_tmp9_) {
						break;
					}
					gtk_tree_model_get (model, &target, VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, &selectable, -1);
					if (selectable) {
						break;
					}
					curr = target;
				}
			}
		} else {
			GtkTreeModel* _tmp10_ = NULL;
			GtkTreeModel* _tmp11_;
			GtkTreeIter _tmp12_ = {0};
			GtkTreePath* _tmp13_ = NULL;
			_tmp10_ = gtk_tree_view_get_model (self->priv->_treeview);
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (model);
			model = _tmp11_;
			gtk_tree_model_get_iter_first (model, &_tmp12_);
			target = _tmp12_;
			_tmp13_ = gtk_tree_model_get_path (model, &target);
			_gtk_tree_path_free0 (path);
			path = _tmp13_;
			gtk_tree_model_get (model, &target, VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, &selectable, -1);
			if (!selectable) {
				curr = target;
				while (TRUE) {
					GtkTreeIter _tmp14_ = {0};
					gboolean _tmp15_;
					_tmp15_ = vtg_filtered_list_dialog_move_cursor_down (self, model, &curr, &_tmp14_);
					target = _tmp14_;
					if (!_tmp15_) {
						break;
					}
					gtk_tree_model_get (model, &target, VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, &selectable, -1);
					if (selectable) {
						break;
					}
					curr = target;
				}
			}
		}
		_tmp16_ = gtk_tree_model_get_path (model, &target);
		_gtk_tree_path_free0 (path);
		path = _tmp16_;
		_tmp17_ = gtk_tree_view_get_selection (self->priv->_treeview);
		gtk_tree_selection_select_iter (_tmp17_, &target);
		gtk_tree_view_scroll_to_cell (self->priv->_treeview, path, NULL, FALSE, (gfloat) 0, (gfloat) 0);
		result = TRUE;
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		return result;
	}
	result = FALSE;
	return result;
}


gboolean vtg_filtered_list_dialog_on_treeview_key_press (VtgFilteredListDialog* self, GtkWidget* sender, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	if (((*evt).state & GDK_MOD1_MASK) == 0) {
		_tmp0_ = (*evt).keyval == GDK_KEY_Return;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vtg_filtered_list_dialog_can_select_current_row (self);
		if (_tmp1_) {
			gtk_dialog_response (self->priv->_dialog, 2);
		}
	}
	result = FALSE;
	return result;
}


static void vtg_filtered_list_dialog_on_entry_text_changed (VtgFilteredListDialog* self, GObject* pspec, GParamSpec* gobject) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	g_return_if_fail (gobject != NULL);
	_tmp0_ = gtk_entry_get_text (self->priv->_entry);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_current_filter);
	self->priv->_current_filter = _tmp1_;
	_tmp2_ = vtg_string_utils_is_null_or_empty (self->priv->_current_filter);
	if (_tmp2_) {
		_g_pattern_spec_free0 (self->priv->_current_pattern);
		self->priv->_current_pattern = NULL;
	} else {
		gchar* _tmp3_ = NULL;
		gboolean _tmp4_;
		gboolean _tmp6_;
		GPatternSpec* _tmp8_ = NULL;
		_tmp3_ = vtg_string_utils_replace (self->priv->_current_filter, " ", "*");
		_g_free0 (self->priv->_current_filter);
		self->priv->_current_filter = _tmp3_;
		_tmp4_ = g_str_has_suffix (self->priv->_current_filter, "*");
		if (!_tmp4_) {
			gchar* _tmp5_;
			_tmp5_ = g_strconcat (self->priv->_current_filter, "*", NULL);
			_g_free0 (self->priv->_current_filter);
			self->priv->_current_filter = _tmp5_;
		}
		_tmp6_ = g_str_has_prefix (self->priv->_current_filter, "*");
		if (!_tmp6_) {
			gchar* _tmp7_;
			_tmp7_ = g_strconcat ("*", self->priv->_current_filter, NULL);
			_g_free0 (self->priv->_current_filter);
			self->priv->_current_filter = _tmp7_;
		}
		_tmp8_ = g_pattern_spec_new (self->priv->_current_filter);
		_g_pattern_spec_free0 (self->priv->_current_pattern);
		self->priv->_current_pattern = _tmp8_;
	}
	vtg_filtered_list_dialog_filter_and_highlight_rows (self);
	gtk_tree_model_filter_refilter (self->priv->_filtered_model);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->_sorted_model, 0, GTK_SORT_ASCENDING);
	_tmp9_ = vtg_filtered_list_dialog_can_select_current_row (self);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_button_ok, _tmp9_);
}


static gboolean vtg_filtered_list_dialog_can_select_current_row (VtgFilteredListDialog* self) {
	gboolean result = FALSE;
	gboolean res;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	res = FALSE;
	_tmp0_ = gtk_tree_view_get_selection (self->priv->_treeview);
	_tmp2_ = gtk_tree_selection_get_selected (_tmp0_, NULL, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkTreeIter sort = {0};
		GtkTreeIter curr = {0};
		GtkTreeIter _tmp3_ = {0};
		GtkTreeIter _tmp4_ = {0};
		gtk_tree_model_sort_convert_iter_to_child_iter (self->priv->_sorted_model, &_tmp3_, &iter);
		sort = _tmp3_;
		gtk_tree_model_filter_convert_iter_to_child_iter (self->priv->_filtered_model, &_tmp4_, &sort);
		curr = _tmp4_;
		gtk_tree_model_get (self->priv->_child_model, &curr, VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, &res, -1);
	}
	result = res;
	return result;
}


static gboolean vtg_filtered_list_dialog_filter_and_highlight_row (VtgFilteredListDialog* self, GtkTreeIter* iter) {
	gboolean result = FALSE;
	gchar* val = NULL;
	gboolean res;
	gchar* markup = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_tree_model_get (self->priv->_child_model, iter, VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME, &val, -1);
	res = TRUE;
	if (self->priv->_current_pattern != NULL) {
		gboolean _tmp0_;
		_tmp0_ = g_pattern_match_string (self->priv->_current_pattern, val);
		res = _tmp0_;
	}
	if (res) {
		_tmp1_ = self->priv->_current_pattern != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar** _tmp2_;
		gchar** _tmp3_ = NULL;
		gchar** words;
		gint words_length1;
		gint _words_size_;
		gchar* _tmp4_;
		_tmp3_ = _tmp2_ = g_strsplit (self->priv->_current_filter, "*", 0);
		words = _tmp3_;
		words_length1 = _vala_array_length (_tmp2_);
		_words_size_ = _vala_array_length (_tmp2_);
		_tmp4_ = g_strdup ("");
		_g_free0 (markup);
		markup = _tmp4_;
		{
			gchar** word_collection;
			int word_collection_length1;
			int word_it;
			word_collection = words;
			word_collection_length1 = words_length1;
			for (word_it = 0; word_it < words_length1; word_it = word_it + 1) {
				gchar* _tmp5_;
				gchar* word;
				_tmp5_ = g_strdup (word_collection[word_it]);
				word = _tmp5_;
				{
					gboolean _tmp6_;
					_tmp6_ = vtg_string_utils_is_null_or_empty (word);
					if (!_tmp6_) {
						gchar** _tmp7_;
						gchar** _tmp8_ = NULL;
						gchar** pieces;
						gint pieces_length1;
						gint _pieces_size_;
						gchar* _tmp9_ = NULL;
						gboolean _tmp10_ = FALSE;
						_tmp8_ = _tmp7_ = g_strsplit (val, word, 2);
						pieces = _tmp8_;
						pieces_length1 = _vala_array_length (_tmp7_);
						_pieces_size_ = _vala_array_length (_tmp7_);
						_tmp9_ = g_strconcat (markup, pieces[0], NULL);
						_g_free0 (markup);
						markup = _tmp9_;
						if (pieces_length1 == 2) {
							_tmp10_ = TRUE;
						} else {
							gboolean _tmp11_;
							_tmp11_ = g_str_has_suffix (val, word);
							_tmp10_ = _tmp11_;
						}
						if (_tmp10_) {
							gchar* _tmp12_ = NULL;
							_tmp12_ = g_strconcat (markup, "<b>", word, "</b>", NULL);
							_g_free0 (markup);
							markup = _tmp12_;
							if (pieces_length1 == 2) {
								gchar* _tmp13_;
								_tmp13_ = g_strdup (pieces[1]);
								_g_free0 (val);
								val = _tmp13_;
							} else {
								_g_free0 (val);
								val = NULL;
								pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (word);
								break;
							}
						}
						pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
					}
					_g_free0 (word);
				}
			}
		}
		if (val != NULL) {
			gchar* _tmp14_ = NULL;
			_tmp14_ = g_strconcat (markup, val, NULL);
			_g_free0 (markup);
			markup = _tmp14_;
		}
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (val);
		_g_free0 (markup);
		markup = _tmp15_;
	}
	gtk_tree_store_set (GTK_TREE_STORE (self->priv->_child_model), iter, VTG_FILTERED_LIST_DIALOG_COLUMNS_MARKUP, markup, -1);
	gtk_tree_store_set (GTK_TREE_STORE (self->priv->_child_model), iter, VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY, res, -1);
	result = res;
	_g_free0 (markup);
	_g_free0 (val);
	return result;
}


static gint vtg_filtered_list_dialog_filter_and_highlight_item (VtgFilteredListDialog* self, GtkTreeIter* iter) {
	gint result = 0;
	gint res;
	gboolean eof;
	g_return_val_if_fail (self != NULL, 0);
	res = 0;
	eof = FALSE;
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp4_;
		if (!(!eof)) {
			break;
		}
		_tmp0_ = vtg_filtered_list_dialog_filter_and_highlight_row (self, iter);
		if (_tmp0_) {
			res++;
		}
		_tmp1_ = gtk_tree_model_iter_has_child (self->priv->_child_model, iter);
		if (_tmp1_) {
			GtkTreeIter child = {0};
			GtkTreeIter _tmp2_ = {0};
			gint _tmp3_;
			gtk_tree_model_iter_children (self->priv->_child_model, &_tmp2_, iter);
			child = _tmp2_;
			_tmp3_ = vtg_filtered_list_dialog_filter_and_highlight_item (self, &child);
			if (_tmp3_ != 0) {
				res++;
				gtk_tree_store_set (GTK_TREE_STORE (self->priv->_child_model), iter, VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY, TRUE, -1);
			}
		}
		_tmp4_ = gtk_tree_model_iter_next (self->priv->_child_model, iter);
		eof = !_tmp4_;
	}
	result = res;
	return result;
}


static void vtg_filtered_list_dialog_filter_and_highlight_rows (VtgFilteredListDialog* self) {
	guint _tmp0_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_signal_parse_name ("row-changed", GTK_TYPE_TREE_MODEL, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->_child_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _vtg_filtered_list_dialog_on_row_changed_gtk_tree_model_row_changed, self);
	_tmp2_ = gtk_tree_model_get_iter_first (self->priv->_child_model, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		vtg_filtered_list_dialog_filter_and_highlight_item (self, &iter);
	}
	g_signal_connect_object (self->priv->_child_model, "row-changed", (GCallback) _vtg_filtered_list_dialog_on_row_changed_gtk_tree_model_row_changed, self, 0);
	gtk_tree_model_filter_refilter (self->priv->_filtered_model);
	gtk_tree_view_expand_all (self->priv->_treeview);
}


static gint vtg_filtered_list_dialog_sort_model (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	gchar* vala = NULL;
	gchar* valb = NULL;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	gtk_tree_model_get (model, a, VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME, &vala, -1);
	gtk_tree_model_get (model, b, VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME, &valb, -1);
	_tmp0_ = vtg_path_utils_compare_vala_filenames (vala, valb);
	result = _tmp0_;
	_g_free0 (valb);
	_g_free0 (vala);
	return result;
}


static void vtg_filtered_list_dialog_class_init (VtgFilteredListDialogClass * klass) {
	vtg_filtered_list_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgFilteredListDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = vtg_filtered_list_dialog_finalize;
}


static void vtg_filtered_list_dialog_instance_init (VtgFilteredListDialog * self) {
	self->priv = VTG_FILTERED_LIST_DIALOG_GET_PRIVATE (self);
	self->priv->_current_pattern = NULL;
	self->priv->_current_filter = NULL;
}


static void vtg_filtered_list_dialog_finalize (GObject* obj) {
	VtgFilteredListDialog * self;
	self = VTG_FILTERED_LIST_DIALOG (obj);
	_g_object_unref0 (self->priv->_dialog);
	_g_object_unref0 (self->priv->_treeview);
	_g_object_unref0 (self->priv->_entry);
	_g_object_unref0 (self->priv->_filtered_model);
	_g_object_unref0 (self->priv->_sorted_model);
	_g_object_unref0 (self->priv->_child_model);
	_g_pattern_spec_free0 (self->priv->_current_pattern);
	_g_free0 (self->priv->_current_filter);
	_g_object_unref0 (self->priv->_button_ok);
	G_OBJECT_CLASS (vtg_filtered_list_dialog_parent_class)->finalize (obj);
}


GType vtg_filtered_list_dialog_get_type (void) {
	return vtg_filtered_list_dialog_type_id;
}


GType vtg_filtered_list_dialog_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgFilteredListDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_filtered_list_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgFilteredListDialog), 0, (GInstanceInitFunc) vtg_filtered_list_dialog_instance_init, NULL };
	vtg_filtered_list_dialog_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgFilteredListDialog", &g_define_type_info, 0);
	return vtg_filtered_list_dialog_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



