/* vtgprojectsearch.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgprojectsearch.vala, do not modify */

/*
 *  vtgprojectsearch.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2009 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gedit/gedit-window.h>
#include <gtk/gtk.h>
#include <vbf.h>
#include <valagee.h>
#include <glib/gi18n-lib.h>
#include <sys/wait.h>


#define VTG_TYPE_PROJECT_SEARCH (vtg_project_search_get_type ())
#define VTG_PROJECT_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_SEARCH, VtgProjectSearch))
#define VTG_PROJECT_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_SEARCH, VtgProjectSearchClass))
#define VTG_IS_PROJECT_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_SEARCH))
#define VTG_IS_PROJECT_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_SEARCH))
#define VTG_PROJECT_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_SEARCH, VtgProjectSearchClass))

typedef struct _VtgProjectSearch VtgProjectSearch;
typedef struct _VtgProjectSearchClass VtgProjectSearchClass;
typedef struct _VtgProjectSearchPrivate VtgProjectSearchPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW (vtg_project_search_results_view_get_type ())
#define VTG_PROJECT_SEARCH_RESULTS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW, VtgProjectSearchResultsView))
#define VTG_PROJECT_SEARCH_RESULTS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW, VtgProjectSearchResultsViewClass))
#define VTG_IS_PROJECT_SEARCH_RESULTS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW))
#define VTG_IS_PROJECT_SEARCH_RESULTS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW))
#define VTG_PROJECT_SEARCH_RESULTS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_SEARCH_RESULTS_VIEW, VtgProjectSearchResultsViewClass))

typedef struct _VtgProjectSearchResultsView VtgProjectSearchResultsView;
typedef struct _VtgProjectSearchResultsViewClass VtgProjectSearchResultsViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;

#define VTG_TYPE_OUTPUT_VIEW (vtg_output_view_get_type ())
#define VTG_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputView))
#define VTG_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))
#define VTG_IS_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_OUTPUT_VIEW))
#define VTG_IS_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_OUTPUT_VIEW))
#define VTG_OUTPUT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))

typedef struct _VtgOutputView VtgOutputView;
typedef struct _VtgOutputViewClass VtgOutputViewClass;

#define VTG_TYPE_OUTPUT_TYPES (vtg_output_types_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

struct _VtgProjectSearch {
	GObject parent_instance;
	VtgProjectSearchPrivate * priv;
};

struct _VtgProjectSearchClass {
	GObjectClass parent_class;
};

struct _VtgProjectSearchPrivate {
	VtgPluginInstance* _plugin_instance;
	VtgProjectSearchResultsView* _results_view;
	guint _child_watch_id;
	GPid child_pid;
	gboolean is_bottom_pane_visible;
	gint last_exit_code;
};

typedef enum  {
	VTG_OUTPUT_TYPES_MESSAGE,
	VTG_OUTPUT_TYPES_ERROR,
	VTG_OUTPUT_TYPES_CHILD_PROCESS,
	VTG_OUTPUT_TYPES_BUILD,
	VTG_OUTPUT_TYPES_AUTO_BUILD,
	VTG_OUTPUT_TYPES_SEARCH
} VtgOutputTypes;


static gpointer vtg_project_search_parent_class = NULL;
static GType vtg_project_search_type_id = 0;

GType vtg_project_search_get_type (void) G_GNUC_CONST;
GType vtg_project_search_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
GType vtg_project_search_results_view_get_type (void) G_GNUC_CONST;
GType vtg_project_search_results_view_register_type (GTypeModule * module);
#define VTG_PROJECT_SEARCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PROJECT_SEARCH, VtgProjectSearchPrivate))
enum  {
	VTG_PROJECT_SEARCH_DUMMY_PROPERTY,
	VTG_PROJECT_SEARCH_IS_SEARCHING
};
#define VTG_PROJECT_SEARCH_GREP "grep"
VtgProjectSearch* vtg_project_search_new (VtgPluginInstance* plugin_instance);
VtgProjectSearch* vtg_project_search_construct (GType object_type, VtgPluginInstance* plugin_instance);
VtgProjectSearchResultsView* vtg_project_search_results_view_new (VtgPluginInstance* plugin_instance);
VtgProjectSearchResultsView* vtg_project_search_results_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
void vtg_project_search_next_match (VtgProjectSearch* self);
void vtg_project_search_results_view_next_match (VtgProjectSearchResultsView* self);
void vtg_project_search_previous_match (VtgProjectSearch* self);
void vtg_project_search_results_view_previous_match (VtgProjectSearchResultsView* self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
gboolean vtg_project_search_search (VtgProjectSearch* self, VtgProjectManager* project_manager, const char* text, gboolean match_case);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
GType vtg_output_view_get_type (void) G_GNUC_CONST;
GType vtg_output_view_register_type (GTypeModule * module);
VtgOutputView* vtg_plugin_instance_get_output_view (VtgPluginInstance* self);
void vtg_output_view_clean_output (VtgOutputView* self);
GType vtg_output_types_get_type (void) G_GNUC_CONST;
void vtg_output_view_log_message (VtgOutputView* self, VtgOutputTypes output_type, const char* message);
void vtg_utils_trace (const char* format, ...);
static void vtg_project_search_on_child_watch (VtgProjectSearch* self, GPid pid, gint status);
static void _vtg_project_search_on_child_watch_gchild_watch_func (GPid pid, gint status, gpointer self);
void vtg_project_search_results_view_initialize (VtgProjectSearchResultsView* self, VtgProjectManager* project);
void vtg_output_view_start_watch (VtgOutputView* self, VtgOutputTypes output_type, guint id, gint stdo, gint stde, gint stdi);
void vtg_output_view_activate (VtgOutputView* self);
void vtg_output_view_stop_watch (VtgOutputView* self, guint id);
void vtg_project_search_results_view_activate (VtgProjectSearchResultsView* self);
gboolean vtg_project_search_get_is_searching (VtgProjectSearch* self);
static void vtg_project_search_finalize (GObject* obj);
static void vtg_project_search_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



VtgProjectSearch* vtg_project_search_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgProjectSearch * self;
	VtgProjectSearchResultsView* _tmp0_;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgProjectSearch*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	self->priv->_results_view = (_tmp0_ = vtg_project_search_results_view_new (self->priv->_plugin_instance), _g_object_unref0 (self->priv->_results_view), _tmp0_);
	self->priv->is_bottom_pane_visible = gtk_widget_get_visible ((GtkWidget*) gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	return self;
}


VtgProjectSearch* vtg_project_search_new (VtgPluginInstance* plugin_instance) {
	return vtg_project_search_construct (VTG_TYPE_PROJECT_SEARCH, plugin_instance);
}


void vtg_project_search_next_match (VtgProjectSearch* self) {
	g_return_if_fail (self != NULL);
	vtg_project_search_results_view_next_match (self->priv->_results_view);
}


void vtg_project_search_previous_match (VtgProjectSearch* self) {
	g_return_if_fail (self != NULL);
	vtg_project_search_results_view_previous_match (self->priv->_results_view);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch29_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch29_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally29;
	__catch29_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally29:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static void _vtg_project_search_on_child_watch_gchild_watch_func (GPid pid, gint status, gpointer self) {
	vtg_project_search_on_child_watch (self, pid, status);
}


gboolean vtg_project_search_search (VtgProjectSearch* self, VtgProjectManager* project_manager, const char* text, gboolean match_case) {
	gboolean result = FALSE;
	VbfProject* project;
	char* working_dir;
	gint stdo = 0;
	gint stde = 0;
	gint stdi = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_manager != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		result = FALSE;
		return result;
	}
	project = _g_object_ref0 (vtg_project_manager_get_project (project_manager));
	working_dir = g_strdup (project->id);
	{
		VtgOutputView* log;
		char* cmd;
		gint cmds_length1;
		gint _cmds_size_;
		char** cmds;
		char* start_message;
		char* _tmp17_;
		char* _tmp18_;
		log = _g_object_ref0 (vtg_plugin_instance_get_output_view (self->priv->_plugin_instance));
		cmd = NULL;
		vtg_output_view_clean_output (log);
		if (text == NULL) {
			char* _tmp0_;
			vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp0_ = g_strdup_printf ("No command text to search specified for project %s", project->name));
			_g_free0 (_tmp0_);
			result = FALSE;
			_g_free0 (cmd);
			_g_object_unref0 (log);
			_g_free0 (working_dir);
			_g_object_unref0 (project);
			return result;
		} else {
			const char* _tmp1_;
			char* _tmp2_;
			char* _tmp3_;
			char* dirs;
			char* _tmp14_;
			char* _tmp15_;
			char* _tmp16_;
			_tmp1_ = NULL;
			if (match_case) {
				_tmp1_ = "";
			} else {
				_tmp1_ = "i";
			}
			cmd = (_tmp3_ = g_strdup_printf ("sh -c '%s -Hn%s %s", VTG_PROJECT_SEARCH_GREP, _tmp1_, _tmp2_ = string_replace (text, " ", "\\ ")), _g_free0 (cmd), _tmp3_);
			_g_free0 (_tmp2_);
			dirs = g_strdup ("");
			{
				ValaList* _tmp4_;
				ValaIterator* _tmp5_;
				ValaIterator* _group_it;
				_group_it = (_tmp5_ = vala_iterable_iterator ((ValaIterable*) (_tmp4_ = vbf_project_get_groups (project))), _vala_collection_object_unref0 (_tmp4_), _tmp5_);
				while (TRUE) {
					VbfGroup* group;
					if (!vala_iterator_next (_group_it)) {
						break;
					}
					group = (VbfGroup*) vala_iterator_get (_group_it);
					{
						ValaList* _tmp6_;
						ValaIterator* _tmp7_;
						ValaIterator* _target_it;
						_target_it = (_tmp7_ = vala_iterable_iterator ((ValaIterable*) (_tmp6_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp6_), _tmp7_);
						while (TRUE) {
							VbfTarget* target;
							gboolean group_done;
							if (!vala_iterator_next (_target_it)) {
								break;
							}
							target = (VbfTarget*) vala_iterator_get (_target_it);
							group_done = FALSE;
							if (vbf_target_has_sources_of_type (target, VBF_FILE_TYPES_VALA_SOURCE)) {
								char* _tmp8_;
								char* _tmp9_;
								char* _tmp10_;
								dirs = (_tmp10_ = g_strconcat (dirs, " ", _tmp9_ = string_replace (_tmp8_ = g_build_filename (group->id, "*.vala", NULL), " ", "\\ "), NULL), _g_free0 (dirs), _tmp10_);
								_g_free0 (_tmp9_);
								_g_free0 (_tmp8_);
								group_done = TRUE;
							}
							if (vbf_target_has_file_with_extension (target, "vapi")) {
								char* _tmp11_;
								char* _tmp12_;
								char* _tmp13_;
								dirs = (_tmp13_ = g_strconcat (dirs, " ", _tmp12_ = string_replace (_tmp11_ = g_build_filename (group->id, "*.vapi", NULL), " ", "\\ "), NULL), _g_free0 (dirs), _tmp13_);
								_g_free0 (_tmp12_);
								_g_free0 (_tmp11_);
								group_done = TRUE;
							}
							if (group_done) {
								_g_object_unref0 (target);
								break;
							}
							_g_object_unref0 (target);
						}
						_vala_collection_object_unref0 (_target_it);
					}
					_g_object_unref0 (group);
				}
				_vala_collection_object_unref0 (_group_it);
			}
			cmd = (_tmp16_ = g_strconcat (cmd, _tmp15_ = g_strconcat (_tmp14_ = g_strconcat (" ", dirs, NULL), "'", NULL), NULL), _g_free0 (cmd), _tmp16_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp14_);
			_g_free0 (dirs);
		}
		vtg_utils_trace ("vtgprojectsearch.vala:106: project grep: %s", cmd);
		cmds = (cmds_length1 = 0, NULL);
		g_shell_parse_argv (cmd, &cmds_length1, &cmds, &_inner_error_);
		if (_inner_error_ != NULL) {
			cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (cmd);
			_g_object_unref0 (log);
			goto __catch28_g_error;
		}
		start_message = g_strdup_printf (_ ("Searching for '%s' in project %s\n"), text, project->name);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp18_ = g_strdup_printf ("%s\n\n", _tmp17_ = g_strnfill ((gsize) (string_get_length (start_message) - 1), '-')));
		_g_free0 (_tmp18_);
		_g_free0 (_tmp17_);
		g_spawn_async_with_pipes (working_dir, cmds, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &self->priv->child_pid, &stdi, &stdo, &stde, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (start_message);
			cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (cmd);
			_g_object_unref0 (log);
			goto __catch28_g_error;
		}
		if (self->priv->child_pid != ((GPid) 0)) {
			self->priv->_child_watch_id = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->child_pid, _vtg_project_search_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
			vtg_project_search_results_view_initialize (self->priv->_results_view, project_manager);
			if (self->priv->last_exit_code == 0) {
				self->priv->is_bottom_pane_visible = gtk_widget_get_visible ((GtkWidget*) gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
			}
			vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_SEARCH, self->priv->_child_watch_id, stdo, stde, stdi);
			vtg_output_view_activate (log);
			g_signal_emit_by_name (self, "search-start");
		} else {
			vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, "error spawning process\n");
		}
		result = TRUE;
		_g_free0 (start_message);
		cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_object_unref0 (log);
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		return result;
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgprojectsearch.vala:126: Error spawning search process: %s", err->message);
			result = FALSE;
			_g_error_free0 (err);
			_g_free0 (working_dir);
			_g_object_unref0 (project);
			return result;
		}
	}
	__finally28:
	{
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (working_dir);
	_g_object_unref0 (project);
}


static void vtg_project_search_on_child_watch (VtgProjectSearch* self, GPid pid, gint status) {
	VtgOutputView* log;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	log = _g_object_ref0 (vtg_plugin_instance_get_output_view (self->priv->_plugin_instance));
	self->priv->last_exit_code = WEXITSTATUS (status);
	vtg_output_view_stop_watch (log, self->priv->_child_watch_id);
	g_spawn_close_pid (self->priv->child_pid);
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp0_ = g_strdup_printf (_ ("\nsearch terminated with exit status %d\n"), status));
	_g_free0 (_tmp0_);
	vtg_project_search_results_view_activate (self->priv->_results_view);
	self->priv->_child_watch_id = (guint) 0;
	g_signal_emit_by_name (self, "search-exit", WEXITSTATUS (status));
	self->priv->child_pid = (GPid) 0;
	_g_object_unref0 (log);
}


gboolean vtg_project_search_get_is_searching (VtgProjectSearch* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_child_watch_id != 0;
	return result;
}


static void vtg_project_search_class_init (VtgProjectSearchClass * klass) {
	vtg_project_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgProjectSearchPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_project_search_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_project_search_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_SEARCH_IS_SEARCHING, g_param_spec_boolean ("is-searching", "is-searching", "is-searching", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("search_start", VTG_TYPE_PROJECT_SEARCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("search_exit", VTG_TYPE_PROJECT_SEARCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void vtg_project_search_instance_init (VtgProjectSearch * self) {
	self->priv = VTG_PROJECT_SEARCH_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
	self->priv->_results_view = NULL;
	self->priv->_child_watch_id = (guint) 0;
	self->priv->child_pid = (GPid) 0;
	self->priv->last_exit_code = 0;
}


static void vtg_project_search_finalize (GObject* obj) {
	VtgProjectSearch * self;
	self = VTG_PROJECT_SEARCH (obj);
	_g_object_unref0 (self->priv->_results_view);
	G_OBJECT_CLASS (vtg_project_search_parent_class)->finalize (obj);
}


GType vtg_project_search_get_type (void) {
	return vtg_project_search_type_id;
}


GType vtg_project_search_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgProjectSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_project_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgProjectSearch), 0, (GInstanceInitFunc) vtg_project_search_instance_init, NULL };
	vtg_project_search_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgProjectSearch", &g_define_type_info, 0);
	return vtg_project_search_type_id;
}


static void vtg_project_search_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgProjectSearch * self;
	self = VTG_PROJECT_SEARCH (object);
	switch (property_id) {
		case VTG_PROJECT_SEARCH_IS_SEARCHING:
		g_value_set_boolean (value, vtg_project_search_get_is_searching (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




