/* vtgprojectmanager.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgprojectmanager.vala, do not modify */

/*
 *  vtgprojectmanager.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <vbf.h>
#include <gtk/gtk.h>
#include <afrodite.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gedit/gedit-plugin.h>


#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_PROJECT_MANAGER_UI (vtg_project_manager_ui_get_type ())
#define VTG_PROJECT_MANAGER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUi))
#define VTG_PROJECT_MANAGER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUiClass))
#define VTG_IS_PROJECT_MANAGER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER_UI))
#define VTG_IS_PROJECT_MANAGER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER_UI))
#define VTG_PROJECT_MANAGER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUiClass))

typedef struct _VtgProjectManagerUi VtgProjectManagerUi;
typedef struct _VtgProjectManagerUiClass VtgProjectManagerUiClass;

#define VTG_TYPE_PROJECT_BUILDER (vtg_project_builder_get_type ())
#define VTG_PROJECT_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilder))
#define VTG_PROJECT_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilderClass))
#define VTG_IS_PROJECT_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_BUILDER))
#define VTG_IS_PROJECT_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_BUILDER))
#define VTG_PROJECT_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilderClass))

typedef struct _VtgProjectBuilder VtgProjectBuilder;
typedef struct _VtgProjectBuilderClass VtgProjectBuilderClass;

#define VTG_TYPE_BUILD_LOG_VIEW (vtg_build_log_view_get_type ())
#define VTG_BUILD_LOG_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogView))
#define VTG_BUILD_LOG_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewClass))
#define VTG_IS_BUILD_LOG_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_BUILD_LOG_VIEW))
#define VTG_IS_BUILD_LOG_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_BUILD_LOG_VIEW))
#define VTG_BUILD_LOG_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewClass))

typedef struct _VtgBuildLogView VtgBuildLogView;
typedef struct _VtgBuildLogViewClass VtgBuildLogViewClass;

#define VTG_VCS_BACKENDS_TYPE_VCS_BASE (vtg_vcs_backends_vcs_base_get_type ())
#define VTG_VCS_BACKENDS_VCS_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBase))
#define VTG_VCS_BACKENDS_VCS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBaseClass))
#define VTG_VCS_BACKENDS_IS_VCS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE))
#define VTG_VCS_BACKENDS_IS_VCS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_VCS_BASE))
#define VTG_VCS_BACKENDS_VCS_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBaseClass))

typedef struct _VtgVcsBackendsVcsBase VtgVcsBackendsVcsBase;
typedef struct _VtgVcsBackendsVcsBaseClass VtgVcsBackendsVcsBaseClass;

#define VTG_VCS_BACKENDS_TYPE_GIT (vtg_vcs_backends_git_get_type ())
#define VTG_VCS_BACKENDS_GIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGit))
#define VTG_VCS_BACKENDS_GIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGitClass))
#define VTG_VCS_BACKENDS_IS_GIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_GIT))
#define VTG_VCS_BACKENDS_IS_GIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_GIT))
#define VTG_VCS_BACKENDS_GIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGitClass))

typedef struct _VtgVcsBackendsGit VtgVcsBackendsGit;
typedef struct _VtgVcsBackendsGitClass VtgVcsBackendsGitClass;

#define VTG_VCS_BACKENDS_TYPE_BZR (vtg_vcs_backends_bzr_get_type ())
#define VTG_VCS_BACKENDS_BZR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzr))
#define VTG_VCS_BACKENDS_BZR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzrClass))
#define VTG_VCS_BACKENDS_IS_BZR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_BZR))
#define VTG_VCS_BACKENDS_IS_BZR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_BZR))
#define VTG_VCS_BACKENDS_BZR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzrClass))

typedef struct _VtgVcsBackendsBzr VtgVcsBackendsBzr;
typedef struct _VtgVcsBackendsBzrClass VtgVcsBackendsBzrClass;

#define VTG_VCS_BACKENDS_TYPE_SVN (vtg_vcs_backends_svn_get_type ())
#define VTG_VCS_BACKENDS_SVN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvn))
#define VTG_VCS_BACKENDS_SVN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvnClass))
#define VTG_VCS_BACKENDS_IS_SVN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_SVN))
#define VTG_VCS_BACKENDS_IS_SVN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_SVN))
#define VTG_VCS_BACKENDS_SVN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvnClass))

typedef struct _VtgVcsBackendsSvn VtgVcsBackendsSvn;
typedef struct _VtgVcsBackendsSvnClass VtgVcsBackendsSvnClass;

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	char* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	char* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};

struct _VtgProjectManagerPrivate {
	VbfProject* _project;
	GtkTreeStore* _model;
	gboolean _enable_completion;
	gboolean in_update;
	ValaHashMap* _completions;
	gint parser_thread_count;
	gboolean _sc_building;
	gboolean _automanaged;
	guint _idle_id;
};

typedef enum  {
	VTG_PROJECT_MANAGER_ERROR_NO_BACKEND
} VtgProjectManagerError;
#define VTG_PROJECT_MANAGER_ERROR vtg_project_manager_error_quark ()

extern VtgPlugin* vtg_plugin_main_instance;
static gpointer vtg_project_manager_parent_class = NULL;
static GType vtg_project_manager_type_id = 0;

GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
#define VTG_PROJECT_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerPrivate))
enum  {
	VTG_PROJECT_MANAGER_DUMMY_PROPERTY,
	VTG_PROJECT_MANAGER_MODEL,
	VTG_PROJECT_MANAGER_PROJECT,
	VTG_PROJECT_MANAGER_AUTOMANAGED,
	VTG_PROJECT_MANAGER_ENABLE_COMPLETION,
	VTG_PROJECT_MANAGER_COMPLETIONS
};
VtgProjectManager* vtg_project_manager_new (gboolean enable_completion);
VtgProjectManager* vtg_project_manager_construct (GType object_type, gboolean enable_completion);
AfroditeCompletionEngine* vtg_project_manager_get_completion_for_file (VtgProjectManager* self, const char* uri);
AfroditeCompletionEngine* vtg_project_manager_get_completion_for_target (VtgProjectManager* self, VbfTarget* target);
gboolean vtg_project_manager_contains_filename (VtgProjectManager* self, const char* filename);
VbfSource* vtg_project_manager_get_source_file_from_uri (VtgProjectManager* self, const char* uri);
VbfSource* vtg_project_manager_get_source_file_for_filename (VtgProjectManager* self, const char* filename);
gboolean vtg_project_manager_contains_vala_source_file (VtgProjectManager* self, const char* uri);
char* vtg_project_manager_source_uri_for_name (VtgProjectManager* self, const char* name);
void vtg_project_manager_create_default_project (VtgProjectManager* self);
static void vtg_project_manager_on_project_updated (VtgProjectManager* self, VbfProject* sender);
static void _vtg_project_manager_on_project_updated_vbf_project_updated (VbfProject* _sender, gpointer self);
gboolean vtg_project_manager_open (VtgProjectManager* self, const char* project_filename, GError** error);
static void vtg_project_manager_parse_project (VtgProjectManager* self);
static void vtg_project_manager_setup_completions (VtgProjectManager* self);
static void vtg_project_manager_build_tree_model (VtgProjectManager* self);
static void vtg_project_manager_vcs_test (VtgProjectManager* self, const char* filename);
GQuark vtg_project_manager_error_quark (void);
static gboolean vtg_project_manager_target_has_vala_source (VtgProjectManager* self, VbfTarget* target);
static void vtg_project_manager_on_completion_engine_begin_parse (VtgProjectManager* self, AfroditeCompletionEngine* sender);
static void _vtg_project_manager_on_completion_engine_begin_parse_afrodite_completion_engine_begin_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self);
static void vtg_project_manager_on_completion_engine_end_parse (VtgProjectManager* self, AfroditeCompletionEngine* sender);
static void _vtg_project_manager_on_completion_engine_end_parse_afrodite_completion_engine_end_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self);
static void vtg_project_manager_on_completion_engine_file_parsed (VtgProjectManager* self, AfroditeCompletionEngine* sender, const char* filename, AfroditeParseResult* parse_result);
static void _vtg_project_manager_on_completion_engine_file_parsed_afrodite_completion_engine_file_parsed (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, const char* filename, AfroditeParseResult* parse_result, gpointer self);
void vtg_utils_trace (const char* format, ...);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
ValaList* vtg_plugin_get_instances (VtgPlugin* self);
void vtg_plugin_instance_bind_completion_engine_with_target (VtgPluginInstance* self, VbfTarget* target, AfroditeCompletionEngine* engine);
static void vtg_project_manager_cleanup_completions (VtgProjectManager* self);
void vtg_plugin_instance_unbind_completion_engine (VtgPluginInstance* self, AfroditeCompletionEngine* engine);
static gboolean vtg_project_manager_on_idle (VtgProjectManager* self);
static gboolean _vtg_project_manager_on_idle_gsource_func (gpointer self);
GType vtg_project_manager_ui_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_ui_register_type (GTypeModule * module);
VtgProjectManagerUi* vtg_plugin_instance_get_project_manager_ui (VtgPluginInstance* self);
GType vtg_project_builder_get_type (void) G_GNUC_CONST;
GType vtg_project_builder_register_type (GTypeModule * module);
VtgProjectBuilder* vtg_project_manager_ui_get_project_builder (VtgProjectManagerUi* self);
GType vtg_build_log_view_get_type (void) G_GNUC_CONST;
GType vtg_build_log_view_register_type (GTypeModule * module);
VtgBuildLogView* vtg_project_builder_get_error_pane (VtgProjectBuilder* self);
void vtg_build_log_view_clear_messages_for_source (VtgBuildLogView* self, const char* filename);
void vtg_build_log_view_update_parse_result (VtgBuildLogView* self, const char* filename, AfroditeParseResult* parse_result);
VtgVcsBackendsGit* vtg_vcs_backends_git_new (void);
VtgVcsBackendsGit* vtg_vcs_backends_git_construct (GType object_type);
GType vtg_vcs_backends_vcs_base_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_vcs_base_register_type (GTypeModule * module);
GType vtg_vcs_backends_git_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_git_register_type (GTypeModule * module);
gboolean vtg_vcs_backends_vcs_base_test (VtgVcsBackendsVcsBase* self, const char* path);
VtgVcsBackendsBzr* vtg_vcs_backends_bzr_new (void);
VtgVcsBackendsBzr* vtg_vcs_backends_bzr_construct (GType object_type);
GType vtg_vcs_backends_bzr_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_bzr_register_type (GTypeModule * module);
VtgVcsBackendsSvn* vtg_vcs_backends_svn_new (void);
VtgVcsBackendsSvn* vtg_vcs_backends_svn_construct (GType object_type);
GType vtg_vcs_backends_svn_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_svn_register_type (GTypeModule * module);
void vtg_project_manager_close (VtgProjectManager* self);
gboolean vtg_string_utils_is_null_or_empty (const char* data);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
char* vtg_utils_get_stock_id_for_target_type (VbfTargetTypes type);
static gint vtg_project_manager_sort_model (VtgProjectManager* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _vtg_project_manager_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
gint vtg_path_utils_compare_vala_filenames (const char* filea, const char* fileb);
GtkTreeModel* vtg_project_manager_get_model (VtgProjectManager* self);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
gboolean vtg_project_manager_get_automanaged (VtgProjectManager* self);
void vtg_project_manager_set_automanaged (VtgProjectManager* self, gboolean value);
gboolean vtg_project_manager_get_enable_completion (VtgProjectManager* self);
void vtg_project_manager_set_enable_completion (VtgProjectManager* self, gboolean value);
ValaHashMap* vtg_project_manager_get_completions (VtgProjectManager* self);
static void vtg_project_manager_finalize (GObject* obj);
static void vtg_project_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void vtg_project_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

VtgProjectManager* vtg_project_manager_construct (GType object_type, gboolean enable_completion) {
	VtgProjectManager * self;
	self = (VtgProjectManager*) g_object_new (object_type, NULL);
	self->priv->_enable_completion = enable_completion;
	return self;
}


VtgProjectManager* vtg_project_manager_new (gboolean enable_completion) {
	return vtg_project_manager_construct (VTG_TYPE_PROJECT_MANAGER, enable_completion);
}


AfroditeCompletionEngine* vtg_project_manager_get_completion_for_file (VtgProjectManager* self, const char* uri) {
	AfroditeCompletionEngine* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (uri != NULL) {
		_tmp0_ = self->priv->_completions != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaList* _tmp1_;
			ValaIterator* _tmp2_;
			ValaIterator* _group_it;
			_group_it = (_tmp2_ = vala_iterable_iterator ((ValaIterable*) (_tmp1_ = vbf_project_get_groups (self->priv->_project))), _vala_collection_object_unref0 (_tmp1_), _tmp2_);
			while (TRUE) {
				VbfGroup* group;
				if (!vala_iterator_next (_group_it)) {
					break;
				}
				group = (VbfGroup*) vala_iterator_get (_group_it);
				{
					ValaList* _tmp3_;
					ValaIterator* _tmp4_;
					ValaIterator* _target_it;
					_target_it = (_tmp4_ = vala_iterable_iterator ((ValaIterable*) (_tmp3_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp3_), _tmp4_);
					while (TRUE) {
						VbfTarget* target;
						if (!vala_iterator_next (_target_it)) {
							break;
						}
						target = (VbfTarget*) vala_iterator_get (_target_it);
						{
							ValaList* _tmp5_;
							ValaIterator* _tmp6_;
							ValaIterator* _source_it;
							_source_it = (_tmp6_ = vala_iterable_iterator ((ValaIterable*) (_tmp5_ = vbf_target_get_sources (target))), _vala_collection_object_unref0 (_tmp5_), _tmp6_);
							while (TRUE) {
								VbfSource* source;
								if (!vala_iterator_next (_source_it)) {
									break;
								}
								source = (VbfSource*) vala_iterator_get (_source_it);
								if (_vala_strcmp0 (((VbfFile*) source)->uri, uri) == 0) {
									result = vtg_project_manager_get_completion_for_target (self, target);
									_g_object_unref0 (source);
									_vala_collection_object_unref0 (_source_it);
									_g_object_unref0 (target);
									_vala_collection_object_unref0 (_target_it);
									_g_object_unref0 (group);
									_vala_collection_object_unref0 (_group_it);
									return result;
								}
								_g_object_unref0 (source);
							}
							_vala_collection_object_unref0 (_source_it);
						}
						_g_object_unref0 (target);
					}
					_vala_collection_object_unref0 (_target_it);
				}
				_g_object_unref0 (group);
			}
			_vala_collection_object_unref0 (_group_it);
		}
	}
	result = NULL;
	return result;
}


AfroditeCompletionEngine* vtg_project_manager_get_completion_for_target (VtgProjectManager* self, VbfTarget* target) {
	AfroditeCompletionEngine* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	if (self->priv->_completions != NULL) {
		{
			ValaSet* _tmp0_;
			ValaIterator* _tmp1_;
			ValaIterator* _key_it;
			_key_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_map_get_keys ((ValaMap*) self->priv->_completions))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				VbfTarget* key;
				if (!vala_iterator_next (_key_it)) {
					break;
				}
				key = (VbfTarget*) vala_iterator_get (_key_it);
				if (_vala_strcmp0 (key->id, target->id) == 0) {
					result = (AfroditeCompletionEngine*) vala_map_get ((ValaMap*) self->priv->_completions, key);
					_g_object_unref0 (key);
					_vala_collection_object_unref0 (_key_it);
					return result;
				}
				_g_object_unref0 (key);
			}
			_vala_collection_object_unref0 (_key_it);
		}
	}
	result = NULL;
	return result;
}


gboolean vtg_project_manager_contains_filename (VtgProjectManager* self, const char* filename) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (filename != NULL) {
		{
			ValaList* _tmp0_;
			ValaIterator* _tmp1_;
			ValaIterator* _group_it;
			_group_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vbf_project_get_groups (self->priv->_project))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				VbfGroup* group;
				if (!vala_iterator_next (_group_it)) {
					break;
				}
				group = (VbfGroup*) vala_iterator_get (_group_it);
				{
					ValaList* _tmp2_;
					ValaIterator* _tmp3_;
					ValaIterator* _target_it;
					_target_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
					while (TRUE) {
						VbfTarget* target;
						if (!vala_iterator_next (_target_it)) {
							break;
						}
						target = (VbfTarget*) vala_iterator_get (_target_it);
						{
							ValaList* _tmp4_;
							ValaIterator* _tmp5_;
							ValaIterator* _source_it;
							_source_it = (_tmp5_ = vala_iterable_iterator ((ValaIterable*) (_tmp4_ = vbf_target_get_sources (target))), _vala_collection_object_unref0 (_tmp4_), _tmp5_);
							while (TRUE) {
								VbfSource* source;
								if (!vala_iterator_next (_source_it)) {
									break;
								}
								source = (VbfSource*) vala_iterator_get (_source_it);
								{
									char* _tmp6_;
									char* _tmp7_;
									gboolean _tmp8_;
									_tmp6_ = g_filename_from_uri (((VbfFile*) source)->uri, NULL, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == G_CONVERT_ERROR) {
											goto __catch37_g_convert_error;
										}
										_g_object_unref0 (source);
										_vala_collection_object_unref0 (_source_it);
										_g_object_unref0 (target);
										_vala_collection_object_unref0 (_target_it);
										_g_object_unref0 (group);
										_vala_collection_object_unref0 (_group_it);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
									if ((_tmp8_ = _vala_strcmp0 (_tmp7_ = _tmp6_, filename) == 0, _g_free0 (_tmp7_), _tmp8_)) {
										result = TRUE;
										_g_object_unref0 (source);
										_vala_collection_object_unref0 (_source_it);
										_g_object_unref0 (target);
										_vala_collection_object_unref0 (_target_it);
										_g_object_unref0 (group);
										_vala_collection_object_unref0 (_group_it);
										return result;
									}
								}
								goto __finally37;
								__catch37_g_convert_error:
								{
									GError * err;
									err = _inner_error_;
									_inner_error_ = NULL;
									{
										g_warning ("vtgprojectmanager.vala:138: error converting uri %s to filename: %s", ((VbfFile*) source)->uri, err->message);
										_g_error_free0 (err);
									}
								}
								__finally37:
								if (_inner_error_ != NULL) {
									_g_object_unref0 (source);
									_vala_collection_object_unref0 (_source_it);
									_g_object_unref0 (target);
									_vala_collection_object_unref0 (_target_it);
									_g_object_unref0 (group);
									_vala_collection_object_unref0 (_group_it);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
								_g_object_unref0 (source);
							}
							_vala_collection_object_unref0 (_source_it);
						}
						{
							ValaList* _tmp9_;
							ValaIterator* _tmp10_;
							ValaIterator* _file_it;
							_file_it = (_tmp10_ = vala_iterable_iterator ((ValaIterable*) (_tmp9_ = vbf_target_get_files (target))), _vala_collection_object_unref0 (_tmp9_), _tmp10_);
							while (TRUE) {
								VbfFile* file;
								if (!vala_iterator_next (_file_it)) {
									break;
								}
								file = (VbfFile*) vala_iterator_get (_file_it);
								{
									char* _tmp11_;
									char* _tmp12_;
									gboolean _tmp13_;
									_tmp11_ = g_filename_from_uri (file->uri, NULL, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == G_CONVERT_ERROR) {
											goto __catch38_g_convert_error;
										}
										_g_object_unref0 (file);
										_vala_collection_object_unref0 (_file_it);
										_g_object_unref0 (target);
										_vala_collection_object_unref0 (_target_it);
										_g_object_unref0 (group);
										_vala_collection_object_unref0 (_group_it);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
									if ((_tmp13_ = _vala_strcmp0 (_tmp12_ = _tmp11_, filename) == 0, _g_free0 (_tmp12_), _tmp13_)) {
										result = TRUE;
										_g_object_unref0 (file);
										_vala_collection_object_unref0 (_file_it);
										_g_object_unref0 (target);
										_vala_collection_object_unref0 (_target_it);
										_g_object_unref0 (group);
										_vala_collection_object_unref0 (_group_it);
										return result;
									}
								}
								goto __finally38;
								__catch38_g_convert_error:
								{
									GError * err;
									err = _inner_error_;
									_inner_error_ = NULL;
									{
										g_warning ("vtgprojectmanager.vala:147: error converting uri %s to filename: %s", file->uri, err->message);
										_g_error_free0 (err);
									}
								}
								__finally38:
								if (_inner_error_ != NULL) {
									_g_object_unref0 (file);
									_vala_collection_object_unref0 (_file_it);
									_g_object_unref0 (target);
									_vala_collection_object_unref0 (_target_it);
									_g_object_unref0 (group);
									_vala_collection_object_unref0 (_group_it);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
								_g_object_unref0 (file);
							}
							_vala_collection_object_unref0 (_file_it);
						}
						_g_object_unref0 (target);
					}
					_vala_collection_object_unref0 (_target_it);
				}
				_g_object_unref0 (group);
			}
			_vala_collection_object_unref0 (_group_it);
		}
	}
	result = FALSE;
	return result;
}


VbfSource* vtg_project_manager_get_source_file_from_uri (VtgProjectManager* self, const char* uri) {
	VbfSource* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (uri != NULL) {
		{
			ValaList* _tmp0_;
			ValaIterator* _tmp1_;
			ValaIterator* _group_it;
			_group_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vbf_project_get_groups (self->priv->_project))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				VbfGroup* group;
				if (!vala_iterator_next (_group_it)) {
					break;
				}
				group = (VbfGroup*) vala_iterator_get (_group_it);
				{
					ValaList* _tmp2_;
					ValaIterator* _tmp3_;
					ValaIterator* _target_it;
					_target_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
					while (TRUE) {
						VbfTarget* target;
						if (!vala_iterator_next (_target_it)) {
							break;
						}
						target = (VbfTarget*) vala_iterator_get (_target_it);
						{
							ValaList* _tmp4_;
							ValaIterator* _tmp5_;
							ValaIterator* _source_it;
							_source_it = (_tmp5_ = vala_iterable_iterator ((ValaIterable*) (_tmp4_ = vbf_target_get_sources (target))), _vala_collection_object_unref0 (_tmp4_), _tmp5_);
							while (TRUE) {
								VbfSource* source;
								if (!vala_iterator_next (_source_it)) {
									break;
								}
								source = (VbfSource*) vala_iterator_get (_source_it);
								if (_vala_strcmp0 (((VbfFile*) source)->uri, uri) == 0) {
									result = source;
									_vala_collection_object_unref0 (_source_it);
									_g_object_unref0 (target);
									_vala_collection_object_unref0 (_target_it);
									_g_object_unref0 (group);
									_vala_collection_object_unref0 (_group_it);
									return result;
								}
								_g_object_unref0 (source);
							}
							_vala_collection_object_unref0 (_source_it);
						}
						_g_object_unref0 (target);
					}
					_vala_collection_object_unref0 (_target_it);
				}
				_g_object_unref0 (group);
			}
			_vala_collection_object_unref0 (_group_it);
		}
	}
	result = NULL;
	return result;
}


VbfSource* vtg_project_manager_get_source_file_for_filename (VtgProjectManager* self, const char* filename) {
	VbfSource* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (filename != NULL) {
		{
			ValaList* _tmp0_;
			ValaIterator* _tmp1_;
			ValaIterator* _group_it;
			_group_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vbf_project_get_groups (self->priv->_project))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				VbfGroup* group;
				if (!vala_iterator_next (_group_it)) {
					break;
				}
				group = (VbfGroup*) vala_iterator_get (_group_it);
				{
					ValaList* _tmp2_;
					ValaIterator* _tmp3_;
					ValaIterator* _target_it;
					_target_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
					while (TRUE) {
						VbfTarget* target;
						if (!vala_iterator_next (_target_it)) {
							break;
						}
						target = (VbfTarget*) vala_iterator_get (_target_it);
						{
							ValaList* _tmp4_;
							ValaIterator* _tmp5_;
							ValaIterator* _source_it;
							_source_it = (_tmp5_ = vala_iterable_iterator ((ValaIterable*) (_tmp4_ = vbf_target_get_sources (target))), _vala_collection_object_unref0 (_tmp4_), _tmp5_);
							while (TRUE) {
								VbfSource* source;
								if (!vala_iterator_next (_source_it)) {
									break;
								}
								source = (VbfSource*) vala_iterator_get (_source_it);
								if (_vala_strcmp0 (((VbfFile*) source)->filename, filename) == 0) {
									result = source;
									_vala_collection_object_unref0 (_source_it);
									_g_object_unref0 (target);
									_vala_collection_object_unref0 (_target_it);
									_g_object_unref0 (group);
									_vala_collection_object_unref0 (_group_it);
									return result;
								}
								_g_object_unref0 (source);
							}
							_vala_collection_object_unref0 (_source_it);
						}
						_g_object_unref0 (target);
					}
					_vala_collection_object_unref0 (_target_it);
				}
				_g_object_unref0 (group);
			}
			_vala_collection_object_unref0 (_group_it);
		}
	}
	result = NULL;
	return result;
}


gboolean vtg_project_manager_contains_vala_source_file (VtgProjectManager* self, const char* uri) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (uri != NULL) {
		{
			ValaIterator* _source_it;
			_source_it = vala_iterable_iterator ((ValaIterable*) self->all_vala_sources);
			while (TRUE) {
				VbfSource* source;
				if (!vala_iterator_next (_source_it)) {
					break;
				}
				source = (VbfSource*) vala_iterator_get (_source_it);
				if (_vala_strcmp0 (((VbfFile*) source)->uri, uri) == 0) {
					result = TRUE;
					_g_object_unref0 (source);
					_vala_collection_object_unref0 (_source_it);
					return result;
				}
				_g_object_unref0 (source);
			}
			_vala_collection_object_unref0 (_source_it);
		}
	}
	result = FALSE;
	return result;
}


char* vtg_project_manager_source_uri_for_name (VtgProjectManager* self, const char* name) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (name != NULL) {
		gint name_parts_length1;
		gint _name_parts_size_;
		char** _tmp1_;
		char** _tmp0_;
		char** name_parts;
		name_parts = (_tmp1_ = _tmp0_ = g_strsplit (name, "/", 0), name_parts_length1 = _vala_array_length (_tmp0_), _name_parts_size_ = name_parts_length1, _tmp1_);
		{
			ValaList* _tmp2_;
			ValaIterator* _tmp3_;
			ValaIterator* _group_it;
			_group_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vbf_project_get_groups (self->priv->_project))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
			while (TRUE) {
				VbfGroup* group;
				if (!vala_iterator_next (_group_it)) {
					break;
				}
				group = (VbfGroup*) vala_iterator_get (_group_it);
				{
					ValaList* _tmp4_;
					ValaIterator* _tmp5_;
					ValaIterator* _target_it;
					_target_it = (_tmp5_ = vala_iterable_iterator ((ValaIterable*) (_tmp4_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp4_), _tmp5_);
					while (TRUE) {
						VbfTarget* target;
						if (!vala_iterator_next (_target_it)) {
							break;
						}
						target = (VbfTarget*) vala_iterator_get (_target_it);
						{
							ValaList* _tmp6_;
							ValaIterator* _tmp7_;
							ValaIterator* _source_it;
							_source_it = (_tmp7_ = vala_iterable_iterator ((ValaIterable*) (_tmp6_ = vbf_target_get_sources (target))), _vala_collection_object_unref0 (_tmp6_), _tmp7_);
							while (TRUE) {
								VbfSource* source;
								if (!vala_iterator_next (_source_it)) {
									break;
								}
								source = (VbfSource*) vala_iterator_get (_source_it);
								if (name_parts_length1 == 1) {
									if (_vala_strcmp0 (((VbfFile*) source)->name, name) == 0) {
										result = g_strdup (((VbfFile*) source)->uri);
										_g_object_unref0 (source);
										_vala_collection_object_unref0 (_source_it);
										_g_object_unref0 (target);
										_vala_collection_object_unref0 (_target_it);
										_g_object_unref0 (group);
										_vala_collection_object_unref0 (_group_it);
										name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
										return result;
									}
								} else {
									if (((VbfFile*) source)->uri != NULL) {
										gint src_parts_length1;
										gint _src_parts_size_;
										char** _tmp9_;
										char** _tmp8_;
										char** src_parts;
										src_parts = (_tmp9_ = _tmp8_ = g_strsplit (((VbfFile*) source)->uri, "/", 0), src_parts_length1 = _vala_array_length (_tmp8_), _src_parts_size_ = src_parts_length1, _tmp9_);
										if (name_parts_length1 <= src_parts_length1) {
											gboolean equals;
											equals = TRUE;
											{
												gint idx;
												idx = 0;
												{
													gboolean _tmp10_;
													_tmp10_ = TRUE;
													while (TRUE) {
														if (!_tmp10_) {
															idx++;
														}
														_tmp10_ = FALSE;
														if (!(idx < name_parts_length1)) {
															break;
														}
														if (_vala_strcmp0 (src_parts[src_parts_length1 - idx], name_parts[name_parts_length1 - idx]) != 0) {
															equals = FALSE;
															break;
														}
													}
												}
											}
											if (equals) {
												result = g_strdup (((VbfFile*) source)->uri);
												src_parts = (_vala_array_free (src_parts, src_parts_length1, (GDestroyNotify) g_free), NULL);
												_g_object_unref0 (source);
												_vala_collection_object_unref0 (_source_it);
												_g_object_unref0 (target);
												_vala_collection_object_unref0 (_target_it);
												_g_object_unref0 (group);
												_vala_collection_object_unref0 (_group_it);
												name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
												return result;
											}
										}
										src_parts = (_vala_array_free (src_parts, src_parts_length1, (GDestroyNotify) g_free), NULL);
									}
								}
								_g_object_unref0 (source);
							}
							_vala_collection_object_unref0 (_source_it);
						}
						_g_object_unref0 (target);
					}
					_vala_collection_object_unref0 (_target_it);
				}
				_g_object_unref0 (group);
			}
			_vala_collection_object_unref0 (_group_it);
		}
		name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
	}
	result = NULL;
	return result;
}


static void _vtg_project_manager_on_project_updated_vbf_project_updated (VbfProject* _sender, gpointer self) {
	vtg_project_manager_on_project_updated (self, _sender);
}


void vtg_project_manager_create_default_project (VtgProjectManager* self) {
	VbfProject* _tmp0_;
	char* _tmp1_;
	VbfGroup* group;
	VbfTarget* target;
	g_return_if_fail (self != NULL);
	self->priv->_project = (_tmp0_ = vbf_project_new ("vtg-default-project"), _g_object_unref0 (self->priv->_project), _tmp0_);
	self->priv->_project->name = (_tmp1_ = g_strdup (_ ("default project")), _g_free0 (self->priv->_project->name), _tmp1_);
	group = vbf_group_new (self->priv->_project, "Sources");
	target = vbf_target_new (group, VBF_TARGET_TYPES_PROGRAM, "Default");
	vbf_group_add_target (group, target);
	vbf_project_add_group (self->priv->_project, group);
	g_signal_connect_object (self->priv->_project, "updated", (GCallback) _vtg_project_manager_on_project_updated_vbf_project_updated, self, 0);
	self->is_default = TRUE;
	_g_object_unref0 (target);
	_g_object_unref0 (group);
}


gboolean vtg_project_manager_open (VtgProjectManager* self, const char* project_filename, GError** error) {
	gboolean result = FALSE;
	VbfIProjectBackend* backend;
	VbfIProjectBackend* _tmp0_ = NULL;
	gboolean _tmp1_;
	VbfIProjectBackend* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_filename != NULL, FALSE);
	if (!g_file_test (project_filename, (G_FILE_TEST_IS_DIR | G_FILE_TEST_IS_REGULAR) | G_FILE_TEST_EXISTS)) {
		_inner_error_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _ ("Can't load project, file not found"));
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	backend = NULL;
	if ((_tmp1_ = vbf_probe (project_filename, &_tmp0_), backend = (_tmp2_ = _tmp0_, _g_object_unref0 (backend), _tmp2_), _tmp1_)) {
		VbfProject* _tmp3_;
		self->priv->_project = (_tmp3_ = vbf_iproject_backend_open (backend, project_filename), _g_object_unref0 (self->priv->_project), _tmp3_);
		if (self->priv->_project == NULL) {
			result = FALSE;
			_g_object_unref0 (backend);
			return result;
		}
		vtg_project_manager_parse_project (self);
		vtg_project_manager_setup_completions (self);
		vtg_project_manager_build_tree_model (self);
		vtg_project_manager_vcs_test (self, project_filename);
		g_signal_connect_object (self->priv->_project, "updated", (GCallback) _vtg_project_manager_on_project_updated_vbf_project_updated, self, 0);
		result = TRUE;
		_g_object_unref0 (backend);
		return result;
	} else {
		_inner_error_ = g_error_new_literal (VTG_PROJECT_MANAGER_ERROR, VTG_PROJECT_MANAGER_ERROR_NO_BACKEND, _ ("Can't load project, no suitable backend found"));
		{
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (backend);
			return FALSE;
		}
	}
	_g_object_unref0 (backend);
}


static gboolean vtg_project_manager_target_has_vala_source (VtgProjectManager* self, VbfTarget* target) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target != NULL, FALSE);
	{
		ValaList* _tmp0_;
		ValaIterator* _tmp1_;
		ValaIterator* _source_it;
		_source_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vbf_target_get_sources (target))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			VbfSource* source;
			if (!vala_iterator_next (_source_it)) {
				break;
			}
			source = (VbfSource*) vala_iterator_get (_source_it);
			if (((VbfFile*) source)->type == VBF_FILE_TYPES_VALA_SOURCE) {
				result = TRUE;
				_g_object_unref0 (source);
				_vala_collection_object_unref0 (_source_it);
				return result;
			}
			_g_object_unref0 (source);
		}
		_vala_collection_object_unref0 (_source_it);
	}
	result = FALSE;
	return result;
}


static void _vtg_project_manager_on_completion_engine_begin_parse_afrodite_completion_engine_begin_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self) {
	vtg_project_manager_on_completion_engine_begin_parse (self, sender);
}


static void _vtg_project_manager_on_completion_engine_end_parse_afrodite_completion_engine_end_parsing (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, gpointer self) {
	vtg_project_manager_on_completion_engine_end_parse (self, sender);
}


static void _vtg_project_manager_on_completion_engine_file_parsed_afrodite_completion_engine_file_parsed (AfroditeCompletionEngine* _sender, AfroditeCompletionEngine* sender, const char* filename, AfroditeParseResult* parse_result, gpointer self) {
	vtg_project_manager_on_completion_engine_file_parsed (self, sender, filename, parse_result);
}


static void vtg_project_manager_setup_completions (VtgProjectManager* self) {
	ValaHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	if (!self->priv->_enable_completion) {
		return;
	}
	self->priv->_completions = (_tmp0_ = vala_hash_map_new (VBF_TYPE_TARGET, (GBoxedCopyFunc) g_object_ref, g_object_unref, AFRODITE_TYPE_COMPLETION_ENGINE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), _vala_collection_object_unref0 (self->priv->_completions), _tmp0_);
	{
		ValaList* _tmp1_;
		ValaIterator* _tmp2_;
		ValaIterator* _group_it;
		_group_it = (_tmp2_ = vala_iterable_iterator ((ValaIterable*) (_tmp1_ = vbf_project_get_groups (self->priv->_project))), _vala_collection_object_unref0 (_tmp1_), _tmp2_);
		while (TRUE) {
			VbfGroup* group;
			if (!vala_iterator_next (_group_it)) {
				break;
			}
			group = (VbfGroup*) vala_iterator_get (_group_it);
			{
				ValaList* _tmp3_;
				ValaIterator* _tmp4_;
				ValaIterator* _target_it;
				_target_it = (_tmp4_ = vala_iterable_iterator ((ValaIterable*) (_tmp3_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp3_), _tmp4_);
				while (TRUE) {
					VbfTarget* target;
					AfroditeCompletionEngine* completion;
					ValaList* vapis;
					gint vapi_dirs_length1;
					gint _vapi_dirs_size_;
					char** _tmp8_;
					gint _tmp7_;
					char** vapi_dirs;
					gint index;
					if (!vala_iterator_next (_target_it)) {
						break;
					}
					target = (VbfTarget*) vala_iterator_get (_target_it);
					if (!vtg_project_manager_target_has_vala_source (self, target)) {
						_g_object_unref0 (target);
						continue;
					}
					completion = afrodite_completion_engine_new (target->name);
					g_signal_connect_object (completion, "begin-parsing", (GCallback) _vtg_project_manager_on_completion_engine_begin_parse_afrodite_completion_engine_begin_parsing, self, 0);
					g_signal_connect_object (completion, "end-parsing", (GCallback) _vtg_project_manager_on_completion_engine_end_parse_afrodite_completion_engine_end_parsing, self, 0);
					g_signal_connect_object (completion, "file-parsed", (GCallback) _vtg_project_manager_on_completion_engine_file_parsed_afrodite_completion_engine_file_parsed, self, 0);
					vala_map_set ((ValaMap*) self->priv->_completions, target, completion);
					{
						ValaList* _tmp5_;
						ValaIterator* _tmp6_;
						ValaIterator* _path_it;
						_path_it = (_tmp6_ = vala_iterable_iterator ((ValaIterable*) (_tmp5_ = vbf_target_get_include_dirs (target))), _vala_collection_object_unref0 (_tmp5_), _tmp6_);
						while (TRUE) {
							char* path;
							if (!vala_iterator_next (_path_it)) {
								break;
							}
							path = (char*) vala_iterator_get (_path_it);
							afrodite_completion_engine_add_vapi_dir (completion, path);
							_g_free0 (path);
						}
						_vala_collection_object_unref0 (_path_it);
					}
					vapis = vbf_target_get_include_dirs (target);
					vapi_dirs = (_tmp8_ = g_new0 (char*, (_tmp7_ = vala_collection_get_size ((ValaCollection*) vapis)) + 1), vapi_dirs_length1 = _tmp7_, _vapi_dirs_size_ = vapi_dirs_length1, _tmp8_);
					index = 0;
					{
						ValaIterator* _item_it;
						_item_it = vala_iterable_iterator ((ValaIterable*) vapis);
						while (TRUE) {
							char* item;
							char* *_tmp9_;
							char* _tmp10_;
							if (!vala_iterator_next (_item_it)) {
								break;
							}
							item = (char*) vala_iterator_get (_item_it);
							_tmp9_ = &vapi_dirs[index++];
							(*_tmp9_) = (_tmp10_ = g_strdup (item), _g_free0 ((*_tmp9_)), _tmp10_);
							_g_free0 (item);
						}
						_vala_collection_object_unref0 (_item_it);
					}
					{
						ValaList* _tmp11_;
						ValaIterator* _tmp12_;
						ValaIterator* _package_it;
						_package_it = (_tmp12_ = vala_iterable_iterator ((ValaIterable*) (_tmp11_ = vbf_target_get_packages (target))), _vala_collection_object_unref0 (_tmp11_), _tmp12_);
						while (TRUE) {
							VbfPackage* package;
							ValaList* paths;
							if (!vala_iterator_next (_package_it)) {
								break;
							}
							package = (VbfPackage*) vala_iterator_get (_package_it);
							vtg_utils_trace ("vtgprojectmanager.vala:316: setup_completions: target %s, referenced p" \
"ackage: %s", target->id, package->id);
							paths = afrodite_utils_get_package_paths (package->id, NULL, vapi_dirs, vapi_dirs_length1);
							if (paths != NULL) {
								afrodite_completion_engine_queue_sourcefiles (completion, paths, NULL, TRUE, FALSE);
							} else {
								vtg_utils_trace ("vtgprojectmanager.vala:323: setup_completions: target %s, no vapi foun" \
"d for: %s", target->id, package->id);
							}
							_vala_collection_object_unref0 (paths);
							_g_object_unref0 (package);
						}
						_vala_collection_object_unref0 (_package_it);
					}
					{
						ValaList* _tmp13_;
						ValaIterator* _tmp14_;
						ValaIterator* _source_it;
						_source_it = (_tmp14_ = vala_iterable_iterator ((ValaIterable*) (_tmp13_ = vbf_target_get_sources (target))), _vala_collection_object_unref0 (_tmp13_), _tmp14_);
						while (TRUE) {
							VbfSource* source;
							if (!vala_iterator_next (_source_it)) {
								break;
							}
							source = (VbfSource*) vala_iterator_get (_source_it);
							if (((VbfFile*) source)->type == VBF_FILE_TYPES_VALA_SOURCE) {
								vtg_utils_trace ("vtgprojectmanager.vala:330: setup_completions: source %s", ((VbfFile*) source)->filename);
								if (g_file_test (((VbfFile*) source)->filename, (G_FILE_TEST_EXISTS | G_FILE_TEST_IS_SYMLINK) | G_FILE_TEST_IS_REGULAR)) {
									afrodite_completion_engine_queue_sourcefile (completion, ((VbfFile*) source)->filename, NULL, FALSE, FALSE);
								}
							}
							_g_object_unref0 (source);
						}
						_vala_collection_object_unref0 (_source_it);
					}
					{
						ValaIterator* _instance_it;
						_instance_it = vala_iterable_iterator ((ValaIterable*) vtg_plugin_get_instances (vtg_plugin_main_instance));
						while (TRUE) {
							VtgPluginInstance* instance;
							if (!vala_iterator_next (_instance_it)) {
								break;
							}
							instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
							vtg_plugin_instance_bind_completion_engine_with_target (instance, target, completion);
							_g_object_unref0 (instance);
						}
						_vala_collection_object_unref0 (_instance_it);
					}
					vapi_dirs = (_vala_array_free (vapi_dirs, vapi_dirs_length1, (GDestroyNotify) g_free), NULL);
					_vala_collection_object_unref0 (vapis);
					_g_object_unref0 (completion);
					_g_object_unref0 (target);
				}
				_vala_collection_object_unref0 (_target_it);
			}
			_g_object_unref0 (group);
		}
		_vala_collection_object_unref0 (_group_it);
	}
}


static void vtg_project_manager_cleanup_completions (VtgProjectManager* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_completions != NULL) {
		ValaHashMap* _tmp5_;
		{
			ValaCollection* _tmp0_;
			ValaIterator* _tmp1_;
			ValaIterator* _completion_it;
			_completion_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_map_get_values ((ValaMap*) self->priv->_completions))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
			while (TRUE) {
				AfroditeCompletionEngine* completion;
				guint _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				if (!vala_iterator_next (_completion_it)) {
					break;
				}
				completion = (AfroditeCompletionEngine*) vala_iterator_get (_completion_it);
				g_signal_parse_name ("begin-parsing", AFRODITE_TYPE_COMPLETION_ENGINE, &_tmp2_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (completion, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _vtg_project_manager_on_completion_engine_begin_parse_afrodite_completion_engine_begin_parsing, self);
				g_signal_parse_name ("end-parsing", AFRODITE_TYPE_COMPLETION_ENGINE, &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (completion, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _vtg_project_manager_on_completion_engine_end_parse_afrodite_completion_engine_end_parsing, self);
				g_signal_parse_name ("file-parsed", AFRODITE_TYPE_COMPLETION_ENGINE, &_tmp4_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (completion, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _vtg_project_manager_on_completion_engine_file_parsed_afrodite_completion_engine_file_parsed, self);
				{
					ValaIterator* _instance_it;
					_instance_it = vala_iterable_iterator ((ValaIterable*) vtg_plugin_get_instances (vtg_plugin_main_instance));
					while (TRUE) {
						VtgPluginInstance* instance;
						if (!vala_iterator_next (_instance_it)) {
							break;
						}
						instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
						vtg_plugin_instance_unbind_completion_engine (instance, completion);
						_g_object_unref0 (instance);
					}
					_vala_collection_object_unref0 (_instance_it);
				}
				_g_object_unref0 (completion);
			}
			_vala_collection_object_unref0 (_completion_it);
		}
		vala_map_clear ((ValaMap*) self->priv->_completions);
		self->priv->_completions = (_tmp5_ = NULL, _vala_collection_object_unref0 (self->priv->_completions), _tmp5_);
	}
}


static gboolean _vtg_project_manager_on_idle_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_project_manager_on_idle (self);
	return result;
}


static void vtg_project_manager_on_completion_engine_begin_parse (VtgProjectManager* self, AfroditeCompletionEngine* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_signal_emit_by_name (self, "completion-begin-parsing", self, sender);
	if (g_atomic_int_exchange_and_add (&self->priv->parser_thread_count, 1) == 0) {
		if (self->priv->_idle_id == 0) {
			self->priv->_idle_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _vtg_project_manager_on_idle_gsource_func, g_object_ref (self), g_object_unref);
		}
	}
}


static void vtg_project_manager_on_completion_engine_end_parse (VtgProjectManager* self, AfroditeCompletionEngine* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_signal_emit_by_name (self, "completion-end-parsing", self, sender);
	if (g_atomic_int_dec_and_test (&self->priv->parser_thread_count)) {
		if (self->priv->_idle_id == 0) {
			self->priv->_idle_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _vtg_project_manager_on_idle_gsource_func, g_object_ref (self), g_object_unref);
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void vtg_project_manager_on_completion_engine_file_parsed (VtgProjectManager* self, AfroditeCompletionEngine* sender, const char* filename, AfroditeParseResult* parse_result) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (parse_result != NULL);
	{
		ValaIterator* _instance_it;
		_instance_it = vala_iterable_iterator ((ValaIterable*) vtg_plugin_get_instances (vtg_plugin_main_instance));
		while (TRUE) {
			VtgPluginInstance* instance;
			VtgBuildLogView* view;
			if (!vala_iterator_next (_instance_it)) {
				break;
			}
			instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
			view = _g_object_ref0 (vtg_project_builder_get_error_pane (vtg_project_manager_ui_get_project_builder (vtg_plugin_instance_get_project_manager_ui (instance))));
			vtg_build_log_view_clear_messages_for_source (view, filename);
			vtg_build_log_view_update_parse_result (view, filename, parse_result);
			_g_object_unref0 (view);
			_g_object_unref0 (instance);
		}
		_vala_collection_object_unref0 (_instance_it);
	}
}


static gboolean vtg_project_manager_on_idle (VtgProjectManager* self) {
	gboolean result = FALSE;
	gint val;
	g_return_val_if_fail (self != NULL, FALSE);
	val = g_atomic_int_get (&self->priv->parser_thread_count);
	if (val > 0) {
		if (!self->priv->_sc_building) {
			self->priv->_sc_building = TRUE;
			g_signal_emit_by_name (self, "symbol-cache-building", self);
		}
	} else {
		if (self->priv->_sc_building) {
			self->priv->_sc_building = FALSE;
			g_signal_emit_by_name (self, "symbol-cache-builded", self);
		}
	}
	self->priv->_idle_id = (guint) 0;
	result = FALSE;
	return result;
}


static void vtg_project_manager_vcs_test (VtgProjectManager* self, const char* filename) {
	VtgVcsBackendsVcsBase* backend;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	backend = (VtgVcsBackendsVcsBase*) vtg_vcs_backends_git_new ();
	self->vcs_type = VTG_VCS_TYPES_NONE;
	if (vtg_vcs_backends_vcs_base_test (backend, filename)) {
		self->vcs_type = VTG_VCS_TYPES_GIT;
	} else {
		VtgVcsBackendsVcsBase* _tmp0_;
		backend = (_tmp0_ = (VtgVcsBackendsVcsBase*) vtg_vcs_backends_bzr_new (), _g_object_unref0 (backend), _tmp0_);
		if (vtg_vcs_backends_vcs_base_test (backend, filename)) {
			self->vcs_type = VTG_VCS_TYPES_BZR;
		} else {
			VtgVcsBackendsVcsBase* _tmp1_;
			backend = (_tmp1_ = (VtgVcsBackendsVcsBase*) vtg_vcs_backends_svn_new (), _g_object_unref0 (backend), _tmp1_);
			if (vtg_vcs_backends_vcs_base_test (backend, filename)) {
				self->vcs_type = VTG_VCS_TYPES_SVN;
			}
		}
	}
	_g_object_unref0 (backend);
}


void vtg_project_manager_close (VtgProjectManager* self) {
	GtkTreeStore* _tmp0_;
	VbfProject* _tmp1_;
	g_return_if_fail (self != NULL);
	vala_collection_clear ((ValaCollection*) self->exec_targets);
	vala_collection_clear ((ValaCollection*) self->all_vala_sources);
	self->priv->_model = (_tmp0_ = NULL, _g_object_unref0 (self->priv->_model), _tmp0_);
	self->priv->_project = (_tmp1_ = NULL, _g_object_unref0 (self->priv->_project), _tmp1_);
}


static void vtg_project_manager_on_project_updated (VtgProjectManager* self, VbfProject* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	if (self->priv->in_update) {
		return;
	}
	self->priv->in_update = TRUE;
	vtg_project_manager_cleanup_completions (self);
	vtg_project_manager_parse_project (self);
	vtg_project_manager_build_tree_model (self);
	vtg_project_manager_setup_completions (self);
	g_signal_emit_by_name (self, "updated");
	self->priv->in_update = FALSE;
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static gint _vtg_project_manager_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = vtg_project_manager_sort_model (self, model, a, b);
	return result;
}


static void vtg_project_manager_build_tree_model (VtgProjectManager* self) {
	GtkTreeIter project_iter = {0};
	GtkTreeIter* modules_iter;
	GtkTreeIter groups_iter = {0};
	GtkTreeIter* group_iter;
	GtkTreeStore* _tmp0_;
	gboolean reference_added;
	g_return_if_fail (self != NULL);
	modules_iter = NULL;
	group_iter = NULL;
	self->priv->_model = (_tmp0_ = gtk_tree_store_new (5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_OBJECT, G_TYPE_STRING), _g_object_unref0 (self->priv->_model), _tmp0_);
	gtk_tree_store_append (self->priv->_model, &project_iter, NULL);
	if (vtg_string_utils_is_null_or_empty (self->priv->_project->version)) {
		char* _tmp1_;
		gtk_tree_store_set (self->priv->_model, &project_iter, 0, GTK_STOCK_DIRECTORY, 1, _tmp1_ = g_strdup_printf ("%s", self->priv->_project->name), 2, "project-root", 4, "", -1);
		_g_free0 (_tmp1_);
	} else {
		char* _tmp2_;
		gtk_tree_store_set (self->priv->_model, &project_iter, 0, GTK_STOCK_DIRECTORY, 1, _tmp2_ = g_strdup_printf ("%s - %s", self->priv->_project->name, self->priv->_project->version), 2, "project-root", 4, "", -1);
		_g_free0 (_tmp2_);
	}
	reference_added = FALSE;
	{
		ValaList* _tmp3_;
		ValaIterator* _tmp4_;
		ValaIterator* _module_it;
		_module_it = (_tmp4_ = vala_iterable_iterator ((ValaIterable*) (_tmp3_ = vbf_project_get_modules (self->priv->_project))), _vala_collection_object_unref0 (_tmp3_), _tmp4_);
		while (TRUE) {
			VbfModule* module;
			GtkTreeIter module_iter = {0};
			if (!vala_iterator_next (_module_it)) {
				break;
			}
			module = (VbfModule*) vala_iterator_get (_module_it);
			if (!reference_added) {
				GtkTreeIter _tmp5_ = {0};
				GtkTreeIter* _tmp6_;
				gtk_tree_store_append (self->priv->_model, &_tmp5_, &project_iter);
				modules_iter = (_tmp6_ = __gtk_tree_iter_dup0 (&_tmp5_), _g_free0 (modules_iter), _tmp6_);
				gtk_tree_store_set (self->priv->_model, modules_iter, 0, GTK_STOCK_DIRECTORY, 1, _ ("References"), 2, "project-reference", 4, "1", -1);
				reference_added = TRUE;
			}
			gtk_tree_store_append (self->priv->_model, &module_iter, modules_iter);
			gtk_tree_store_set (self->priv->_model, &module_iter, 0, GTK_STOCK_DIRECTORY, 1, module->name, 2, module->id, 3, module, 4, module->name, -1);
			{
				ValaList* _tmp7_;
				ValaIterator* _tmp8_;
				ValaIterator* _package_it;
				_package_it = (_tmp8_ = vala_iterable_iterator ((ValaIterable*) (_tmp7_ = vbf_module_get_packages (module))), _vala_collection_object_unref0 (_tmp7_), _tmp8_);
				while (TRUE) {
					VbfPackage* package;
					GtkTreeIter package_iter = {0};
					if (!vala_iterator_next (_package_it)) {
						break;
					}
					package = (VbfPackage*) vala_iterator_get (_package_it);
					gtk_tree_store_append (self->priv->_model, &package_iter, &module_iter);
					gtk_tree_store_set (self->priv->_model, &package_iter, 0, GTK_STOCK_FILE, 1, package->name, 2, package->id, 3, package, 4, package->name, -1);
					_g_object_unref0 (package);
				}
				_vala_collection_object_unref0 (_package_it);
			}
			_g_object_unref0 (module);
		}
		_vala_collection_object_unref0 (_module_it);
	}
	gtk_tree_store_append (self->priv->_model, &groups_iter, &project_iter);
	gtk_tree_store_set (self->priv->_model, &groups_iter, 0, GTK_STOCK_DIRECTORY, 1, _ ("Files"), 2, "project-files", 4, "2", -1);
	{
		ValaList* _tmp9_;
		ValaIterator* _tmp10_;
		ValaIterator* _group_it;
		_group_it = (_tmp10_ = vala_iterable_iterator ((ValaIterable*) (_tmp9_ = vbf_project_get_groups (self->priv->_project))), _vala_collection_object_unref0 (_tmp9_), _tmp10_);
		while (TRUE) {
			VbfGroup* group;
			gboolean group_added;
			if (!vala_iterator_next (_group_it)) {
				break;
			}
			group = (VbfGroup*) vala_iterator_get (_group_it);
			group_added = FALSE;
			{
				ValaList* _tmp11_;
				ValaIterator* _tmp12_;
				ValaIterator* _target_it;
				_target_it = (_tmp12_ = vala_iterable_iterator ((ValaIterable*) (_tmp11_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp11_), _tmp12_);
				while (TRUE) {
					VbfTarget* target;
					gboolean _tmp13_ = FALSE;
					if (!vala_iterator_next (_target_it)) {
						break;
					}
					target = (VbfTarget*) vala_iterator_get (_target_it);
					if (vbf_target_has_sources_of_type (target, VBF_FILE_TYPES_VALA_SOURCE)) {
						_tmp13_ = TRUE;
					} else {
						ValaList* _tmp14_;
						_tmp13_ = vala_collection_get_size ((ValaCollection*) (_tmp14_ = vbf_target_get_files (target))) > 0;
						_vala_collection_object_unref0 (_tmp14_);
					}
					if (_tmp13_) {
						GtkTreeIter target_iter;
						GtkTreeIter vapi_group_iter;
						gboolean target_added;
						gboolean vapi_group_added;
						target_iter = groups_iter;
						vapi_group_iter = target_iter;
						target_added = FALSE;
						{
							ValaList* _tmp15_;
							ValaIterator* _tmp16_;
							ValaIterator* _source_it;
							_source_it = (_tmp16_ = vala_iterable_iterator ((ValaIterable*) (_tmp15_ = vbf_target_get_sources (target))), _vala_collection_object_unref0 (_tmp15_), _tmp16_);
							while (TRUE) {
								VbfSource* source;
								gboolean _tmp17_ = FALSE;
								gboolean _tmp18_ = FALSE;
								gboolean _tmp19_ = FALSE;
								GtkTreeIter source_iter = {0};
								if (!vala_iterator_next (_source_it)) {
									break;
								}
								source = (VbfSource*) vala_iterator_get (_source_it);
								if (g_str_has_prefix (((VbfFile*) source)->name, ".")) {
									_tmp19_ = TRUE;
								} else {
									_tmp19_ = g_str_has_suffix (((VbfFile*) source)->name, ".c");
								}
								if (_tmp19_) {
									_tmp18_ = TRUE;
								} else {
									_tmp18_ = g_str_has_suffix (((VbfFile*) source)->name, ".h");
								}
								if (_tmp18_) {
									_tmp17_ = TRUE;
								} else {
									_tmp17_ = g_str_has_suffix (((VbfFile*) source)->name, ".stamp");
								}
								if (_tmp17_) {
									_g_object_unref0 (source);
									continue;
								}
								if (!group_added) {
									GtkTreeIter _tmp20_ = {0};
									GtkTreeIter* _tmp21_;
									gtk_tree_store_append (self->priv->_model, &_tmp20_, &groups_iter);
									group_iter = (_tmp21_ = __gtk_tree_iter_dup0 (&_tmp20_), _g_free0 (group_iter), _tmp21_);
									gtk_tree_store_set (self->priv->_model, group_iter, 0, GTK_STOCK_DIRECTORY, 1, group->name, 2, "group-targets", 3, group, 4, "2", -1);
									group_added = TRUE;
								}
								if (!target_added) {
									char* _tmp22_;
									gtk_tree_store_append (self->priv->_model, &target_iter, group_iter);
									gtk_tree_store_set (self->priv->_model, &target_iter, 0, _tmp22_ = vtg_utils_get_stock_id_for_target_type (target->type), 1, target->name, 2, target->id, 3, target, 4, group->name, -1);
									_g_free0 (_tmp22_);
									target_added = TRUE;
								}
								gtk_tree_store_append (self->priv->_model, &source_iter, &target_iter);
								gtk_tree_store_set (self->priv->_model, &source_iter, 0, GTK_STOCK_FILE, 1, ((VbfFile*) source)->name, 2, ((VbfFile*) source)->uri, 3, source, 4, ((VbfFile*) source)->name, -1);
								_g_object_unref0 (source);
							}
							_vala_collection_object_unref0 (_source_it);
						}
						{
							ValaList* _tmp23_;
							ValaIterator* _tmp24_;
							ValaIterator* _file_it;
							_file_it = (_tmp24_ = vala_iterable_iterator ((ValaIterable*) (_tmp23_ = vbf_target_get_files (target))), _vala_collection_object_unref0 (_tmp23_), _tmp24_);
							while (TRUE) {
								VbfFile* file;
								GtkTreeIter file_iter = {0};
								if (!vala_iterator_next (_file_it)) {
									break;
								}
								file = (VbfFile*) vala_iterator_get (_file_it);
								if (!group_added) {
									GtkTreeIter _tmp25_ = {0};
									GtkTreeIter* _tmp26_;
									gtk_tree_store_append (self->priv->_model, &_tmp25_, &groups_iter);
									group_iter = (_tmp26_ = __gtk_tree_iter_dup0 (&_tmp25_), _g_free0 (group_iter), _tmp26_);
									gtk_tree_store_set (self->priv->_model, group_iter, 0, GTK_STOCK_DIRECTORY, 1, group->name, 2, "group-targets", 3, group, 4, "2", -1);
									group_added = TRUE;
								}
								if (!target_added) {
									char* _tmp27_;
									gtk_tree_store_append (self->priv->_model, &target_iter, group_iter);
									gtk_tree_store_set (self->priv->_model, &target_iter, 0, _tmp27_ = vtg_utils_get_stock_id_for_target_type (target->type), 1, target->name, 2, target->id, 3, target, 4, group->name, -1);
									_g_free0 (_tmp27_);
									target_added = TRUE;
								}
								gtk_tree_store_append (self->priv->_model, &file_iter, &target_iter);
								gtk_tree_store_set (self->priv->_model, &file_iter, 0, GTK_STOCK_FILE, 1, file->name, 2, file->uri, 3, file, 4, file->name, -1);
								_g_object_unref0 (file);
							}
							_vala_collection_object_unref0 (_file_it);
						}
						vapi_group_added = FALSE;
						{
							ValaList* _tmp28_;
							ValaIterator* _tmp29_;
							ValaIterator* _package_it;
							_package_it = (_tmp29_ = vala_iterable_iterator ((ValaIterable*) (_tmp28_ = vbf_target_get_packages (target))), _vala_collection_object_unref0 (_tmp28_), _tmp29_);
							while (TRUE) {
								VbfPackage* package;
								GtkTreeIter vapi_iter = {0};
								if (!vala_iterator_next (_package_it)) {
									break;
								}
								package = (VbfPackage*) vala_iterator_get (_package_it);
								if (!vapi_group_added) {
									gtk_tree_store_append (self->priv->_model, &vapi_group_iter, &target_iter);
									gtk_tree_store_set (self->priv->_model, &vapi_group_iter, 0, GTK_STOCK_DIRECTORY, 1, _ ("Referenced packages"), 2, "vapi-targets", 3, NULL, 4, "2", -1);
									vapi_group_added = TRUE;
								}
								gtk_tree_store_append (self->priv->_model, &vapi_iter, &vapi_group_iter);
								gtk_tree_store_set (self->priv->_model, &vapi_iter, 0, GTK_STOCK_FILE, 1, package->name, 2, vbf_package_get_uri (package), 3, package, 4, package->name, -1);
								_g_object_unref0 (package);
							}
							_vala_collection_object_unref0 (_package_it);
						}
					}
					_g_object_unref0 (target);
				}
				_vala_collection_object_unref0 (_target_it);
			}
			_g_object_unref0 (group);
		}
		_vala_collection_object_unref0 (_group_it);
	}
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->_model, 4, GTK_SORT_ASCENDING);
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self->priv->_model, 4, _vtg_project_manager_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	_g_free0 (group_iter);
	_g_free0 (modules_iter);
}


static void vtg_project_manager_parse_project (VtgProjectManager* self) {
	char* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	vala_collection_clear ((ValaCollection*) self->exec_targets);
	vala_collection_clear ((ValaCollection*) self->all_vala_sources);
	self->changelog_uri = (_tmp0_ = NULL, _g_free0 (self->changelog_uri), _tmp0_);
	{
		ValaList* _tmp1_;
		ValaIterator* _tmp2_;
		ValaIterator* _group_it;
		_group_it = (_tmp2_ = vala_iterable_iterator ((ValaIterable*) (_tmp1_ = vbf_project_get_groups (self->priv->_project))), _vala_collection_object_unref0 (_tmp1_), _tmp2_);
		while (TRUE) {
			VbfGroup* group;
			if (!vala_iterator_next (_group_it)) {
				break;
			}
			group = (VbfGroup*) vala_iterator_get (_group_it);
			{
				ValaList* _tmp3_;
				ValaIterator* _tmp4_;
				ValaIterator* _target_it;
				_target_it = (_tmp4_ = vala_iterable_iterator ((ValaIterable*) (_tmp3_ = vbf_group_get_targets (group))), _vala_collection_object_unref0 (_tmp3_), _tmp4_);
				while (TRUE) {
					VbfTarget* target;
					gboolean _tmp5_ = FALSE;
					if (!vala_iterator_next (_target_it)) {
						break;
					}
					target = (VbfTarget*) vala_iterator_get (_target_it);
					if (target->type == VBF_TARGET_TYPES_PROGRAM) {
						_tmp5_ = TRUE;
					} else {
						gboolean _tmp6_ = FALSE;
						if (target->type == VBF_TARGET_TYPES_BUILT_SOURCES) {
							_tmp6_ = !g_str_has_prefix (target->name, "lib");
						} else {
							_tmp6_ = FALSE;
						}
						_tmp5_ = _tmp6_;
					}
					if (_tmp5_) {
						vala_collection_add ((ValaCollection*) self->exec_targets, target);
					}
					{
						ValaList* _tmp7_;
						ValaIterator* _tmp8_;
						ValaIterator* _source_it;
						_source_it = (_tmp8_ = vala_iterable_iterator ((ValaIterable*) (_tmp7_ = vbf_target_get_sources (target))), _vala_collection_object_unref0 (_tmp7_), _tmp8_);
						while (TRUE) {
							VbfSource* source;
							if (!vala_iterator_next (_source_it)) {
								break;
							}
							source = (VbfSource*) vala_iterator_get (_source_it);
							if (((VbfFile*) source)->type == VBF_FILE_TYPES_VALA_SOURCE) {
								vala_collection_add ((ValaCollection*) self->all_vala_sources, source);
							}
							_g_object_unref0 (source);
						}
						_vala_collection_object_unref0 (_source_it);
					}
					_g_object_unref0 (target);
				}
				_vala_collection_object_unref0 (_target_it);
			}
			_g_object_unref0 (group);
		}
		_vala_collection_object_unref0 (_group_it);
	}
	{
		char* _tmp9_;
		gboolean _tmp10_;
		if ((_tmp10_ = g_file_test (_tmp9_ = g_build_filename (self->priv->_project->working_dir, "changelog", NULL), G_FILE_TEST_EXISTS), _g_free0 (_tmp9_), _tmp10_)) {
			char* _tmp11_;
			char* _tmp12_;
			char* _tmp13_;
			char* _tmp14_;
			_tmp13_ = (_tmp12_ = g_filename_to_uri (_tmp11_ = g_build_filename (self->priv->_project->working_dir, "changelog", NULL), NULL, &_inner_error_), _g_free0 (_tmp11_), _tmp12_);
			if (_inner_error_ != NULL) {
				goto __catch39_g_error;
			}
			self->changelog_uri = (_tmp14_ = _tmp13_, _g_free0 (self->changelog_uri), _tmp14_);
		} else {
			char* _tmp15_;
			gboolean _tmp16_;
			if ((_tmp16_ = g_file_test (_tmp15_ = g_build_filename (self->priv->_project->working_dir, "ChangeLog", NULL), G_FILE_TEST_EXISTS), _g_free0 (_tmp15_), _tmp16_)) {
				char* _tmp17_;
				char* _tmp18_;
				char* _tmp19_;
				char* _tmp20_;
				_tmp19_ = (_tmp18_ = g_filename_to_uri (_tmp17_ = g_build_filename (self->priv->_project->working_dir, "ChangeLog", NULL), NULL, &_inner_error_), _g_free0 (_tmp17_), _tmp18_);
				if (_inner_error_ != NULL) {
					goto __catch39_g_error;
				}
				self->changelog_uri = (_tmp20_ = _tmp19_, _g_free0 (self->changelog_uri), _tmp20_);
			}
		}
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgprojectmanager.vala:580: error %s converting changelog file to uri", e->message);
			_g_error_free0 (e);
		}
	}
	__finally39:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gint vtg_project_manager_sort_model (VtgProjectManager* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	char* vala;
	char* valb;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	vala = NULL;
	valb = NULL;
	gtk_tree_model_get (model, a, 4, &vala, -1);
	gtk_tree_model_get (model, b, 4, &valb, -1);
	result = vtg_path_utils_compare_vala_filenames (vala, valb);
	_g_free0 (valb);
	_g_free0 (vala);
	return result;
}


GtkTreeModel* vtg_project_manager_get_model (VtgProjectManager* self) {
	GtkTreeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GtkTreeModel*) self->priv->_model;
	return result;
}


VbfProject* vtg_project_manager_get_project (VtgProjectManager* self) {
	VbfProject* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_project;
	return result;
}


gboolean vtg_project_manager_get_automanaged (VtgProjectManager* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automanaged;
	return result;
}


void vtg_project_manager_set_automanaged (VtgProjectManager* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_automanaged = value;
	g_object_notify ((GObject *) self, "automanaged");
}


gboolean vtg_project_manager_get_enable_completion (VtgProjectManager* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_completion;
	return result;
}


void vtg_project_manager_set_enable_completion (VtgProjectManager* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_enable_completion != value) {
		self->priv->_enable_completion = value;
		if (self->priv->_enable_completion) {
			vtg_project_manager_setup_completions (self);
		} else {
			vtg_project_manager_cleanup_completions (self);
		}
	}
	g_object_notify ((GObject *) self, "enable-completion");
}


ValaHashMap* vtg_project_manager_get_completions (VtgProjectManager* self) {
	ValaHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_completions;
	return result;
}


static void vtg_project_manager_class_init (VtgProjectManagerClass * klass) {
	vtg_project_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgProjectManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_project_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = vtg_project_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_project_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_MANAGER_MODEL, g_param_spec_object ("model", "model", "model", GTK_TYPE_TREE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_MANAGER_PROJECT, g_param_spec_object ("project", "project", "project", VBF_TYPE_PROJECT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_MANAGER_AUTOMANAGED, g_param_spec_boolean ("automanaged", "automanaged", "automanaged", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_MANAGER_ENABLE_COMPLETION, g_param_spec_boolean ("enable-completion", "enable-completion", "enable-completion", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_MANAGER_COMPLETIONS, vala_param_spec_collection_object ("completions", "completions", "completions", VALA_TYPE_HASH_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("updated", VTG_TYPE_PROJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("symbol_cache_building", VTG_TYPE_PROJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, VTG_TYPE_PROJECT_MANAGER);
	g_signal_new ("symbol_cache_builded", VTG_TYPE_PROJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, VTG_TYPE_PROJECT_MANAGER);
	g_signal_new ("completion_begin_parsing", VTG_TYPE_PROJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, VTG_TYPE_PROJECT_MANAGER, AFRODITE_TYPE_COMPLETION_ENGINE);
	g_signal_new ("completion_end_parsing", VTG_TYPE_PROJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, VTG_TYPE_PROJECT_MANAGER, AFRODITE_TYPE_COMPLETION_ENGINE);
}


static void vtg_project_manager_instance_init (VtgProjectManager * self) {
	self->priv = VTG_PROJECT_MANAGER_GET_PRIVATE (self);
	self->priv->_project = NULL;
	self->priv->in_update = FALSE;
	self->priv->_completions = NULL;
	self->priv->parser_thread_count = 0;
	self->priv->_sc_building = FALSE;
	self->filename = NULL;
	self->is_default = FALSE;
	self->exec_targets = (ValaList*) vala_array_list_new (VBF_TYPE_TARGET, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->all_vala_sources = (ValaList*) vala_array_list_new (VBF_TYPE_SOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->vcs_type = VTG_VCS_TYPES_NONE;
	self->changelog_uri = NULL;
}


static void vtg_project_manager_finalize (GObject* obj) {
	VtgProjectManager * self;
	self = VTG_PROJECT_MANAGER (obj);
	{
		vtg_project_manager_cleanup_completions (self);
	}
	_g_object_unref0 (self->priv->_project);
	_g_object_unref0 (self->priv->_model);
	_vala_collection_object_unref0 (self->priv->_completions);
	_g_free0 (self->filename);
	_vala_collection_object_unref0 (self->exec_targets);
	_vala_collection_object_unref0 (self->all_vala_sources);
	_g_free0 (self->changelog_uri);
	G_OBJECT_CLASS (vtg_project_manager_parent_class)->finalize (obj);
}


GType vtg_project_manager_get_type (void) {
	return vtg_project_manager_type_id;
}


GType vtg_project_manager_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgProjectManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_project_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgProjectManager), 0, (GInstanceInitFunc) vtg_project_manager_instance_init, NULL };
	vtg_project_manager_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgProjectManager", &g_define_type_info, 0);
	return vtg_project_manager_type_id;
}


static void vtg_project_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgProjectManager * self;
	self = VTG_PROJECT_MANAGER (object);
	switch (property_id) {
		case VTG_PROJECT_MANAGER_MODEL:
		g_value_set_object (value, vtg_project_manager_get_model (self));
		break;
		case VTG_PROJECT_MANAGER_PROJECT:
		g_value_set_object (value, vtg_project_manager_get_project (self));
		break;
		case VTG_PROJECT_MANAGER_AUTOMANAGED:
		g_value_set_boolean (value, vtg_project_manager_get_automanaged (self));
		break;
		case VTG_PROJECT_MANAGER_ENABLE_COMPLETION:
		g_value_set_boolean (value, vtg_project_manager_get_enable_completion (self));
		break;
		case VTG_PROJECT_MANAGER_COMPLETIONS:
		vala_value_set_collection_object (value, vtg_project_manager_get_completions (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vtg_project_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgProjectManager * self;
	self = VTG_PROJECT_MANAGER (object);
	switch (property_id) {
		case VTG_PROJECT_MANAGER_AUTOMANAGED:
		vtg_project_manager_set_automanaged (self, g_value_get_boolean (value));
		break;
		case VTG_PROJECT_MANAGER_ENABLE_COMPLETION:
		vtg_project_manager_set_enable_completion (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}



