/* vtgprojectbuilder.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgprojectbuilder.vala, do not modify */

/*
 *  vtgprojectbuilder.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gedit/gedit-window.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <vbf.h>
#include <sys/wait.h>
#include <gdk/gdk.h>
#include <signal.h>
#include <sys/types.h>


#define VTG_TYPE_PROJECT_BUILDER (vtg_project_builder_get_type ())
#define VTG_PROJECT_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilder))
#define VTG_PROJECT_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilderClass))
#define VTG_IS_PROJECT_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_BUILDER))
#define VTG_IS_PROJECT_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_BUILDER))
#define VTG_PROJECT_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilderClass))

typedef struct _VtgProjectBuilder VtgProjectBuilder;
typedef struct _VtgProjectBuilderClass VtgProjectBuilderClass;
typedef struct _VtgProjectBuilderPrivate VtgProjectBuilderPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_BUILD_LOG_VIEW (vtg_build_log_view_get_type ())
#define VTG_BUILD_LOG_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogView))
#define VTG_BUILD_LOG_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewClass))
#define VTG_IS_BUILD_LOG_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_BUILD_LOG_VIEW))
#define VTG_IS_BUILD_LOG_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_BUILD_LOG_VIEW))
#define VTG_BUILD_LOG_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewClass))

typedef struct _VtgBuildLogView VtgBuildLogView;
typedef struct _VtgBuildLogViewClass VtgBuildLogViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VTG_TYPE_OUTPUT_VIEW (vtg_output_view_get_type ())
#define VTG_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputView))
#define VTG_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))
#define VTG_IS_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_OUTPUT_VIEW))
#define VTG_IS_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_OUTPUT_VIEW))
#define VTG_OUTPUT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))

typedef struct _VtgOutputView VtgOutputView;
typedef struct _VtgOutputViewClass VtgOutputViewClass;

#define VTG_TYPE_OUTPUT_TYPES (vtg_output_types_get_type ())

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))

struct _VtgProjectBuilder {
	GObject parent_instance;
	VtgProjectBuilderPrivate * priv;
};

struct _VtgProjectBuilderClass {
	GObjectClass parent_class;
};

struct _VtgProjectBuilderPrivate {
	VtgPluginInstance* _plugin_instance;
	VtgBuildLogView* _build_view;
	guint _child_watch_id;
	gboolean is_bottom_pane_visible;
	gint last_exit_code;
	GPid _child_pid;
	char* _operation;
};

typedef enum  {
	VTG_OUTPUT_TYPES_MESSAGE,
	VTG_OUTPUT_TYPES_ERROR,
	VTG_OUTPUT_TYPES_CHILD_PROCESS,
	VTG_OUTPUT_TYPES_BUILD,
	VTG_OUTPUT_TYPES_AUTO_BUILD,
	VTG_OUTPUT_TYPES_SEARCH
} VtgOutputTypes;


static gpointer vtg_project_builder_parent_class = NULL;
static GType vtg_project_builder_type_id = 0;

GType vtg_project_builder_get_type (void) G_GNUC_CONST;
GType vtg_project_builder_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
GType vtg_build_log_view_get_type (void) G_GNUC_CONST;
GType vtg_build_log_view_register_type (GTypeModule * module);
#define VTG_PROJECT_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PROJECT_BUILDER, VtgProjectBuilderPrivate))
enum  {
	VTG_PROJECT_BUILDER_DUMMY_PROPERTY,
	VTG_PROJECT_BUILDER_ERROR_PANE,
	VTG_PROJECT_BUILDER_IS_BUILDING
};
VtgProjectBuilder* vtg_project_builder_new (VtgPluginInstance* plugin_instance);
VtgProjectBuilder* vtg_project_builder_construct (GType object_type, VtgPluginInstance* plugin_instance);
VtgBuildLogView* vtg_build_log_view_new (VtgPluginInstance* plugin_instance);
VtgBuildLogView* vtg_build_log_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
gboolean vtg_project_builder_compile_file (VtgProjectBuilder* self, const char* filename, const char* params);
GType vtg_output_view_get_type (void) G_GNUC_CONST;
GType vtg_output_view_register_type (GTypeModule * module);
VtgOutputView* vtg_plugin_instance_get_output_view (VtgPluginInstance* self);
void vtg_output_view_clean_output (VtgOutputView* self);
GType vtg_output_types_get_type (void) G_GNUC_CONST;
void vtg_output_view_log_message (VtgOutputView* self, VtgOutputTypes output_type, const char* message);
static void vtg_project_builder_on_child_watch (VtgProjectBuilder* self, GPid pid, gint status);
static void _vtg_project_builder_on_child_watch_gchild_watch_func (GPid pid, gint status, gpointer self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
void vtg_build_log_view_initialize (VtgBuildLogView* self, VtgProjectManager* project);
void vtg_output_view_start_watch (VtgOutputView* self, VtgOutputTypes output_type, guint id, gint stdo, gint stde, gint stdi);
void vtg_output_view_activate (VtgOutputView* self);
gboolean vtg_project_builder_build (VtgProjectBuilder* self, VtgProjectManager* project_manager, const char* params);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
void vtg_interaction_error_message (const char* message, GError* err);
gboolean vtg_project_builder_configure (VtgProjectBuilder* self, VtgProjectManager* project_manager, const char* params);
gboolean vtg_project_builder_clean (VtgProjectBuilder* self, VtgProjectManager* project_manager, gboolean vala_stamp);
void vtg_project_builder_next_error (VtgProjectBuilder* self);
void vtg_build_log_view_next_error (VtgBuildLogView* self);
void vtg_project_builder_previous_error (VtgProjectBuilder* self);
void vtg_build_log_view_previous_error (VtgBuildLogView* self);
void vtg_output_view_stop_watch (VtgOutputView* self, guint id);
void vtg_interaction_info_message (const char* message);
gint vtg_build_log_view_get_error_count (VtgBuildLogView* self);
void vtg_build_log_view_activate (VtgBuildLogView* self);
void vtg_project_builder_stop_build (VtgProjectBuilder* self);
VtgBuildLogView* vtg_project_builder_get_error_pane (VtgProjectBuilder* self);
gboolean vtg_project_builder_get_is_building (VtgProjectBuilder* self);
void vtg_utils_trace (const char* format, ...);
void vtg_build_log_view_destroy (VtgBuildLogView* self);
static void vtg_project_builder_finalize (GObject* obj);
static void vtg_project_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



VtgProjectBuilder* vtg_project_builder_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgProjectBuilder * self;
	VtgBuildLogView* _tmp0_;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgProjectBuilder*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	self->priv->_build_view = (_tmp0_ = vtg_build_log_view_new (self->priv->_plugin_instance), _g_object_unref0 (self->priv->_build_view), _tmp0_);
	self->priv->is_bottom_pane_visible = gtk_widget_get_visible ((GtkWidget*) gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	return self;
}


VtgProjectBuilder* vtg_project_builder_new (VtgPluginInstance* plugin_instance) {
	return vtg_project_builder_construct (VTG_TYPE_PROJECT_BUILDER, plugin_instance);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static void _vtg_project_builder_on_child_watch_gchild_watch_func (GPid pid, gint status, gpointer self) {
	vtg_project_builder_on_child_watch (self, pid, status);
}


gboolean vtg_project_builder_compile_file (VtgProjectBuilder* self, const char* filename, const char* params) {
	gboolean result = FALSE;
	char* working_dir;
	gint stdo = 0;
	gint stde = 0;
	VtgOutputView* log;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		result = FALSE;
		return result;
	}
	working_dir = g_path_get_dirname (filename);
	log = _g_object_ref0 (vtg_plugin_instance_get_output_view (self->priv->_plugin_instance));
	{
		char* cmd;
		gint pars_length1;
		gint _pars_size_;
		char** pars;
		char* start_message;
		char* _tmp2_;
		char* _tmp3_;
		char* _tmp4_;
		cmd = NULL;
		if (params != NULL) {
			char* _tmp0_;
			cmd = (_tmp0_ = g_strdup_printf ("%s %s %s", "valac", params, filename), _g_free0 (cmd), _tmp0_);
		} else {
			char* _tmp1_;
			cmd = (_tmp1_ = g_strdup_printf ("valac %s", filename), _g_free0 (cmd), _tmp1_);
		}
		pars = (pars_length1 = 0, NULL);
		g_shell_parse_argv (cmd, &pars_length1, &pars, &_inner_error_);
		if (_inner_error_ != NULL) {
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (cmd);
			goto __catch22_g_error;
		}
		vtg_output_view_clean_output (log);
		start_message = g_strdup_printf (_ ("Start compiling file: %s\n"), filename);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp3_ = g_strdup_printf ("%s\n\n", _tmp2_ = g_strnfill ((gsize) (string_get_length (start_message) - 1), '-')));
		_g_free0 (_tmp3_);
		_g_free0 (_tmp2_);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp4_ = g_strdup_printf ("%s\n", cmd));
		_g_free0 (_tmp4_);
		g_spawn_async_with_pipes (working_dir, pars, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &self->priv->_child_pid, NULL, &stdo, &stde, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (start_message);
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (cmd);
			goto __catch22_g_error;
		}
		if (self->priv->_child_pid != ((GPid) 0)) {
			char* _tmp5_;
			self->priv->_operation = (_tmp5_ = g_strdup_printf (_ ("File '%s': compilation"), filename), _g_free0 (self->priv->_operation), _tmp5_);
			self->priv->_child_watch_id = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->_child_pid, _vtg_project_builder_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
			vtg_build_log_view_initialize (self->priv->_build_view, NULL);
			if (self->priv->last_exit_code == 0) {
				self->priv->is_bottom_pane_visible = gtk_widget_get_visible ((GtkWidget*) gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
			}
			vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_BUILD, self->priv->_child_watch_id, stdo, stde, -1);
			vtg_output_view_activate (log);
			g_signal_emit_by_name (self, "build-start");
		} else {
			vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, "error compiling file\n");
		}
		result = TRUE;
		_g_free0 (start_message);
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_object_unref0 (log);
		_g_free0 (working_dir);
		return result;
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			char* msg;
			msg = g_strdup_printf ("error spawning compiler process: %s", err->message);
			g_warning ("vtgprojectbuilder.vala:109: %s", msg);
			vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, msg);
			result = FALSE;
			_g_free0 (msg);
			_g_error_free0 (err);
			_g_object_unref0 (log);
			_g_free0 (working_dir);
			return result;
		}
	}
	__finally22:
	{
		_g_object_unref0 (log);
		_g_free0 (working_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (log);
	_g_free0 (working_dir);
}


gboolean vtg_project_builder_build (VtgProjectBuilder* self, VtgProjectManager* project_manager, const char* params) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	VbfProject* project;
	char* working_dir;
	gint stdo = 0;
	gint stde = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_manager != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		_tmp0_ = TRUE;
	} else {
		char* _tmp1_;
		_tmp0_ = (_tmp1_ = vbf_project_get_build_command (vtg_project_manager_get_project (project_manager))) == NULL;
		_g_free0 (_tmp1_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	project = _g_object_ref0 (vtg_project_manager_get_project (project_manager));
	working_dir = g_strdup (project->id);
	{
		VtgOutputView* log;
		char* start_message;
		char* _tmp2_;
		char* _tmp3_;
		char* cmd;
		gint pars_length1;
		gint _pars_size_;
		char** pars;
		char* _tmp7_;
		log = _g_object_ref0 (vtg_plugin_instance_get_output_view (self->priv->_plugin_instance));
		vtg_output_view_clean_output (log);
		start_message = g_strdup_printf (_ ("Start building project: %s\n"), project->name);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp3_ = g_strdup_printf ("%s\n\n", _tmp2_ = g_strnfill ((gsize) (string_get_length (start_message) - 1), '-')));
		_g_free0 (_tmp3_);
		_g_free0 (_tmp2_);
		cmd = NULL;
		if (params != NULL) {
			char* _tmp4_;
			char* _tmp5_;
			cmd = (_tmp5_ = g_strdup_printf ("%s %s", _tmp4_ = vbf_project_get_build_command (vtg_project_manager_get_project (project_manager)), params), _g_free0 (cmd), _tmp5_);
			_g_free0 (_tmp4_);
		} else {
			char* _tmp6_;
			cmd = (_tmp6_ = vbf_project_get_build_command (vtg_project_manager_get_project (project_manager)), _g_free0 (cmd), _tmp6_);
		}
		pars = (pars_length1 = 0, NULL);
		g_shell_parse_argv (cmd, &pars_length1, &pars, &_inner_error_);
		if (_inner_error_ != NULL) {
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (cmd);
			_g_free0 (start_message);
			_g_object_unref0 (log);
			goto __catch23_g_error;
		}
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp7_ = g_strdup_printf ("%s\n", cmd));
		_g_free0 (_tmp7_);
		g_spawn_async_with_pipes (working_dir, pars, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &self->priv->_child_pid, NULL, &stdo, &stde, &_inner_error_);
		if (_inner_error_ != NULL) {
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (cmd);
			_g_free0 (start_message);
			_g_object_unref0 (log);
			goto __catch23_g_error;
		}
		if (self->priv->_child_pid != ((GPid) 0)) {
			char* _tmp8_;
			self->priv->_operation = (_tmp8_ = g_strdup_printf (_ ("Project '%s': build"), project->name), _g_free0 (self->priv->_operation), _tmp8_);
			self->priv->_child_watch_id = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->_child_pid, _vtg_project_builder_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
			vtg_build_log_view_initialize (self->priv->_build_view, project_manager);
			if (self->priv->last_exit_code == 0) {
				self->priv->is_bottom_pane_visible = gtk_widget_get_visible ((GtkWidget*) gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
			}
			vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_BUILD, self->priv->_child_watch_id, stdo, stde, -1);
			vtg_output_view_activate (log);
			g_signal_emit_by_name (self, "build-start");
		} else {
			vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, "error spawning 'make' process\n");
		}
		result = TRUE;
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_free0 (start_message);
		_g_object_unref0 (log);
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		return result;
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgprojectbuilder.vala:155: Error spawning build process: %s", err->message);
			vtg_interaction_error_message (_ ("Build failed"), err);
			result = FALSE;
			_g_error_free0 (err);
			_g_free0 (working_dir);
			_g_object_unref0 (project);
			return result;
		}
	}
	__finally23:
	{
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (working_dir);
	_g_object_unref0 (project);
}


gboolean vtg_project_builder_configure (VtgProjectBuilder* self, VtgProjectManager* project_manager, const char* params) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	VbfProject* project;
	char* working_dir;
	gint stdo = 0;
	gint stde = 0;
	char* configure_command;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_manager != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		_tmp0_ = TRUE;
	} else {
		char* _tmp1_;
		_tmp0_ = (_tmp1_ = vbf_project_get_configure_command (vtg_project_manager_get_project (project_manager))) == NULL;
		_g_free0 (_tmp1_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	project = _g_object_ref0 (vtg_project_manager_get_project (project_manager));
	working_dir = g_strdup (project->id);
	configure_command = vbf_project_get_configure_command (vtg_project_manager_get_project (project_manager));
	{
		VtgOutputView* log;
		char* start_message;
		char* _tmp2_;
		char* _tmp3_;
		char* cmd;
		gint pars_length1;
		gint _pars_size_;
		char** pars;
		char* _tmp6_;
		log = _g_object_ref0 (vtg_plugin_instance_get_output_view (self->priv->_plugin_instance));
		vtg_output_view_clean_output (log);
		start_message = g_strdup_printf (_ ("Start configure project: %s\n"), project->name);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp3_ = g_strdup_printf ("%s\n\n", _tmp2_ = g_strnfill ((gsize) (string_get_length (start_message) - 1), '-')));
		_g_free0 (_tmp3_);
		_g_free0 (_tmp2_);
		cmd = NULL;
		if (params != NULL) {
			char* _tmp4_;
			cmd = (_tmp4_ = g_strdup_printf ("%s %s", configure_command, params), _g_free0 (cmd), _tmp4_);
		} else {
			char* _tmp5_;
			cmd = (_tmp5_ = g_strdup (configure_command), _g_free0 (cmd), _tmp5_);
		}
		pars = (pars_length1 = 0, NULL);
		g_shell_parse_argv (cmd, &pars_length1, &pars, &_inner_error_);
		if (_inner_error_ != NULL) {
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (cmd);
			_g_free0 (start_message);
			_g_object_unref0 (log);
			goto __catch24_g_error;
		}
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp6_ = g_strdup_printf ("%s\n", cmd));
		_g_free0 (_tmp6_);
		g_spawn_async_with_pipes (working_dir, pars, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &self->priv->_child_pid, NULL, &stdo, &stde, &_inner_error_);
		if (_inner_error_ != NULL) {
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (cmd);
			_g_free0 (start_message);
			_g_object_unref0 (log);
			goto __catch24_g_error;
		}
		if (self->priv->_child_pid != ((GPid) 0)) {
			char* _tmp7_;
			self->priv->_operation = (_tmp7_ = g_strdup_printf (_ ("Project '%s': configuration"), project->name), _g_free0 (self->priv->_operation), _tmp7_);
			self->priv->_child_watch_id = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->_child_pid, _vtg_project_builder_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
			vtg_build_log_view_initialize (self->priv->_build_view, project_manager);
			if (self->priv->last_exit_code == 0) {
				self->priv->is_bottom_pane_visible = gtk_widget_get_visible ((GtkWidget*) gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
			}
			vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_BUILD, self->priv->_child_watch_id, stdo, stde, -1);
			vtg_output_view_activate (log);
			g_signal_emit_by_name (self, "build-start");
		} else {
			char* _tmp8_;
			vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, _tmp8_ = g_strdup_printf (_ ("error spawning '%s' process\n"), configure_command));
			_g_free0 (_tmp8_);
		}
		result = TRUE;
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_free0 (start_message);
		_g_object_unref0 (log);
		_g_free0 (configure_command);
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		return result;
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgprojectbuilder.vala:202: Error spawning build process: %s", err->message);
			vtg_interaction_error_message (_ ("Configure failed"), err);
			result = FALSE;
			_g_error_free0 (err);
			_g_free0 (configure_command);
			_g_free0 (working_dir);
			_g_object_unref0 (project);
			return result;
		}
	}
	__finally24:
	{
		_g_free0 (configure_command);
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (configure_command);
	_g_free0 (working_dir);
	_g_object_unref0 (project);
}


gboolean vtg_project_builder_clean (VtgProjectBuilder* self, VtgProjectManager* project_manager, gboolean vala_stamp) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	VbfProject* project;
	char* working_dir;
	gint stdo = 0;
	gint stde = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project_manager != NULL, FALSE);
	if (self->priv->_child_watch_id != 0) {
		_tmp0_ = TRUE;
	} else {
		char* _tmp1_;
		_tmp0_ = (_tmp1_ = vbf_project_get_clean_command (vtg_project_manager_get_project (project_manager))) == NULL;
		_g_free0 (_tmp1_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	project = _g_object_ref0 (vtg_project_manager_get_project (project_manager));
	working_dir = g_strdup (project->working_dir);
	{
		VtgOutputView* log;
		char* start_message;
		char* _tmp2_;
		char* _tmp3_;
		gint pars_length1;
		gint _pars_size_;
		char** pars;
		char* _tmp8_;
		char* _tmp9_;
		char* _tmp10_;
		log = _g_object_ref0 (vtg_plugin_instance_get_output_view (self->priv->_plugin_instance));
		vtg_output_view_clean_output (log);
		start_message = g_strdup_printf (_ ("Start cleaning project: %s\n"), project->name);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, start_message);
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp3_ = g_strdup_printf ("%s\n\n", _tmp2_ = g_strnfill ((gsize) (string_get_length (start_message) - 1), '-')));
		_g_free0 (_tmp3_);
		_g_free0 (_tmp2_);
		if (vala_stamp) {
			char* _tmp4_;
			char* command;
			char* _tmp5_;
			gboolean _tmp6_;
			vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp4_ = g_strdup_printf (_ ("cleaning 'stamp' files for project: %s\n"), project->name));
			_g_free0 (_tmp4_);
			command = g_strdup_printf ("find %s/ -name *.stamp -delete", working_dir);
			vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp5_ = g_strdup_printf ("%s\n\n", command));
			_g_free0 (_tmp5_);
			_tmp6_ = g_spawn_command_line_sync (command, NULL, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (command);
				_g_free0 (start_message);
				_g_object_unref0 (log);
				goto __catch25_g_error;
			}
			if (!_tmp6_) {
				char* _tmp7_;
				vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, _tmp7_ = g_strdup_printf (_ ("error cleaning 'stamp' files for project: %s\n"), project->name));
				_g_free0 (_tmp7_);
				result = FALSE;
				_g_free0 (command);
				_g_free0 (start_message);
				_g_object_unref0 (log);
				_g_free0 (working_dir);
				_g_object_unref0 (project);
				return result;
			}
			_g_free0 (command);
		}
		pars = (pars_length1 = 0, NULL);
		g_shell_parse_argv (_tmp8_ = vbf_project_get_clean_command (project), &pars_length1, &pars, &_inner_error_);
		_g_free0 (_tmp8_);
		if (_inner_error_ != NULL) {
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (start_message);
			_g_object_unref0 (log);
			goto __catch25_g_error;
		}
		vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp10_ = g_strdup_printf ("%s\n", _tmp9_ = vbf_project_get_clean_command (project)));
		_g_free0 (_tmp10_);
		_g_free0 (_tmp9_);
		g_spawn_async_with_pipes (working_dir, pars, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &self->priv->_child_pid, NULL, &stdo, &stde, &_inner_error_);
		if (_inner_error_ != NULL) {
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (start_message);
			_g_object_unref0 (log);
			goto __catch25_g_error;
		}
		if (self->priv->_child_pid != ((GPid) 0)) {
			char* _tmp11_;
			self->priv->_operation = (_tmp11_ = g_strdup_printf (_ ("Project '%s': cleaning"), project->name), _g_free0 (self->priv->_operation), _tmp11_);
			self->priv->_child_watch_id = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->_child_pid, _vtg_project_builder_on_child_watch_gchild_watch_func, g_object_ref (self), g_object_unref);
			vtg_build_log_view_initialize (self->priv->_build_view, project_manager);
			if (self->priv->last_exit_code == 0) {
				self->priv->is_bottom_pane_visible = gtk_widget_get_visible ((GtkWidget*) gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
			}
			vtg_output_view_start_watch (log, VTG_OUTPUT_TYPES_BUILD, self->priv->_child_watch_id, stdo, stde, -1);
			vtg_output_view_activate (log);
			g_signal_emit_by_name (self, "build-start");
		} else {
			vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_ERROR, "error spawning 'make clean' process\n");
		}
		result = TRUE;
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (start_message);
		_g_object_unref0 (log);
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		return result;
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgprojectbuilder.vala:252: Error spawning clean command: %s", err->message);
			vtg_interaction_error_message (_ ("Clean failed"), err);
			result = FALSE;
			_g_error_free0 (err);
			_g_free0 (working_dir);
			_g_object_unref0 (project);
			return result;
		}
	}
	__finally25:
	{
		_g_free0 (working_dir);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (working_dir);
	_g_object_unref0 (project);
}


void vtg_project_builder_next_error (VtgProjectBuilder* self) {
	g_return_if_fail (self != NULL);
	vtg_build_log_view_next_error (self->priv->_build_view);
}


void vtg_project_builder_previous_error (VtgProjectBuilder* self) {
	g_return_if_fail (self != NULL);
	vtg_build_log_view_previous_error (self->priv->_build_view);
}


static void vtg_project_builder_on_child_watch (VtgProjectBuilder* self, GPid pid, gint status) {
	VtgOutputView* log;
	char* _tmp0_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	log = _g_object_ref0 (vtg_plugin_instance_get_output_view (self->priv->_plugin_instance));
	vtg_output_view_stop_watch (log, self->priv->_child_watch_id);
	self->priv->last_exit_code = WEXITSTATUS (status);
	vtg_output_view_log_message (log, VTG_OUTPUT_TYPES_MESSAGE, _tmp0_ = g_strdup_printf (_ ("\ncompilation end with exit status %d\n"), self->priv->last_exit_code));
	_g_free0 (_tmp0_);
	if (self->priv->last_exit_code != 0) {
		char* _tmp1_;
		vtg_interaction_info_message (_tmp1_ = g_strdup_printf (_ ("%s failed"), self->priv->_operation));
		_g_free0 (_tmp1_);
	}
	if (self->priv->last_exit_code == 0) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (self->priv->last_exit_code != 0) {
			_tmp3_ = vtg_build_log_view_get_error_count (self->priv->_build_view) > 0;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp2_ = _tmp3_;
	}
	if (_tmp2_) {
		vtg_build_log_view_activate (self->priv->_build_view);
	}
	self->priv->_child_watch_id = (guint) 0;
	g_signal_emit_by_name (self, "build-exit", self->priv->last_exit_code);
	g_spawn_close_pid (pid);
	if (self->priv->last_exit_code == 0) {
		if (!self->priv->is_bottom_pane_visible) {
			gtk_widget_hide ((GtkWidget*) gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
		}
	} else {
		gdk_beep ();
	}
	self->priv->_child_pid = (GPid) 0;
	_g_object_unref0 (log);
}


static gpointer _g_main_context_ref0 (gpointer self) {
	return self ? g_main_context_ref (self) : NULL;
}


void vtg_project_builder_stop_build (VtgProjectBuilder* self) {
	g_return_if_fail (self != NULL);
	if (((gint) self->priv->_child_pid) != 0) {
		if (kill ((gint) self->priv->_child_pid, 9) != 0) {
			g_warning ("vtgprojectbuilder.vala:301: stop build error: kill failed");
		} else {
			GMainContext* ctx;
			ctx = _g_main_context_ref0 (g_main_context_default ());
			while (TRUE) {
				gboolean _tmp0_ = FALSE;
				if (self->priv->_child_watch_id != 0) {
					_tmp0_ = g_main_context_pending (ctx);
				} else {
					_tmp0_ = FALSE;
				}
				if (!_tmp0_) {
					break;
				}
				g_main_context_iteration (ctx, FALSE);
			}
			_g_main_context_unref0 (ctx);
		}
	}
}


VtgBuildLogView* vtg_project_builder_get_error_pane (VtgProjectBuilder* self) {
	VtgBuildLogView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_build_view;
	return result;
}


gboolean vtg_project_builder_get_is_building (VtgProjectBuilder* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_child_watch_id != 0;
	return result;
}


static void vtg_project_builder_class_init (VtgProjectBuilderClass * klass) {
	vtg_project_builder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgProjectBuilderPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_project_builder_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_project_builder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_BUILDER_ERROR_PANE, g_param_spec_object ("error-pane", "error-pane", "error-pane", VTG_TYPE_BUILD_LOG_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PROJECT_BUILDER_IS_BUILDING, g_param_spec_boolean ("is-building", "is-building", "is-building", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("build_start", VTG_TYPE_PROJECT_BUILDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("build_exit", VTG_TYPE_PROJECT_BUILDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void vtg_project_builder_instance_init (VtgProjectBuilder * self) {
	self->priv = VTG_PROJECT_BUILDER_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
	self->priv->_build_view = NULL;
	self->priv->_child_watch_id = (guint) 0;
	self->priv->last_exit_code = 0;
	self->priv->_operation = NULL;
}


static void vtg_project_builder_finalize (GObject* obj) {
	VtgProjectBuilder * self;
	self = VTG_PROJECT_BUILDER (obj);
	{
		VtgBuildLogView* _tmp0_;
		vtg_utils_trace ("vtgprojectbuilder.vala:64: ProjectBuilder destroying");
		vtg_build_log_view_destroy (self->priv->_build_view);
		self->priv->_build_view = (_tmp0_ = NULL, _g_object_unref0 (self->priv->_build_view), _tmp0_);
		vtg_utils_trace ("vtgprojectbuilder.vala:67: ProjectBuilder destroyed");
	}
	_g_object_unref0 (self->priv->_build_view);
	_g_free0 (self->priv->_operation);
	G_OBJECT_CLASS (vtg_project_builder_parent_class)->finalize (obj);
}


GType vtg_project_builder_get_type (void) {
	return vtg_project_builder_type_id;
}


GType vtg_project_builder_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgProjectBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_project_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgProjectBuilder), 0, (GInstanceInitFunc) vtg_project_builder_instance_init, NULL };
	vtg_project_builder_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgProjectBuilder", &g_define_type_info, 0);
	return vtg_project_builder_type_id;
}


static void vtg_project_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgProjectBuilder * self;
	self = VTG_PROJECT_BUILDER (object);
	switch (property_id) {
		case VTG_PROJECT_BUILDER_ERROR_PANE:
		g_value_set_object (value, vtg_project_builder_get_error_pane (self));
		break;
		case VTG_PROJECT_BUILDER_IS_BUILDING:
		g_value_set_boolean (value, vtg_project_builder_get_is_building (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




