/* vtgbuildlogview.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgbuildlogview.vala, do not modify */

/*
 *  vtgbuildlogview.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gedit/gedit-window.h>
#include <gedit/gedit-panel.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gedit/gedit-view.h>
#include <gedit/gedit-tab.h>
#include <float.h>
#include <math.h>
#include <valagee.h>
#include <afrodite.h>


#define VTG_TYPE_BUILD_LOG_VIEW (vtg_build_log_view_get_type ())
#define VTG_BUILD_LOG_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogView))
#define VTG_BUILD_LOG_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewClass))
#define VTG_IS_BUILD_LOG_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_BUILD_LOG_VIEW))
#define VTG_IS_BUILD_LOG_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_BUILD_LOG_VIEW))
#define VTG_BUILD_LOG_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewClass))

typedef struct _VtgBuildLogView VtgBuildLogView;
typedef struct _VtgBuildLogViewClass VtgBuildLogViewClass;
typedef struct _VtgBuildLogViewPrivate VtgBuildLogViewPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;

#define VTG_BUILD_LOG_VIEW_TYPE_COLUMNS (vtg_build_log_view_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_OUTPUT_VIEW (vtg_output_view_get_type ())
#define VTG_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputView))
#define VTG_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))
#define VTG_IS_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_OUTPUT_VIEW))
#define VTG_IS_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_OUTPUT_VIEW))
#define VTG_OUTPUT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))

typedef struct _VtgOutputView VtgOutputView;
typedef struct _VtgOutputViewClass VtgOutputViewClass;

#define VTG_TYPE_OUTPUT_TYPES (vtg_output_types_get_type ())
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

struct _VtgBuildLogView {
	GObject parent_instance;
	VtgBuildLogViewPrivate * priv;
};

struct _VtgBuildLogViewClass {
	GObjectClass parent_class;
};

struct _VtgBuildLogViewPrivate {
	GtkVBox* _ui;
	GtkListStore* _child_model;
	GtkTreeModelFilter* _model;
	GtkTreeView* _build_view;
	gint _current_error_row;
	gint _vala_error_count;
	gint _vala_warning_count;
	gint _c_error_count;
	gint _c_warning_count;
	VtgPluginInstance* _plugin_instance;
	VtgProjectManager* _project;
	gboolean _show_vala_warnings;
	gboolean _show_vala_errors;
	gboolean _show_c_warnings;
	gboolean _show_c_errors;
	GtkToggleToolButton* _vala_warning_button;
	GtkToggleToolButton* _vala_error_button;
	GtkToggleToolButton* _c_warning_button;
	GtkToggleToolButton* _c_error_button;
};

typedef enum  {
	VTG_BUILD_LOG_VIEW_COLUMNS_ICON,
	VTG_BUILD_LOG_VIEW_COLUMNS_MESSAGE,
	VTG_BUILD_LOG_VIEW_COLUMNS_FILENAME,
	VTG_BUILD_LOG_VIEW_COLUMNS_LINE,
	VTG_BUILD_LOG_VIEW_COLUMNS_COLUMN,
	VTG_BUILD_LOG_VIEW_COLUMNS_IS_WARNING,
	VTG_BUILD_LOG_VIEW_COLUMNS_IS_VALA_SOURCE,
	VTG_BUILD_LOG_VIEW_COLUMNS_IS_AUTO_BUILD_MESSAGE,
	VTG_BUILD_LOG_VIEW_COLUMNS_PROJECT,
	VTG_BUILD_LOG_VIEW_COLUMNS_COLUMNS_COUNT
} VtgBuildLogViewColumns;

typedef enum  {
	VTG_OUTPUT_TYPES_MESSAGE,
	VTG_OUTPUT_TYPES_ERROR,
	VTG_OUTPUT_TYPES_CHILD_PROCESS,
	VTG_OUTPUT_TYPES_BUILD,
	VTG_OUTPUT_TYPES_AUTO_BUILD,
	VTG_OUTPUT_TYPES_SEARCH
} VtgOutputTypes;


static gpointer vtg_build_log_view_parent_class = NULL;
static GType vtg_build_log_view_type_id = 0;

GType vtg_build_log_view_get_type (void) G_GNUC_CONST;
GType vtg_build_log_view_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
#define VTG_BUILD_LOG_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_BUILD_LOG_VIEW, VtgBuildLogViewPrivate))
enum  {
	VTG_BUILD_LOG_VIEW_DUMMY_PROPERTY,
	VTG_BUILD_LOG_VIEW_ERROR_COUNT,
	VTG_BUILD_LOG_VIEW_WARNING_COUNT
};
static GType vtg_build_log_view_columns_get_type (void) G_GNUC_UNUSED;
VtgBuildLogView* vtg_build_log_view_new (VtgPluginInstance* plugin_instance);
VtgBuildLogView* vtg_build_log_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
static void vtg_build_log_view_on_toggle_vala_warnings_toggled (VtgBuildLogView* self, GtkToggleToolButton* sender);
static void _vtg_build_log_view_on_toggle_vala_warnings_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void vtg_build_log_view_on_toggle_vala_errors_toggled (VtgBuildLogView* self, GtkToggleToolButton* sender);
static void _vtg_build_log_view_on_toggle_vala_errors_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void vtg_build_log_view_on_toggle_c_warnings_toggled (VtgBuildLogView* self, GtkToggleToolButton* sender);
static void _vtg_build_log_view_on_toggle_c_warnings_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void vtg_build_log_view_on_toggle_c_errors_toggled (VtgBuildLogView* self, GtkToggleToolButton* sender);
static void _vtg_build_log_view_on_toggle_c_errors_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static gboolean vtg_build_log_view_filter_model (VtgBuildLogView* self, GtkTreeModel* model, GtkTreeIter* iter);
static gboolean _vtg_build_log_view_filter_model_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
void vtg_build_log_view_on_build_view_row_activated (VtgBuildLogView* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column);
static void _vtg_build_log_view_on_build_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
GType vtg_output_view_get_type (void) G_GNUC_CONST;
GType vtg_output_view_register_type (GTypeModule * module);
VtgOutputView* vtg_plugin_instance_get_output_view (VtgPluginInstance* self);
GType vtg_output_types_get_type (void) G_GNUC_CONST;
void vtg_build_log_view_on_message_added (VtgBuildLogView* self, VtgOutputView* sender, VtgOutputTypes output_type, const char* message);
static void _vtg_build_log_view_on_message_added_vtg_output_view_message_added (VtgOutputView* _sender, VtgOutputTypes output_type, const char* message, gpointer self);
static void vtg_build_log_view_update_toolbar_button_status (VtgBuildLogView* self);
void vtg_build_log_view_destroy (VtgBuildLogView* self);
void vtg_build_log_view_initialize (VtgBuildLogView* self, VtgProjectManager* project);
void vtg_build_log_view_activate (VtgBuildLogView* self);
static void vtg_build_log_view_add_message (VtgBuildLogView* self, VtgOutputTypes output_type, const char* message);
static void vtg_build_log_view_activate_path (VtgBuildLogView* self, GtkTreePath* path);
char* vtg_project_manager_source_uri_for_name (VtgProjectManager* self, const char* name);
GeditTab* vtg_plugin_instance_activate_uri (VtgPluginInstance* self, const char* uri, gint line, gint col);
void vtg_plugin_instance_activate_display_name (VtgPluginInstance* self, const char* display_name, gint line, gint col);
void vtg_build_log_view_next_error (VtgBuildLogView* self);
static gint vtg_build_log_view_get_shown_messages (VtgBuildLogView* self);
void vtg_build_log_view_previous_error (VtgBuildLogView* self);
void vtg_build_log_view_clear_messages (VtgBuildLogView* self);
void vtg_build_log_view_clear_messages_for_source (VtgBuildLogView* self, const char* filename);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
void vtg_build_log_view_update_parse_result (VtgBuildLogView* self, const char* filename, AfroditeParseResult* parse_result);
gboolean vtg_string_utils_is_null_or_empty (const char* data);
static void vtg_build_log_view_add_vala_message (VtgBuildLogView* self, const char* file, const char* message, gboolean is_auto_build_message);
static void vtg_build_log_view_add_c_message (VtgBuildLogView* self, const char* file, const char* message, gboolean is_auto_build_message);
void vtg_utils_trace (const char* format, ...);
gint vtg_build_log_view_get_error_count (VtgBuildLogView* self);
gint vtg_build_log_view_get_warning_count (VtgBuildLogView* self);
static void vtg_build_log_view_finalize (GObject* obj);
static void vtg_build_log_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static GType vtg_build_log_view_columns_get_type (void) {
	static volatile gsize vtg_build_log_view_columns_type_id__volatile = 0;
	if (g_once_init_enter (&vtg_build_log_view_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{VTG_BUILD_LOG_VIEW_COLUMNS_ICON, "VTG_BUILD_LOG_VIEW_COLUMNS_ICON", "icon"}, {VTG_BUILD_LOG_VIEW_COLUMNS_MESSAGE, "VTG_BUILD_LOG_VIEW_COLUMNS_MESSAGE", "message"}, {VTG_BUILD_LOG_VIEW_COLUMNS_FILENAME, "VTG_BUILD_LOG_VIEW_COLUMNS_FILENAME", "filename"}, {VTG_BUILD_LOG_VIEW_COLUMNS_LINE, "VTG_BUILD_LOG_VIEW_COLUMNS_LINE", "line"}, {VTG_BUILD_LOG_VIEW_COLUMNS_COLUMN, "VTG_BUILD_LOG_VIEW_COLUMNS_COLUMN", "column"}, {VTG_BUILD_LOG_VIEW_COLUMNS_IS_WARNING, "VTG_BUILD_LOG_VIEW_COLUMNS_IS_WARNING", "is-warning"}, {VTG_BUILD_LOG_VIEW_COLUMNS_IS_VALA_SOURCE, "VTG_BUILD_LOG_VIEW_COLUMNS_IS_VALA_SOURCE", "is-vala-source"}, {VTG_BUILD_LOG_VIEW_COLUMNS_IS_AUTO_BUILD_MESSAGE, "VTG_BUILD_LOG_VIEW_COLUMNS_IS_AUTO_BUILD_MESSAGE", "is-auto-build-message"}, {VTG_BUILD_LOG_VIEW_COLUMNS_PROJECT, "VTG_BUILD_LOG_VIEW_COLUMNS_PROJECT", "project"}, {VTG_BUILD_LOG_VIEW_COLUMNS_COLUMNS_COUNT, "VTG_BUILD_LOG_VIEW_COLUMNS_COLUMNS_COUNT", "columns-count"}, {0, NULL, NULL}};
		GType vtg_build_log_view_columns_type_id;
		vtg_build_log_view_columns_type_id = g_enum_register_static ("VtgBuildLogViewColumns", values);
		g_once_init_leave (&vtg_build_log_view_columns_type_id__volatile, vtg_build_log_view_columns_type_id);
	}
	return vtg_build_log_view_columns_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vtg_build_log_view_on_toggle_vala_warnings_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
	vtg_build_log_view_on_toggle_vala_warnings_toggled (self, _sender);
}


static void _vtg_build_log_view_on_toggle_vala_errors_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
	vtg_build_log_view_on_toggle_vala_errors_toggled (self, _sender);
}


static void _vtg_build_log_view_on_toggle_c_warnings_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
	vtg_build_log_view_on_toggle_c_warnings_toggled (self, _sender);
}


static void _vtg_build_log_view_on_toggle_c_errors_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
	vtg_build_log_view_on_toggle_c_errors_toggled (self, _sender);
}


static gboolean _vtg_build_log_view_filter_model_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = vtg_build_log_view_filter_model (self, model, iter);
	return result;
}


static void _vtg_build_log_view_on_build_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	vtg_build_log_view_on_build_view_row_activated (self, _sender, path, column);
}


static void _vtg_build_log_view_on_message_added_vtg_output_view_message_added (VtgOutputView* _sender, VtgOutputTypes output_type, const char* message, gpointer self) {
	vtg_build_log_view_on_message_added (self, _sender, output_type, message);
}


VtgBuildLogView* vtg_build_log_view_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgBuildLogView * self;
	GeditPanel* panel;
	GtkVBox* _tmp0_;
	GtkToolbar* toolbar;
	GtkToggleToolButton* _tmp1_;
	GtkToggleToolButton* _tmp2_;
	GtkSeparatorToolItem* separator;
	GtkToggleToolButton* _tmp3_;
	GtkToggleToolButton* _tmp4_;
	GtkListStore* _tmp5_;
	GtkTreeModelFilter* model_tmp;
	GtkTreeView* _tmp6_;
	GtkCellRenderer* renderer;
	GtkTreeViewColumn* column;
	GtkCellRenderer* _tmp7_;
	GtkCellRenderer* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkCellRenderer* _tmp10_;
	GtkTreeViewColumn* _tmp11_;
	GtkCellRenderer* _tmp12_;
	GtkTreeViewColumn* _tmp13_;
	GtkScrolledWindow* scroll;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgBuildLogView*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	panel = _g_object_ref0 (gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	self->priv->_ui = (_tmp0_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 8)), _g_object_unref0 (self->priv->_ui), _tmp0_);
	toolbar = g_object_ref_sink ((GtkToolbar*) gtk_toolbar_new ());
	gtk_toolbar_set_style (toolbar, GTK_TOOLBAR_BOTH_HORIZ);
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_SMALL_TOOLBAR);
	self->priv->_vala_warning_button = (_tmp1_ = g_object_ref_sink ((GtkToggleToolButton*) gtk_toggle_tool_button_new ()), _g_object_unref0 (self->priv->_vala_warning_button), _tmp1_);
	gtk_tool_button_set_label ((GtkToolButton*) self->priv->_vala_warning_button, _ ("Warnings"));
	gtk_tool_item_set_is_important ((GtkToolItem*) self->priv->_vala_warning_button, TRUE);
	gtk_tool_button_set_icon_name ((GtkToolButton*) self->priv->_vala_warning_button, GTK_STOCK_DIALOG_WARNING);
	gtk_toggle_tool_button_set_active (self->priv->_vala_warning_button, TRUE);
	g_signal_connect_object (self->priv->_vala_warning_button, "toggled", (GCallback) _vtg_build_log_view_on_toggle_vala_warnings_toggled_gtk_toggle_tool_button_toggled, self, 0);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self->priv->_vala_warning_button, _ ("Show or hide the warnings from the build result view"));
	gtk_toolbar_insert (toolbar, (GtkToolItem*) self->priv->_vala_warning_button, -1);
	self->priv->_vala_error_button = (_tmp2_ = g_object_ref_sink ((GtkToggleToolButton*) gtk_toggle_tool_button_new ()), _g_object_unref0 (self->priv->_vala_error_button), _tmp2_);
	gtk_tool_button_set_label ((GtkToolButton*) self->priv->_vala_error_button, _ ("Errors"));
	gtk_tool_item_set_is_important ((GtkToolItem*) self->priv->_vala_error_button, TRUE);
	gtk_tool_button_set_icon_name ((GtkToolButton*) self->priv->_vala_error_button, GTK_STOCK_DIALOG_ERROR);
	g_signal_connect_object (self->priv->_vala_error_button, "toggled", (GCallback) _vtg_build_log_view_on_toggle_vala_errors_toggled_gtk_toggle_tool_button_toggled, self, 0);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self->priv->_vala_error_button, _ ("Show or hide the errors from the build result view"));
	gtk_toggle_tool_button_set_active (self->priv->_vala_error_button, TRUE);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) self->priv->_vala_error_button, -1);
	separator = g_object_ref_sink ((GtkSeparatorToolItem*) gtk_separator_tool_item_new ());
	gtk_toolbar_insert (toolbar, (GtkToolItem*) separator, -1);
	self->priv->_c_warning_button = (_tmp3_ = g_object_ref_sink ((GtkToggleToolButton*) gtk_toggle_tool_button_new ()), _g_object_unref0 (self->priv->_c_warning_button), _tmp3_);
	gtk_tool_button_set_label ((GtkToolButton*) self->priv->_c_warning_button, _ ("C Warnings"));
	gtk_tool_item_set_is_important ((GtkToolItem*) self->priv->_c_warning_button, TRUE);
	gtk_tool_button_set_icon_name ((GtkToolButton*) self->priv->_c_warning_button, GTK_STOCK_DIALOG_WARNING);
	gtk_toggle_tool_button_set_active (self->priv->_c_warning_button, self->priv->_show_c_warnings);
	g_signal_connect_object (self->priv->_c_warning_button, "toggled", (GCallback) _vtg_build_log_view_on_toggle_c_warnings_toggled_gtk_toggle_tool_button_toggled, self, 0);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self->priv->_c_warning_button, _ ("Show or hide the C warnings from the build result view"));
	gtk_toolbar_insert (toolbar, (GtkToolItem*) self->priv->_c_warning_button, -1);
	self->priv->_c_error_button = (_tmp4_ = g_object_ref_sink ((GtkToggleToolButton*) gtk_toggle_tool_button_new ()), _g_object_unref0 (self->priv->_c_error_button), _tmp4_);
	gtk_tool_button_set_label ((GtkToolButton*) self->priv->_c_error_button, _ ("C Errors"));
	gtk_tool_item_set_is_important ((GtkToolItem*) self->priv->_c_error_button, TRUE);
	gtk_tool_button_set_icon_name ((GtkToolButton*) self->priv->_c_error_button, GTK_STOCK_DIALOG_ERROR);
	g_signal_connect_object (self->priv->_c_error_button, "toggled", (GCallback) _vtg_build_log_view_on_toggle_c_errors_toggled_gtk_toggle_tool_button_toggled, self, 0);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self->priv->_c_error_button, _ ("Show or hide the C errors from the build result view"));
	gtk_toggle_tool_button_set_active (self->priv->_c_error_button, TRUE);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) self->priv->_c_error_button, -1);
	gtk_box_pack_start ((GtkBox*) self->priv->_ui, (GtkWidget*) toolbar, FALSE, TRUE, (guint) 0);
	self->priv->_child_model = (_tmp5_ = gtk_list_store_new ((gint) VTG_BUILD_LOG_VIEW_COLUMNS_COLUMNS_COUNT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_OBJECT), _g_object_unref0 (self->priv->_child_model), _tmp5_);
	model_tmp = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) self->priv->_child_model, NULL);
	self->priv->_model = model_tmp;
	gtk_tree_model_filter_set_visible_func (self->priv->_model, _vtg_build_log_view_filter_model_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	self->priv->_build_view = (_tmp6_ = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->_model)), _g_object_unref0 (self->priv->_build_view), _tmp6_);
	renderer = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ());
	column = g_object_ref_sink (gtk_tree_view_column_new ());
	gtk_tree_view_column_set_title (column, _ ("Message"));
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "stock-id", (gint) VTG_BUILD_LOG_VIEW_COLUMNS_ICON);
	renderer = (_tmp7_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp7_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "text", (gint) VTG_BUILD_LOG_VIEW_COLUMNS_MESSAGE);
	gtk_tree_view_append_column (self->priv->_build_view, column);
	renderer = (_tmp8_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp8_);
	column = (_tmp9_ = g_object_ref_sink (gtk_tree_view_column_new ()), _g_object_unref0 (column), _tmp9_);
	gtk_tree_view_column_set_title (column, _ ("File"));
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "text", (gint) VTG_BUILD_LOG_VIEW_COLUMNS_FILENAME);
	gtk_tree_view_append_column (self->priv->_build_view, column);
	renderer = (_tmp10_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp10_);
	column = (_tmp11_ = g_object_ref_sink (gtk_tree_view_column_new ()), _g_object_unref0 (column), _tmp11_);
	gtk_tree_view_column_set_title (column, _ ("Line"));
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "text", (gint) VTG_BUILD_LOG_VIEW_COLUMNS_LINE);
	gtk_tree_view_append_column (self->priv->_build_view, column);
	renderer = (_tmp12_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp12_);
	column = (_tmp13_ = g_object_ref_sink (gtk_tree_view_column_new ()), _g_object_unref0 (column), _tmp13_);
	gtk_tree_view_column_set_title (column, _ ("Column"));
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "text", (gint) VTG_BUILD_LOG_VIEW_COLUMNS_COLUMN);
	gtk_tree_view_append_column (self->priv->_build_view, column);
	g_signal_connect_object (self->priv->_build_view, "row-activated", (GCallback) _vtg_build_log_view_on_build_view_row_activated_gtk_tree_view_row_activated, self, 0);
	gtk_tree_view_set_rules_hint (self->priv->_build_view, TRUE);
	scroll = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->_build_view);
	gtk_box_pack_start ((GtkBox*) self->priv->_ui, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) self->priv->_ui);
	gedit_panel_add_item_with_stock_icon (panel, (GtkWidget*) self->priv->_ui, _ ("Build results"), GTK_STOCK_EXECUTE);
	g_signal_connect_object (vtg_plugin_instance_get_output_view (self->priv->_plugin_instance), "message-added", (GCallback) _vtg_build_log_view_on_message_added_vtg_output_view_message_added, self, 0);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->_child_model, 5, GTK_SORT_ASCENDING);
	vtg_build_log_view_update_toolbar_button_status (self);
	_g_object_unref0 (scroll);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer);
	_g_object_unref0 (model_tmp);
	_g_object_unref0 (separator);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (panel);
	return self;
}


VtgBuildLogView* vtg_build_log_view_new (VtgPluginInstance* plugin_instance) {
	return vtg_build_log_view_construct (VTG_TYPE_BUILD_LOG_VIEW, plugin_instance);
}


void vtg_build_log_view_destroy (VtgBuildLogView* self) {
	GeditPanel* panel;
	GtkVBox* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkListStore* _tmp2_;
	g_return_if_fail (self != NULL);
	panel = _g_object_ref0 (gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	gedit_panel_remove_item (panel, (GtkWidget*) self->priv->_ui);
	self->priv->_ui = (_tmp0_ = NULL, _g_object_unref0 (self->priv->_ui), _tmp0_);
	self->priv->_model = NULL;
	self->priv->_build_view = (_tmp1_ = NULL, _g_object_unref0 (self->priv->_build_view), _tmp1_);
	self->priv->_child_model = (_tmp2_ = NULL, _g_object_unref0 (self->priv->_child_model), _tmp2_);
	_g_object_unref0 (panel);
}


void vtg_build_log_view_initialize (VtgBuildLogView* self, VtgProjectManager* project) {
	g_return_if_fail (self != NULL);
	self->priv->_project = project;
	self->priv->_current_error_row = 0;
	self->priv->_vala_error_count = 0;
	self->priv->_vala_warning_count = 0;
	self->priv->_c_error_count = 0;
	self->priv->_c_warning_count = 0;
	gtk_list_store_clear (self->priv->_child_model);
	vtg_build_log_view_update_toolbar_button_status (self);
}


void vtg_build_log_view_activate (VtgBuildLogView* self) {
	GeditPanel* panel;
	GeditView* view;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	panel = _g_object_ref0 (gedit_window_get_bottom_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	gedit_panel_activate_item (panel, (GtkWidget*) self->priv->_ui);
	view = _g_object_ref0 (gedit_window_get_active_view (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	if (view != NULL) {
		gboolean _tmp1_;
		_tmp0_ = !(g_object_get ((GtkWidget*) view, "is-focus", &_tmp1_, NULL), _tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_widget_grab_focus ((GtkWidget*) view);
	}
	_g_object_unref0 (view);
	_g_object_unref0 (panel);
}


static void vtg_build_log_view_on_toggle_vala_warnings_toggled (VtgBuildLogView* self, GtkToggleToolButton* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	self->priv->_show_vala_warnings = gtk_toggle_tool_button_get_active (sender);
	if (self->priv->_model != NULL) {
		gtk_tree_model_filter_refilter (self->priv->_model);
	}
}


static void vtg_build_log_view_on_toggle_vala_errors_toggled (VtgBuildLogView* self, GtkToggleToolButton* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	self->priv->_show_vala_errors = gtk_toggle_tool_button_get_active (sender);
	if (self->priv->_model != NULL) {
		gtk_tree_model_filter_refilter (self->priv->_model);
	}
}


static void vtg_build_log_view_on_toggle_c_warnings_toggled (VtgBuildLogView* self, GtkToggleToolButton* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	self->priv->_show_c_warnings = gtk_toggle_tool_button_get_active (sender);
	if (self->priv->_model != NULL) {
		gtk_tree_model_filter_refilter (self->priv->_model);
	}
}


static void vtg_build_log_view_on_toggle_c_errors_toggled (VtgBuildLogView* self, GtkToggleToolButton* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	self->priv->_show_c_errors = gtk_toggle_tool_button_get_active (sender);
	if (self->priv->_model != NULL) {
		gtk_tree_model_filter_refilter (self->priv->_model);
	}
}


void vtg_build_log_view_on_message_added (VtgBuildLogView* self, VtgOutputView* sender, VtgOutputTypes output_type, const char* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (message != NULL);
	vtg_build_log_view_add_message (self, output_type, message);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


void vtg_build_log_view_on_build_view_row_activated (VtgBuildLogView* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreePath* child_path;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	child_path = _gtk_tree_path_copy0 (gtk_tree_model_filter_convert_path_to_child_path (self->priv->_model, path));
	vtg_build_log_view_activate_path (self, child_path);
	_gtk_tree_path_free0 (child_path);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void vtg_build_log_view_activate_path (VtgBuildLogView* self, GtkTreePath* path) {
	GtkTreeIter iter = {0};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (gtk_tree_model_get_iter ((GtkTreeModel*) self->priv->_child_model, &iter, path)) {
		char* name;
		gint line = 0;
		gint col = 0;
		gboolean is_vala_source = FALSE;
		VtgProjectManager* proj;
		name = NULL;
		proj = NULL;
		gtk_tree_model_get ((GtkTreeModel*) self->priv->_child_model, &iter, VTG_BUILD_LOG_VIEW_COLUMNS_FILENAME, &name, VTG_BUILD_LOG_VIEW_COLUMNS_LINE, &line, VTG_BUILD_LOG_VIEW_COLUMNS_COLUMN, &col, VTG_BUILD_LOG_VIEW_COLUMNS_IS_VALA_SOURCE, &is_vala_source, VTG_BUILD_LOG_VIEW_COLUMNS_PROJECT, &proj, -1);
		if (proj != NULL) {
			char* uri;
			uri = NULL;
			if (is_vala_source) {
				char* _tmp0_;
				uri = (_tmp0_ = vtg_project_manager_source_uri_for_name (proj, name), _g_free0 (uri), _tmp0_);
			} else {
				char* _tmp1_;
				gboolean _tmp2_;
				if ((_tmp2_ = g_str_has_prefix (name, _tmp1_ = g_strdup_printf ("%c", G_DIR_SEPARATOR)), _g_free0 (_tmp1_), _tmp2_)) {
					{
						char* _tmp3_;
						char* _tmp4_;
						_tmp3_ = g_filename_to_uri (name, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch36_g_error;
						}
						uri = (_tmp4_ = _tmp3_, _g_free0 (uri), _tmp4_);
					}
					goto __finally36;
					__catch36_g_error:
					{
						GError * err;
						err = _inner_error_;
						_inner_error_ = NULL;
						{
							g_critical ("vtgbuildlogview.vala:313: error: %s", err->message);
							_g_error_free0 (err);
						}
					}
					__finally36:
					if (_inner_error_ != NULL) {
						_g_free0 (uri);
						_g_object_unref0 (proj);
						_g_free0 (name);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					char* _tmp5_;
					char* _tmp6_;
					char* vala_name;
					char* _tmp7_;
					vala_name = (_tmp6_ = g_strconcat (_tmp5_ = string_substring (name, (glong) 0, string_get_length (name) - string_get_length (".c")), ".vala", NULL), _g_free0 (_tmp5_), _tmp6_);
					uri = (_tmp7_ = vtg_project_manager_source_uri_for_name (proj, vala_name), _g_free0 (uri), _tmp7_);
					if (uri == NULL) {
						char* _tmp8_;
						char* _tmp9_;
						char* _tmp10_;
						vala_name = (_tmp9_ = g_strconcat (_tmp8_ = string_substring (name, (glong) 0, string_get_length (name) - string_get_length (".c")), ".vapi", NULL), _g_free0 (vala_name), _tmp9_);
						_g_free0 (_tmp8_);
						uri = (_tmp10_ = vtg_project_manager_source_uri_for_name (proj, vala_name), _g_free0 (uri), _tmp10_);
					}
					if (uri != NULL) {
						char* _tmp11_;
						char* _tmp12_;
						uri = (_tmp12_ = g_build_filename (_tmp11_ = g_path_get_dirname (uri), name, NULL), _g_free0 (uri), _tmp12_);
						_g_free0 (_tmp11_);
					}
					_g_free0 (vala_name);
				}
			}
			if (uri != NULL) {
				GeditTab* _tmp13_;
				_tmp13_ = vtg_plugin_instance_activate_uri (self->priv->_plugin_instance, uri, line, col);
				_g_object_unref0 (_tmp13_);
			} else {
				g_warning ("vtgbuildlogview.vala:331: Couldn't find uri for source: %s", name);
			}
			_g_free0 (uri);
		} else {
			vtg_plugin_instance_activate_display_name (self->priv->_plugin_instance, name, line, col);
		}
		_g_object_unref0 (proj);
		_g_free0 (name);
	}
}


void vtg_build_log_view_next_error (VtgBuildLogView* self) {
	char* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* path;
	g_return_if_fail (self != NULL);
	path = (_tmp1_ = gtk_tree_path_new_from_string (_tmp0_ = g_strdup_printf ("%i", self->priv->_current_error_row)), _g_free0 (_tmp0_), _tmp1_);
	if (path != NULL) {
		GtkTreePath* child_path;
		child_path = _gtk_tree_path_copy0 (gtk_tree_model_filter_convert_path_to_child_path (self->priv->_model, path));
		vtg_build_log_view_activate_path (self, child_path);
		gtk_tree_view_scroll_to_cell (self->priv->_build_view, path, NULL, FALSE, (float) 0, (float) 0);
		gtk_tree_selection_select_path (gtk_tree_view_get_selection (self->priv->_build_view), path);
		_gtk_tree_path_free0 (child_path);
	}
	if (self->priv->_current_error_row < (vtg_build_log_view_get_shown_messages (self) - 1)) {
		self->priv->_current_error_row++;
	} else {
		self->priv->_current_error_row = 0;
	}
	_gtk_tree_path_free0 (path);
}


void vtg_build_log_view_previous_error (VtgBuildLogView* self) {
	char* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* path;
	g_return_if_fail (self != NULL);
	path = (_tmp1_ = gtk_tree_path_new_from_string (_tmp0_ = g_strdup_printf ("%i", self->priv->_current_error_row)), _g_free0 (_tmp0_), _tmp1_);
	if (path != NULL) {
		GtkTreePath* child_path;
		child_path = _gtk_tree_path_copy0 (gtk_tree_model_filter_convert_path_to_child_path (self->priv->_model, path));
		vtg_build_log_view_activate_path (self, child_path);
		gtk_tree_view_scroll_to_cell (self->priv->_build_view, path, NULL, FALSE, (float) 0, (float) 0);
		gtk_tree_selection_select_path (gtk_tree_view_get_selection (self->priv->_build_view), path);
		_gtk_tree_path_free0 (child_path);
	}
	if (self->priv->_current_error_row > 0) {
		self->priv->_current_error_row--;
	} else {
		self->priv->_current_error_row = vtg_build_log_view_get_shown_messages (self) - 1;
	}
	_gtk_tree_path_free0 (path);
}


void vtg_build_log_view_clear_messages (VtgBuildLogView* self) {
	g_return_if_fail (self != NULL);
	gtk_list_store_clear (self->priv->_child_model);
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


void vtg_build_log_view_clear_messages_for_source (VtgBuildLogView* self, const char* filename) {
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	if (gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->_child_model, &iter)) {
		ValaList* to_del;
		char* basename;
		to_del = (ValaList*) vala_array_list_new (GTK_TYPE_TREE_ITER, (GBoxedCopyFunc) _gtk_tree_iter_dup, g_free, g_direct_equal);
		basename = g_path_get_basename (filename);
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* file;
				gboolean is_warning = FALSE;
				gboolean is_auto_build = FALSE;
				gboolean _tmp1_ = FALSE;
				if (!_tmp0_) {
					if (!gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->_child_model, &iter)) {
						break;
					}
				}
				_tmp0_ = FALSE;
				file = NULL;
				gtk_tree_model_get ((GtkTreeModel*) self->priv->_child_model, &iter, VTG_BUILD_LOG_VIEW_COLUMNS_FILENAME, &file, VTG_BUILD_LOG_VIEW_COLUMNS_IS_WARNING, &is_warning, VTG_BUILD_LOG_VIEW_COLUMNS_IS_AUTO_BUILD_MESSAGE, &is_auto_build, -1);
				if (is_auto_build) {
					_tmp1_ = _vala_strcmp0 (file, basename) == 0;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					GtkTreeIter copy;
					copy = iter;
					vala_collection_add ((ValaCollection*) to_del, &copy);
					if (is_warning) {
						self->priv->_vala_warning_count--;
					} else {
						self->priv->_vala_error_count--;
					}
				}
				_g_free0 (file);
			}
		}
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) to_del);
			while (TRUE) {
				GtkTreeIter* _tmp2_;
				GtkTreeIter _tmp3_;
				GtkTreeIter item;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (_tmp3_ = *(_tmp2_ = (GtkTreeIter*) vala_iterator_get (_item_it)), _g_free0 (_tmp2_), _tmp3_);
				gtk_list_store_remove (self->priv->_child_model, &item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
		vtg_build_log_view_update_toolbar_button_status (self);
		_g_free0 (basename);
		_vala_collection_object_unref0 (to_del);
	}
}


void vtg_build_log_view_update_parse_result (VtgBuildLogView* self, const char* filename, AfroditeParseResult* parse_result) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (parse_result != NULL);
	{
		ValaIterator* _message_it;
		_message_it = vala_iterable_iterator ((ValaIterable*) parse_result->errors);
		while (TRUE) {
			char* message;
			if (!vala_iterator_next (_message_it)) {
				break;
			}
			message = (char*) vala_iterator_get (_message_it);
			vtg_build_log_view_add_message (self, VTG_OUTPUT_TYPES_AUTO_BUILD, message);
			_g_free0 (message);
		}
		_vala_collection_object_unref0 (_message_it);
	}
	{
		ValaIterator* _message_it;
		_message_it = vala_iterable_iterator ((ValaIterable*) parse_result->warnings);
		while (TRUE) {
			char* message;
			if (!vala_iterator_next (_message_it)) {
				break;
			}
			message = (char*) vala_iterator_get (_message_it);
			vtg_build_log_view_add_message (self, VTG_OUTPUT_TYPES_AUTO_BUILD, message);
			_g_free0 (message);
		}
		_vala_collection_object_unref0 (_message_it);
	}
	vtg_build_log_view_update_toolbar_button_status (self);
}


static void vtg_build_log_view_add_message (VtgBuildLogView* self, VtgOutputTypes output_type, const char* message) {
	gboolean _tmp0_ = FALSE;
	gint lines_length1;
	gint _lines_size_;
	char** _tmp2_;
	char** _tmp1_;
	char** lines;
	gint idx;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	if (output_type != VTG_OUTPUT_TYPES_BUILD) {
		_tmp0_ = output_type != VTG_OUTPUT_TYPES_AUTO_BUILD;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	lines = (_tmp2_ = _tmp1_ = g_strsplit (message, "\n", 0), lines_length1 = _vala_array_length (_tmp1_), _lines_size_ = lines_length1, _tmp2_);
	idx = 0;
	while (TRUE) {
		gint tmp_length1;
		gint _tmp_size_;
		char** _tmp4_;
		char** _tmp3_;
		char** tmp;
		gboolean _tmp5_ = FALSE;
		if (!(lines[idx] != NULL)) {
			break;
		}
		tmp = (_tmp4_ = _tmp3_ = g_strsplit (lines[idx], ":", 2), tmp_length1 = _vala_array_length (_tmp3_), _tmp_size_ = tmp_length1, _tmp4_);
		if (!vtg_string_utils_is_null_or_empty (tmp[0])) {
			_tmp5_ = !vtg_string_utils_is_null_or_empty (tmp[1]);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gboolean _tmp6_ = FALSE;
			if (g_str_has_suffix (tmp[0], ".vala")) {
				_tmp6_ = TRUE;
			} else {
				_tmp6_ = g_str_has_suffix (tmp[0], ".vapi");
			}
			if (_tmp6_) {
				vtg_build_log_view_add_vala_message (self, tmp[0], tmp[1], output_type == VTG_OUTPUT_TYPES_AUTO_BUILD);
			} else {
				gboolean _tmp7_ = FALSE;
				if (g_str_has_suffix (tmp[0], ".c")) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = g_str_has_suffix (tmp[0], ".h");
				}
				if (_tmp7_) {
					vtg_build_log_view_add_c_message (self, tmp[0], tmp[1], output_type == VTG_OUTPUT_TYPES_AUTO_BUILD);
				}
			}
		}
		idx++;
		tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


static void vtg_build_log_view_add_vala_message (VtgBuildLogView* self, const char* file, const char* message, gboolean is_auto_build_message) {
	gint parts_length1;
	gint _parts_size_;
	char** _tmp1_;
	char** _tmp0_;
	char** parts;
	gint src_ref_length1;
	gint _src_ref_size_;
	char** _tmp6_;
	char** _tmp2_;
	char** _tmp3_;
	gint _tmp3__length1;
	char** _tmp4_;
	char** _tmp5_;
	char** src_ref;
	gint line;
	gint col;
	char* stock_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (message != NULL);
	parts = (_tmp1_ = _tmp0_ = g_strsplit (message, ":", 3), parts_length1 = _vala_array_length (_tmp0_), _parts_size_ = parts_length1, _tmp1_);
	src_ref = (_tmp6_ = (_tmp5_ = _tmp4_ = g_strsplit ((_tmp3_ = _tmp2_ = g_strsplit (parts[0], "-", 0), _tmp3__length1 = _vala_array_length (_tmp2_), _tmp3_)[0], ".", 0), _tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL), _tmp5_), src_ref_length1 = _vala_array_length (_tmp4_), _src_ref_size_ = src_ref_length1, _tmp6_);
	if (src_ref_length1 < 2) {
		src_ref = (_vala_array_free (src_ref, src_ref_length1, (GDestroyNotify) g_free), NULL);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	line = atoi (src_ref[0]);
	col = 0;
	if (src_ref[1] != NULL) {
		col = atoi (src_ref[1]);
	}
	stock_id = NULL;
	if (parts[1] != NULL) {
		if (parts[2] != NULL) {
			gint is_warning;
			GtkTreeIter iter = {0};
			is_warning = 0;
			if (g_str_has_suffix (parts[1], "error")) {
				char* _tmp7_;
				stock_id = (_tmp7_ = g_strdup (GTK_STOCK_DIALOG_ERROR), _g_free0 (stock_id), _tmp7_);
				self->priv->_vala_error_count++;
				is_warning = 0;
			} else {
				if (g_str_has_suffix (parts[1], "warning")) {
					char* _tmp8_;
					stock_id = (_tmp8_ = g_strdup (GTK_STOCK_DIALOG_WARNING), _g_free0 (stock_id), _tmp8_);
					self->priv->_vala_warning_count++;
					is_warning = 1;
				} else {
					self->priv->_vala_error_count++;
					is_warning = 0;
				}
			}
			gtk_list_store_append (self->priv->_child_model, &iter);
			gtk_list_store_set (self->priv->_child_model, &iter, VTG_BUILD_LOG_VIEW_COLUMNS_ICON, stock_id, VTG_BUILD_LOG_VIEW_COLUMNS_MESSAGE, parts[2], VTG_BUILD_LOG_VIEW_COLUMNS_FILENAME, file, VTG_BUILD_LOG_VIEW_COLUMNS_LINE, line, VTG_BUILD_LOG_VIEW_COLUMNS_COLUMN, col, VTG_BUILD_LOG_VIEW_COLUMNS_IS_WARNING, is_warning, VTG_BUILD_LOG_VIEW_COLUMNS_IS_VALA_SOURCE, TRUE, VTG_BUILD_LOG_VIEW_COLUMNS_IS_AUTO_BUILD_MESSAGE, is_auto_build_message, VTG_BUILD_LOG_VIEW_COLUMNS_PROJECT, self->priv->_project, -1);
			vtg_build_log_view_update_toolbar_button_status (self);
		}
	}
	_g_free0 (stock_id);
	src_ref = (_vala_array_free (src_ref, src_ref_length1, (GDestroyNotify) g_free), NULL);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static char* string_chomp (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static void vtg_build_log_view_add_c_message (VtgBuildLogView* self, const char* file, const char* message, gboolean is_auto_build_message) {
	gint parts_length1;
	gint _parts_size_;
	char** _tmp1_;
	char** _tmp0_;
	char** parts;
	gint src_ref_length1;
	gint _src_ref_size_;
	char** _tmp6_;
	char** _tmp2_;
	char** _tmp3_;
	gint _tmp3__length1;
	char** _tmp4_;
	char** _tmp5_;
	char** src_ref;
	gint line;
	char* stock_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (message != NULL);
	parts = (_tmp1_ = _tmp0_ = g_strsplit (message, ":", 3), parts_length1 = _vala_array_length (_tmp0_), _parts_size_ = parts_length1, _tmp1_);
	src_ref = (_tmp6_ = (_tmp5_ = _tmp4_ = g_strsplit ((_tmp3_ = _tmp2_ = g_strsplit (parts[0], "-", 0), _tmp3__length1 = _vala_array_length (_tmp2_), _tmp3_)[0], ".", 0), _tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL), _tmp5_), src_ref_length1 = _vala_array_length (_tmp4_), _src_ref_size_ = src_ref_length1, _tmp6_);
	if (src_ref_length1 > 1) {
		src_ref = (_vala_array_free (src_ref, src_ref_length1, (GDestroyNotify) g_free), NULL);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	line = atoi (src_ref[0]);
	stock_id = NULL;
	if (parts[1] != NULL) {
		if (parts[2] != NULL) {
			char* message_type;
			char* message_text;
			gint is_warning;
			GtkTreeIter iter = {0};
			message_type = NULL;
			message_text = NULL;
			is_warning = 0;
			if (atoi (parts[1]) != 0) {
				gint tmp_length1;
				gint _tmp_size_;
				char** _tmp8_;
				char** _tmp7_;
				char** tmp;
				char* _tmp9_;
				char* _tmp10_;
				tmp = (_tmp8_ = _tmp7_ = g_strsplit (parts[2], ":", 2), tmp_length1 = _vala_array_length (_tmp7_), _tmp_size_ = tmp_length1, _tmp8_);
				message_type = (_tmp9_ = string_strip (tmp[0]), _g_free0 (message_type), _tmp9_);
				message_text = (_tmp10_ = g_strdup (tmp[1]), _g_free0 (message_text), _tmp10_);
				tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
			} else {
				char* _tmp11_;
				char* _tmp12_;
				message_type = (_tmp11_ = g_strdup (parts[1]), _g_free0 (message_type), _tmp11_);
				message_text = (_tmp12_ = g_strdup (parts[2]), _g_free0 (message_text), _tmp12_);
			}
			if (g_str_has_suffix (message_type, "error")) {
				char* _tmp13_;
				stock_id = (_tmp13_ = g_strdup (GTK_STOCK_DIALOG_ERROR), _g_free0 (stock_id), _tmp13_);
				self->priv->_c_error_count++;
				is_warning = 0;
			} else {
				if (g_str_has_suffix (message_type, "warning")) {
					char* _tmp14_;
					stock_id = (_tmp14_ = g_strdup (GTK_STOCK_DIALOG_WARNING), _g_free0 (stock_id), _tmp14_);
					self->priv->_c_warning_count++;
					is_warning = 1;
				} else {
					char* _tmp15_;
					gboolean _tmp16_;
					if ((_tmp16_ = !g_str_has_suffix (_tmp15_ = string_chomp (message_type), "note"), _g_free0 (_tmp15_), _tmp16_)) {
						vtg_utils_trace ("vtgbuildlogview.vala:552: unrecognized message category, default to er" \
"ror for %s: '%s' ---> '%s' '%s' '%s'", file, message, parts[0], message_type, message_text);
						self->priv->_c_error_count++;
						is_warning = 0;
					} else {
						_g_free0 (message_text);
						_g_free0 (message_type);
						_g_free0 (stock_id);
						src_ref = (_vala_array_free (src_ref, src_ref_length1, (GDestroyNotify) g_free), NULL);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
				}
			}
			gtk_list_store_append (self->priv->_child_model, &iter);
			gtk_list_store_set (self->priv->_child_model, &iter, VTG_BUILD_LOG_VIEW_COLUMNS_ICON, stock_id, VTG_BUILD_LOG_VIEW_COLUMNS_MESSAGE, message_text, VTG_BUILD_LOG_VIEW_COLUMNS_FILENAME, file, VTG_BUILD_LOG_VIEW_COLUMNS_LINE, line, VTG_BUILD_LOG_VIEW_COLUMNS_COLUMN, 0, VTG_BUILD_LOG_VIEW_COLUMNS_IS_WARNING, is_warning, VTG_BUILD_LOG_VIEW_COLUMNS_IS_VALA_SOURCE, FALSE, VTG_BUILD_LOG_VIEW_COLUMNS_IS_AUTO_BUILD_MESSAGE, is_auto_build_message, VTG_BUILD_LOG_VIEW_COLUMNS_PROJECT, self->priv->_project, -1);
			vtg_build_log_view_update_toolbar_button_status (self);
			_g_free0 (message_text);
			_g_free0 (message_type);
		}
	}
	_g_free0 (stock_id);
	src_ref = (_vala_array_free (src_ref, src_ref_length1, (GDestroyNotify) g_free), NULL);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
}


static void vtg_build_log_view_update_toolbar_button_status (VtgBuildLogView* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_vala_warning_count == 0) {
		gtk_tool_button_set_label ((GtkToolButton*) self->priv->_vala_warning_button, _ ("Warnings"));
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_vala_warning_button, FALSE);
	} else {
		char* _tmp0_;
		gtk_tool_button_set_label ((GtkToolButton*) self->priv->_vala_warning_button, _tmp0_ = g_strdup_printf ("%s (%d)", _ ("Warnings"), self->priv->_vala_warning_count));
		_g_free0 (_tmp0_);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_vala_warning_button, TRUE);
	}
	if (self->priv->_vala_error_count == 0) {
		gtk_tool_button_set_label ((GtkToolButton*) self->priv->_vala_error_button, _ ("Errors"));
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_vala_error_button, FALSE);
	} else {
		char* _tmp1_;
		gtk_tool_button_set_label ((GtkToolButton*) self->priv->_vala_error_button, _tmp1_ = g_strdup_printf ("%s (%d)", _ ("Errors"), self->priv->_vala_error_count));
		_g_free0 (_tmp1_);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_vala_error_button, TRUE);
	}
	if (self->priv->_c_warning_count == 0) {
		gtk_tool_button_set_label ((GtkToolButton*) self->priv->_c_warning_button, _ ("C Warnings"));
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_c_warning_button, FALSE);
	} else {
		char* _tmp2_;
		gtk_tool_button_set_label ((GtkToolButton*) self->priv->_c_warning_button, _tmp2_ = g_strdup_printf ("%s (%d)", _ ("C Warnings"), self->priv->_c_warning_count));
		_g_free0 (_tmp2_);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_c_warning_button, TRUE);
	}
	if (self->priv->_c_error_count == 0) {
		gtk_tool_button_set_label ((GtkToolButton*) self->priv->_c_error_button, _ ("C Errors"));
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_c_error_button, FALSE);
	} else {
		char* _tmp3_;
		gtk_tool_button_set_label ((GtkToolButton*) self->priv->_c_error_button, _tmp3_ = g_strdup_printf ("%s (%d)", _ ("C Errors"), self->priv->_c_error_count));
		_g_free0 (_tmp3_);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_c_error_button, TRUE);
	}
}


static gboolean vtg_build_log_view_filter_model (VtgBuildLogView* self, GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	gboolean is_vala_source = FALSE;
	gint val = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	gtk_tree_model_get (model, iter, VTG_BUILD_LOG_VIEW_COLUMNS_IS_VALA_SOURCE, &is_vala_source, VTG_BUILD_LOG_VIEW_COLUMNS_IS_WARNING, &val, -1);
	if (is_vala_source) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (self->priv->_show_vala_warnings) {
			_tmp0_ = self->priv->_show_vala_errors;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
		if (val == 0) {
			_tmp1_ = self->priv->_show_vala_errors;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (val == 1) {
				_tmp2_ = self->priv->_show_vala_warnings;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = TRUE;
				return result;
			}
		}
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (self->priv->_show_c_warnings) {
			_tmp3_ = self->priv->_show_c_errors;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		}
		if (val == 0) {
			_tmp4_ = self->priv->_show_c_errors;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp5_ = FALSE;
			if (val == 1) {
				_tmp5_ = self->priv->_show_c_warnings;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}


gint vtg_build_log_view_get_error_count (VtgBuildLogView* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_vala_error_count + self->priv->_c_error_count;
	return result;
}


gint vtg_build_log_view_get_warning_count (VtgBuildLogView* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_vala_warning_count + self->priv->_c_warning_count;
	return result;
}


static gint vtg_build_log_view_get_shown_messages (VtgBuildLogView* self) {
	gint result;
	gint count;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	if (self->priv->_show_vala_warnings) {
		count = count + self->priv->_vala_warning_count;
	}
	if (self->priv->_show_vala_errors) {
		count = count + self->priv->_vala_error_count;
	}
	if (self->priv->_show_c_warnings) {
		count = count + self->priv->_c_warning_count;
	}
	if (self->priv->_show_c_errors) {
		count = count + self->priv->_c_error_count;
	}
	result = count;
	return result;
}


static void vtg_build_log_view_class_init (VtgBuildLogViewClass * klass) {
	vtg_build_log_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgBuildLogViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_build_log_view_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_build_log_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_BUILD_LOG_VIEW_ERROR_COUNT, g_param_spec_int ("error-count", "error-count", "error-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_BUILD_LOG_VIEW_WARNING_COUNT, g_param_spec_int ("warning-count", "warning-count", "warning-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vtg_build_log_view_instance_init (VtgBuildLogView * self) {
	self->priv = VTG_BUILD_LOG_VIEW_GET_PRIVATE (self);
	self->priv->_child_model = NULL;
	self->priv->_build_view = NULL;
	self->priv->_current_error_row = 0;
	self->priv->_vala_error_count = 0;
	self->priv->_vala_warning_count = 0;
	self->priv->_c_error_count = 0;
	self->priv->_c_warning_count = 0;
	self->priv->_plugin_instance = NULL;
	self->priv->_show_vala_warnings = TRUE;
	self->priv->_show_vala_errors = TRUE;
	self->priv->_show_c_warnings = FALSE;
	self->priv->_show_c_errors = TRUE;
	self->priv->_vala_warning_button = NULL;
	self->priv->_vala_error_button = NULL;
	self->priv->_c_warning_button = NULL;
	self->priv->_c_error_button = NULL;
}


static void vtg_build_log_view_finalize (GObject* obj) {
	VtgBuildLogView * self;
	self = VTG_BUILD_LOG_VIEW (obj);
	{
		vtg_utils_trace ("vtgbuildlogview.vala:209: BuildLogView destroying");
		vtg_utils_trace ("vtgbuildlogview.vala:210: BuildLogView destroyed");
	}
	_g_object_unref0 (self->priv->_ui);
	_g_object_unref0 (self->priv->_child_model);
	_g_object_unref0 (self->priv->_build_view);
	_g_object_unref0 (self->priv->_vala_warning_button);
	_g_object_unref0 (self->priv->_vala_error_button);
	_g_object_unref0 (self->priv->_c_warning_button);
	_g_object_unref0 (self->priv->_c_error_button);
	G_OBJECT_CLASS (vtg_build_log_view_parent_class)->finalize (obj);
}


GType vtg_build_log_view_get_type (void) {
	return vtg_build_log_view_type_id;
}


GType vtg_build_log_view_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgBuildLogViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_build_log_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgBuildLogView), 0, (GInstanceInitFunc) vtg_build_log_view_instance_init, NULL };
	vtg_build_log_view_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgBuildLogView", &g_define_type_info, 0);
	return vtg_build_log_view_type_id;
}


static void vtg_build_log_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgBuildLogView * self;
	self = VTG_BUILD_LOG_VIEW (object);
	switch (property_id) {
		case VTG_BUILD_LOG_VIEW_ERROR_COUNT:
		g_value_set_int (value, vtg_build_log_view_get_error_count (self));
		break;
		case VTG_BUILD_LOG_VIEW_WARNING_COUNT:
		g_value_set_int (value, vtg_build_log_view_get_warning_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




