/* utils.c generated by valac 0.10.0, the Vala compiler
 * generated from utils.vala, do not modify */

/* utils.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <vala.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS (afrodite_utils_symbols_predefined_symbols_get_type ())
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbols))
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbolsClass))
#define AFRODITE_UTILS_SYMBOLS_IS_PREDEFINED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS))
#define AFRODITE_UTILS_SYMBOLS_IS_PREDEFINED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS))
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbolsClass))

typedef struct _AfroditeUtilsSymbolsPredefinedSymbols AfroditeUtilsSymbolsPredefinedSymbols;
typedef struct _AfroditeUtilsSymbolsPredefinedSymbolsClass AfroditeUtilsSymbolsPredefinedSymbolsClass;
#define _afrodite_utils_symbols_predefined_symbols_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_utils_symbols_predefined_symbols_unref (var), NULL)))
typedef struct _AfroditeUtilsSymbolsPredefinedSymbolsPrivate AfroditeUtilsSymbolsPredefinedSymbolsPrivate;

#define AFRODITE_TYPE_DATA_TYPE (afrodite_data_type_get_type ())
#define AFRODITE_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataType))
#define AFRODITE_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))
#define AFRODITE_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))

typedef struct _AfroditeDataType AfroditeDataType;
typedef struct _AfroditeDataTypeClass AfroditeDataTypeClass;

#define AFRODITE_TYPE_SYMBOL (afrodite_symbol_get_type ())
#define AFRODITE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbol))
#define AFRODITE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))
#define AFRODITE_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))

typedef struct _AfroditeSymbol AfroditeSymbol;
typedef struct _AfroditeSymbolClass AfroditeSymbolClass;
#define _afrodite_symbol_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_symbol_unref (var), NULL)))
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))

#define AFRODITE_TYPE_VOID_TYPE (afrodite_void_type_get_type ())
#define AFRODITE_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidType))
#define AFRODITE_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidTypeClass))
#define AFRODITE_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_VOID_TYPE))
#define AFRODITE_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_VOID_TYPE))
#define AFRODITE_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidTypeClass))

typedef struct _AfroditeVoidType AfroditeVoidType;
typedef struct _AfroditeVoidTypeClass AfroditeVoidTypeClass;

#define AFRODITE_TYPE_SYMBOL_ACCESSIBILITY (afrodite_symbol_accessibility_get_type ())
typedef struct _AfroditeSymbolPrivate AfroditeSymbolPrivate;

#define AFRODITE_TYPE_MEMBER_BINDING (afrodite_member_binding_get_type ())
typedef struct _AfroditeUtilsSymbolsParamSpecPredefinedSymbols AfroditeUtilsSymbolsParamSpecPredefinedSymbols;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

struct _AfroditeUtilsSymbolsPredefinedSymbols {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeUtilsSymbolsPredefinedSymbolsPrivate * priv;
	AfroditeDataType* signal_type;
};

struct _AfroditeUtilsSymbolsPredefinedSymbolsClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeUtilsSymbolsPredefinedSymbols *self);
};

struct _AfroditeUtilsSymbolsPredefinedSymbolsPrivate {
	AfroditeSymbol* _connect_method;
	AfroditeSymbol* _disconnect_method;
	AfroditeSymbol* _signal_symbol;
};

typedef enum  {
	AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE = 1,
	AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL = 1 << 1,
	AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED = 1 << 2,
	AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC = 1 << 3,
	AFRODITE_SYMBOL_ACCESSIBILITY_ANY = ((AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE | AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL) | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED) | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC
} AfroditeSymbolAccessibility;

typedef enum  {
	AFRODITE_MEMBER_BINDING_INSTANCE = 1,
	AFRODITE_MEMBER_BINDING_CLASS = 1 << 1,
	AFRODITE_MEMBER_BINDING_STATIC = 1 << 2,
	AFRODITE_MEMBER_BINDING_ANY = (AFRODITE_MEMBER_BINDING_INSTANCE | AFRODITE_MEMBER_BINDING_CLASS) | AFRODITE_MEMBER_BINDING_STATIC
} AfroditeMemberBinding;

struct _AfroditeSymbol {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeSymbolPrivate * priv;
	ValaList* resolved_targets;
	ValaList* resolve_targets;
	AfroditeMemberBinding binding;
	gboolean is_virtual;
	gboolean is_abstract;
	gboolean overrides;
	gint _static_child_count;
	gint _creation_method_child_count;
};

struct _AfroditeSymbolClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeSymbol *self);
};

struct _AfroditeUtilsSymbolsParamSpecPredefinedSymbols {
	GParamSpec parent_instance;
};


extern AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols__predefined;
AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols__predefined = NULL;
extern AfroditeVoidType* afrodite_symbol_VOID;
static gpointer afrodite_utils_symbols_predefined_symbols_parent_class = NULL;

void afrodite_utils_log_message (const char* log_domain, const char* format, va_list args);
void afrodite_utils_trace (const char* format, ...);
ValaList* afrodite_utils_get_package_paths (const char* pkg, ValaCodeContext* context, char** vapi_dirs, int vapi_dirs_length1);
gpointer afrodite_utils_symbols_predefined_symbols_ref (gpointer instance);
void afrodite_utils_symbols_predefined_symbols_unref (gpointer instance);
GParamSpec* afrodite_utils_symbols_param_spec_predefined_symbols (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_utils_symbols_value_set_predefined_symbols (GValue* value, gpointer v_object);
void afrodite_utils_symbols_value_take_predefined_symbols (GValue* value, gpointer v_object);
gpointer afrodite_utils_symbols_value_get_predefined_symbols (const GValue* value);
GType afrodite_utils_symbols_predefined_symbols_get_type (void) G_GNUC_CONST;
AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_get_predefined (void);
AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_predefined_symbols_new (void);
AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_predefined_symbols_construct (GType object_type);
gpointer afrodite_data_type_ref (gpointer instance);
void afrodite_data_type_unref (gpointer instance);
GParamSpec* afrodite_param_spec_data_type (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_data_type (GValue* value, gpointer v_object);
void afrodite_value_take_data_type (GValue* value, gpointer v_object);
gpointer afrodite_value_get_data_type (const GValue* value);
GType afrodite_data_type_get_type (void) G_GNUC_CONST;
gpointer afrodite_symbol_ref (gpointer instance);
void afrodite_symbol_unref (gpointer instance);
GParamSpec* afrodite_param_spec_symbol (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_symbol (GValue* value, gpointer v_object);
void afrodite_value_take_symbol (GValue* value, gpointer v_object);
gpointer afrodite_value_get_symbol (const GValue* value);
GType afrodite_symbol_get_type (void) G_GNUC_CONST;
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbolsPrivate))
enum  {
	AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_DUMMY_PROPERTY
};
AfroditeSymbol* afrodite_symbol_new (const char* fully_qualified_name, const char* type_name);
AfroditeSymbol* afrodite_symbol_construct (GType object_type, const char* fully_qualified_name, const char* type_name);
AfroditeDataType* afrodite_data_type_new (const char* type_name, const char* name);
AfroditeDataType* afrodite_data_type_construct (GType object_type, const char* type_name, const char* name);
void afrodite_symbol_set_return_type (AfroditeSymbol* self, AfroditeDataType* value);
AfroditeDataType* afrodite_symbol_get_return_type (AfroditeSymbol* self);
GType afrodite_void_type_get_type (void) G_GNUC_CONST;
void afrodite_data_type_set_symbol (AfroditeDataType* self, AfroditeSymbol* value);
GType afrodite_symbol_accessibility_get_type (void) G_GNUC_CONST;
void afrodite_symbol_set_access (AfroditeSymbol* self, AfroditeSymbolAccessibility value);
GType afrodite_member_binding_get_type (void) G_GNUC_CONST;
void afrodite_symbol_add_child (AfroditeSymbol* self, AfroditeSymbol* child);
static void afrodite_utils_symbols_predefined_symbols_finalize (AfroditeUtilsSymbolsPredefinedSymbols* obj);
char* afrodite_utils_unescape_xml_string (const char* text);
char* afrodite_utils_binary_operator_to_string (ValaBinaryOperator op);
char* afrodite_utils_unary_operator_to_string (ValaUnaryOperator op);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * This function shouldn't be used directly but just wrapped with a private one that
 * will specify the correct log domain. See the function trace (...) in this same source 
 */
inline void afrodite_utils_log_message (const char* log_domain, const char* format, va_list args) {
	g_return_if_fail (log_domain != NULL);
	g_return_if_fail (format != NULL);
	g_logv (log_domain, G_LOG_LEVEL_INFO, format, args);
}


inline void afrodite_utils_trace (const char* format, ...) {
	g_return_if_fail (format != NULL);
}


static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


ValaList* afrodite_utils_get_package_paths (const char* pkg, ValaCodeContext* context, char** vapi_dirs, int vapi_dirs_length1) {
	ValaList* result = NULL;
	ValaCodeContext* ctx;
	char* package_path;
	ValaArrayList* results;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* deps_filename;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (pkg != NULL, NULL);
	ctx = _vala_code_context_ref0 (context);
	if (ctx == NULL) {
		ValaCodeContext* _tmp0_;
		ctx = (_tmp0_ = vala_code_context_new (), _vala_code_context_unref0 (ctx), _tmp0_);
	}
	package_path = vala_code_context_get_package_path (ctx, pkg, vapi_dirs, vapi_dirs_length1);
	if (package_path == NULL) {
		result = NULL;
		_g_free0 (package_path);
		_vala_code_context_unref0 (ctx);
		return result;
	}
	results = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	deps_filename = (_tmp3_ = g_build_filename (_tmp1_ = g_path_get_dirname (package_path), _tmp2_ = g_strdup_printf ("%s.deps", pkg), NULL), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	if (g_file_test (deps_filename, G_FILE_TEST_EXISTS)) {
		{
			char* deps_content;
			gulong deps_len = 0UL;
			char* _tmp4_ = NULL;
			char* _tmp5_;
			deps_content = NULL;
			g_file_get_contents (deps_filename, &_tmp4_, &deps_len, &_inner_error_);
			deps_content = (_tmp5_ = _tmp4_, _g_free0 (deps_content), _tmp5_);
			if (_inner_error_ != NULL) {
				_g_free0 (deps_content);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch4_g_file_error;
				}
				_g_free0 (deps_content);
				_g_free0 (deps_filename);
				_vala_collection_object_unref0 (results);
				_g_free0 (package_path);
				_vala_code_context_unref0 (ctx);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			{
				char** _tmp6_;
				char** dep_collection;
				int dep_collection_length1;
				int dep_it;
				dep_collection = _tmp6_ = g_strsplit (deps_content, "\n", 0);
				dep_collection_length1 = _vala_array_length (_tmp6_);
				for (dep_it = 0; dep_it < _vala_array_length (_tmp6_); dep_it = dep_it + 1) {
					char* dep;
					dep = g_strdup (dep_collection[dep_it]);
					{
						char* _tmp7_;
						_tmp7_ = string_strip (dep);
						_g_free0 (_tmp7_);
						if (_vala_strcmp0 (dep, "") != 0) {
							ValaList* deps;
							deps = afrodite_utils_get_package_paths (dep, ctx, vapi_dirs, vapi_dirs_length1);
							if (deps == NULL) {
								char* _tmp8_;
								g_warning ("utils.vala:72: %s", _tmp8_ = g_strdup_printf ("%s, dependency of %s, not found in specified Vala API directories", dep, pkg));
								_g_free0 (_tmp8_);
							} else {
								{
									ValaIterator* _dep_package_it;
									_dep_package_it = vala_iterable_iterator ((ValaIterable*) deps);
									while (TRUE) {
										char* dep_package;
										if (!vala_iterator_next (_dep_package_it)) {
											break;
										}
										dep_package = (char*) vala_iterator_get (_dep_package_it);
										vala_collection_add ((ValaCollection*) results, dep_package);
										_g_free0 (dep_package);
									}
									_vala_collection_object_unref0 (_dep_package_it);
								}
							}
							_vala_collection_object_unref0 (deps);
						}
						_g_free0 (dep);
					}
				}
				dep_collection = (_vala_array_free (dep_collection, dep_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (deps_content);
		}
		goto __finally4;
		__catch4_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp9_;
				g_warning ("utils.vala:81: %s", _tmp9_ = g_strdup_printf ("Unable to read dependency file: %s", e->message));
				_g_free0 (_tmp9_);
				_g_error_free0 (e);
			}
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_free0 (deps_filename);
			_vala_collection_object_unref0 (results);
			_g_free0 (package_path);
			_vala_code_context_unref0 (ctx);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_collection_add ((ValaCollection*) results, package_path);
	result = (ValaList*) results;
	_g_free0 (deps_filename);
	_g_free0 (package_path);
	_vala_code_context_unref0 (ctx);
	return result;
}


static gpointer _afrodite_utils_symbols_predefined_symbols_ref0 (gpointer self) {
	return self ? afrodite_utils_symbols_predefined_symbols_ref (self) : NULL;
}


AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_get_predefined (void) {
	AfroditeUtilsSymbolsPredefinedSymbols* result = NULL;
	if (afrodite_utils_symbols__predefined == NULL) {
		AfroditeUtilsSymbolsPredefinedSymbols* _tmp0_;
		afrodite_utils_symbols__predefined = (_tmp0_ = afrodite_utils_symbols_predefined_symbols_new (), _afrodite_utils_symbols_predefined_symbols_unref0 (afrodite_utils_symbols__predefined), _tmp0_);
	}
	result = _afrodite_utils_symbols_predefined_symbols_ref0 (afrodite_utils_symbols__predefined);
	return result;
}


AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_predefined_symbols_construct (GType object_type) {
	AfroditeUtilsSymbolsPredefinedSymbols* self;
	AfroditeSymbol* _tmp0_;
	AfroditeDataType* _tmp1_;
	AfroditeSymbol* _tmp2_;
	AfroditeDataType* _tmp3_;
	AfroditeSymbol* _tmp4_;
	AfroditeDataType* _tmp5_;
	self = (AfroditeUtilsSymbolsPredefinedSymbols*) g_type_create_instance (object_type);
	self->priv->_connect_method = (_tmp0_ = afrodite_symbol_new ("connect", "Method"), _afrodite_symbol_unref0 (self->priv->_connect_method), _tmp0_);
	afrodite_symbol_set_return_type (self->priv->_connect_method, _tmp1_ = afrodite_data_type_new ("void", NULL));
	_afrodite_data_type_unref0 (_tmp1_);
	afrodite_data_type_set_symbol (afrodite_symbol_get_return_type (self->priv->_connect_method), (AfroditeSymbol*) afrodite_symbol_VOID);
	afrodite_symbol_set_access (self->priv->_connect_method, AFRODITE_SYMBOL_ACCESSIBILITY_ANY);
	self->priv->_connect_method->binding = AFRODITE_MEMBER_BINDING_ANY;
	self->priv->_disconnect_method = (_tmp2_ = afrodite_symbol_new ("disconnect", "Method"), _afrodite_symbol_unref0 (self->priv->_disconnect_method), _tmp2_);
	afrodite_symbol_set_return_type (self->priv->_disconnect_method, _tmp3_ = afrodite_data_type_new ("void", NULL));
	_afrodite_data_type_unref0 (_tmp3_);
	afrodite_data_type_set_symbol (afrodite_symbol_get_return_type (self->priv->_disconnect_method), (AfroditeSymbol*) afrodite_symbol_VOID);
	afrodite_symbol_set_access (self->priv->_disconnect_method, AFRODITE_SYMBOL_ACCESSIBILITY_ANY);
	self->priv->_disconnect_method->binding = AFRODITE_MEMBER_BINDING_ANY;
	self->priv->_signal_symbol = (_tmp4_ = afrodite_symbol_new ("#signal", "Class"), _afrodite_symbol_unref0 (self->priv->_signal_symbol), _tmp4_);
	afrodite_symbol_add_child (self->priv->_signal_symbol, self->priv->_connect_method);
	afrodite_symbol_add_child (self->priv->_signal_symbol, self->priv->_disconnect_method);
	self->signal_type = (_tmp5_ = afrodite_data_type_new ("#signal", NULL), _afrodite_data_type_unref0 (self->signal_type), _tmp5_);
	afrodite_data_type_set_symbol (self->signal_type, self->priv->_signal_symbol);
	return self;
}


AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_predefined_symbols_new (void) {
	return afrodite_utils_symbols_predefined_symbols_construct (AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS);
}


static void afrodite_utils_symbols_value_predefined_symbols_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void afrodite_utils_symbols_value_predefined_symbols_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		afrodite_utils_symbols_predefined_symbols_unref (value->data[0].v_pointer);
	}
}


static void afrodite_utils_symbols_value_predefined_symbols_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = afrodite_utils_symbols_predefined_symbols_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer afrodite_utils_symbols_value_predefined_symbols_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* afrodite_utils_symbols_value_predefined_symbols_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AfroditeUtilsSymbolsPredefinedSymbols* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = afrodite_utils_symbols_predefined_symbols_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* afrodite_utils_symbols_value_predefined_symbols_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AfroditeUtilsSymbolsPredefinedSymbols** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = afrodite_utils_symbols_predefined_symbols_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* afrodite_utils_symbols_param_spec_predefined_symbols (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AfroditeUtilsSymbolsParamSpecPredefinedSymbols* spec;
	g_return_val_if_fail (g_type_is_a (object_type, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer afrodite_utils_symbols_value_get_predefined_symbols (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS), NULL);
	return value->data[0].v_pointer;
}


void afrodite_utils_symbols_value_set_predefined_symbols (GValue* value, gpointer v_object) {
	AfroditeUtilsSymbolsPredefinedSymbols* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		afrodite_utils_symbols_predefined_symbols_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		afrodite_utils_symbols_predefined_symbols_unref (old);
	}
}


void afrodite_utils_symbols_value_take_predefined_symbols (GValue* value, gpointer v_object) {
	AfroditeUtilsSymbolsPredefinedSymbols* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		afrodite_utils_symbols_predefined_symbols_unref (old);
	}
}


static void afrodite_utils_symbols_predefined_symbols_class_init (AfroditeUtilsSymbolsPredefinedSymbolsClass * klass) {
	afrodite_utils_symbols_predefined_symbols_parent_class = g_type_class_peek_parent (klass);
	AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_CLASS (klass)->finalize = afrodite_utils_symbols_predefined_symbols_finalize;
	g_type_class_add_private (klass, sizeof (AfroditeUtilsSymbolsPredefinedSymbolsPrivate));
}


static void afrodite_utils_symbols_predefined_symbols_instance_init (AfroditeUtilsSymbolsPredefinedSymbols * self) {
	self->priv = AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void afrodite_utils_symbols_predefined_symbols_finalize (AfroditeUtilsSymbolsPredefinedSymbols* obj) {
	AfroditeUtilsSymbolsPredefinedSymbols * self;
	self = AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS (obj);
	_afrodite_symbol_unref0 (self->priv->_connect_method);
	_afrodite_symbol_unref0 (self->priv->_disconnect_method);
	_afrodite_symbol_unref0 (self->priv->_signal_symbol);
	_afrodite_data_type_unref0 (self->signal_type);
}


GType afrodite_utils_symbols_predefined_symbols_get_type (void) {
	static volatile gsize afrodite_utils_symbols_predefined_symbols_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_utils_symbols_predefined_symbols_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { afrodite_utils_symbols_value_predefined_symbols_init, afrodite_utils_symbols_value_predefined_symbols_free_value, afrodite_utils_symbols_value_predefined_symbols_copy_value, afrodite_utils_symbols_value_predefined_symbols_peek_pointer, "p", afrodite_utils_symbols_value_predefined_symbols_collect_value, "p", afrodite_utils_symbols_value_predefined_symbols_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeUtilsSymbolsPredefinedSymbolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_utils_symbols_predefined_symbols_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeUtilsSymbolsPredefinedSymbols), 0, (GInstanceInitFunc) afrodite_utils_symbols_predefined_symbols_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType afrodite_utils_symbols_predefined_symbols_type_id;
		afrodite_utils_symbols_predefined_symbols_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AfroditeUtilsSymbolsPredefinedSymbols", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&afrodite_utils_symbols_predefined_symbols_type_id__volatile, afrodite_utils_symbols_predefined_symbols_type_id);
	}
	return afrodite_utils_symbols_predefined_symbols_type_id__volatile;
}


gpointer afrodite_utils_symbols_predefined_symbols_ref (gpointer instance) {
	AfroditeUtilsSymbolsPredefinedSymbols* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void afrodite_utils_symbols_predefined_symbols_unref (gpointer instance) {
	AfroditeUtilsSymbolsPredefinedSymbols* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


char* afrodite_utils_unescape_xml_string (const char* text) {
	char* result = NULL;
	char* res;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (text != NULL, NULL);
	res = g_strdup (text);
	result = (_tmp1_ = string_replace (_tmp0_ = string_replace (res, "&lt;", "<"), "&gt;", ">"), _g_free0 (_tmp0_), _tmp1_);
	_g_free0 (res);
	return result;
	_g_free0 (res);
}


char* afrodite_utils_binary_operator_to_string (ValaBinaryOperator op) {
	char* result = NULL;
	char* res;
	res = NULL;
	switch (op) {
		case VALA_BINARY_OPERATOR_NONE:
		{
			char* _tmp0_;
			res = (_tmp0_ = g_strdup (""), _g_free0 (res), _tmp0_);
			break;
		}
		case VALA_BINARY_OPERATOR_PLUS:
		{
			char* _tmp1_;
			res = (_tmp1_ = g_strdup ("+"), _g_free0 (res), _tmp1_);
			break;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			char* _tmp2_;
			res = (_tmp2_ = g_strdup ("-"), _g_free0 (res), _tmp2_);
			break;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			char* _tmp3_;
			res = (_tmp3_ = g_strdup ("*"), _g_free0 (res), _tmp3_);
			break;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			char* _tmp4_;
			res = (_tmp4_ = g_strdup ("/"), _g_free0 (res), _tmp4_);
			break;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			char* _tmp5_;
			res = (_tmp5_ = g_strdup ("%"), _g_free0 (res), _tmp5_);
			break;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			char* _tmp6_;
			res = (_tmp6_ = g_strdup ("<<"), _g_free0 (res), _tmp6_);
			break;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			char* _tmp7_;
			res = (_tmp7_ = g_strdup (">>"), _g_free0 (res), _tmp7_);
			break;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			char* _tmp8_;
			res = (_tmp8_ = g_strdup ("<"), _g_free0 (res), _tmp8_);
			break;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			char* _tmp9_;
			res = (_tmp9_ = g_strdup (">"), _g_free0 (res), _tmp9_);
			break;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			char* _tmp10_;
			res = (_tmp10_ = g_strdup ("<="), _g_free0 (res), _tmp10_);
			break;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			char* _tmp11_;
			res = (_tmp11_ = g_strdup (">="), _g_free0 (res), _tmp11_);
			break;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			char* _tmp12_;
			res = (_tmp12_ = g_strdup ("=="), _g_free0 (res), _tmp12_);
			break;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			char* _tmp13_;
			res = (_tmp13_ = g_strdup ("!="), _g_free0 (res), _tmp13_);
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			char* _tmp14_;
			res = (_tmp14_ = g_strdup ("&"), _g_free0 (res), _tmp14_);
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			char* _tmp15_;
			res = (_tmp15_ = g_strdup ("|"), _g_free0 (res), _tmp15_);
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			char* _tmp16_;
			res = (_tmp16_ = g_strdup ("^"), _g_free0 (res), _tmp16_);
			break;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			char* _tmp17_;
			res = (_tmp17_ = g_strdup ("&&"), _g_free0 (res), _tmp17_);
			break;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			char* _tmp18_;
			res = (_tmp18_ = g_strdup ("||"), _g_free0 (res), _tmp18_);
			break;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			char* _tmp19_;
			res = (_tmp19_ = g_strdup ("in"), _g_free0 (res), _tmp19_);
			break;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			char* _tmp20_;
			res = (_tmp20_ = g_strdup ("??"), _g_free0 (res), _tmp20_);
			break;
		}
		default:
		{
			GEnumClass* cl;
			char* _tmp21_;
			cl = (GEnumClass*) g_type_class_ref (VALA_TYPE_BINARY_OPERATOR);
			res = (_tmp21_ = g_strdup (g_enum_get_value (cl, (gint) op)->value_nick), _g_free0 (res), _tmp21_);
			_g_type_class_unref0 (cl);
			break;
		}
	}
	result = res;
	return result;
}


char* afrodite_utils_unary_operator_to_string (ValaUnaryOperator op) {
	char* result = NULL;
	char* res;
	res = NULL;
	switch (op) {
		case VALA_UNARY_OPERATOR_NONE:
		{
			char* _tmp0_;
			res = (_tmp0_ = g_strdup (""), _g_free0 (res), _tmp0_);
			break;
		}
		case VALA_UNARY_OPERATOR_PLUS:
		{
			char* _tmp1_;
			res = (_tmp1_ = g_strdup ("+"), _g_free0 (res), _tmp1_);
			break;
		}
		case VALA_UNARY_OPERATOR_MINUS:
		{
			char* _tmp2_;
			res = (_tmp2_ = g_strdup ("-"), _g_free0 (res), _tmp2_);
			break;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			char* _tmp3_;
			res = (_tmp3_ = g_strdup ("^"), _g_free0 (res), _tmp3_);
			break;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			char* _tmp4_;
			res = (_tmp4_ = g_strdup ("~"), _g_free0 (res), _tmp4_);
			break;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		{
			char* _tmp5_;
			res = (_tmp5_ = g_strdup ("++"), _g_free0 (res), _tmp5_);
			break;
		}
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			char* _tmp6_;
			res = (_tmp6_ = g_strdup ("--"), _g_free0 (res), _tmp6_);
			break;
		}
		case VALA_UNARY_OPERATOR_REF:
		{
			char* _tmp7_;
			res = (_tmp7_ = g_strdup ("ref"), _g_free0 (res), _tmp7_);
			break;
		}
		case VALA_UNARY_OPERATOR_OUT:
		{
			char* _tmp8_;
			res = (_tmp8_ = g_strdup ("out"), _g_free0 (res), _tmp8_);
			break;
		}
		default:
		{
			GEnumClass* cl;
			char* _tmp9_;
			cl = (GEnumClass*) g_type_class_ref (VALA_TYPE_UNARY_OPERATOR);
			res = (_tmp9_ = g_strdup (g_enum_get_value (cl, (gint) op)->value_nick), _g_free0 (res), _tmp9_);
			_g_type_class_unref0 (cl);
			break;
		}
	}
	result = res;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




