/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef AXES_H
#define AXES_H

#include <visu_extension.h>
#include <visu_tools.h>
#include <visu_data.h>

/**
 * initExtensionAxes
 *
 * It initialises all variables of the OpenGL extension.
 * It creates all resources and parameters introduced by
 * this extension.
 * This method should be added in the #listInitExtensionFunc to
 * be called automatically by the initOpenGLExtensions() at V_Sim
 * startup.
 *
 * Returns: a pointer to the OpenGLExtension it created or
 * NULL otherwise.
 */
OpenGLExtension* initExtensionAxes();

/**
 * EXT_AXES_ID:
 *
 * The id used to identify this extension, see
 * OpenGLExtensionRebuild_list() for instance.
 */
#define EXT_AXES_ID "Axes"

/**
 * axesSet_RGBValues:
 * @rgb: a three floats array with values (0 <= values <= 1) for the
 * red, the green and the blue color. Only values specified by the mask
 * are really relevant.
 * @mask: use #MASK_RGB_R, #MASK_RGB_G, #MASK_RGB_B, #MASK_RGB_ALL or a
 * combinaison to indicate what values in the rgb array must be taken
 * into account.
 *
 * Method used to change the value of the parameter axes_color.
 *
 * Returns: TRUE if axesDraw() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
gboolean axesSet_RGBValues(float rgb[3], int mask);
/**
 * axesSet_lineWidth:
 * @width: value of the desired axe width.
 *
 * Method used to change the value of the parameter axes_line_width.
 *
 * Returns: TRUE if axesDraw() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
gboolean axesSet_lineWidth(float width);
/**
 * axesSet_lineStipple:
 * @stipple: value of the desired pattern.
 *
 * Method used to change the value of the parameter axes_line_stipple.
 *
 * Returns: TRUE if axesDraw() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
gboolean axesSet_lineStipple(guint16 stipple);
/**
 * axesSet_areOn:
 * @value: TRUE if axes must be drawn, FALSE otherwise.
 *
 * Method used to change the value of the parameter axes_are_on.
 *
 * Returns: TRUE if axesDraw() should be called. In all cases, 'OpenGLAskForReDraw'
 *          signal should then be emitted.
 */
gboolean axesSet_areOn(gboolean value);

/**
 * axesGet_RGBvalues:
 *
 * Read all the colour components of axes (in [0;1]). 
 *
 * Returns: three RGB values, private from V_Sim, read only.
 */
float* axesGet_RGBvalues();
/**
 * axesGet_areOn:
 *
 * Read if axes are drawn or not.
 *
 * Returns: 1 if axes are drawn, 0 otherwise.
 */
int axesGet_areOn();
/**
 * axesGet_lineWidth:
 *
 * Read the line width used to draw axes.
 *
 * Returns: the value of current axes width.
 */
float axesGet_lineWidth();
/**
 * axesGet_lineStipple:
 *
 * Read the line pattern used to draw axes.
 *
 * Returns: the value of current axes pattern.
 */
guint16 axesGet_lineStipple();
/**
 * axesDraw:
 * @dataObj: the #VisuData object to build axes for.
 *
 * This method create a compile list that draw a box for the given @data.
 */
void axesDraw(VisuData *dataObj);

#endif
