/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef INTERACTIVE_H
#define INTERACTIVE_H

#include <glib.h>

#include <visu_nodes.h>
#include <visu_data.h>
#include <visu_pickMesure.h>
#include <renderingBackend/visu_actionInterface.h>

/**
 * OPENGL_OBSERVE_CONSTRAINED
 *
 * This is a key for the constrained mode in the observe session.
 * In this mode, the movements are along meridians when the mouse is
 * dragged along y axis and along parallels when the movement is along x axis.
 */
#define OPENGL_OBSERVE_CONSTRAINED 0
/**
 * OPENGL_OBSERVE_WALKER
 *
 * This is a key for the constrained mode in the observe session.
 * In this mode, the movementsare those of a walking ant on a sphere,
 * when mouse move along y axis, the ant goes strait on, when mouse is
 * dragged along x axis, the ant translates on its right or on its left.
 */
#define OPENGL_OBSERVE_WALKER 1

/**
 * VisuInteractive:
 *
 * All fields are private.
 */
typedef struct _VisuInteractive VisuInteractive;

/**
 * openGLInteractiveSet_preferedObserveMethod:
 * @method: an integer that identify the method, see #OPENGL_OBSERVE_CONSTRAINED,
 *          and #OPENGL_OBSERVE_WALKER flags.
 *
 * There are two methods to move the camera in a pick and observe sesion. These
 * two methods are described in the commentary of the keys #OPENGL_OBSERVE_CONSTRAINED
 * an d#OPENGL_OBSERVE_WALKER.
 */
void openGLInteractiveSet_preferedObserveMethod(int method);
/**
 * openGLInteractiveGet_preferedObserveMethod:
 *
 * There are two methods to move the camera in a pick and observe sesion. These
 * two methods are described in the commentary of the keys #OPENGL_OBSERVE_CONSTRAINED
 * an d#OPENGL_OBSERVE_WALKER.
 *
 * Returns: an integer that identify the method, see #OPENGL_OBSERVE_CONSTRAINED,
 *          and #OPENGL_OBSERVE_WALKER flags.
 */
int openGLInteractiveGet_preferedObserveMethod();

/**
 * callBackOnNodeSelectedFunc:
 * @mesureData: the object that stores the pick information ;
 * @data: a pointer to user define data.
 *
 * This interface defines functions that are called whenever a
 * node is selected.
 */
typedef void (*callBackOnNodeSelectedFunc)(PickMesure *mesureData, gpointer data);

/**
 * callBackOnEventFunc:
 * @event: the event that triggered the action ;
 * @inter: the #VisuInteractive object the callback deals with.
 *
 * An interface to methods that can be called whenever an action occurs.
 *
 * Returns: TRUE if action should be stopped after this call.
 */
typedef gboolean (*callBackOnEventFunc)(SimplifiedEvents *event,
					VisuInteractive *inter);


/* observe and pick functions. */
/**
 * openGLInteractiveInit_session:
 * @window: a pointer to the window that ask to initialize
 *          an interactive mode ;
 * @handler: a pointer to a method to be called whenever
 *           an element is selected (can be NULL) ;
 * @data: a location for user data that can be given to handler ;
 * @stopPickObserve: a pointer to a method that will be called
 *                   every time a pick or an observe session are
 *                   finish (can be NULL).
 *
 * Initialises a period when the client can control an interactive session
 * (observe, pick, move...). It changes cursors shapes and initialises different
 * internal variables. It can be stop by a call to openGLInteractiveEnd_session().
 * The default first interactive session is an observe session.
 *
 * Returns: a newly created object. This object is automatically
 * associated to the #VisuData handled by the @window and will be
 * destroyed with it.
 */
VisuInteractive* openGLInteractiveInit_session(GenericRenderingWindow window,
					       callBackOnNodeSelectedFunc handler,
					       gpointer data,
					       GDestroyNotify stopPickObserve);
/**
 * openGLInteractiveEnd_session:
 * @inter: a #VisuInteractive object.
 *
 * Stop the period when pick or observe sessions are allowed. Basically,
 * for the user point of view it returns the cursor to its initial shape.
 */
void openGLInteractiveEnd_session(VisuInteractive *inter);
/**
 * openGLInteractiveBegin_observe:
 * @inter: a #VisuInteractive object.
 * 
 * During a pick or observe session, the client can begin an observe session
 * by a call to this method. It actually stops also a possibly running
 * pick session.
 */
void openGLInteractiveBegin_observe(VisuInteractive *inter);
/**
 * openGLInteractiveBegin_pick:
 * @inter: a #VisuInteractive object.
 * 
 * During a pick or observe session, the client can begin a pick session
 * by a call to this method. It actually stops also a possibly running
 * observe session.
 */
void openGLInteractiveBegin_pick(VisuInteractive *inter);
/**
 * openGLInteractiveBegin_move:
 * @inter: a #VisuInteractive object.
 * 
 * During an interactive session, the client can begin a move session
 * by a call to this method. It enables the press-button (and release), the motion-notify
 * and the scroll event. It returns the displacement and the node selected.
 */
void openGLInteractiveBegin_move(VisuInteractive *inter);
/**
 * openGLInteractiveBegin_mark:
 * @inter: a #VisuInteractive object.
 * 
 * During an interactive session, the client can begin a mark session
 * by a call to this method. It enables the press-button (and
 * release), the motion-notify and the scroll event. A mark is drawn
 * around the selected element (or removed) when clicked. To begin an
 * interactive session, see openGLInteractiveInit_session().
 */
void openGLInteractiveBegin_mark(VisuInteractive *inter);
/**
 * openGLInteractiveBegin_pickAndObserve:
 * @inter: a #VisuInteractive object.
 * 
 * During a pick or observe session, the client can both observe (normal way)
 * and do minimal pick with the right button.
 */
void openGLInteractiveBegin_pickAndObserve(VisuInteractive *inter);

/**
 * openGLInteractiveHandle_event:
 * @ev: an event ;
 * @inter: a #VisuInteractive object.
 *
 * This routine should be called by the rendering window when some
 * event is raised on the rendering surface.
 */
void openGLInteractiveHandle_event(SimplifiedEvents *ev, VisuInteractive *inter);

/**
 * openGLInteractiveStart_move:
 * @inter: a #VisuInteractive object ;
 * @nodes: a list of #VisuNode (not ids).
 *
 * Update the internal of @inter when the given list is dragged. This
 * means to create a new list with the given nodes and remove them
 * from the classical #VisuData OpenGL lists. A redraw is
 * automatically asked.
 */
void openGLInteractiveStart_move(VisuInteractive *inter, GList *nodes);
/**
 * openGLInteractiveStop_move:
 * @inter: a #VisuInteractive object ;
 * @nodes: a list of #VisuNode (not ids).
 *
 * Update the internal of @inter when the drag stops. The @nodes are
 * recreated in the OpenGL lists of #VisuData. A redraw is
 * automatically asked.
 */
void openGLInteractiveStop_move(VisuInteractive *inter, GList *nodes);
/**
 * openGLInteractiveMove:
 * @inter: a #VisuInteractive object ;
 * @nodes: a list of #VisuNode ids ;
 * @drag: a translation (in cartesian coordinates).
 *
 * Update the internal of @inter when the given list is dragged.
 */
void openGLInteractiveMove(VisuInteractive *inter, GList *nodes, float drag[3]);

/**
 * openGLInteractiveGet_pickMesure:
 * @inter: a #VisuInteractive object.
 * 
 * Get the #PickMesure object associated to an interactive session.
 *
 * Returns: a #PickMesure object, private.
 */
PickMesure* openGLInteractiveGet_pickMesure(VisuInteractive *inter);
/**
 * openGLInteractiveSet_visuData:
 * @inter: a #VisuInteractive object ;
 * @data: a #VisuData object.
 *
 * Change the #VisuData the interactive session is dealing with.
 */
void openGLInteractiveSet_visuData(VisuInteractive *inter, VisuData *data);


/**
 * openGLInteractive_init:
 *
 * Used to initialise this part of code, don't use it.
 */
void openGLInteractive_init();

#endif
