// vi: set ts=2 shiftwidth=2 expandtab:
//
// Copyright (C) 2001-2006  Simon Baldwin (simon_baldwin@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef _XCWCP_APPLICATION_H
#define _XCWCP_APPLICATION_H

#include <qmainwindow.h>

#include <string>
#include <deque>

#include "modeset.h"


class QKeyEvent;
class QComboBox;
class QSpinBox;
class QToolButton;
class QCheckBox;
class QTimer;


//-----------------------------------------------------------------------
//  Class Application
//-----------------------------------------------------------------------

// Encapsulates the outermost Xcwcp Qt application.  Defines slots and
// signals, as well as the usual class information.

namespace cw {

class Display;
class Sender;
class Receiver;

class Application : public QMainWindow
{
 Q_OBJECT
 public:
  Application ();

  // Handle key press and mouse button press events
  void key_event (QKeyEvent *event);
  void mouse_event (QMouseEvent *event);

 protected:
  void closeEvent (QCloseEvent *event);

 private slots:
  // Qt widget library callback functions.
  void about ();
  void startstop ();
  void start ();
  void stop ();
  void new_instance ();
  void clear ();
  void sync_speed ();
  void speed_change ();
  void frequency_change ();
  void volume_change ();
  void gap_change ();
  void mode_change ();
  void curtis_mode_b_change ();
  void adaptive_receive_change ();
  void fonts ();
  void colors ();
  void poll_timer_event ();

 private:
  // Class variable to enable sharing of the cwlib across instances.  Set to
  // the 'this' of the CW user instance, or NULL if no current user.
  static Application *cwlib_user_application_instance;

  // GUI elements used throughout the class.
  QComboBox *mode_combo_;
  QSpinBox *speed_spin_;
  QSpinBox *frequency_spin_;
  QSpinBox *volume_spin_;
  QSpinBox *gap_spin_;
  QToolButton *startstop_button_;
  QCheckBox *reverse_paddles_;
  QCheckBox *curtis_mode_b_;
  QCheckBox *adaptive_receive_;
  Display *display_;
  QPopupMenu *file_menu_;
  int file_synchronize_speed_id_;
  int file_start_id_;
  int file_stop_id_;

  // Set of modes used by the application; initialized from dictionaries, with
  // keyboard and receive modes added.
  ModeSet modeset_;

  // Sender and receiver.
  Sender *sender_;
  Receiver *receiver_;

  // Poll timer, used to ensure that all of the application processing can
  // be handled in the foreground, rather than in the signal handling context
  // of a cwlib tone queue low callback.
  QTimer *poll_timer_;

  // Flag indicating if this instance is currently using the cwlib.
  bool is_using_cwlib_;

  // Saved receive speed, used to reinstate adaptive tracked speed on start.
  int saved_receive_speed_;

  // Keying callback function for cwlib.  There is a static version for
  // the whole class, and an instance version for each object.  The class
  // version calls the relevant instance version, based on which instance is
  // the current registered cwlib user.
  static void cwlib_keying_event_static (void *, int key_state);
  void cwlib_keying_event (int key_state);

  // Prevent unwanted operations.
  Application (const Application &);
  Application &operator= (const Application &);
};

}  // cw namespace

#endif  // _XCWCP_APPLICATION_H
