#include "helpdialog.h"
#include "ui_helpdialog.h"

helpDialog::helpDialog(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::helpDialog)
{
	m_ui->setupUi(this);
	#if (DEBUG_ULTRACOPIER<=0)
	m_ui->pushButtonSaveAdvancedRepport->hide();
	m_ui->pushButtonSaveAdvancedRepport->deleteLater();
	#else
	onShot.setInterval(1000);
	onShot.setSingleShot(true);
	connect(&onShot,SIGNAL(timeout()),this,SLOT(updateTextEditDebug()));
        source=QString("");
	textEditDebug = new QTextEdit(NULL);
	textEditDebug->setObjectName(QString::fromUtf8("textEditDebug"));
	m_ui->verticalLayoutTotal->addWidget(textEditDebug);
	QFile file(giveWritablePath("log/stdout.log.html"));
	if(file.open(QIODevice::ReadOnly))
	{
		source=QString(file.readAll());
		source.replace("<pre>","");
		textEditDebug->setHtml(QString("<pre>")+source+QString("</pre>"));
		file.close();
	}
	this->setMinimumSize(640,480);
	#endif
	UpdateStyle();
}

helpDialog::~helpDialog()
{
    delete m_ui;
}

#if (DEBUG_ULTRACOPIER>0)
//for prevent crash emit signal here for the update
void helpDialog::new_html_log(QString theNewHtml)
{
	source+=theNewHtml;
	onShot.start();
}

void helpDialog::updateTextEditDebug()
{
	textEditDebug->setHtml(QString("<pre>")+source+QString("</pre>"));
}

void helpDialog::show_debug_console()
{
	if(textEditDebug->isHidden())
		textEditDebug->show();
}
#endif

void helpDialog::closeEvent(QCloseEvent * event)
{
	this->hide();
	event->ignore();
}

void helpDialog::SetText(QString url,QString version_type,QString version,int debug_level)
{
	QString text="<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\"><html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">p, li { white-space: pre-wrap; }</style></head><body style=\" font-family:'DejaVu Sans'; font-size:9pt; font-weight:400; font-style:normal;\"><p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><img src=\":/other/ultracopier-128x128.png\" style=\"float:left;height:128px;width:128px;\" /><span style=\" font-family:'Sans Serif'; font-size:12pt; font-weight:600;\">Ultracopier %VERSION%</span></p><p style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; font-family:'Sans Serif'; font-size:12pt; font-weight:600;\"></p><p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:'Sans Serif';\">";
	text+=tr("Based on Qt. It provide advanced copier with more advanced feature. It's under");
	text+=" </span><span style=\" font-family:'Sans Serif'; font-style:italic;\">GPL3</span><span style=\" font-family:'Sans Serif';\">.</span></p><p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:'Sans Serif';\">";
	text+=tr("This version is compiled for");
	text+=" </span><span style=\" font-family:'Sans Serif'; font-style:italic;\">%VERSION_TYPE%</span><span style=\" font-family:'Sans Serif';\">.</span></p><p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:'Sans Serif';\">";
	text+=tr("For more informations see the website");
	text+=" %URL%</span></p><p style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; font-family:'Sans Serif';\"></p><p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:'Sans Serif';\">%DEBUG%</span></p></body></html>";
	#ifdef _WIN64
		text.replace("%VERSION%",version+" x64");
	#else
		text.replace("%VERSION%",version);
	#endif
	text.replace("%URL%",url);
	text.replace("%VERSION_TYPE%",version_type);
	
	
	if(debug_level==0)
		text.replace("%DEBUG%","");
	else
	{
		QString DebugString="<u>Debug level:</u> "+QString::number(debug_level);
		#ifdef __GNUC__
		#ifdef __GNUC_MINOR__
		#ifdef __GNUC_PATCHLEVEL__
		DebugString+="<br /><u>Gcc version:</u> "+QString::number(__GNUC__)+'.'+QString::number(__GNUC_MINOR__)+'.'+QString::number(__GNUC_PATCHLEVEL__);
		#endif
		#endif
		#endif
		#ifdef _MSC_FULL_VER
		DebugString+="<br /><u>Msvc version:</u> "+QString::number(_MSC_FULL_VER);
		#endif
		text.replace("%DEBUG%",DebugString);
	}
	m_ui->labelText->setText(text);
}

void helpDialog::on_pushButton_clicked()
{
    QApplication::aboutQt();
}

#if (DEBUG_ULTRACOPIER>0)
void helpDialog::on_pushButtonSaveAdvancedRepport_clicked()
{
	QString fileName = QFileDialog::getSaveFileName(this, tr("Save file"),
		"ultracopier-repport.log.html",
		tr("Log file")+" (*.log)");
	if(fileName=="")
		 return;
	if(QFile::exists(fileName))
		QFile::remove(fileName);
	if(!QFile::copy(giveWritablePath("log/stdout.log.html"),fileName))
		QMessageBox::critical(this,"Error","Unable to save advanced repport");
}
#endif

//update the style
void helpDialog::UpdateStyle()
{
	//update style here
	m_ui->pushButton->setIcon(loadImage("info.png"));
	#if (DEBUG_ULTRACOPIER>0)
	m_ui->pushButtonSaveAdvancedRepport->setIcon(loadImage("advanced.png"));
	#endif
	m_ui->pushButtonClose->setIcon(loadImage("exit.png"));
}

