/***************************************************************************
                               AddFolderAddFolderThread.h
                              -------------------
 
     Begin        : Sat Oct 23 2007 10:00 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the class of the addfolderthreads
 
****************************************************************************/

#ifndef THREAD_H
#define THREAD_H

#include <QThread>
#include <QTime>
#include <QWaitCondition>
#include <QUrl>
#include <QDir>
#include <QFileInfo>
#include <QSemaphore>

#include "env.h"

/** \brief Thread for list the folder.

This thread need source and destination folder for send via Qt signal the files, folders and items what to be in source folder.
*/

class AddFolderThread : public QThread
{
	Q_OBJECT
public:
	AddFolderThread(QObject * parent = 0);
	~AddFolderThread();
	//for stop the Listing threads
	void stop();
public slots:
	//for set source and destination dir
	void setDir(const QDir& dir,bool isDestDir);
	//for set list of url
	void setFileListDropped(const QList<QUrl>& url);
	//set action if Folder are same
	void action(int query);
	//set action if error
	void actionAtError(int query);
signals:
	/// \brief add one entry to source dir list
	void putToSourceDirList(QDir theDir);
	/// \brief add one entry to dir list when the folder is empty
	void putToDirDestinationEmptyList(QDir theDir);
	/// \brief add one entry to copy list
	void addToCopyList(QFileInfo source,QFileInfo destination);
        /// \brief add one entry to dir list
	void putToDirList(QDir theDir);
	/// \brief emit if the sourcefolder and the destination folder are the same
	void FolderSourceAndDestAreSame(QString dirDest);
	/// \brief emit if error
	void ErrorInListing(QString theDir,QString theError);
protected:
	void run();
private:
	volatile bool	stopped;
	QDir		dirDest;		///< Variable for store the destination folder
	QDir		dirSource;		///< Variable for store the source folder
	QList<QDir>	sourceDirList;		///< For store the source dir list for example for removing in moving mode
	void scandir(const QString& dir="");
	QList<QUrl>	urlList;		///< Variable for store and detect the duplicate folder
	int		actionNum;		///< For store the number of the action requested
	bool		stopIt;
	QSemaphore	waitOneAction;
	QString		translationOfCopyOf;	///< Store the "copy of " translated
};

#endif
