echo cleaning Package_Root dir
rm -rf build/Package_Root

PRODUCT_NAME="Unipro UGENE"
RELEASE_DIR=../../src/_release
TARGET_APP_DIR="./build/Package_Root/Applications/${PRODUCT_NAME}.app/"
TARGET_EXE_DIR="${TARGET_APP_DIR}/Contents/MacOS"


echo recreating Package_Root dir structure
mkdir "build/Package_Root"
mkdir "build/Package_Root/Applications"
mkdir "${TARGET_APP_DIR}"
mkdir "${TARGET_APP_DIR}/Contents"
mkdir "${TARGET_APP_DIR}/Contents/MacOS"
mkdir "${TARGET_APP_DIR}/Contents/MacOS/plugins"
mkdir "${TARGET_APP_DIR}/Contents/MacOS/plugins/script"
mkdir "${TARGET_APP_DIR}/Contents/MacOS/scripts"
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data"
mkdir "${TARGET_APP_DIR}/Contents/Resources"



echo copying UGENE executable
cp $RELEASE_DIR/ugene.app/Contents/MacOS/ugeneui "$TARGET_EXE_DIR/ugeneui"
cp $RELEASE_DIR/congene.app/Contents/MacOS/ugene "$TARGET_EXE_DIR/ugene"

# ensure script is executable
chmod +x scripts/postflight
#chmod +x ugene.sh
#cp ugene.sh "${TARGET_EXE_DIR}"


echo copying autogenerated resources
cp -r "$RELEASE_DIR/ugene.app/Contents/Resources"   "${TARGET_APP_DIR}/Contents"
cp -r "Info.plist"  "${TARGET_APP_DIR}/Contents"
cp -r "$RELEASE_DIR/ugene.app/Contents/PkgInfo"     "${TARGET_APP_DIR}/Contents"

echo copying translations
cp $RELEASE_DIR/transl_en.qm "$TARGET_EXE_DIR"
cp $RELEASE_DIR/transl_ru.qm "$TARGET_EXE_DIR"

echo copying core shared lib
cp $RELEASE_DIR/libcore.1.dylib "$TARGET_EXE_DIR"

echo copying plugins
cp "$RELEASE_DIR/plugins/libannotator.dylib"        "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libchroma_view.dylib"      "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libdna_export.dylib"       "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libdna_stat.dylib"         "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libdna_graphpack.dylib"    "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libenzymes.dylib"          "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/liborf_marker.dylib"       "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libremote_request.dylib"   "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/librepeat_finder.dylib"    "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libsmith_waterman2.dylib"  "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libhmm2.dylib"             "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libhmm3.dylib"             "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libprimer3.dylib"          "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libpsipred.dylib"          "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libgor4.dylib"            "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libumuscle.dylib"          "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libsitecon.dylib"          "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libwork_designer.dylib"    "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/libbiostruct3d_view.dylib" "${TARGET_EXE_DIR}/plugins/"
cp "$RELEASE_DIR/plugins/ball.dylib" "${TARGET_EXE_DIR}/plugins/"

echo copying script-mapping libs
cp "$RELEASE_DIR/plugins/script/libqtbindings_core.dylib"   "${TARGET_EXE_DIR}/plugins/script/"
cp "$RELEASE_DIR/plugins/script/libqtbindings_gui.dylib"    "${TARGET_EXE_DIR}/plugins/script/"
cp "$RELEASE_DIR/plugins/script/libqtbindings_xml.dylib"    "${TARGET_EXE_DIR}/plugins/script/"

echo copying scripts
cp "$RELEASE_DIR/../../scripts/blastn.qs"           "${TARGET_EXE_DIR}/scripts/"
cp "$RELEASE_DIR/../../scripts/blastp.qs"           "${TARGET_EXE_DIR}/scripts/"
cp "$RELEASE_DIR/../../scripts/cdd.qs"              "${TARGET_EXE_DIR}/scripts/"

echo copying data dir
cp "$RELEASE_DIR/../../data/DBXRefRegistry.txt"         "${TARGET_EXE_DIR}/data/"
cp "$RELEASE_DIR/../../data/translations.txt"           "${TARGET_EXE_DIR}/data/"

#biostruct3d
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/biostruct3d_plugin"
cp "$RELEASE_DIR/../../data/biostruct3d_plugin/"*.txt "${TARGET_EXE_DIR}/data/biostruct3d_plugin/"

#enzymes
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/enzymes"
cp "$RELEASE_DIR/../../data/enzymes/"*.gz "${TARGET_EXE_DIR}/data/enzymes/"

#primer3
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/primer3"
cp "$RELEASE_DIR/../../data/primer3/"*.txt "${TARGET_EXE_DIR}/data/primer3/"

#samples 
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/samples"
cp "$RELEASE_DIR/../../data/samples/"* "${TARGET_EXE_DIR}/data/samples/"
rm -rf "$RELEASE_DIR/../../data/samples/.svn"

#sitecon
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/sitecon_models"
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/sitecon_models/eukaryotic"
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/sitecon_models/prokaryotic"
cp "$RELEASE_DIR/../../data/sitecon_models/eukaryotic/"*.sitecon.gz   "${TARGET_EXE_DIR}/data/sitecon_models/eukaryotic/"
cp "$RELEASE_DIR/../../data/sitecon_models/prokaryotic/"*.sitecon.gz   "${TARGET_EXE_DIR}/data/sitecon_models/prokaryotic/"

#weight_matrix
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/weight_matrix"
cp "$RELEASE_DIR/../../data/weight_matrix/"*.txt "${TARGET_EXE_DIR}/data/weight_matrix/"

#workflow_samples
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/workflow_samples"
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/workflow_samples/Alignment"
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/workflow_samples/Conversions"
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/workflow_samples/HMMER"
mkdir "${TARGET_APP_DIR}/Contents/MacOS/data/workflow_samples/Transcriptomics"

cp "$RELEASE_DIR/../../data/workflow_samples/Alignment/"*.uws   "${TARGET_EXE_DIR}/data/workflow_samples/Alignment/"
cp "$RELEASE_DIR/../../data/workflow_samples/Conversions/"*.uws "${TARGET_EXE_DIR}/data/workflow_samples/Conversions/"
cp "$RELEASE_DIR/../../data/workflow_samples/HMMER/"*.uws       "${TARGET_EXE_DIR}/data/workflow_samples/HMMER/"
cp "$RELEASE_DIR/../../data/workflow_samples/Transcriptomics/"*.uws  "${TARGET_EXE_DIR}/data/workflow_samples/Transcriptomics/"

echo copying QT libs
cp /usr/local/Trolltech/Qt-4.5.2/lib/libQtCore.4.dylib    "$TARGET_EXE_DIR"
cp /usr/local/Trolltech/Qt-4.5.2/lib/libQtGui.4.dylib     "$TARGET_EXE_DIR"
cp /usr/local/Trolltech/Qt-4.5.2/lib/libQtNetwork.4.dylib "$TARGET_EXE_DIR"
cp /usr/local/Trolltech/Qt-4.5.2/lib/libQtXml.4.dylib     "$TARGET_EXE_DIR"
cp /usr/local/Trolltech/Qt-4.5.2/lib/libQtScript.4.dylib  "$TARGET_EXE_DIR"
cp /usr/local/Trolltech/Qt-4.5.2/lib/libQtSvg.4.dylib     "$TARGET_EXE_DIR"
cp /usr/local/Trolltech/Qt-4.5.2/lib/libQtOpenGL.4.dylib  "$TARGET_EXE_DIR"
cp /usr/local/Trolltech/Qt-4.5.2/lib/libQtWebKit.4.dylib  "$TARGET_EXE_DIR"
cp /usr/local/Trolltech/Qt-4.5.2/lib/libphonon.4.dylib    "$TARGET_EXE_DIR"


