/***************************************************************************
 *   Project TUPI: Magia 2D                                                *
 *   Project Contact: info@maefloresta.com                                 *
 *   Project Website: http://www.maefloresta.com                           *
 *   Project Leader: Gustav Gonzalez <info@maefloresta.com>                *
 *                                                                         *
 *   Developers:                                                           *
 *   2010:                                                                 *
 *    Gustavo Gonzalez                                                     *
 *                                                                         *
 *   KTooN's versions:                                                     * 
 *                                                                         *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   Copyright (C) 2010 Gustav Gonzalez - http://www.maefloresta.com       *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef KTBRUSHSTATUS_H
#define KTBRUSHSTATUS_H

#include "ktcolorwidget.h"

#include <QPixmap>
#include <QPen>
#include <QBrush>
#include <QColor>

class KTColorWidget;

class KTBrushStatus : public QWidget
{
    Q_OBJECT

    public:
        KTBrushStatus(const QString &label, const QPixmap &pix, bool bg);
        ~KTBrushStatus();

        void setForeground(const QPen &pen);
        void setColor(const QColor &color);
        void setTooltip(const QString &tip);

    signals:
        void colorRequested();
        void colorUpdated(const QColor);

    private slots:
        void updateColour(); 

    private:
        KTColorWidget *brush;
        bool background;
};

#endif
