//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef _RANDOMLAYOUT_H
#define _RANDOMLAYOUT_H

#include <tulip/TulipPlugin.h>

/// Random.h - An implementation of a random 3D layout.
/** This plugin is an implementation of a random 3D layout
 *
 *  <b>HISTORY</b>
 *
 *  01/12/99 Verson 0.0.1: Initial release
 *
 *
 *  \note This algorithm works on general graphs. \n
 *  Let n be the number of nodes, the algorithm complexity is in O(n).
 *
 *
 *  \author David Auber University Bordeaux I France, Email : auber@tulip-software.com
 */
class Random:public tlp::LayoutAlgorithm
{ 
public:
  Random(const tlp::PropertyContext &);
  ~Random();
  
  bool run();
  bool check(std::string &);
};

#endif










