/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"


struct dsp *dsp;

struct dsp *init_dsp(){
    struct dsp *dsp;

    dsp = g_new0(struct dsp, 1);   
    dsp->type = cfg->ssbd_type;
    dsp->fd = -1;
    CONDGFREE(dsp->source);


    dsp->set_format = dummy_dsp_set_format;
    dsp->open   = dummy_dsp_open;
    dsp->close  = dummy_dsp_close;
    dsp->write  = dummy_dsp_write;
    dsp->read   = dummy_dsp_read;
    dsp->reset  = dummy_dsp_reset;
    dsp->sync   = dummy_dsp_sync;
    dsp->set_source = dummy_dsp_set_source;

    switch(dsp->type){
        case DSPT_OSS:
            dsp->set_format = oss_set_format;
            dsp->open   = oss_open;
            dsp->close  = oss_close;
            dsp->write  = oss_write;
            dsp->read   = oss_read;
            dsp->reset  = oss_reset;
            dsp->sync   = oss_sync;
            dsp->set_source = oss_set_source;
            
            if (cfg->ssbd_oss_src){
                dsp->source=g_strdup(cfg->ssbd_oss_src);
            }else{
                dsp->source=g_strdup(oss_recsrc2source(cfg->ssbd_recsrc));
            }
            break;
        case DSPT_ALSA:
#ifdef HAVE_ALSA            
            dsp->set_format = alsa_set_format;
            dsp->open   = alsa_open;
            dsp->close  = alsa_close;
            dsp->write  = alsa_write;
            dsp->read   = alsa_read;
            dsp->reset  = alsa_reset;
            dsp->sync   = alsa_sync;
            dsp->set_source = alsa_set_source;
            dsp->source = g_strdup(cfg->ssbd_alsa_src);
            dsp->pcm_opened = 0;
#else
            log_addf("Alsa support not compilled in");
            dbg("Alsa support not compilled in");
#endif            
            break;
        /*case DSPT_SSBD:*/
        default:
            internal("bad dsp->type");
            break;
            
    }
    
    return dsp;
}

void free_dsp(struct dsp *dsp){
    if (!dsp) return;

    dsp->close(dsp);
    CONDGFREE(dsp->filename);
#ifdef HAVE_ALSA
#endif    
    CONDGFREE(dsp->name);
    CONDGFREE(dsp->source);
	g_free(dsp);
}


int dummy_dsp_set_format(struct dsp *dsp, SF_INFO *sfinfo){
    return 0;
}

int dummy_dsp_open(struct dsp *dsp, int rec){
    return 0;
}

int dummy_dsp_close(struct dsp *dsp){
    return 0;
}

int dummy_dsp_write(struct dsp *dsp, void *data, int len){
    return 0;
}

int dummy_dsp_read(struct dsp *dsp, void *data, int len){
    return 0;
}

int dummy_dsp_reset(struct dsp *dsp){
    return 0;
}

int dummy_dsp_sync(struct dsp *dsp){
    return 0;
}

int dummy_dsp_set_source(struct dsp *dsp){
    return 0;
}

