/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"
void ssbd_read_handler(struct ssbd *ssbd);

struct ssbd *ssbd;

struct ssbd *init_ssbd(){
    struct ssbd *ssbd;
    int on;
    struct sockaddr_in sin;
    int a;
    struct passwd *pwd;

    ssbd = g_new0(struct ssbd, 1);
        
    ssbd->sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (ssbd->sock < 0) goto err;

    on=1;
    if (setsockopt(ssbd->sock, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on))){
        dbg("Can't set SO_REUSEADDR\n");
        goto err;
    }
    
    if (fcntl(ssbd->sock, F_SETFL, O_NONBLOCK)){
        dbg("Can't set O_NONBLOCK\n");
        goto err;
    }
    
    memset(&sin, 0, sizeof(struct sockaddr_in));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(cfg->ssbd_udp_port);
    if (!cfg->ssbd_hostname) cfg->ssbd_hostname = g_strdup("");
    inet_aton(cfg->ssbd_hostname, &sin.sin_addr);
    
    if (connect(ssbd->sock, (struct sockaddr *)&sin, sizeof(sin))){
        dbg("Can't connect\n");
        goto err;
    }

    /* fill user,group and umask */   
    a=getuid();
    pwd=getpwuid(a);
    if (pwd){
        ssbd->user=g_strdup(pwd->pw_name);
    }else{
        ssbd->user=g_strdup_printf("%d",a);
    }
    
    ssbd->umask=umask(022);
    umask(ssbd->umask);
    

    set_handlers(ssbd->sock, (void (*)(void *))ssbd_read_handler, NULL, NULL, (void*)ssbd);
    return ssbd;
err:;
    if (ssbd->sock>=0) close(ssbd->sock);
    ssbd->sock = -1;
    return ssbd;
    
}

void free_ssbd(struct ssbd *ssbd){
    cq_abort(1);
    if (ssbd->sock>=0) {
        ssbd_abort(ssbd,1);
        set_handlers(ssbd->sock, NULL, NULL, NULL, NULL);
        close(ssbd->sock);
    }
    g_free(ssbd->user);
/*    g_free(ssbd->group);*/
    g_free(ssbd);
}

void ssbd_play_file(struct ssbd *ssbd, gchar *filename){
    gchar *c,*tmpl;
    int ret;
    
    ssbd_abort(ssbd,1); /*aborts playing or recording */
    if (ssbd->sock<0) return;

    tmpl=convert_esc(filename, NULL);
    c = g_strdup_printf("e%d\np%s", -1 /*ssbd->ssbd_seq++*/, tmpl);
    ret=send(ssbd->sock, c, strlen(c), 0);
    /*dbg("ret=%d\n",ret);*/
    g_free(c);
    g_free(tmpl);
    
}

void ssbd_read_handler(struct ssbd *ssbd){
    char s[1024];
    struct sockaddr_in sin;
    socklen_t socklen;
    int rcvd;

    /*dbg("ssbd_read_handler\n");*/
    if (!ctest) {
        /* we must clear kernel queue */
        recvfrom(ssbd->sock, s, sizeof(s)-1, 0, 
            (struct sockaddr *)&sin, &socklen);
        return;
    }
    
    memset(s, 0, sizeof(s));
    socklen = sizeof(sin);
    rcvd=recvfrom(ssbd->sock, s, sizeof(s)-1, 0, 
            (struct sockaddr *)&sin, &socklen);
    /*dbg("  received '%s' = %d  last_cq_timer_id=%d \n", s, rcvd, ctest->last_cq_timer_id);*/
    if (rcvd<=0) return;
    if (ctest->last_cq_timer_id){ /* CQ was abortet while playing */
        kill_timer(ctest->last_cq_timer_id);
        ctest->last_cq_timer_id = 0;
    }

    switch(s[0]){
        case '!':  /* error */
            cq_abort(ssbd->recording); /*abort recording only if it is in progress */
            log_addf("ssbd: %s", s+1);
            break;
        case 'e':  /* sample played */
	    if (!ctest || !ctest->last_cq) break; /* zdravime uW 2004 :-) */
            if (ctest->last_cq->ssb_repeat)
                cq_ssb_wait(ctest->last_cq);
            else{
                ctest->last_cq->type=MOD_NONE;
                cq_abort(ssbd->recording);
            }
            redraw_later(term);
            break;
    }
}

void ssbd_rec_file(struct ssbd *ssbd){
    gchar *c, *tmpl;
    
    /*dbg("ssbd_rec_file\n");*/

    if (!cfg->ssbd_record) return;
    if (ssbd->recording) return;
   
    tmpl=convert_esc(cfg->ssbd_template, NULL);
    
    c = g_strdup_printf("x%s\nz0x%x\n"
                        "d%s\nf0x%x\n"
                        "c%d\ns%d\n"
                        "u%s\nm0%o\n"
                        "r%s", 
            cfg->ssbd_mixer, cfg->ssbd_recsrc,
            cfg->ssbd_dsp, cfg->ssbd_format, 
            cfg->ssbd_channels, cfg->ssbd_samplerate, 
            ssbd->user, ssbd->umask,
            tmpl);
    send(ssbd->sock, c, strlen(c), 0);
    g_free(c);
    g_free(tmpl);
    ssbd->recording=1;
}

void ssbd_abort(struct ssbd *ssbd, int abort_rec){
    char s[8];
    
    /*dbg("ssbd_abort\n");*/
    
    ssbd->recording=0;
    if (!ssbd || ssbd->sock<0) return;
    strcpy(s,"a");
    send(ssbd->sock, s, strlen(s), 0);

    if (abort_rec) return;

    ssbd_rec_file(ssbd);
}

/* called from SEGV handler */
void ssbd_safe_abort(struct ssbd *ssbd){
    if (!ssbd || ssbd->sock<0) return;
    send(ssbd->sock, "a", 1, 0);
}

int ssbd_recording(struct ssbd *ssbd){
    return ssbd->recording;
}

int ssbd_callsign(struct ssbd *ssbd, char *call){
    gchar *c, *d;
    
    c=g_strdup_printf("v%s", call);
    for (d=c; *d!='\0'; d++) if (*d=='/') *d='_';
    send(ssbd->sock, c, strlen(c), 0);
    g_free(c);
	return 0;
}

