/* tracker-stats.c generated by valac 0.14.0, the Vala compiler
 * generated from tracker-stats.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>


#define TYPE_STATISTICS (statistics_get_type ())
#define STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATISTICS, Statistics))
#define IS_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATISTICS))
#define STATISTICS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_STATISTICS, StatisticsIface))

typedef struct _Statistics Statistics;
typedef struct _StatisticsIface StatisticsIface;

#define TYPE_STATISTICS_PROXY (statistics_proxy_get_type ())
typedef GDBusProxy StatisticsProxy;
typedef GDBusProxyClass StatisticsProxyClass;

#define TRACKER_TYPE_STATS (tracker_stats_get_type ())
#define TRACKER_STATS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATS, TrackerStats))
#define TRACKER_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATS, TrackerStatsClass))
#define TRACKER_IS_STATS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATS))
#define TRACKER_IS_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATS))
#define TRACKER_STATS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATS, TrackerStatsClass))

typedef struct _TrackerStats TrackerStats;
typedef struct _TrackerStatsClass TrackerStatsClass;
typedef struct _TrackerStatsPrivate TrackerStatsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _StatisticsIface {
	GTypeInterface parent_iface;
	gchar** (*Get) (Statistics* self, int* result_length1, int* result_length2, GError** error);
};

struct _TrackerStats {
	GtkDialog parent_instance;
	TrackerStatsPrivate * priv;
};

struct _TrackerStatsClass {
	GtkDialogClass parent_class;
};

struct _TrackerStatsPrivate {
	Statistics* tracker;
};


static gpointer tracker_stats_parent_class = NULL;

#define b PACKAGE_NAME
GType statistics_proxy_get_type (void) G_GNUC_CONST;
guint statistics_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType statistics_get_type (void) G_GNUC_CONST;
gchar** statistics_Get (Statistics* self, int* result_length1, int* result_length2, GError** error);
static void statistics_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar** statistics_proxy_Get (Statistics* self, int* result_length1, int* result_length2, GError** error);
static void statistics_proxy_statistics_interface_init (StatisticsIface* iface);
static void _dbus_statistics_Get (Statistics* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void statistics_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* statistics_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean statistics_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _statistics_unregister_object (gpointer user_data);
GType tracker_stats_get_type (void) G_GNUC_CONST;
#define TRACKER_STATS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_STATS, TrackerStatsPrivate))
enum  {
	TRACKER_STATS_DUMMY_PROPERTY
};
TrackerStats* tracker_stats_new (void);
TrackerStats* tracker_stats_construct (GType object_type);
static void tracker_stats_setup_dbus (TrackerStats* self);
static void tracker_stats_setup_ui (TrackerStats* self);
static void tracker_stats_on_response (TrackerStats* self, GtkDialog* source, gint response_id);
static void _tracker_stats_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void tracker_stats_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _statistics_dbus_arg_info_Get_result = {-1, "result", "aas"};
static const GDBusArgInfo * const _statistics_dbus_arg_info_Get_in[] = {NULL};
static const GDBusArgInfo * const _statistics_dbus_arg_info_Get_out[] = {&_statistics_dbus_arg_info_Get_result, NULL};
static const GDBusMethodInfo _statistics_dbus_method_info_Get = {-1, "Get", (GDBusArgInfo **) (&_statistics_dbus_arg_info_Get_in), (GDBusArgInfo **) (&_statistics_dbus_arg_info_Get_out)};
static const GDBusMethodInfo * const _statistics_dbus_method_info[] = {&_statistics_dbus_method_info_Get, NULL};
static const GDBusSignalInfo * const _statistics_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _statistics_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _statistics_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Statistics", (GDBusMethodInfo **) (&_statistics_dbus_method_info), (GDBusSignalInfo **) (&_statistics_dbus_signal_info), (GDBusPropertyInfo **) (&_statistics_dbus_property_info)};
static const GDBusInterfaceVTable _statistics_dbus_interface_vtable = {statistics_dbus_interface_method_call, statistics_dbus_interface_get_property, statistics_dbus_interface_set_property};

gchar** statistics_Get (Statistics* self, int* result_length1, int* result_length2, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return STATISTICS_GET_INTERFACE (self)->Get (self, result_length1, result_length2, error);
}


static void statistics_base_init (StatisticsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType statistics_get_type (void) {
	static volatile gsize statistics_type_id__volatile = 0;
	if (g_once_init_enter (&statistics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StatisticsIface), (GBaseInitFunc) statistics_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType statistics_type_id;
		statistics_type_id = g_type_register_static (G_TYPE_INTERFACE, "Statistics", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (statistics_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (statistics_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) statistics_proxy_get_type);
		g_type_set_qdata (statistics_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Tracker1.Statistics");
		g_type_set_qdata (statistics_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) statistics_register_object);
		g_once_init_leave (&statistics_type_id__volatile, statistics_type_id);
	}
	return statistics_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (StatisticsProxy, statistics_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_STATISTICS, statistics_proxy_statistics_interface_init) )
static void statistics_proxy_class_init (StatisticsProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = statistics_proxy_g_signal;
}


static void statistics_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void statistics_proxy_init (StatisticsProxy* self) {
}


static gchar** statistics_proxy_Get (Statistics* self, int* result_length1, int* result_length2, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	int _result_length2;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Statistics", "Get");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		int _tmp1__length2;
		GVariantIter _tmp4_;
		GVariant* _tmp5_;
		_tmp1__length2 = 0;
		g_variant_iter_init (&_tmp4_, _tmp3_);
		for (; (_tmp5_ = g_variant_iter_next_value (&_tmp4_)) != NULL; _tmp1__length2++) {
			if (_tmp1__size == _tmp1__length) {
				_tmp1__size = 2 * _tmp1__size;
				_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
			}
			_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp5_, NULL);
			g_variant_unref (_tmp5_);
		}
		_result_length2 = _tmp1__length2;
		g_variant_unref (_tmp3_);
	}
	_result_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_result = _tmp1_;
	g_variant_unref (_tmp0_);
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	g_object_unref (_reply_message);
	return _result;
}


static void statistics_proxy_statistics_interface_init (StatisticsIface* iface) {
	iface->Get = statistics_proxy_Get;
}


static void _dbus_statistics_Get (Statistics* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	int result_length2 = 0;
	gchar** _tmp6_;
	GVariantBuilder _tmp7_;
	int _tmp8_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = statistics_Get (self, &result_length1, &result_length2, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp6_ = result;
	g_variant_builder_init (&_tmp7_, G_VARIANT_TYPE ("aas"));
	for (_tmp8_ = 0; _tmp8_ < result_length1; _tmp8_++) {
		GVariantBuilder _tmp9_;
		int _tmp10_;
		g_variant_builder_init (&_tmp9_, G_VARIANT_TYPE ("aas"));
		for (_tmp10_ = 0; _tmp10_ < result_length2; _tmp10_++) {
			g_variant_builder_add_value (&_tmp9_, g_variant_new_string (*_tmp6_));
			_tmp6_++;
		}
		g_variant_builder_add_value (&_tmp7_, g_variant_builder_end (&_tmp9_));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp7_));
	result = (_vala_array_free (result, result_length1 * result_length2, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void statistics_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Get") == 0) {
		_dbus_statistics_Get (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* statistics_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean statistics_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint statistics_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_statistics_dbus_interface_info), &_statistics_dbus_interface_vtable, data, _statistics_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _statistics_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


TrackerStats* tracker_stats_construct (GType object_type) {
	TrackerStats * self = NULL;
	self = (TrackerStats*) g_object_new (object_type, NULL);
	gtk_window_set_title ((GtkWindow*) self, "Statistics");
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 12);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	tracker_stats_setup_dbus (self);
	tracker_stats_setup_ui (self);
	return self;
}


TrackerStats* tracker_stats_new (void) {
	return tracker_stats_construct (TRACKER_TYPE_STATS);
}


static void tracker_stats_setup_dbus (TrackerStats* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("tracker-stats.vala:43: Setting up statistics D-Bus connection");
	{
		Statistics* _tmp0_ = NULL;
		Statistics* _tmp1_;
		_tmp0_ = g_initable_new (TYPE_STATISTICS_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", "org.freedesktop.Tracker1", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/Tracker1/Statistics", "g-interface-name", "org.freedesktop.Tracker1.Statistics", NULL);
		_tmp1_ = (Statistics*) _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch11_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (self->priv->tracker);
		self->priv->tracker = _tmp1_;
	}
	goto __finally11;
	__catch11_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		GtkMessageDialog* _tmp4_;
		GtkMessageDialog* _tmp5_;
		GtkMessageDialog* msg;
		GtkMessageDialog* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Error connecting to D-Bus session bus, %s", _tmp3_);
		_tmp5_ = g_object_ref_sink (_tmp4_);
		msg = _tmp5_;
		_tmp6_ = msg;
		gtk_dialog_run ((GtkDialog*) _tmp6_);
		gtk_main_quit ();
		_g_object_unref0 (msg);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _tracker_stats_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	tracker_stats_on_response (self, _sender, response_id);
}


static void tracker_stats_setup_ui (TrackerStats* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkBox* _tmp1_;
	GtkBox* vbox;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* label;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkSizeGroup* _tmp11_;
	GtkSizeGroup* sizegroup;
	GtkBox* _tmp118_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("tracker-stats.vala:63: Setting up statistics UI");
	_tmp0_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp1_ = _g_object_ref0 (GTK_IS_BOX (_tmp0_) ? ((GtkBox*) _tmp0_) : NULL);
	vbox = _tmp1_;
	_tmp2_ = vbox;
	gtk_box_set_spacing (_tmp2_, 18);
	_tmp3_ = vbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp3_, (guint) 0);
	_tmp4_ = _ ("The statistics represented here do not reflect their availability, rat" \
"her the total data stored:");
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	_tmp6_ = g_object_ref_sink (_tmp5_);
	label = _tmp6_;
	_tmp7_ = label;
	gtk_label_set_line_wrap (_tmp7_, TRUE);
	_tmp8_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp8_, 0.0f, 0.5f);
	_tmp9_ = vbox;
	_tmp10_ = label;
	gtk_box_pack_start (_tmp9_, (GtkWidget*) _tmp10_, TRUE, TRUE, (guint) 0);
	_tmp11_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	sizegroup = _tmp11_;
	{
		Statistics* _tmp12_;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar** _tmp15_ = NULL;
		gchar** _result_;
		gint _result__length1;
		gint _result__length2;
		_tmp12_ = self->priv->tracker;
		_tmp15_ = statistics_Get (_tmp12_, &_tmp13_, &_tmp14_, &_inner_error_);
		_result_ = _tmp15_;
		_result__length1 = _tmp13_;
		_result__length2 = _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				goto __catch12_g_dbus_error;
			}
			_g_object_unref0 (sizegroup);
			_g_object_unref0 (label);
			_g_object_unref0 (vbox);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp16_;
				_tmp16_ = TRUE;
				while (TRUE) {
					gboolean _tmp17_;
					gint _tmp19_;
					gchar** _tmp20_;
					gint _tmp20__length1;
					gint _tmp20__length2;
					gint _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					gint _tmp22__length2;
					gint _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* key;
					gchar** _tmp26_;
					gint _tmp26__length1;
					gint _tmp26__length2;
					gint _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* val;
					gchar* key_used = NULL;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					GQuark _tmp35_ = 0U;
					static GQuark _tmp34_label0 = 0;
					static GQuark _tmp34_label1 = 0;
					static GQuark _tmp34_label2 = 0;
					static GQuark _tmp34_label3 = 0;
					static GQuark _tmp34_label4 = 0;
					static GQuark _tmp34_label5 = 0;
					static GQuark _tmp34_label6 = 0;
					static GQuark _tmp34_label7 = 0;
					static GQuark _tmp34_label8 = 0;
					static GQuark _tmp34_label9 = 0;
					static GQuark _tmp34_label10 = 0;
					static GQuark _tmp34_label11 = 0;
					static GQuark _tmp34_label12 = 0;
					static GQuark _tmp34_label13 = 0;
					static GQuark _tmp34_label14 = 0;
					GtkHBox* _tmp96_;
					GtkHBox* _tmp97_;
					GtkHBox* hbox;
					const gchar* _tmp98_;
					GtkLabel* _tmp99_;
					GtkLabel* _tmp100_;
					GtkLabel* label_key;
					const gchar* _tmp101_;
					GtkLabel* _tmp102_;
					GtkLabel* _tmp103_;
					GtkLabel* label_val;
					GtkLabel* _tmp104_;
					GtkLabel* _tmp105_;
					GtkHBox* _tmp106_;
					GtkLabel* _tmp107_;
					GtkHBox* _tmp108_;
					GtkLabel* _tmp109_;
					GtkSizeGroup* _tmp110_;
					GtkLabel* _tmp111_;
					GtkBox* _tmp112_;
					GtkHBox* _tmp113_;
					_tmp17_ = _tmp16_;
					if (!_tmp17_) {
						gint _tmp18_;
						_tmp18_ = i;
						i = _tmp18_ + 1;
					}
					_tmp16_ = FALSE;
					_tmp19_ = i;
					_tmp20_ = _result_;
					_tmp20__length1 = _result__length1;
					_tmp20__length2 = _result__length2;
					_tmp21_ = _tmp20__length1;
					if (!(_tmp19_ < _tmp21_)) {
						break;
					}
					_tmp22_ = _result_;
					_tmp22__length1 = _result__length1;
					_tmp22__length2 = _result__length2;
					_tmp23_ = i;
					_tmp24_ = _tmp22_[(_tmp23_ * _tmp22__length2) + 0];
					_tmp25_ = g_strdup (_tmp24_);
					key = _tmp25_;
					_tmp26_ = _result_;
					_tmp26__length1 = _result__length1;
					_tmp26__length2 = _result__length2;
					_tmp27_ = i;
					_tmp28_ = _tmp26_[(_tmp27_ * _tmp26__length2) + 1];
					_tmp29_ = g_strdup (_tmp28_);
					val = _tmp29_;
					_tmp30_ = key;
					_tmp31_ = val;
					g_debug ("tracker-stats.vala:87: --> %s = %s", _tmp30_, _tmp31_);
					_tmp32_ = key;
					_tmp33_ = _tmp32_;
					_tmp35_ = (NULL == _tmp33_) ? 0 : g_quark_from_string (_tmp33_);
					if (_tmp35_ == ((0 != _tmp34_label0) ? _tmp34_label0 : (_tmp34_label0 = g_quark_from_static_string ("nao:Tag")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp36_;
								gint _tmp37_ = 0;
								const gchar* _tmp38_ = NULL;
								gchar* _tmp39_;
								_tmp36_ = val;
								_tmp37_ = atoi (_tmp36_);
								_tmp38_ = ngettext ("Tag", "Tags", (gulong) _tmp37_);
								_tmp39_ = g_strdup (_tmp38_);
								_g_free0 (key_used);
								key_used = _tmp39_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label1) ? _tmp34_label1 : (_tmp34_label1 = g_quark_from_static_string ("nco:Contact")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp40_;
								gint _tmp41_ = 0;
								const gchar* _tmp42_ = NULL;
								gchar* _tmp43_;
								_tmp40_ = val;
								_tmp41_ = atoi (_tmp40_);
								_tmp42_ = ngettext ("Contact", "Contacts", (gulong) _tmp41_);
								_tmp43_ = g_strdup (_tmp42_);
								_g_free0 (key_used);
								key_used = _tmp43_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label2) ? _tmp34_label2 : (_tmp34_label2 = g_quark_from_static_string ("nfo:Audio")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp44_;
								gint _tmp45_ = 0;
								const gchar* _tmp46_ = NULL;
								gchar* _tmp47_;
								_tmp44_ = val;
								_tmp45_ = atoi (_tmp44_);
								_tmp46_ = ngettext ("Audio", "Audios", (gulong) _tmp45_);
								_tmp47_ = g_strdup (_tmp46_);
								_g_free0 (key_used);
								key_used = _tmp47_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label3) ? _tmp34_label3 : (_tmp34_label3 = g_quark_from_static_string ("nfo:Document")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp48_;
								gint _tmp49_ = 0;
								const gchar* _tmp50_ = NULL;
								gchar* _tmp51_;
								_tmp48_ = val;
								_tmp49_ = atoi (_tmp48_);
								_tmp50_ = ngettext ("Document", "Documents", (gulong) _tmp49_);
								_tmp51_ = g_strdup (_tmp50_);
								_g_free0 (key_used);
								key_used = _tmp51_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label4) ? _tmp34_label4 : (_tmp34_label4 = g_quark_from_static_string ("nfo:FileDataObject")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp52_;
								gint _tmp53_ = 0;
								const gchar* _tmp54_ = NULL;
								gchar* _tmp55_;
								_tmp52_ = val;
								_tmp53_ = atoi (_tmp52_);
								_tmp54_ = ngettext ("File", "Files", (gulong) _tmp53_);
								_tmp55_ = g_strdup (_tmp54_);
								_g_free0 (key_used);
								key_used = _tmp55_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label5) ? _tmp34_label5 : (_tmp34_label5 = g_quark_from_static_string ("nfo:Folder")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp56_;
								gint _tmp57_ = 0;
								const gchar* _tmp58_ = NULL;
								gchar* _tmp59_;
								_tmp56_ = val;
								_tmp57_ = atoi (_tmp56_);
								_tmp58_ = ngettext ("Folder", "Folders", (gulong) _tmp57_);
								_tmp59_ = g_strdup (_tmp58_);
								_g_free0 (key_used);
								key_used = _tmp59_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label6) ? _tmp34_label6 : (_tmp34_label6 = g_quark_from_static_string ("nfo:Image")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp60_;
								gint _tmp61_ = 0;
								const gchar* _tmp62_ = NULL;
								gchar* _tmp63_;
								_tmp60_ = val;
								_tmp61_ = atoi (_tmp60_);
								_tmp62_ = ngettext ("Image", "Images", (gulong) _tmp61_);
								_tmp63_ = g_strdup (_tmp62_);
								_g_free0 (key_used);
								key_used = _tmp63_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label7) ? _tmp34_label7 : (_tmp34_label7 = g_quark_from_static_string ("nfo:SoftwareApplication")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp64_;
								gint _tmp65_ = 0;
								const gchar* _tmp66_ = NULL;
								gchar* _tmp67_;
								_tmp64_ = val;
								_tmp65_ = atoi (_tmp64_);
								_tmp66_ = ngettext ("Application", "Applications", (gulong) _tmp65_);
								_tmp67_ = g_strdup (_tmp66_);
								_g_free0 (key_used);
								key_used = _tmp67_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label8) ? _tmp34_label8 : (_tmp34_label8 = g_quark_from_static_string ("nfo:Video")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp68_;
								gint _tmp69_ = 0;
								const gchar* _tmp70_ = NULL;
								gchar* _tmp71_;
								_tmp68_ = val;
								_tmp69_ = atoi (_tmp68_);
								_tmp70_ = ngettext ("Video", "Videos", (gulong) _tmp69_);
								_tmp71_ = g_strdup (_tmp70_);
								_g_free0 (key_used);
								key_used = _tmp71_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label9) ? _tmp34_label9 : (_tmp34_label9 = g_quark_from_static_string ("nmm:MusicAlbum")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp72_;
								gint _tmp73_ = 0;
								const gchar* _tmp74_ = NULL;
								gchar* _tmp75_;
								_tmp72_ = val;
								_tmp73_ = atoi (_tmp72_);
								_tmp74_ = ngettext ("Album", "Albums", (gulong) _tmp73_);
								_tmp75_ = g_strdup (_tmp74_);
								_g_free0 (key_used);
								key_used = _tmp75_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label10) ? _tmp34_label10 : (_tmp34_label10 = g_quark_from_static_string ("nmm:MusicPiece")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp76_;
								gint _tmp77_ = 0;
								const gchar* _tmp78_ = NULL;
								gchar* _tmp79_;
								_tmp76_ = val;
								_tmp77_ = atoi (_tmp76_);
								_tmp78_ = ngettext ("Music Track", "Music Tracks", (gulong) _tmp77_);
								_tmp79_ = g_strdup (_tmp78_);
								_g_free0 (key_used);
								key_used = _tmp79_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label11) ? _tmp34_label11 : (_tmp34_label11 = g_quark_from_static_string ("nmm:Photo")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp80_;
								gint _tmp81_ = 0;
								const gchar* _tmp82_ = NULL;
								gchar* _tmp83_;
								_tmp80_ = val;
								_tmp81_ = atoi (_tmp80_);
								_tmp82_ = ngettext ("Photo", "Photos", (gulong) _tmp81_);
								_tmp83_ = g_strdup (_tmp82_);
								_g_free0 (key_used);
								key_used = _tmp83_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label12) ? _tmp34_label12 : (_tmp34_label12 = g_quark_from_static_string ("nmm:Playlist")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp84_;
								gint _tmp85_ = 0;
								const gchar* _tmp86_ = NULL;
								gchar* _tmp87_;
								_tmp84_ = val;
								_tmp85_ = atoi (_tmp84_);
								_tmp86_ = ngettext ("Playlist", "Playlists", (gulong) _tmp85_);
								_tmp87_ = g_strdup (_tmp86_);
								_g_free0 (key_used);
								key_used = _tmp87_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label13) ? _tmp34_label13 : (_tmp34_label13 = g_quark_from_static_string ("nmo:Email")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp88_;
								gint _tmp89_ = 0;
								const gchar* _tmp90_ = NULL;
								gchar* _tmp91_;
								_tmp88_ = val;
								_tmp89_ = atoi (_tmp88_);
								_tmp90_ = ngettext ("Email", "Emails", (gulong) _tmp89_);
								_tmp91_ = g_strdup (_tmp90_);
								_g_free0 (key_used);
								key_used = _tmp91_;
								break;
							}
						}
					} else if (_tmp35_ == ((0 != _tmp34_label14) ? _tmp34_label14 : (_tmp34_label14 = g_quark_from_static_string ("nfo:Bookmark")))) {
						switch (0) {
							default:
							{
								const gchar* _tmp92_;
								gint _tmp93_ = 0;
								const gchar* _tmp94_ = NULL;
								gchar* _tmp95_;
								_tmp92_ = val;
								_tmp93_ = atoi (_tmp92_);
								_tmp94_ = ngettext ("Bookmark", "Bookmarks", (gulong) _tmp93_);
								_tmp95_ = g_strdup (_tmp94_);
								_g_free0 (key_used);
								key_used = _tmp95_;
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								continue;
							}
						}
					}
					_tmp96_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
					_tmp97_ = g_object_ref_sink (_tmp96_);
					hbox = _tmp97_;
					_tmp98_ = key_used;
					_tmp99_ = (GtkLabel*) gtk_label_new (_tmp98_);
					_tmp100_ = g_object_ref_sink (_tmp99_);
					label_key = _tmp100_;
					_tmp101_ = val;
					_tmp102_ = (GtkLabel*) gtk_label_new (_tmp101_);
					_tmp103_ = g_object_ref_sink (_tmp102_);
					label_val = _tmp103_;
					_tmp104_ = label_key;
					gtk_misc_set_alignment ((GtkMisc*) _tmp104_, 0.0f, 0.5f);
					_tmp105_ = label_val;
					gtk_misc_set_alignment ((GtkMisc*) _tmp105_, 0.0f, 0.5f);
					_tmp106_ = hbox;
					_tmp107_ = label_key;
					gtk_box_pack_start ((GtkBox*) _tmp106_, (GtkWidget*) _tmp107_, TRUE, TRUE, (guint) 0);
					_tmp108_ = hbox;
					_tmp109_ = label_val;
					gtk_box_pack_start ((GtkBox*) _tmp108_, (GtkWidget*) _tmp109_, FALSE, TRUE, (guint) 0);
					_tmp110_ = sizegroup;
					_tmp111_ = label_key;
					gtk_size_group_add_widget (_tmp110_, (GtkWidget*) _tmp111_);
					_tmp112_ = vbox;
					_tmp113_ = hbox;
					gtk_box_pack_start (_tmp112_, (GtkWidget*) _tmp113_, TRUE, TRUE, (guint) 0);
					_g_object_unref0 (label_val);
					_g_object_unref0 (label_key);
					_g_object_unref0 (hbox);
					_g_free0 (key_used);
					_g_free0 (val);
					_g_free0 (key);
				}
			}
		}
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	}
	goto __finally12;
	__catch12_g_dbus_error:
	{
		GError* e = NULL;
		GError* _tmp114_;
		const gchar* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp114_ = e;
		_tmp115_ = _tmp114_->message;
		_tmp116_ = g_strconcat ("Could not get Tracker statistics: ", _tmp115_, NULL);
		_tmp117_ = _tmp116_;
		g_warning ("tracker-stats.vala:155: %s", _tmp117_);
		_g_free0 (_tmp117_);
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (sizegroup);
		_g_object_unref0 (label);
		_g_object_unref0 (vbox);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp118_ = vbox;
	gtk_box_set_spacing (_tmp118_, 10);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _tracker_stats_on_response_gtk_dialog_response, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (sizegroup);
	_g_object_unref0 (label);
	_g_object_unref0 (vbox);
}


static void tracker_stats_on_response (TrackerStats* self, GtkDialog* source, gint response_id) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = response_id;
	switch (_tmp0_) {
		case GTK_RESPONSE_CLOSE:
		{
			gtk_widget_destroy ((GtkWidget*) self);
			break;
		}
		default:
		break;
	}
}


static void tracker_stats_class_init (TrackerStatsClass * klass) {
	tracker_stats_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerStatsPrivate));
	G_OBJECT_CLASS (klass)->finalize = tracker_stats_finalize;
}


static void tracker_stats_instance_init (TrackerStats * self) {
	self->priv = TRACKER_STATS_GET_PRIVATE (self);
}


static void tracker_stats_finalize (GObject* obj) {
	TrackerStats * self;
	self = TRACKER_STATS (obj);
	_g_object_unref0 (self->priv->tracker);
	G_OBJECT_CLASS (tracker_stats_parent_class)->finalize (obj);
}


GType tracker_stats_get_type (void) {
	static volatile gsize tracker_stats_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_stats_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStatsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_stats_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStats), 0, (GInstanceInitFunc) tracker_stats_instance_init, NULL };
		GType tracker_stats_type_id;
		tracker_stats_type_id = g_type_register_static (GTK_TYPE_DIALOG, "TrackerStats", &g_define_type_info, 0);
		g_once_init_leave (&tracker_stats_type_id__volatile, tracker_stats_type_id);
	}
	return tracker_stats_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



