/* tosh_lcd.c -- set LCD parameters of a Toshiba laptop.
 *
 * Copyright (c) 1998-00  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *                        for architecture, device driver, and libraries
*/
#define VERSION_STRING "\
Tosh_LCD version 1.0\n\
 Copyright (c) 2000-2000  Christian Gennerat <christian.gennerat@vz.cit.alcatel.fr>\n"
/* 
 *                        for this small program
 *
 * $Log: tosh_lcd.c,v $
 * Revision 1.1  2000/04/19 xg
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

static char const rcsid[]="$Id: tosh_lcd.c,v 1.0 2000/042/19 xg $";


#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>

#include"sci.h"

#define USAGE_STRING "\
Usage: tosh_lcd [-option]\n\
Set specific parameters of a Toshiba Libretto\n\n\
  -n,--narrow		narrow display (console mode)\n\
  -w,--wide		wide   display (console mode)\n\
  -d,--dark		dark LCD screen\n\
  -D,--dim		dim  LCD screen\n\
  -s,--semi		semi-bright LCD screen\n\
  -b,--bright		bright LCD screen\n\
  -h,--help		display this help message\n\
  -v,--version		display version\n\
Report bugs to christian.gennerat@vz.cit.alcatel.fr\n"

enum {
	DISPLAY_STRETCH  = 0x0002,
	LCD_BACKLIGHT = 0x0004,
};


/*
 * check the alarm features of the laptop
 */
int LibSupport(void)
{
	SMMRegisters reg;
	int support;

	support = 0x0000;
	reg.ecx = 0;
	reg.edx = 0;
	SciOpenInterface();

	reg.ebx = SCI_DISPLAY_STRETCH;
	if (SciGet(&reg)==SCI_SUCCESS) {
		support |= DISPLAY_STRETCH;
	}

	reg.ebx = SCI_LCD_BACKLIGHT;
	if (SciGet(&reg)==SCI_SUCCESS) {
		support |= LCD_BACKLIGHT;
	}

	reg.edx = 0;
	SciCloseInterface();
	
	return support;
}



int main(int argc, char *argv[])
{
	SMMRegisters reg;
	int i,version,hibern,width,light,support;

	if (argc!=2)  {
			printf(USAGE_STRING);
			exit(0);
			}

	reg.ebx = 0;
	reg.ecx = 0;
	reg.edx = 0;
	/* do some quick checks on the laptop */

	if (SciSupportCheck(&version)==1) {
		fprintf(stderr, "alarm: this computer is not supported\n");
		return 1;
	}

	/* check this model supports what we want */

	support = LibSupport();
	if (support==0) {
		fprintf(stderr, 
		"Lib: feature not supported on this model.\n");
		return 1;
	}

	/* process command line arguments */

	light = -1;
	width = -1;
	hibern = -1;
	for (i=1;i<argc;i++) {
		if ((!strcmp(argv[i], "-h")) || (!strcmp(argv[i], "--help"))) {
			printf(USAGE_STRING);
			exit(0);
		}
		if ((!strcmp(argv[i], "-v")) || (!strcmp(argv[i], "--version"))) {
			printf(VERSION_STRING);
			exit(0);
		}


		if ((!strcmp(argv[i], "-w")) || (!strcmp(argv[i], "--wide"))) {
			width = 1;
		}		
		if ((!strcmp(argv[i], "-n")) || (!strcmp(argv[i], "--narrow"))) {
			width = 0;
		}		
		if ((!strcmp(argv[i], "-W")) || (!strcmp(argv[i], "--wide"))) {
			width = 3;
		}		
		if ((!strcmp(argv[i], "-N")) || (!strcmp(argv[i], "--narrow"))) {
			width = 2;
		}		


		if ((!strcmp(argv[i], "-d")) || (!strcmp(argv[i], "--dark"))) {
			light = SCI_BACK_DARK;
		}		
		if ((!strcmp(argv[i], "-D")) || (!strcmp(argv[i], "--dim"))) {
			light = SCI_BACK_DIM;
		}		
		if ((!strcmp(argv[i], "-s")) || (!strcmp(argv[i], "--semi"))) {
			light = SCI_BACK_SEMI;
		}		
		if ((!strcmp(argv[i], "-b")) || (!strcmp(argv[i], "--bright"))) {
			light = SCI_BACK_BRIGHT;
		}		
	}

	if (width!=-1) {
		SciOpenInterface();
		reg.ebx = SCI_DISPLAY_STRETCH;
		reg.ecx = width;
		reg.edx = 0;
		if (!SciSet(&reg))
			printf("Lib: Screen width updated: %d\n",width);
		SciCloseInterface();
	}

	if (light!=-1) {
		SciOpenInterface();
		reg.ebx = SCI_LCD_BACKLIGHT;
		reg.ecx = light;
		reg.edx = 0;
		if (!SciSet(&reg))
			printf("Lib: Screen light updated: %d\n",light);
		SciCloseInterface();
		;
	}

	return 0;
}
