/***************************************************************************
 * $Id: warnings.h,v 1.34 2009/06/20 09:29:15 hoganrobert Exp $
 *   Copyright (C) 2006 - 2008 Robert Hogan                                *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/

#include "tork.h"
#include <qstring.h>

typedef struct message_t {
  const char *logmessage; /**< The full keyword (case insensitive). */
  const QString headline; /**< String (or null) describing initial value. */
  char torsaid[250]; /**< String (or null) describing initial value. */
  const QString body; /**< String (or null) describing initial value. */
  const QString type; /**< String (or null) describing initial value. */
  const char *icon; /**< String (or null) describing initial value. */
  bool (tork::*pt2Member)();
  display_status_t state;  /**< The type of the value. */
  bool always;  /**< The type of the value. */
  bool showstopper;  /**< The type of the value. */
} message_t;


#define MSG(logmessage,headline,torsaid, body, type, icon, show, state, always, showstopper)                             \
  { logmessage, headline,torsaid,body, type, icon, show, state, always, showstopper }

static message_t _tork_messages[] = {
    MSG("ommencing hibernation", 
        i18n("Tor Is No Longer Accepting Traffic!"),
        "",
        i18n("Tor has exceeded the bandwidth limits you set in "
        "'My Server->Performance' and so will no longer accept traffic. To fix this, set a higher threshold in"
        "'My Server->Performance'."),
        i18n("Show Usage Warnings"),
        "tork_info",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("Accounting period ended", 
        i18n("Tor Is No Longer Accepting Traffic!"),
        "",
        i18n("Tor has exceeded the bandwidth limits you set in "
        "'My Server->Performance' and so will no longer accept traffic. To fix this, set a higher threshold in"
        "'My Server->Performance'."),
        i18n("Show Usage Warnings"),
        "tork_info",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("Hibernation period ended", 
        i18n("Tor Is Now Accepting Traffic Again!"),
        "",
        i18n("Tor has completed a hibernation period that resulted from the settings you defined in "
        "'My Server->Performance'. If you do not want to accept traffic, set a lower threshold in"
        "'My Server->Performance'."),
        i18n("Show Usage Warnings"),
        "tork_info",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("Your IP seems to have changed", 
        i18n("You are running a server without any contact information!"),
        "",
        i18n("You can set your contact info in the configuration section 'My Server'. Please do so! "),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("notorexecutable", 
        i18n("Can't Find Your Tor Installation!"),
        "",
        i18n("You need to tell me where Tor is - it's not in any of your executable paths. Run the 'First Run Wizard' again from the 'Tools' menu."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, true),
    MSG("noprivoxyexecutable", 
        i18n("Can't Find Your Privoxy Installation!"),
        "",
        i18n("You need to tell me where Privoxy is - it's not in any of your executable paths. Run the 'First Run Wizard' again from the 'Tools' menu."),
        i18n("General Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("dnsrequestsdetected", 
        i18n("You May Be Leaking DNS Requests!"),
        "",
        i18n("You should inspect the 'Traffic Log' to establish which application made the DNS request. Look for :domain or :53 in the Host/Port column of the Non-Tor traffic log. It may be that the application submitting the request is not of interest to you."),
        i18n("DNS Leak Warnings"),
        "tork_alert",
        (&tork::showDNSLeaks),
        DISPLAY_NONE, false, false),
    MSG("Error writing to", 
        i18n("Problem Accessing Files!"),
        "",
        i18n("You should make sure that you have the requisite access to the files required by Tor. Try typing 'tor' at the command line to investigate further."),
        i18n("General Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, true),
    MSG("cannot be read", 
        i18n("Problem Accessing Files!"),
        "",
        i18n("You should make sure that you have the requesite access to the files required by Tor. Try typing 'tor' at the command line to investigate further."),
        i18n("General Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, true),
    MSG("Could not chmod", 
        i18n("Problem Accessing Files!"),
        "",
        i18n("You should make sure that you have the requesite access to the files required by Tor. Try typing 'tor' at the command line to investigate further."),
        i18n("General Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, true),
    MSG("Couldn't open", 
        i18n("Problem Accessing Files!"),
        "",
        i18n("You should make sure that you have the requesite access to the files required by Tor. Try typing 'tor' at the command line to investigate further."),
        i18n("General Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, true),
    MSG("Error creating", 
        i18n("Problem Accessing Files!"),
        "",
        i18n("You should make sure that you have the requesite access to the files required by Tor. Try typing 'tor' at the command line to investigate further."),
        i18n("General Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, true),
    MSG("deprecated", 
        i18n("TorK is using a deprecated config option!"),
        "",
        i18n("Please report this using 'Help->Report Bug' in the menu. Try to provide as much detail as possible. Thanks!"),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("Unparseable address in hidden service", 
        i18n("Your Hidden Service Could Not Be Started!"),
        "",
        i18n("The address you configured for it may be invalid. See 'Tor Log' pane for details."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("Failed to parse/validate config", 
        i18n("TorK has passed an invalid configuration file to Tor!"),
        "",
        i18n("Please report this using 'Help->Report Bug' in the menu. Try to provide as much detail as possible. Thanks!"),
        i18n("General Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, true),
    MSG("your clock just jumped", 
        i18n("Tor is having problems with your local clock!"),
        "",
        i18n("Please report this using 'Help->Report Bug' in the menu or directly to or-talk@freehaven.net. Try to provide as much detail as possible. Thanks!"),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("your ORPort is reachable from the outside", 
        i18n("Your Tor Server appears to be working!!"),
        "",
        i18n("You are now serving the Tor network. Be careful out there!"),
        i18n("Show Usage Warnings"),
        "tork_torserver",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),
    MSG("your DirPort is reachable from the outside", 
        i18n("Your Tor Server's directory appears to be working!!"),
        "",
        i18n("You can now serve directory listings to the Tor network. Be careful out there!"),
        i18n("Show Usage Warnings"),
        "tork_torserver",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),
    MSG("torclosedconnection", 
        i18n("Tor Stopped Talking To Us!!"),
        "",
        i18n("Try starting Tork again!"),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, true),
    MSG("hidden service is unavailable", 
        i18n("The Hidden Service You Are Trying to Reach is Currently Unavailable!"),
        "",
        i18n("It's not just you. The hidden service you're trying to reach is actually down."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("we have none", 
        i18n("Tor can't retrieve a list of all servers on the network yet!"),
        "",
        i18n("TorK will try again as soon as Tor says it has enough info, in the meantime you can still use Tor though the servers list in the 'Tor Network' tab will be empty."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("/var/lib/tor", 
        i18n("You are using an old version of Tor that TorK is not compatible with!"),
        "",
        i18n("Try upgrading Tor through Tools->Download Tor."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("cantreadprofiles", 
        i18n("The file is not readable by Tork!"),
        "",
        i18n("Does it exist?."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("cantcopyprofile", 
        i18n("The file is not readable by Tork!"),
        "",
        i18n("Does it exist?"),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("cantwritefirefoxsettings", 
        i18n("The file is not writeable by Tork!"),
        "",
        i18n("Try again maybe."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("torrunning", 
        i18n("TorK is connected to Tor. You need to click 'Stop' first!"),
        "",
        i18n("To run the setup wizard, click 'Stop' in the Anonymize tab and try again."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),

    MSG("bwreset", 
        i18n("TorK has reset the bandwidth rates on Tor as per your instructions!"),
        "",
        i18n("You instructed TorK to do this in 'My Bandwidth'."),
        i18n("Show Usage Warnings"),
        "tork_info",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),

    MSG("nonanonkonqhidden", 
        i18n("TorK has hidden your non-anonymous Konqueror windows."),
        "",
        i18n("Konqueror windows that have been used non-anonymously are not suitable for anonymous work!"),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),

    MSG("nonanonkonqshown", 
        i18n("TorK has un-hidden your non-anonymous Konqueror windows."),
        "",
        i18n("Konqueror windows that were used non-anonymously are safe to use again for non-anonymous work!"),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),

    MSG("DANGEROUS_VERSION", 
        i18n("Your version of Tor may have problems."),
        "",
        i18n("You should think of using the recommended version of Tor!"),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),

    MSG("CIRCUIT_ESTABLISHED", 
        i18n("Tor is ready for use as a client."),
        "",
        i18n("You can now use Tor to anonymize your traffic!"),
        i18n("Show Usage Warnings"),
        "tork_info",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),

    MSG("TOO_MANY_CONNECTIONS", 
        i18n("Your system has too many open connections."),
        "",
        i18n("You should try running 'ulimit -n 10000' to improve things."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),

    MSG("cookienotfound", 
        i18n("Tor's Authentication Cookie Not Available."),
        "",
        i18n("If you stored it elsewhere, please copy it to the suggested location above."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, true, true),

    MSG("authenticationfailed", 
        i18n("You used the wrong password to connect to Tor!"),
        "",
        i18n("Check the password entered in 'My Client'."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, true, true),

    MSG("authenticationrequired", 
        i18n("You need to use a password or cookie to connect to Tor!"),
        "",
        i18n("Enter the correct password or select cookie authentication in 'My Client'."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, true, true),

    MSG("featuresdisabled", 
        i18n("You may notice some of TorK's features have been disabled/hidden!"),
        "",
        i18n("This is because they are for use with the 0.2.x alpha series of Tor. If you "
        "run the alpha series they will be re-enabled."),
        i18n("Show Usage Warnings"),
        "tork_info",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),

    MSG("geoipmissing", 
        i18n("Your GeoIP database is missing!"),
        "",
        i18n("TorK needs the file GeoIP.dat to assign country flags to Tor servers. "
        "It looks like this file has gone missing. Please re-install GeoIP and/or TorK to fix."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, false, false),
    MSG("fwdok", 
        i18n("Easy Accessiblity Enabled On Your Router!"),
        "",
        i18n("TorK has forwarded the common web ports on your router to Tor. "
             "This will make your Tor server more accessible to users and other servers."
             ),
        i18n("Show Usage Warnings"),
        "tork_info",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),
    MSG("unfwok", 
        i18n("Easy Accessibility Disabled On Your Router!"),
        "",
        i18n("TorK has removed the forwarding of the common web ports on your router to Tor. "
             "For your Tor server to be reachable, ensure you manually configure your router."
             ),
        i18n("Show Usage Warnings"),
        "tork_info",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),


    MSG("fwderror", 
        i18n("Error Enabling Easy Accessibility On Your Router!"),
        "",
        i18n("It's possible that this is just temporary. TorK will try again later."
        ),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),

    MSG("unfwerror", 
        i18n("Error Disabling Easy Accessibility On Your Router!"),
        "",
        i18n("It's possible that this is just temporary. TorK will try again later."
        ),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),

    MSG("cantfindrouter", 
        i18n("Your Broadband Router May Not Be Plug 'n Playable!"),
        "",
        i18n("Check that UPnP is enabled on the router and that your computer firewall "
             "allows traffic to and from the router. You can still be a server, but the "
             "ports Tor uses will be the defaults rather than 443 and 80."),
        i18n("Show Usage Warnings"),
        "tork_alert",
        (&tork::showUsage),
        DISPLAY_NONE, true, false),

  { NULL,  NULL, "", NULL, NULL, NULL, NULL, DISPLAY_NONE, false, false }
};
#undef MSG
