/*
 * StreamedMedia page for channel notebook.
 *
 * Copyright (C) 2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2008 Nokia Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_PAGE_STREAMED_MEDIA_H__
#define __TI_PAGE_STREAMED_MEDIA_H__

#include <gtk/gtk.h>
#include <glib-object.h>
#include <telepathy-glib/channel.h>

#include "page.h"

typedef struct _TIPageStreamedMedia TIPageStreamedMedia;
typedef struct _TIPageStreamedMediaClass TIPageStreamedMediaClass;
typedef struct _TIPageStreamedMediaPrivate TIPageStreamedMediaPrivate;

GType ti_page_streamed_media_get_type (void);

#define TI_TYPE_PAGE_STREAMED_MEDIA \
  (ti_page_streamed_media_get_type ())
#define TI_PAGE_STREAMED_MEDIA(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), TI_TYPE_PAGE_STREAMED_MEDIA, \
                               TIPageStreamedMedia))
#define TI_PAGE_STREAMED_MEDIA_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PAGE_STREAMED_MEDIA, \
                            TIPageStreamedMediaClass))
#define TI_IS_PAGE_STREAMED_MEDIA(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TI_TYPE_PAGE_STREAMED_MEDIA))
#define TI_IS_PAGE_STREAMED_MEDIA_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PAGE_STREAMED_MEDIA))
#define TI_PAGE_STREAMED_MEDIA_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), TI_TYPE_PAGE_STREAMED_MEDIA, \
                              TIPageStreamedMediaClass))

struct _TIPageStreamedMedia {
    TIPage parent;
    TIPageStreamedMediaPrivate *priv;
};

TIPageStreamedMedia *ti_page_streamed_media_new (GtkNotebook *parent_notebook,
    TpChannel *channel);

#endif
