#ifndef PROPERTIES_H__
#define PROPERTIES_H__

#include "teatime.h"

#define TEATIME_PREFS_CUP	           "cup"
#define TEATIME_PREFS_POPUP	         "popup"
#define TEATIME_PREFS_SOUND          "sound"
#define TEATIME_PREFS_PLAY_SOUND     "play_sound"
#define TEATIME_PREFS_SOUND_CHOOSER  "sound_entry"
#define TEATIME_PREFS_SHOW_CLOCK     "show_clock"
#define TEATIME_PREFS_LAST_TEA       "last_tea"
#define TEATIME_PREFS_TEAS           "teas"
#define TEATIME_PREFS_TIMES          "times"

typedef struct{
  gint *drawing_times;
  GtkTooltips   *tips;
  GtkWidget     *time_vbox;
  GtkWidget     **time_table;
  GtkWidget     **tea_label;
  GtkWidget     **time_label;
  GtkWidget     **time_slider;
  GtkWidget     **remove_button;
  GtkAdjustment **time_adj;
}TimeProperties;

void teatime_load_properties           (Teatime *teatime);
void teatime_display_properties_dialog (BonoboUIComponent *uic,
                                        Teatime *teatime,
                                        const gchar *verbname);
#endif
